/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.internationalization.runtime;

import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import jetbrains.mps.internal.collections.runtime.IMapping;
import jetbrains.mps.internal.collections.runtime.ISetSequence;
import jetbrains.mps.internal.collections.runtime.IterableUtils;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.mps.internationalization.runtime.LocalizationPropertyIsDuplicatedException;

class DuplicateAwareProperties
extends Properties {
    @Override
    public Object put(Object key, Object value) {
        Object oldValue = super.put(key, value);
        if (oldValue != null) {
            throw new LocalizationPropertyIsDuplicatedException("Property " + key + " is duplicated");
        }
        return oldValue;
    }

    public Object putIgnoreDuplicates(String key, String value) {
        return super.put(key, value);
    }

    public void putAllIgnoreDuplicates(Map<String, String> map) {
        for (IMapping pair : MapSequence.fromMap(map)) {
            this.putIgnoreDuplicates((String)pair.key(), (String)pair.value());
        }
    }

    @Override
    public void putAll(Map<? extends Object, ? extends Object> mapFromParams) {
        ISetSequence duplicates = SetSequence.fromSet(new HashSet());
        for (IMapping pair : MapSequence.fromMap(mapFromParams)) {
            Object old = this.putIgnoreDuplicates(pair.key().toString(), pair.value().toString());
            if (old == null) continue;
            SetSequence.fromSet((Set)duplicates).addElement((Object)old.toString());
        }
        if (SetSequence.fromSet((Set)duplicates).isNotEmpty()) {
            throw new LocalizationPropertyIsDuplicatedException("Properties with keys " + IterableUtils.join((Iterable)SetSequence.fromSet((Set)duplicates), (String)",") + " are duplicated");
        }
    }
}

