/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.internationalization.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.exodus.util.StringInterner;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ArrayUtils;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.webr.stateless.template.runtime.TemplateBuilderContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webr.framework.textBuilder.TBuilderContext;

public class Message {
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\{\\??\\d+\\}");
    private static final Pattern BRACE_PATTERN = Pattern.compile("\\{", 16);
    private static final StringInterner MESSAGES_INTERNER = StringInterner.newInterner((int)11967);
    protected static Log log = LogFactory.getLog(Message.class);
    private final String[] parts;
    private final int[] variables;

    public Message(String message) {
        IListSequence partsList = ListSequence.fromList(new ArrayList());
        IListSequence variablesList = ListSequence.fromList(new ArrayList());
        Matcher matcher = VARIABLE_PATTERN.matcher(message);
        int cur = 0;
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            ListSequence.fromList((List)partsList).addElement((Object)message.substring(cur, start));
            String variable = message.substring(start + 1, end - 1);
            if (variable.charAt(0) == '?') {
                variable = variable.substring(1);
            }
            ListSequence.fromList((List)variablesList).addElement((Object)new Integer(variable));
            cur = end;
        }
        ListSequence.fromList((List)partsList).addElement((Object)message.substring(cur));
        this.parts = (String[])ListSequence.fromList((List)partsList).toGenericArray(String.class);
        for (int i = 0; i < this.parts.length; ++i) {
            this.parts[i] = MESSAGES_INTERNER.doIntern(BRACE_PATTERN.matcher(this.parts[i]).replaceAll("{"));
        }
        this.variables = ArrayUtils.toIntArray((ISequence)ListSequence.fromList((List)variablesList));
    }

    public String substituteParams(Object ... params) {
        List<Object> reducedParams = this.reduceParams(params);
        TBuilderContext builderContext = null;
        int start = 0;
        if (ListSequence.fromList(reducedParams).count() >= 1 && ListSequence.fromList(reducedParams).getElement(0) instanceof TBuilderContext) {
            builderContext = (TBuilderContext)ListSequence.fromList(reducedParams).getElement(0);
            start = 1;
        }
        if (this.variables.length == 0) {
            return this.parts[0];
        }
        StringBuilder result = new StringBuilder(this.parts[0]);
        for (int i = 0; i < this.variables.length; ++i) {
            if (this.variables[i] + start < ListSequence.fromList(reducedParams).count()) {
                Object param = ListSequence.fromList(reducedParams).getElement(this.variables[i] + start);
                if (param instanceof _FunctionTypes._return_P1_E0) {
                    result.append(((_FunctionTypes._return_P1_E0)param).invoke((Object)builderContext));
                } else {
                    result.append(param);
                }
            } else {
                result.append("{" + this.variables[i] + "}");
            }
            result.append(this.parts[i + 1]);
        }
        return result.toString();
    }

    public void substituteParamsForTemplateContent(TBuilderContext builderContext, Object ... params) {
        List<Object> reducedParams = this.reduceParams(params);
        builderContext.append(this.parts[0]);
        for (int i = 0; i < this.variables.length; ++i) {
            if (this.variables[i] < ListSequence.fromList(reducedParams).count()) {
                Object param = ListSequence.fromList(reducedParams).getElement(this.variables[i]);
                if (param instanceof _FunctionTypes._void_P1_E0) {
                    ((_FunctionTypes._void_P1_E0)param).invoke((Object)builderContext);
                } else if (param instanceof _FunctionTypes._return_P1_E0) {
                    ((_FunctionTypes._return_P1_E0)param).invoke((Object)builderContext);
                } else {
                    builderContext.append(param);
                }
            } else {
                builderContext.append("{" + this.variables[i] + "}");
                if (log.isErrorEnabled()) {
                    log.error((Object)("The l10n message requires at least " + (this.variables[i] + 1) + " parameters. Seems like generation is broken."), (Throwable)new IllegalArgumentException("Not enough l10n message parameters"));
                }
            }
            builderContext.append(this.parts[i + 1]);
        }
    }

    public void substituteParamsForStatelessTemplateContent(TemplateBuilderContext builderContext, Object ... params) {
        List<Object> reducedParams = this.reduceParams(params);
        builderContext.append(this.parts[0]);
        for (int i = 0; i < this.variables.length; ++i) {
            if (this.variables[i] < ListSequence.fromList(reducedParams).count()) {
                Object param = ListSequence.fromList(reducedParams).getElement(this.variables[i]);
                if (param instanceof _FunctionTypes._void_P1_E0) {
                    ((_FunctionTypes._void_P1_E0)param).invoke((Object)builderContext);
                } else if (param instanceof _FunctionTypes._return_P1_E0) {
                    ((_FunctionTypes._return_P1_E0)param).invoke((Object)builderContext);
                } else {
                    builderContext.append(param.toString());
                }
            } else {
                builderContext.append("{" + this.variables[i] + "}");
                if (log.isErrorEnabled()) {
                    log.error((Object)("The l10n message requires at least " + (this.variables[i] + 1) + " parameters. Seems like generation is broken."), (Throwable)new IllegalArgumentException("Not enough l10n message parameters"));
                }
            }
            builderContext.append(this.parts[i + 1]);
        }
    }

    private List<Object> reduceParams(Object ... params) {
        IListSequence reducedParamsList = ListSequence.fromList(new ArrayList());
        for (int i = 0; i < params.length; ++i) {
            if (params[i] instanceof Boolean) {
                if (((Boolean)params[i]).booleanValue()) {
                    ListSequence.fromList((List)reducedParamsList).addElement(params[i + 1]);
                } else {
                    ListSequence.fromList((List)reducedParamsList).addElement((Object)"");
                }
                ++i;
                continue;
            }
            ListSequence.fromList((List)reducedParamsList).addElement(params[i]);
        }
        return reducedParamsList;
    }
}

