/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.internationalization.runtime;

import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.CollectionSequence;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.mps.internationalization.runtime.LocaleEntry;
import jetbrains.mps.internationalization.runtime.LocaleUtil;
import jetbrains.mps.internationalization.runtime.Locales;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;

public class SupportedLocales {
    private static final String BUNDLED_LOCALES_CONFIGURATION_FILE_NAME = "supportedLocales.xml";
    public static final String BUNDLED_LOCALES_RESOURCE_NAME = "translations/supportedLocales.xml";
    public static final String CUSTOM_TRANSLATIONS_LOCATION = "jetbrains.mps.webr.i18n.custom-translations";
    protected static Log log = LogFactory.getLog(SupportedLocales.class);
    private Collection<LocaleEntry> bundledLocales = new ArrayList<LocaleEntry>();
    private Collection<LocaleEntry> customLocales = new ArrayList<LocaleEntry>();
    private Set<LocaleEntry> supportedLocales = new HashSet<LocaleEntry>();

    public SupportedLocales() {
        try {
            LocaleEntry defaultLocale = new LocaleEntry();
            defaultLocale.setLocale(LocaleUtil.DEFAULT_LOCALE);
            defaultLocale.setName("English");
            CollectionSequence.fromCollection(this.bundledLocales).addElement((Object)defaultLocale);
            SetSequence.fromSet(this.supportedLocales).addElement((Object)defaultLocale);
            Resource resource = (Resource)Sequence.fromIterable((Iterable)Sequence.fromArray((Object[])ServiceLocator.getResources((String)BUNDLED_LOCALES_RESOURCE_NAME))).first();
            if (resource == null || !resource.exists()) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Cannot load locales configuration. To add locales configuration create file classpath:translations/supportedLocales.xml");
                }
                return;
            }
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{LocaleEntry.class, Locales.class});
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            Collection<LocaleEntry> locales = this.loadLocalesConfiguration(unmarshaller, resource.getInputStream());
            CollectionSequence.fromCollection(this.bundledLocales).addSequence(CollectionSequence.fromCollection(locales).where((_FunctionTypes._return_P1_E0)new IWhereFilter<LocaleEntry>(){

                public boolean accept(LocaleEntry it) {
                    return !it.community;
                }
            }));
            CollectionSequence.fromCollection(this.customLocales).addSequence(CollectionSequence.fromCollection(locales).where((_FunctionTypes._return_P1_E0)new IWhereFilter<LocaleEntry>(){

                public boolean accept(LocaleEntry it) {
                    return it.community;
                }
            }));
            SetSequence.fromSet(this.supportedLocales).addSequence((ISequence)CollectionSequence.fromCollection(locales));
            this.loadCustomTranslationsConfig();
            this.makeUnmodifiable();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    void loadCustomTranslationsConfig() {
        block6: {
            String systemProperty = System.getProperty(CUSTOM_TRANSLATIONS_LOCATION);
            if (systemProperty == null || systemProperty.length() == 0) {
                return;
            }
            File directory = this.getCustomLocalesLocation();
            if (!directory.exists()) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Directory with name " + systemProperty + "doesn't exists. Cannot load custom translations."));
                }
                return;
            }
            try {
                FileFilter localeFilter = new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.isDirectory() && file.getName().matches("[a-z]+[_-][A-Z]+");
                    }
                };
                for (File localeDirectory : directory.listFiles(localeFilter)) {
                    String[] split = localeDirectory.getName().split("[_-]");
                    String name = localeDirectory.getName();
                    Locale locale = new Locale(split[0], split[1]);
                    LocaleEntry le = new LocaleEntry();
                    le.setName(name);
                    le.setLocale(locale);
                    CollectionSequence.fromCollection(this.customLocales).addElement((Object)le);
                }
                SetSequence.fromSet(this.supportedLocales).addSequence((ISequence)CollectionSequence.fromCollection(this.customLocales));
            }
            catch (Throwable e) {
                if (!log.isErrorEnabled()) break block6;
                log.error((Object)"Cannot load custom translations", e);
            }
        }
    }

    private Collection<LocaleEntry> loadLocalesConfiguration(Unmarshaller unmarshaller, InputStream stream) throws JAXBException {
        JAXBElement element = unmarshaller.unmarshal((Source)new StreamSource(stream), Locales.class);
        Locales locales = (Locales)element.getValue();
        return locales.getBundledLocales();
    }

    private void makeUnmodifiable() {
        this.bundledLocales = Collections.unmodifiableCollection(this.bundledLocales);
        if (this.customLocales != null) {
            this.customLocales = Collections.unmodifiableCollection(this.customLocales);
        }
    }

    Collection<LocaleEntry> getBundledLocales() {
        return this.bundledLocales;
    }

    Collection<LocaleEntry> getCustomLocales() {
        return this.customLocales;
    }

    Iterable<LocaleEntry> getSupportedLocales() {
        return this.supportedLocales;
    }

    File getCustomLocalesLocation() {
        return new File(System.getProperty(CUSTOM_TRANSLATIONS_LOCATION));
    }
}

