/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.oauth2.rest.security;

import com.intellij.hub.auth.InvalidTokenException;
import com.intellij.hub.auth.TokenVerification;
import com.intellij.hub.auth.basic.BasicAuthToken;
import com.intellij.hub.auth.oauth2.provider.source.DSAPublicKeySource;
import com.intellij.hub.auth.oauth2.token.AccessToken;
import com.intellij.hub.auth.oauth2.token.AccessTokenData;
import com.intellij.hub.auth.oauth2.token.GuestToken;
import com.intellij.hub.auth.oauth2.token.PermanentToken;
import java.util.Collection;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.query.NodeBase;
import jetbrains.jetpass.api.Alias;
import jetbrains.jetpass.api.IdItem;
import jetbrains.jetpass.api.Service;
import jetbrains.jetpass.api.authority.AuthorityHolder;
import jetbrains.jetpass.api.authority.User;
import jetbrains.jetpass.auth.module.dnq.authentication.SecondFactorRequiredException;
import jetbrains.jetpass.auth.module.dnq.authentication.ServletRequestCredentials;
import jetbrains.jetpass.dao.api.API;
import jetbrains.jetpass.dao.api.DataAccessException;
import jetbrains.jetpass.dao.api.authority.UserDAO;
import jetbrains.jetpass.dao.dnq.api.JetPassDAOContainer;
import jetbrains.jetpass.dao.dnq.api.authority.module.JetPassAuthModuleDAO;
import jetbrains.jetpass.dnq.TransactionKt;
import jetbrains.jetpass.oauth2.rest.security.DefaultDSAPublicKeySource;
import jetbrains.jetpass.oauth2.rest.security.OAuth;
import jetbrains.jetpass.oauth2.rest.security.OAuthResourceFilter;
import jetbrains.jetpass.oauth2.rest.security.OAuthResourceFilter$verify$1$1;
import jetbrains.jetpass.oauth2.rest.security.SecurityContext;
import jetbrains.jetpass.service.api.HubPrincipalManager;
import jetbrains.jetpass.service.api.JetPassMainApp;
import jetbrains.jetpass.spring.SpringUtils;
import jetbrains.jetpass.userManagement.persistence.dnq.XdBaseUser;
import jetbrains.jetpass.userManagement.persistence.dnq.XdEmailContact;
import jetbrains.jetpass.userManagement.persistence.dnq.XdEndUserAgreement;
import jetbrains.jetpass.userManagement.persistence.dnq.XdEndUserAgreementConsent;
import jetbrains.jetpass.userManagement.persistence.dnq.XdProfile;
import jetbrains.jetpass.userManagement.persistence.dnq.XdPublicSettings;
import jetbrains.jetpass.userManagement.persistence.dnq.XdService;
import jetbrains.jetpass.userManagement.persistence.dnq.XdUUIDObject;
import jetbrains.jetpass.userManagement.persistence.dnq.XdUser;
import jetbrains.jetpass.userManagement.persistence.dnq.oauth.XdPermanentToken;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KClass;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty1;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.dnq.query.NodeBaseOperationsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.util.ReflectionUtilKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OAuth
@Provider
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 32\u00020\u00012\u00020\u0002:\u00013B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0006\u0010 \u001a\u00020\u001fJ\u001a\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010#H\u0002J\b\u0010%\u001a\u00020\u001cH\u0002J\u0010\u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020(H\u0016J\u0018\u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J\n\u0010+\u001a\u00020\u001c*\u00020,J\n\u0010+\u001a\u00020-*\u00020.J\n\u0010/\u001a\u00020\u001c*\u00020,J\f\u00100\u001a\u00020-*\u00020-H\u0002J\f\u00101\u001a\u00020-*\u00020-H\u0002J\u0012\u00102\u001a\u00020-*\u00020-2\u0006\u0010$\u001a\u00020#R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\n\u001a\u00020\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\t\u001a\u0004\b\f\u0010\rR\u001b\u0010\u000f\u001a\u00020\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\t\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0014\u001a\u00020\u00158FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\t\u001a\u0004\b\u0016\u0010\u0017R\u0012\u0010\u0019\u001a\u00020\u001a8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Ljetbrains/jetpass/oauth2/rest/security/OAuthResourceFilter;", "Ljavax/ws/rs/container/ContainerRequestFilter;", "Ljavax/ws/rs/container/ContainerResponseFilter;", "()V", "api", "Ljetbrains/jetpass/dao/api/API;", "getApi", "()Ljetbrains/jetpass/dao/api/API;", "api$delegate", "Lkotlin/properties/ReadOnlyProperty;", "daoContainer", "Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "getDaoContainer", "()Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "daoContainer$delegate", "hubPrincipalManager", "Ljetbrains/jetpass/service/api/HubPrincipalManager;", "getHubPrincipalManager", "()Ljetbrains/jetpass/service/api/HubPrincipalManager;", "hubPrincipalManager$delegate", "jetPass", "Ljetbrains/jetpass/service/api/JetPassMainApp;", "getJetPass", "()Ljetbrains/jetpass/service/api/JetPassMainApp;", "jetPass$delegate", "resourceInfo", "Ljavax/ws/rs/container/ResourceInfo;", "assertBasicAuthIsEnabled", "", "beginSecurityAccess", "ctx", "Ljetbrains/jetpass/oauth2/rest/security/SecurityContext;", "createGuestSecurityContext", "createSecurityContext", "serviceID", "", "userID", "endSecurityAccess", "filter", "request", "Ljavax/ws/rs/container/ContainerRequestContext;", "response", "Ljavax/ws/rs/container/ContainerResponseContext;", "verify", "Lcom/intellij/hub/auth/oauth2/token/AccessToken;", "Ljetbrains/jetpass/api/authority/User;", "Lcom/intellij/hub/auth/oauth2/token/PermanentToken;", "verifyClient", "verifyEUAAcceptedIfRequired", "verifyEmailIsVerifiedIfRequired", "verifyIsNotDeleted", "Companion", "jetbrains.jetpass.oauth2.rest.security"})
public final class OAuthResourceFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final ReadOnlyProperty hubPrincipalManager$delegate;
    @NotNull
    private final ReadOnlyProperty api$delegate;
    @NotNull
    private final ReadOnlyProperty daoContainer$delegate;
    @NotNull
    private final ReadOnlyProperty jetPass$delegate;
    @Context
    private ResourceInfo resourceInfo;
    private static final ThreadLocal<SecurityContext> SECURITY_CONTEXT;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(OAuthResourceFilter.class), "hubPrincipalManager", "getHubPrincipalManager()Ljetbrains/jetpass/service/api/HubPrincipalManager;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(OAuthResourceFilter.class), "api", "getApi()Ljetbrains/jetpass/dao/api/API;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(OAuthResourceFilter.class), "daoContainer", "getDaoContainer()Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(OAuthResourceFilter.class), "jetPass", "getJetPass()Ljetbrains/jetpass/service/api/JetPassMainApp;"))};
        Companion = new Companion(null);
        SECURITY_CONTEXT = new ThreadLocal();
    }

    @NotNull
    public final HubPrincipalManager getHubPrincipalManager() {
        return (HubPrincipalManager)this.hubPrincipalManager$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @NotNull
    public final API getApi() {
        return (API)this.api$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @NotNull
    public final JetPassDAOContainer getDaoContainer() {
        return (JetPassDAOContainer)this.daoContainer$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    @NotNull
    public final JetPassMainApp getJetPass() {
        return (JetPassMainApp)this.jetPass$delegate.getValue((Object)this, $$delegatedProperties[3]);
    }

    public void filter(@NotNull ContainerRequestContext request) {
        User user;
        GuestToken token;
        SecurityContext securityContext;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        String authorizationHeader = request.getHeaderString("Authorization");
        if (authorizationHeader == null) {
            Companion.getLogger().trace((Function0)filter.ctx.1.INSTANCE);
            securityContext = this.createGuestSecurityContext();
        } else if (GuestToken.isGuestTokenHeader((String)authorizationHeader)) {
            token = GuestToken.decodeHeader((String)authorizationHeader);
            Companion.getLogger().trace((Function0)new Function0<String>(token){
                final /* synthetic */ GuestToken $token;

                @NotNull
                public final String invoke() {
                    return "Guest token: " + this.$token + ". Logged in as guest.";
                }
                {
                    this.$token = guestToken;
                    super(0);
                }
            });
            securityContext = this.createGuestSecurityContext();
        } else if (PermanentToken.Companion.isPermanentTokenHeader(authorizationHeader)) {
            token = PermanentToken.Companion.decodeHeader(authorizationHeader);
            Companion.getLogger().trace((Function0)new Function0<String>((PermanentToken)token){
                final /* synthetic */ PermanentToken $token;

                @NotNull
                public final String invoke() {
                    return "Permanent token: " + this.$token.getUsername();
                }
                {
                    this.$token = permanentToken;
                    super(0);
                }
            });
            user = this.verify((PermanentToken)token);
            securityContext = new SecurityContext(this.getJetPass().getDefaultService(), (AuthorityHolder)user);
        } else if (AccessToken.Companion.isBearer(authorizationHeader)) {
            token = AccessToken.Companion.decodeHeader(authorizationHeader);
            Companion.getLogger().trace((Function0)new Function0<String>((AccessToken)token){
                final /* synthetic */ AccessToken $token;

                @NotNull
                public final String invoke() {
                    return "Access token: " + this.$token;
                }
                {
                    this.$token = accessToken;
                    super(0);
                }
            });
            this.verify((AccessToken)token);
            AccessTokenData data = token.getData();
            securityContext = this.createSecurityContext(data.getClient(), data.getUser());
        } else if (BasicAuthToken.Companion.isBasic(authorizationHeader)) {
            SecurityContext securityContext2;
            this.assertBasicAuthIsEnabled();
            BasicAuthToken basic = BasicAuthToken.Companion.decodeHeader(authorizationHeader);
            Companion.getLogger().trace((Function0)new Function0<String>(basic){
                final /* synthetic */ BasicAuthToken $basic;

                @NotNull
                public final String invoke() {
                    return "Basic authorization: " + this.$basic.getUsername();
                }
                {
                    this.$basic = basicAuthToken;
                    super(0);
                }
            });
            try {
                user = JetPassAuthModuleDAO.loginUser$default((JetPassAuthModuleDAO)this.getDaoContainer().getAuthModuleDAO(), (String)basic.getUsername(), (String)basic.getPassword(), null, (String)request.getHeaderString(ServletRequestCredentials.Companion.getUSER_AGENT_HEADER()), null, (boolean)false, (int)52, null);
                this.verifyEmailIsVerifiedIfRequired(user);
                this.verifyEUAAcceptedIfRequired(user);
                securityContext2 = new SecurityContext(this.getJetPass().getDefaultService(), (AuthorityHolder)user);
            }
            catch (SecondFactorRequiredException ex) {
                Companion.getLogger().info((Function0)new Function0<String>(ex){
                    final /* synthetic */ SecondFactorRequiredException $ex;

                    @NotNull
                    public final String invoke() {
                        return "Basic login failed: " + this.$ex.getMessage();
                    }
                    {
                        this.$ex = secondFactorRequiredException;
                        super(0);
                    }
                });
                throw (Throwable)InvalidTokenException.Companion.basicAndTwoFactorAuthenticationEnabled((Exception)((Object)ex));
            }
            catch (DataAccessException ex) {
                Companion.getLogger().info((Throwable)ex, (Function0)new Function0<String>(basic){
                    final /* synthetic */ BasicAuthToken $basic;

                    @NotNull
                    public final String invoke() {
                        return "Basic login failed [username:" + this.$basic.getUsername() + ']';
                    }
                    {
                        this.$basic = basicAuthToken;
                        super(0);
                    }
                });
                throw (Throwable)new NotAuthorizedException("Basic login failed", (Throwable)ex, (Object)BasicAuthToken.Companion.getBASIC_TYPE(), new Object[]{"Bearer"});
            }
            securityContext = securityContext2;
        } else {
            throw (Throwable)new NotAuthorizedException("Invalid authorization header: " + authorizationHeader, (Object)"Bearer", new Object[]{BasicAuthToken.Companion.getBASIC_TYPE()});
        }
        SecurityContext ctx2 = securityContext;
        if (ctx2.getAuthorityHolder() == null) {
            throw (Throwable)new NotAuthorizedException("Auth Required " + request.getMethod(), (Object)"Bearer", new Object[]{BasicAuthToken.Companion.getBASIC_TYPE()});
        }
        this.beginSecurityAccess(ctx2);
    }

    public void filter(@NotNull ContainerRequestContext request, @NotNull ContainerResponseContext response) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        this.endSecurityAccess();
    }

    private final void beginSecurityAccess(SecurityContext ctx2) {
        SECURITY_CONTEXT.set(ctx2);
    }

    private final void endSecurityAccess() {
        SECURITY_CONTEXT.remove();
    }

    @NotNull
    public final SecurityContext createGuestSecurityContext() {
        return (SecurityContext)this.getHubPrincipalManager().runAsRoot((Function0)new Function0<SecurityContext>(this){
            final /* synthetic */ OAuthResourceFilter this$0;

            @NotNull
            public final SecurityContext invoke() {
                UserDAO userDAO = this.this$0.getApi().getUserDAO();
                Intrinsics.checkExpressionValueIsNotNull((Object)userDAO, (String)"api.userDAO");
                User guest = userDAO.getGuest();
                Service clientService = this.this$0.getJetPass().getDefaultService();
                return new SecurityContext(clientService, (AuthorityHolder)guest);
            }
            {
                this.this$0 = oAuthResourceFilter;
                super(0);
            }
        });
    }

    private final SecurityContext createSecurityContext(String serviceID, String userID) {
        return (SecurityContext)this.getHubPrincipalManager().runAsRoot((Function0)new Function0<SecurityContext>(this, serviceID, userID){
            final /* synthetic */ OAuthResourceFilter this$0;
            final /* synthetic */ String $serviceID;
            final /* synthetic */ String $userID;

            @NotNull
            public final SecurityContext invoke() {
                AuthorityHolder authorityHolder;
                Service service2 = (Service)this.this$0.getApi().getServiceDAO().get(this.$serviceID);
                if (service2 == null) {
                    throw (Throwable)new NotAuthorizedException("Unknown service with ID: " + this.$serviceID, (Object)"Bearer", new Object[]{BasicAuthToken.Companion.getBASIC_TYPE()});
                }
                Service clientService = service2;
                if (this.$userID == null) {
                    Service service3 = clientService;
                    Intrinsics.checkExpressionValueIsNotNull((Object)service3, (String)"clientService");
                    authorityHolder = (AuthorityHolder)service3;
                } else {
                    User user;
                    User user2 = (User)this.this$0.getApi().getUserDAO().get(this.$userID);
                    if (user2 == null) {
                        throw (Throwable)new NotAuthorizedException("Unknown user with ID: " + this.$userID, (Object)"Bearer", new Object[]{BasicAuthToken.Companion.getBASIC_TYPE()});
                    }
                    User user3 = user = user2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)user3, (String)"user");
                    this.this$0.verifyIsNotDeleted(user3, this.$userID);
                    OAuthResourceFilter.access$verifyEmailIsVerifiedIfRequired(this.this$0, user);
                    authorityHolder = (AuthorityHolder)OAuthResourceFilter.access$verifyEUAAcceptedIfRequired(this.this$0, user);
                }
                AuthorityHolder authorityHolder2 = authorityHolder;
                Service service4 = clientService;
                Intrinsics.checkExpressionValueIsNotNull((Object)service4, (String)"clientService");
                return new SecurityContext(service4, authorityHolder2);
            }
            {
                this.this$0 = oAuthResourceFilter;
                this.$serviceID = string;
                this.$userID = string2;
                super(0);
            }
        });
    }

    private final void assertBasicAuthIsEnabled() {
        if (this.getJetPass().getAuth().isBasicAuthDisabled()) {
            throw (Throwable)InvalidTokenException.Companion.basicAuthDisabled();
        }
    }

    public final void verify(@NotNull AccessToken $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        TokenVerification.verifyScope((AccessToken)$receiver, (String)this.getJetPass().getDefaultServiceID());
        this.verifyClient($receiver);
        TokenVerification.verifyExpiration((AccessToken)$receiver);
        TokenVerification.verifySignature((AccessToken)$receiver, (DSAPublicKeySource)DefaultDSAPublicKeySource.INSTANCE);
    }

    public final void verifyClient(@NotNull AccessToken $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String clientId = $receiver.getClient();
        Service service2 = (Service)this.getHubPrincipalManager().runAsRoot((Function0)new Function0<Service>(this, clientId){
            final /* synthetic */ OAuthResourceFilter this$0;
            final /* synthetic */ String $clientId;

            @Nullable
            public final Service invoke() {
                return (Service)this.this$0.getApi().getServiceDAO().get(this.$clientId);
            }
            {
                this.this$0 = oAuthResourceFilter;
                this.$clientId = string;
                super(0);
            }
        });
        if (service2 == null) {
            throw (Throwable)InvalidTokenException.Companion.unknownClient(clientId);
        }
    }

    @NotNull
    public final User verify(@NotNull PermanentToken $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return (User)TransactionKt.legacyTransactional$default((boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, User>(this, $receiver){
            final /* synthetic */ OAuthResourceFilter this$0;
            final /* synthetic */ PermanentToken receiver$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final User invoke(@NotNull TransientStoreSession it) {
                XdPermanentToken dbToken;
                block10: {
                    String[] allowedScope2;
                    void $receiver$iv;
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    XdPermanentToken xdPermanentToken = XdPermanentToken.Companion.find(this.receiver$0.getSecret());
                    if (xdPermanentToken == null) {
                        throw (Throwable)InvalidTokenException.Companion.invalidPermanentToken();
                    }
                    dbToken = xdPermanentToken;
                    String requiredScope = this.this$0.getJetPass().getDefaultServiceID();
                    KProperty1 kProperty1 = (KProperty1)OAuthResourceFilter$verify$1$1.INSTANCE;
                    XdQuery xdQuery = (XdQuery)dbToken.getScope();
                    NodeBase nodeBase = NodeBaseOperationsKt.eq((String)ReflectionUtilKt.getDBName((KProperty1)$receiver$iv, (KClass)Reflection.getOrCreateKotlinClass(XdService.class)), (Comparable)((Comparable)((Object)requiredScope)));
                    if (XdQueryKt.none((XdQuery)xdQuery, (NodeBase)nodeBase)) {
                        Collection $receiver$iv2;
                        Collection collection = $receiver$iv2 = (Collection)SequencesKt.toList((Sequence)SequencesKt.map((Sequence)XdQueryKt.asSequence((XdQuery)((XdQuery)dbToken.getScope())), (Function1)verify.allowedScope.1.INSTANCE));
                        if (collection == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                        }
                        Collection thisCollection$iv = collection;
                        String[] stringArray = thisCollection$iv.toArray(new String[0]);
                        if (stringArray == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                        }
                        allowedScope2 = stringArray;
                        throw (Throwable)InvalidTokenException.Companion.invalidTokenScope(requiredScope, allowedScope2);
                    }
                    if (Intrinsics.areEqual((Object)this.receiver$0.getUsername(), (Object)dbToken.getUsername()) ^ true) {
                        throw (Throwable)InvalidTokenException.Companion.invalidPermanentTokenUsername(this.receiver$0.getUsername(), dbToken.getUsername());
                    }
                    if (Intrinsics.areEqual((Object)this.receiver$0.getName(), (Object)dbToken.getName()) ^ true) {
                        throw (Throwable)InvalidTokenException.Companion.invalidPermanentTokenName(this.receiver$0.getName(), dbToken.getName());
                    }
                    allowedScope2 = XdPublicSettings.Companion;
                    XdBaseUser user$iv = (XdBaseUser)dbToken.getUser();
                    if (((XdPublicSettings)XdPublicSettings.Companion.getInstance()).getEmailVerificationRequired() && !user$iv.isAdmin()) {
                        XdEmailContact email$iv;
                        XdProfile xdProfile = user$iv.getProfile();
                        Object object = email$iv = xdProfile != null ? xdProfile.getEmail() : null;
                        if (email$iv != null && !email$iv.getVerified()) {
                            String it2 = email$iv.getEmail();
                            throw (Throwable)InvalidTokenException.Companion.notVerifiedEmail();
                        }
                    }
                    XdEndUserAgreement.Companion this_$iv = XdEndUserAgreement.Companion;
                    user$iv = (XdBaseUser)dbToken.getUser();
                    XdEndUserAgreement endUserAgreement$iv = ((XdPublicSettings)XdPublicSettings.Companion.getInstance()).getEndUserAgreement();
                    if (!endUserAgreement$iv.getEnabled() || !endUserAgreement$iv.getRequiredForREST() || !(user$iv instanceof XdUser)) break block10;
                    XdEndUserAgreementConsent xdEndUserAgreementConsent = ((XdUser)user$iv).getEndUserAgreementConsent();
                    if (xdEndUserAgreementConsent != null) {
                        if (xdEndUserAgreementConsent.isAccepted()) break block10;
                    }
                    throw (Throwable)InvalidTokenException.Companion.notAcceptedEndUserAgreement();
                }
                return (User)this.this$0.getHubPrincipalManager().runAsRoot((Function0)new Function0<User>(this, dbToken){
                    final /* synthetic */ verify.1 this$0;
                    final /* synthetic */ XdPermanentToken $dbToken;

                    @NotNull
                    public final User invoke() {
                        String userID = this.$dbToken.getUser().getUuid();
                        OAuthResourceFilter oAuthResourceFilter = this.this$0.this$0;
                        IdItem idItem = this.this$0.this$0.getApi().getUserDAO().get(userID);
                        if (idItem == null) {
                            Intrinsics.throwNpe();
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)idItem, (String)"api.userDAO.get(userID)!!");
                        return oAuthResourceFilter.verifyIsNotDeleted((User)idItem, userID);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$dbToken = xdPermanentToken;
                        super(0);
                    }
                });
            }
            {
                this.this$0 = oAuthResourceFilter;
                this.receiver$0 = permanentToken;
                super(1);
            }
        }), (int)7, null);
    }

    @NotNull
    public final User verifyIsNotDeleted(@NotNull User $receiver, @NotNull String userID) {
        Alias alias;
        Alias alias2;
        User user;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)userID, (String)"userID");
        User $receiver2 = user = $receiver;
        Iterable iterable = $receiver2.getAliases();
        if (iterable != null) {
            Object v2;
            block4: {
                Iterable $receiver$iv = iterable;
                for (Object element$iv : $receiver$iv) {
                    Alias it;
                    Alias alias3 = it = (Alias)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)alias3, (String)"it");
                    if (!Intrinsics.areEqual((Object)alias3.getId(), (Object)userID)) continue;
                    v2 = element$iv;
                    break block4;
                }
                v2 = null;
            }
            alias2 = v2;
        } else {
            alias2 = alias = null;
        }
        if (alias != null && Intrinsics.areEqual((Object)alias.getAction(), (Object)"DELETE")) {
            throw (Throwable)InvalidTokenException.Companion.userWasDeleted(userID);
        }
        return user;
    }

    private final User verifyEmailIsVerifiedIfRequired(@NotNull User $receiver) {
        User user;
        User $receiver2 = user = $receiver;
        TransactionKt.legacyTransactional$default((boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, Unit>($receiver2){
            final /* synthetic */ User receiver$0;

            public final void invoke(@NotNull TransientStoreSession it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                XdPublicSettings.Companion companion = XdPublicSettings.Companion;
                XdUUIDObject xdUUIDObject = XdBaseUser.Companion.resolve(this.receiver$0.getId());
                if (xdUUIDObject == null) {
                    Intrinsics.throwNpe();
                }
                XdBaseUser user$iv = (XdBaseUser)xdUUIDObject;
                if (((XdPublicSettings)XdPublicSettings.Companion.getInstance()).getEmailVerificationRequired() && !user$iv.isAdmin()) {
                    XdEmailContact email$iv;
                    XdProfile xdProfile = user$iv.getProfile();
                    Object object = email$iv = xdProfile != null ? xdProfile.getEmail() : null;
                    if (email$iv != null && !email$iv.getVerified()) {
                        String it2 = email$iv.getEmail();
                        throw (Throwable)InvalidTokenException.Companion.notVerifiedEmail();
                    }
                }
            }
            {
                this.receiver$0 = user;
                super(1);
            }
        }), (int)7, null);
        return user;
    }

    private final User verifyEUAAcceptedIfRequired(@NotNull User $receiver) {
        OAuth annotation;
        OAuth oAuth;
        User user;
        User $receiver2 = user = $receiver;
        ResourceInfo resourceInfo = this.resourceInfo;
        if (resourceInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"resourceInfo");
        }
        if ((oAuth = resourceInfo.getResourceMethod().getAnnotation(OAuth.class)) == null) {
            ResourceInfo resourceInfo2 = this.resourceInfo;
            if (resourceInfo2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"resourceInfo");
            }
            oAuth = resourceInfo2.getResourceClass().getAnnotation(OAuth.class);
        }
        OAuth oAuth2 = annotation = oAuth;
        if (oAuth2 == null || !oAuth2.ignoreEUConsent()) {
            TransactionKt.legacyTransactional$default((boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, Unit>($receiver2){
                final /* synthetic */ User receiver$0;

                public final void invoke(@NotNull TransientStoreSession it) {
                    block3: {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        XdEndUserAgreement.Companion companion = XdEndUserAgreement.Companion;
                        XdUUIDObject xdUUIDObject = XdBaseUser.Companion.resolve(this.receiver$0.getId());
                        if (xdUUIDObject == null) {
                            Intrinsics.throwNpe();
                        }
                        XdBaseUser user$iv = (XdBaseUser)xdUUIDObject;
                        XdEndUserAgreement endUserAgreement$iv = ((XdPublicSettings)XdPublicSettings.Companion.getInstance()).getEndUserAgreement();
                        if (!endUserAgreement$iv.getEnabled() || !endUserAgreement$iv.getRequiredForREST() || !(user$iv instanceof XdUser)) break block3;
                        XdEndUserAgreementConsent xdEndUserAgreementConsent = ((XdUser)user$iv).getEndUserAgreementConsent();
                        if (xdEndUserAgreementConsent != null) {
                            if (xdEndUserAgreementConsent.isAccepted()) break block3;
                        }
                        throw (Throwable)InvalidTokenException.Companion.notAcceptedEndUserAgreement();
                    }
                }
                {
                    this.receiver$0 = user;
                    super(1);
                }
            }), (int)7, null);
        }
        return user;
    }

    public OAuthResourceFilter() {
        ReadOnlyProperty readOnlyProperty;
        OAuthResourceFilter oAuthResourceFilter = this;
        String name$iv = null;
        oAuthResourceFilter.hubPrincipalManager$delegate = readOnlyProperty = SpringUtils.bean((String)name$iv, (boolean)false);
        oAuthResourceFilter = this;
        name$iv = null;
        oAuthResourceFilter.api$delegate = readOnlyProperty = SpringUtils.bean((String)name$iv, (boolean)false);
        oAuthResourceFilter = this;
        name$iv = null;
        oAuthResourceFilter.daoContainer$delegate = readOnlyProperty = SpringUtils.bean((String)name$iv, (boolean)false);
        oAuthResourceFilter = this;
        name$iv = null;
        oAuthResourceFilter.jetPass$delegate = readOnlyProperty = SpringUtils.bean((String)name$iv, (boolean)false);
    }

    @NotNull
    public static final /* synthetic */ User access$verifyEmailIsVerifiedIfRequired(OAuthResourceFilter $this, @NotNull User $receiver) {
        return $this.verifyEmailIsVerifiedIfRequired($receiver);
    }

    @NotNull
    public static final /* synthetic */ User access$verifyEUAAcceptedIfRequired(OAuthResourceFilter $this, @NotNull User $receiver) {
        return $this.verifyEUAAcceptedIfRequired($receiver);
    }

    @Nullable
    public static final SecurityContext getSecurityContext() {
        return Companion.getSecurityContext();
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u00058FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Ljetbrains/jetpass/oauth2/rest/security/OAuthResourceFilter$Companion;", "Lmu/KLogging;", "()V", "SECURITY_CONTEXT", "Ljava/lang/ThreadLocal;", "Ljetbrains/jetpass/oauth2/rest/security/SecurityContext;", "securityContext", "securityContext$annotations", "getSecurityContext", "()Ljetbrains/jetpass/oauth2/rest/security/SecurityContext;", "jetbrains.jetpass.oauth2.rest.security"})
    public static final class Companion
    extends KLogging {
        @JvmStatic
        public static /* synthetic */ void securityContext$annotations() {
        }

        @Nullable
        public final SecurityContext getSecurityContext() {
            return (SecurityContext)SECURITY_CONTEXT.get();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

