/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.service.util.contract.callbacks.impl.log4j;

import com.jetbrains.service.util.StatusException;
import com.jetbrains.service.util.contract.callbacks.impl.log4j.ServiceCallbackBase;
import com.jetbrains.service.util.contract.service.ConfigurableServiceBase;
import com.jetbrains.service.util.contract.service.context.ConfiguringContextProvider;
import java.io.File;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class ConfigureCallback
extends ServiceCallbackBase {
    @NotNull
    protected final File getServiceConfigDirectory(Map<String, Object> parameters) {
        if (!parameters.containsKey("jetbrains.service.config.path")) {
            throw new StatusException(String.format("Missing mandatory parameter [%s]", "jetbrains.service.config.path"));
        }
        return new File((String)parameters.get("jetbrains.service.config.path"));
    }

    @NotNull
    protected final File getServiceHomeDirectory(Map<String, Object> parameters) {
        if (!parameters.containsKey("jetbrains.service.home.path")) {
            throw new StatusException(String.format("Missing mandatory parameter [%s]", "jetbrains.service.home.path"));
        }
        return Paths.get((String)parameters.get("jetbrains.service.home.path"), new String[0]).toFile();
    }

    @NotNull
    protected final Properties getServiceProperties(Map<String, Object> parameters) {
        if (!parameters.containsKey("jetbrains.service.config.properties.map")) {
            throw new StatusException(String.format("Missing mandatory parameter [%s]", "jetbrains.service.config.properties.map"));
        }
        return (Properties)parameters.get("jetbrains.service.config.properties.map");
    }

    @Override
    protected void doPerform(final @NotNull Map<String, Object> parameters) {
        ConfigurableServiceBase configurableService = this.createConfigurableService();
        configurableService.configure(new ConfiguringContextProvider(){

            @Override
            public Map<String, String> getNewProperties() {
                return ConfigureCallback.convertToMap(ConfigureCallback.this.getServiceProperties(parameters));
            }

            @Override
            public File getServiceHome() {
                return ConfigureCallback.this.getServiceHomeDirectory(parameters);
            }

            @Override
            public File getAppConfFolder() {
                return ConfigureCallback.this.getServiceConfigDirectory(parameters);
            }

            @Override
            public boolean isDebugEnabled() {
                return Boolean.valueOf((String)parameters.get("jetbrains.debug.enabled"));
            }
        });
    }

    @NotNull
    protected ConfigurableServiceBase createConfigurableService() {
        return new ConfigurableServiceBase();
    }

    @NotNull
    private static Map<String, String> convertToMap(Properties properties) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (properties == null) {
            return map;
        }
        for (String property : properties.stringPropertyNames()) {
            String value = properties.getProperty(property);
            if (value == null) continue;
            map.put(property, value);
        }
        return map;
    }
}

