/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common.http;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.springframework.util.StringUtils;

public final class HttpUtils {
    private HttpUtils() {
    }

    public static String parseParamFromHeaderValue(String headerValue, String paramName) {
        if (StringUtils.isEmpty((Object)headerValue)) {
            return null;
        }
        for (String value : headerValue.split(";")) {
            int idx = value.indexOf(61);
            if (idx == -1 || !paramName.equalsIgnoreCase(value.substring(0, idx))) continue;
            return value.substring(idx + 1);
        }
        return null;
    }

    public static String uriEncodePath(String path) {
        try {
            URI uri = new URI(null, null, path, null);
            return uri.toASCIIString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("uriEncode failed, path=\"%s\".", path), e);
        }
    }

    public static String uriDecodePath(String path) {
        if (path == null) {
            return null;
        }
        try {
            return new URI(path).getPath();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("uriDecode failed, path=\"%s\".", path), e);
        }
    }

    public static String parseFileNameFromHeaderValue(String headerValue) {
        String fileName = HttpUtils.parseParamFromHeaderValue(headerValue, "filename");
        fileName = StringUtils.isEmpty((Object)fileName) ? "default" : fileName;
        fileName = HttpUtils.uriDecodePath(fileName);
        return new File(fileName).getName();
    }

    public static String getCharsetFromContentType(String contentType) {
        if (contentType == null) {
            return null;
        }
        int start = contentType.indexOf("charset=");
        if (start < 0) {
            return null;
        }
        String encoding = contentType.substring(start + 8);
        int end = encoding.indexOf(59);
        if (end >= 0) {
            encoding = encoding.substring(0, end);
        }
        if ((encoding = encoding.trim()).length() > 2 && encoding.startsWith("\"") && encoding.endsWith("\"")) {
            encoding = encoding.substring(1, encoding.length() - 1);
        }
        return encoding.trim();
    }
}

