/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.xodus.browser.web.db;

import java.util.List;
import jetbrains.xodus.browser.web.DBSummary;
import jetbrains.xodus.browser.web.db.DBDatabasesStore;
import jetbrains.xodus.browser.web.db.DatabaseService;
import jetbrains.xodus.browser.web.db.DatabasesStore;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0006H\u0016J\b\u0010\u0015\u001a\u00020\u000eH\u0016J\b\u0010\u0016\u001a\u00020\u000eH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ljetbrains/xodus/browser/web/db/PersistentDatabaseService;", "Ljetbrains/xodus/browser/web/db/DatabaseService;", "store", "Ljetbrains/xodus/browser/web/db/DatabasesStore;", "(Ljetbrains/xodus/browser/web/db/DatabasesStore;)V", "isReadonly", "", "()Z", "add", "Ljetbrains/xodus/browser/web/DBSummary;", "dbSummary", "all", "", "delete", "", "uuid", "", "deleteAll", "find", "markStarted", "started", "start", "stop", "entity-browser-app"})
public class PersistentDatabaseService
implements DatabaseService {
    private final DatabasesStore store;

    @Override
    public boolean isReadonly() {
        return false;
    }

    @Override
    @NotNull
    public List<DBSummary> all() {
        return this.store.all();
    }

    @Override
    public void start() {
        this.store.start();
    }

    @Override
    @Nullable
    public DBSummary find(@NotNull String uuid) {
        Intrinsics.checkParameterIsNotNull((Object)uuid, (String)"uuid");
        return DatabasesStore.DefaultImpls.find$default(this.store, uuid, null, 2, null);
    }

    @Override
    @NotNull
    public DBSummary add(@NotNull DBSummary dbSummary) {
        Intrinsics.checkParameterIsNotNull((Object)dbSummary, (String)"dbSummary");
        DBSummary newSummary = this.store.add(dbSummary);
        if (dbSummary.isOpened()) {
            return this.markStarted(newSummary.getUuid(), false);
        }
        return newSummary;
    }

    @Override
    @NotNull
    public DBSummary markStarted(@NotNull String uuid, boolean started) {
        Intrinsics.checkParameterIsNotNull((Object)uuid, (String)"uuid");
        DBSummary summary = DatabasesStore.DefaultImpls.find$default(this.store, uuid, null, 2, null);
        summary.setOpened(started);
        return this.store.update(uuid, summary);
    }

    @Override
    public void delete(@NotNull String uuid) {
        Intrinsics.checkParameterIsNotNull((Object)uuid, (String)"uuid");
        this.store.delete(uuid);
    }

    @Override
    public void deleteAll() {
        Iterable $receiver$iv = this.store.all();
        for (Object element$iv : $receiver$iv) {
            DBSummary it = (DBSummary)element$iv;
            boolean bl = false;
            this.delete(it.getUuid());
        }
    }

    @Override
    public void stop() {
        this.store.stop();
    }

    public PersistentDatabaseService(@NotNull DatabasesStore store) {
        Intrinsics.checkParameterIsNotNull((Object)store, (String)"store");
        this.store = store;
    }

    public /* synthetic */ PersistentDatabaseService(DatabasesStore databasesStore, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            databasesStore = new DBDatabasesStore();
        }
        this(databasesStore);
    }

    public PersistentDatabaseService() {
        this(null, 1, null);
    }
}

