/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.xodus.browser.web.search;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.exodus.entitystore.StoreTransaction;
import jetbrains.xodus.browser.web.search.LinkSearchTerm;
import jetbrains.xodus.browser.web.search.PropertyLikeSearchTerm;
import jetbrains.xodus.browser.web.search.PropertyRangeSearchTerm;
import jetbrains.xodus.browser.web.search.PropertyValueSearchTerm;
import jetbrains.xodus.browser.web.search.SearchQueryException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\u00020\b*\u00020\u00038DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\t\u0082\u0001\u0004\u0012\u0013\u0014\u0015\u00a8\u0006\u0016"}, d2={"Ljetbrains/xodus/browser/web/search/SearchTerm;", "", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "isIdProperty", "", "(Ljava/lang/String;)Z", "search", "Ljetbrains/exodus/entitystore/EntityIterable;", "txn", "Ljetbrains/exodus/entitystore/StoreTransaction;", "entityType", "entityTypeId", "", "Companion", "Ljetbrains/xodus/browser/web/search/PropertyRangeSearchTerm;", "Ljetbrains/xodus/browser/web/search/PropertyLikeSearchTerm;", "Ljetbrains/xodus/browser/web/search/PropertyValueSearchTerm;", "Ljetbrains/xodus/browser/web/search/LinkSearchTerm;", "entity-browser-app"})
public abstract class SearchTerm {
    @NotNull
    private final String name;
    private static final Pattern RANGE_PATTERN;
    private static final Pattern ENTITY_ID;
    private static final String NULL_TOKEN = "null";
    public static final Companion Companion;

    @NotNull
    public abstract EntityIterable search(@NotNull StoreTransaction var1, @NotNull String var2, int var3);

    protected final boolean isIdProperty(@NotNull String $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return StringsKt.equals((String)"id", (String)$receiver, (boolean)true);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    private SearchTerm(String name) {
        this.name = name;
    }

    static {
        Companion = new Companion(null);
        RANGE_PATTERN = Pattern.compile("\\[\\s*(\\d*)\\s*,\\s*(\\d*)\\s*]");
        ENTITY_ID = Pattern.compile("^(?<type>[a-zA-z]\\w*)\\[(?<id>\\d+)]$");
        NULL_TOKEN = NULL_TOKEN;
    }

    public /* synthetic */ SearchTerm(String name, DefaultConstructorMarker $constructor_marker) {
        this(name);
    }

    @JvmStatic
    @NotNull
    public static final SearchTerm from(@NotNull String rawProperty, @NotNull String rawOperand, @NotNull String rawValue) {
        return Companion.from(rawProperty, rawOperand, rawValue);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007H\u0007J \u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J \u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\u00020\n*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0018\u0010\f\u001a\u00020\n*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u001a"}, d2={"Ljetbrains/xodus/browser/web/search/SearchTerm$Companion;", "", "()V", "ENTITY_ID", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "NULL_TOKEN", "", "RANGE_PATTERN", "isEqualsOp", "", "(Ljava/lang/String;)Z", "isNotEqualsOp", "from", "Ljetbrains/xodus/browser/web/search/SearchTerm;", "rawProperty", "rawOperand", "rawValue", "parseAsLink", "linkName", "operand", "value", "parseAsProperty", "propertyName", "prepare", "removeDoubleQuotes", "entity-browser-app"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final SearchTerm from(@NotNull String rawProperty, @NotNull String rawOperand, @NotNull String rawValue) {
            Intrinsics.checkParameterIsNotNull((Object)rawProperty, (String)"rawProperty");
            Intrinsics.checkParameterIsNotNull((Object)rawOperand, (String)"rawOperand");
            Intrinsics.checkParameterIsNotNull((Object)rawValue, (String)"rawValue");
            String property = this.prepare(rawProperty);
            String operand = this.prepare(rawOperand);
            String value = this.prepare(rawValue);
            return StringsKt.startsWith$default((String)property, (String)"@", (boolean)false, (int)2, null) ? this.parseAsLink(StringsKt.removePrefix((String)property, (CharSequence)"@"), operand, value) : this.parseAsProperty(property, operand, rawValue);
        }

        private final SearchTerm parseAsLink(String linkName, String operand, String value) {
            if (!this.isEqualsOp(operand) && !this.isNotEqualsOp(operand)) {
                throw (Throwable)new SearchQueryException("The [" + operand + "] operand is not supported for links. Only the equality [= !=] operands are supported");
            }
            if (Intrinsics.areEqual((Object)value, (Object)NULL_TOKEN)) {
                return LinkSearchTerm.Companion.nullValue(linkName, this.isEqualsOp(operand));
            }
            Matcher entityIdMatcher = ENTITY_ID.matcher(value);
            if (!entityIdMatcher.matches()) {
                throw (Throwable)new SearchQueryException("Link value should have the \"MyType[15]\" pattern but was \"" + value + '\"');
            }
            String string2 = entityIdMatcher.group("type");
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"entityIdMatcher.group(\"type\")");
            String string3 = entityIdMatcher.group("id");
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"entityIdMatcher.group(\"id\")");
            String string4 = string3;
            String string5 = string2;
            String string6 = linkName;
            LinkSearchTerm.Companion companion = LinkSearchTerm.Companion;
            long l = Long.parseLong(string4);
            return companion.value(string6, string5, l, this.isEqualsOp(operand));
        }

        private final SearchTerm parseAsProperty(String propertyName, String operand, String rawValue) {
            SearchTerm searchTerm;
            String value = this.prepare(rawValue);
            boolean isNullValue = Intrinsics.areEqual((Object)rawValue, (Object)NULL_TOKEN);
            if (isNullValue) {
                if (!this.isEqualsOp(operand) && !this.isNotEqualsOp(operand)) {
                    throw (Throwable)new SearchQueryException("Only the equality [= !=] operands are supported for comparing a property value with null");
                }
                searchTerm = new PropertyValueSearchTerm(propertyName, null, this.isEqualsOp(operand));
            } else {
                Matcher rangeMatcher = RANGE_PATTERN.matcher(value);
                if (rangeMatcher.matches()) {
                    long l;
                    if (!this.isEqualsOp(operand)) {
                        throw (Throwable)new SearchQueryException("Only the equality [=] operand is supported for comparing a property value with a range");
                    }
                    String string2 = rangeMatcher.group(1);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"rangeMatcher.group(1)");
                    String string3 = string2;
                    String string4 = propertyName;
                    long l2 = Long.parseLong(string3);
                    String string5 = rangeMatcher.group(2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"rangeMatcher.group(2)");
                    string3 = string5;
                    long l3 = l = Long.parseLong(string3);
                    long l4 = l2;
                    String string6 = string4;
                    searchTerm = new PropertyRangeSearchTerm(string6, l4, l3);
                } else {
                    String string7 = operand;
                    switch (string7.hashCode()) {
                        case 126: {
                            if (string7.equals("~")) {
                                searchTerm = new PropertyLikeSearchTerm(propertyName, value);
                                break;
                            }
                        }
                        default: {
                            searchTerm = new PropertyValueSearchTerm(propertyName, value, this.isEqualsOp(operand));
                        }
                    }
                }
            }
            return searchTerm;
        }

        private final String prepare(String value) {
            String string2;
            if (value.length() <= 1) {
                return value;
            }
            char first = value.charAt(0);
            char last = value.charAt(value.length() - 1);
            if (first == '\'' && last == '\'' || first == '\"' && last == '\"') {
                String string3 = value;
                int n = 1;
                int n2 = value.length() - 1;
                Companion companion = this;
                String string4 = string3;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.substring(n, n2);
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String string6 = string5;
                string2 = companion.removeDoubleQuotes(string6);
            } else {
                string2 = this.removeDoubleQuotes(value);
            }
            return string2;
        }

        private final String removeDoubleQuotes(String value) {
            if (value.length() <= 1) {
                return value;
            }
            return StringsKt.replace$default((String)value, (String)"''", (String)"'", (boolean)false, (int)4, null);
        }

        private final boolean isEqualsOp(@NotNull String $receiver) {
            return Intrinsics.areEqual((Object)$receiver, (Object)"=");
        }

        private final boolean isNotEqualsOp(@NotNull String $receiver) {
            return Intrinsics.areEqual((Object)$receiver, (Object)"!=");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

