/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.baseLanguage.stateMachine.runtime.listener;

import java.util.Map;
import java.util.Set;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;

public class EventContext<SMClass, State> {
    private SMClass smClass;
    private State state;
    private String eventName;
    private Map<String, Object> eventParameters;

    public EventContext(SMClass smClass, State state, String eventName, Map<String, Object> eventParameters) {
        this.smClass = smClass;
        this.state = state;
        this.eventName = eventName;
        this.eventParameters = eventParameters;
    }

    public SMClass getSmClass() {
        return this.smClass;
    }

    public State getState() {
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
    }

    public String getEventName() {
        return this.eventName;
    }

    public Map<String, Object> getEventParameters() {
        return this.eventParameters;
    }

    public String getEventString() {
        String eventString = this.eventName;
        if (this.eventParameters != null && SetSequence.fromSet((Set)MapSequence.fromMap(this.eventParameters).keySet()).isNotEmpty()) {
            StringBuilder builder = new StringBuilder(this.eventName);
            builder.append("(");
            boolean first = true;
            for (String key : SetSequence.fromSet((Set)MapSequence.fromMap(this.eventParameters).keySet())) {
                if (!first) {
                    builder.append(", ");
                } else {
                    first = false;
                }
                builder.append(key).append("=").append(MapSequence.fromMap(this.eventParameters).get((Object)key));
            }
            builder.append(")");
            eventString = builder.toString();
        }
        return eventString;
    }

    public String getConfigString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.smClass.getClass().getSimpleName());
        builder.append(":");
        builder.append(this.state);
        return builder.toString();
    }
}

