/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.baseLanguage.stateMachine.runtime.listener;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;

public class Transition<State> {
    private String eventName;
    private Map<String, Object> matchParameters;
    private String condition;
    private State sourceState;
    private State targetState;

    public Transition(String eventName, String condition, State sourceState, State targetState) {
        this.eventName = eventName;
        this.condition = condition;
        this.sourceState = sourceState;
        this.targetState = targetState;
    }

    public void addMatchParameter(String name, Object value) {
        if (this.matchParameters == null) {
            this.matchParameters = new LinkedHashMap<String, Object>();
        }
        MapSequence.fromMap(this.matchParameters).put((Object)name, value);
    }

    public String toTransitionString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.eventName);
        if (this.matchParameters != null && SetSequence.fromSet((Set)MapSequence.fromMap(this.matchParameters).keySet()).isNotEmpty() || this.condition != null) {
            builder.append("[");
            boolean first = true;
            if (this.matchParameters != null && SetSequence.fromSet((Set)MapSequence.fromMap(this.matchParameters).keySet()).isNotEmpty()) {
                for (String key : SetSequence.fromSet((Set)MapSequence.fromMap(this.matchParameters).keySet())) {
                    if (first) {
                        first = false;
                    } else {
                        builder.append(" & ");
                    }
                    builder.append(key).append("==").append(MapSequence.fromMap(this.matchParameters).get((Object)key));
                }
            }
            if (this.condition != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(" & ");
                }
                builder.append(this.condition);
            }
            builder.append("]");
        }
        builder.append(" ");
        builder.append(this.sourceState);
        if (this.targetState != null) {
            builder.append(" -> ");
            builder.append(this.targetState);
        }
        return builder.toString();
    }
}

