/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.baseLanguage.stateMachine.runtime.logger;

import jetbrains.mps.baseLanguage.stateMachine.runtime.listener.AbstractEventProcessorListener;
import jetbrains.mps.baseLanguage.stateMachine.runtime.listener.EventContext;
import jetbrains.mps.baseLanguage.stateMachine.runtime.listener.Transition;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoggingEventProcessorListener
extends AbstractEventProcessorListener {
    protected static Log log = LogFactory.getLog(LoggingEventProcessorListener.class);

    @Override
    public void eventProcessingStarted(EventContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)(context.getEventString() + " -> " + context.getConfigString() + " {"));
        }
    }

    @Override
    public void eventProcessingFinished(EventContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("} " + context.getConfigString() + "\n"));
        }
    }

    @Override
    public void enterState(EventContext context, Object state) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("  -> " + state));
        }
    }

    @Override
    public void exitState(EventContext context, Object state) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("  " + state + " ->"));
        }
    }

    @Override
    public void testTransition(EventContext context, Transition transition) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("  [?] " + transition.toTransitionString()));
        }
    }

    @Override
    public void foundTransition(EventContext context, Transition transition) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("  [!] " + transition.toTransitionString()));
        }
    }

    @Override
    public void eventSkipped(EventContext context) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("  [x] " + context.getEventString()));
        }
    }

    @Override
    public void beforeAction(EventContext context, Transition transition) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"  do {");
        }
    }

    @Override
    public void afterAction(EventContext context, Transition transition) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"  }");
        }
    }

    @Override
    public void beforeOnEnter(EventContext context, Object state) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"  enter do {");
        }
    }

    @Override
    public void afterOnEnter(EventContext context, Object state) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"  }");
        }
    }

    @Override
    public void beforeOnExit(EventContext context, Object state) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"  exit do {");
        }
    }

    @Override
    public void afterOnExit(EventContext context, Object state) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"  }");
        }
    }
}

