/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.zendesk.rest.integration.resources;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import jetbrains.mps.webr.rpc.rest.filter.runtime.Transactional;
import jetbrains.mps.webr.rpc.rest.runtime.Resource;
import jetbrains.mps.webr.rpc.rest.runtime.Transformer;
import jetbrains.mps.webr.runtime.uri.QueryParameter;
import jetbrains.youtrack.gaprest.filters.AuthIgnored;
import jetbrains.youtrack.zendesk.persistent.XdAgreement;
import jetbrains.youtrack.zendesk.persistent.XdAgreementStatus;
import jetbrains.youtrack.zendesk.rest.integration.NHDAgreement;
import jetbrains.youtrack.zendesk.rest.integration.resources.AgreementsSubResource;
import jetbrains.youtrack.zendesk.rest.integration.resources.BackupRequestBody;
import jetbrains.youtrack.zendesk.rest.integration.resources.UnprocessableEntityException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.FilteringContext;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.query.XdSearchingNode;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;
import webr.framework.url.UrlUtil;

@Component
@Transactional
@BackupRequestBody
@Produces(value={"application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
@AuthIgnored
@Path(value="/networkedhelpdesk/agreements")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0007\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u0006H\u0007J\u001c\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\n2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0007J\u001a\u0010\u000b\u001a\u00020\b2\b\b\u0001\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0004H\u0007\u00a8\u0006\u000e"}, d2={"Ljetbrains/youtrack/zendesk/rest/integration/resources/AgreementsSubResource;", "Ljetbrains/mps/webr/rpc/rest/runtime/Resource;", "()V", "getAgreement", "Ljetbrains/youtrack/zendesk/rest/integration/NHDAgreement;", "agreement", "Ljetbrains/youtrack/zendesk/persistent/XdAgreement;", "postAgreementUuid", "Ljavax/ws/rs/core/Response;", "agreementUuid", "", "putAgreement", "newAgreement", "Companion", "youtrack-zendesk-integration"})
public final class AgreementsSubResource
implements Resource {
    public static final Companion Companion = new Companion(null);

    @POST
    @AuthIgnored
    @Path(value="/{agreementUuid}")
    @Consumes(value={"application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
    @NotNull
    public final Response postAgreementUuid(@PathParam(value="agreementUuid") @NotNull String agreementUuid, @Nullable NHDAgreement agreement) {
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)agreementUuid, (String)"agreementUuid");
        if (agreement == null || Intrinsics.areEqual((Object)agreementUuid, (Object)agreement.getUuid()) ^ true || (charSequence = (CharSequence)agreement.getName()) == null || charSequence.length() == 0 || (charSequence = (CharSequence)agreement.getAccess_key()) == null || charSequence.length() == 0 || (charSequence = (CharSequence)agreement.getReceiver_url()) == null || charSequence.length() == 0 || (charSequence = (CharSequence)agreement.getSender_url()) == null || charSequence.length() == 0 || (charSequence = (CharSequence)agreement.getStatus()) == null || charSequence.length() == 0) {
            Companion.getLogger().warn((Function0)postAgreementUuid.1.INSTANCE);
            throw (Throwable)new UnprocessableEntityException();
        }
        XdAgreement a2 = (XdAgreement)XdQueryKt.firstOrNull((XdQuery)XdFilteringQueryKt.filter((XdEntityType)((XdEntityType)XdAgreement.Companion), (Function2)((Function2)new Function2<FilteringContext, XdAgreement, XdSearchingNode>(agreementUuid){
            final /* synthetic */ String $agreementUuid;

            @NotNull
            public final XdSearchingNode invoke(@NotNull FilteringContext $receiver, @NotNull XdAgreement it) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                return $receiver.eq((Comparable)((Object)it.getUuid()), (Comparable)((Object)this.$agreementUuid));
            }
            {
                this.$agreementUuid = string;
                super(2);
            }
        })));
        if (a2 != null) {
            Companion.getLogger().warn((Function0)new Function0<String>(agreementUuid){
                final /* synthetic */ String $agreementUuid;

                @NotNull
                public final String invoke() {
                    return "agreement with id '" + this.$agreementUuid + "' already exists";
                }
                {
                    this.$agreementUuid = string;
                    super(0);
                }
            });
            throw (Throwable)new UnprocessableEntityException();
        }
        XdAgreementStatus xdAgreementStatus = (XdAgreementStatus)XdQueryKt.firstOrNull((XdQuery)XdFilteringQueryKt.filter((XdEntityType)((XdEntityType)XdAgreementStatus.Companion), (Function2)((Function2)new Function2<FilteringContext, XdAgreementStatus, XdSearchingNode>(agreement){
            final /* synthetic */ NHDAgreement $agreement;

            @NotNull
            public final XdSearchingNode invoke(@NotNull FilteringContext $receiver, @NotNull XdAgreementStatus it) {
                String string;
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                FilteringContext filteringContext = $receiver;
                Comparable comparable = (Comparable)((Object)it.getName());
                String string2 = this.$agreement.getStatus();
                if (string2 != null) {
                    String string3 = string2;
                    Comparable comparable2 = comparable;
                    FilteringContext filteringContext2 = filteringContext;
                    String string4 = string3;
                    if (string4 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string5 = string4.toUpperCase();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toUpperCase()");
                    String string6 = string5;
                    filteringContext = filteringContext2;
                    comparable = comparable2;
                    string = string6;
                } else {
                    string = null;
                }
                return filteringContext.eq(comparable, (Comparable)((Object)string));
            }
            {
                this.$agreement = nHDAgreement;
                super(2);
            }
        })));
        if (xdAgreementStatus == null) {
            throw (Throwable)new UnprocessableEntityException();
        }
        XdAgreementStatus status2 = xdAgreementStatus;
        XdAgreement.Companion.new((Function1)new Function1<XdAgreement, Unit>(agreementUuid, agreement, status2){
            final /* synthetic */ String $agreementUuid;
            final /* synthetic */ NHDAgreement $agreement;
            final /* synthetic */ XdAgreementStatus $status;

            public final void invoke(@NotNull XdAgreement $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
                $receiver.setUuid(this.$agreementUuid);
                $receiver.setAccessKey(this.$agreement.getAccess_key());
                String string = this.$agreement.getName();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                $receiver.setName(string);
                String string2 = this.$agreement.getReceiver_url();
                if (string2 == null) {
                    Intrinsics.throwNpe();
                }
                $receiver.setReceiverUrl(string2);
                String string3 = this.$agreement.getSender_url();
                if (string3 == null) {
                    Intrinsics.throwNpe();
                }
                $receiver.setSenderUrl(string3);
                $receiver.setStatus(this.$status);
                Boolean bl = this.$agreement.getSync_tags();
                $receiver.setSyncTags(bl != null ? bl : false);
                Boolean bl2 = this.$agreement.getSync_custom_fields();
                $receiver.setSyncCustomFields(bl2 != null ? bl2 : false);
                Boolean bl3 = this.$agreement.getAllows_public_comments();
                $receiver.setAllowsPublicComments(bl3 != null ? bl3 : false);
            }
            {
                this.$agreementUuid = string;
                this.$agreement = nHDAgreement;
                this.$status = xdAgreementStatus;
                super(1);
            }
        });
        Response response = Response.status((Response.Status)Response.Status.CREATED).header("Location", (Object)UrlUtil.getRestPathUri((String[])new String[]{"networkedhelpdesk"}).addPathElementsEncoded(new String[]{"agreements"}).addPathElements(new String[]{agreementUuid}).addQueryParameters(new QueryParameter[0])).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.status(Response\u2026                ).build()");
        return response;
    }

    @PUT
    @AuthIgnored
    @Path(value="/{agreement}")
    @Consumes(value={"application/json;charset=UTF-8"})
    @NotNull
    public final Response putAgreement(@Transformer(value="agreementByUuid") @PathParam(value="agreement") @NotNull XdAgreement agreement, @NotNull NHDAgreement newAgreement) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)agreement), (String)"agreement");
        Intrinsics.checkParameterIsNotNull((Object)newAgreement, (String)"newAgreement");
        if (Intrinsics.areEqual((Object)agreement.getUuid(), (Object)newAgreement.getUuid()) ^ true) {
            Companion.getLogger().warn((Function0)new Function0<String>(newAgreement, agreement){
                final /* synthetic */ NHDAgreement $newAgreement;
                final /* synthetic */ XdAgreement $agreement;

                @NotNull
                public final String invoke() {
                    return "agreement uuids mismatch: received '" + this.$newAgreement.getUuid() + "', restored '" + this.$agreement.getUuid() + '\'';
                }
                {
                    this.$newAgreement = nHDAgreement;
                    this.$agreement = xdAgreement;
                    super(0);
                }
            });
            throw (Throwable)new UnprocessableEntityException();
        }
        if (newAgreement.getSender_url() != null && Intrinsics.areEqual((Object)newAgreement.getSender_url(), (Object)agreement.getSenderUrl()) ^ true) {
            Companion.getLogger().warn((Function0)new Function0<String>(newAgreement, agreement){
                final /* synthetic */ NHDAgreement $newAgreement;
                final /* synthetic */ XdAgreement $agreement;

                @NotNull
                public final String invoke() {
                    return "agreement sender_url mismatch: received '" + this.$newAgreement.getSender_url() + "', restored '" + this.$agreement.getSenderUrl() + '\'';
                }
                {
                    this.$newAgreement = nHDAgreement;
                    this.$agreement = xdAgreement;
                    super(0);
                }
            });
            throw (Throwable)new UnprocessableEntityException();
        }
        if (newAgreement.getReceiver_url() != null && Intrinsics.areEqual((Object)newAgreement.getReceiver_url(), (Object)agreement.getReceiverUrl()) ^ true) {
            Companion.getLogger().warn((Function0)new Function0<String>(newAgreement, agreement){
                final /* synthetic */ NHDAgreement $newAgreement;
                final /* synthetic */ XdAgreement $agreement;

                @NotNull
                public final String invoke() {
                    return "agreement receiver_url mismatch: received '" + this.$newAgreement.getReceiver_url() + "', restored '" + this.$agreement.getReceiverUrl() + '\'';
                }
                {
                    this.$newAgreement = nHDAgreement;
                    this.$agreement = xdAgreement;
                    super(0);
                }
            });
            throw (Throwable)new UnprocessableEntityException();
        }
        if (newAgreement.getStatus() != null) {
            Companion.getLogger().info((Function0)new Function0<String>(newAgreement){
                final /* synthetic */ NHDAgreement $newAgreement;

                @NotNull
                public final String invoke() {
                    return "updating agreement status to '" + this.$newAgreement.getStatus() + '\'';
                }
                {
                    this.$newAgreement = nHDAgreement;
                    super(0);
                }
            });
            XdAgreementStatus xdAgreementStatus = (XdAgreementStatus)XdQueryKt.firstOrNull((XdQuery)XdFilteringQueryKt.filter((XdEntityType)((XdEntityType)XdAgreementStatus.Companion), (Function2)((Function2)new Function2<FilteringContext, XdAgreementStatus, XdSearchingNode>(newAgreement){
                final /* synthetic */ NHDAgreement $newAgreement;

                @NotNull
                public final XdSearchingNode invoke(@NotNull FilteringContext $receiver, @NotNull XdAgreementStatus it) {
                    String string;
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                    Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                    FilteringContext filteringContext = $receiver;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    String string2 = this.$newAgreement.getStatus();
                    if (string2 != null) {
                        String string3 = string2;
                        Comparable comparable2 = comparable;
                        FilteringContext filteringContext2 = filteringContext;
                        String string4 = string3;
                        if (string4 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string5 = string4.toUpperCase();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toUpperCase()");
                        String string6 = string5;
                        filteringContext = filteringContext2;
                        comparable = comparable2;
                        string = string6;
                    } else {
                        string = null;
                    }
                    return filteringContext.eq(comparable, (Comparable)((Object)string));
                }
                {
                    this.$newAgreement = nHDAgreement;
                    super(2);
                }
            })));
            if (xdAgreementStatus == null) {
                throw (Throwable)new UnprocessableEntityException();
            }
            XdAgreementStatus status2 = xdAgreementStatus;
            agreement.setStatus(status2);
        }
        if (newAgreement.getAccess_key() != null) {
            agreement.setAccessKey(newAgreement.getAccess_key());
        }
        if (newAgreement.getName() != null) {
            String string = newAgreement.getName();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            agreement.setName(string);
        }
        Response response = Response.ok().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok().build()");
        return response;
    }

    @GET
    @Path(value="/{agreement}")
    @Produces(value={"application/json;charset=UTF-8"})
    @NotNull
    public final NHDAgreement getAgreement(@Transformer(value="agreementByUuid") @PathParam(value="agreement") @NotNull XdAgreement agreement) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)agreement), (String)"agreement");
        return new NHDAgreement(agreement);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/zendesk/rest/integration/resources/AgreementsSubResource$Companion;", "Lmu/KLogging;", "()V", "youtrack-zendesk-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

