/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.zendesk.rest.integration.resources;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import jetbrains.charisma.workflow.exceptions.WorkflowException;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.database.TransientEntityStore;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.webr.rpc.rest.filter.runtime.Transactional;
import jetbrains.mps.webr.rpc.rest.runtime.Resource;
import jetbrains.mps.webr.rpc.rest.runtime.Transformer;
import jetbrains.mps.webr.runtime.uri.QueryParameter;
import jetbrains.mps.webr.userManagement.runtime.PrincipalManager;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.commands.CommandService;
import jetbrains.youtrack.api.commands.ICommandList;
import jetbrains.youtrack.api.notifications.NotificationProvider;
import jetbrains.youtrack.api.workflow.WorkflowUILogicException;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.gaprest.filters.AuthIgnored;
import jetbrains.youtrack.persistent.XdIssue;
import jetbrains.youtrack.persistent.XdIssueAttachment;
import jetbrains.youtrack.persistent.XdIssueComment;
import jetbrains.youtrack.persistent.XdProject;
import jetbrains.youtrack.persistent.XdUser;
import jetbrains.youtrack.persistent.XdUserGroup;
import jetbrains.youtrack.zendesk.BeansKt;
import jetbrains.youtrack.zendesk.TicketSharingInfoService;
import jetbrains.youtrack.zendesk.notifications.ZendeskAgreementDTO;
import jetbrains.youtrack.zendesk.notifications.ZendeskTicketDTO;
import jetbrains.youtrack.zendesk.persistent.ExtensionsKt;
import jetbrains.youtrack.zendesk.persistent.XdAgreement;
import jetbrains.youtrack.zendesk.persistent.XdTicketSharingInfo;
import jetbrains.youtrack.zendesk.rest.integration.NHDAttachment;
import jetbrains.youtrack.zendesk.rest.integration.NHDComment;
import jetbrains.youtrack.zendesk.rest.integration.NHDCustomFields;
import jetbrains.youtrack.zendesk.rest.integration.NHDTicket;
import jetbrains.youtrack.zendesk.rest.integration.NHDUser;
import jetbrains.youtrack.zendesk.rest.integration.resources.BackupRequestBody;
import jetbrains.youtrack.zendesk.rest.integration.resources.ResponseStatus;
import jetbrains.youtrack.zendesk.rest.integration.resources.TicketsSubResource;
import jetbrains.youtrack.zendesk.rest.integration.resources.TicketsSubResource$processAttachments$1$execute$;
import jetbrains.youtrack.zendesk.rest.integration.resources.UnprocessableEntityException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.FilteringContext;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.query.XdSearchingNode;
import mu.KLogging;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import webr.framework.url.UrlUtil;

@Component
@Transactional
@BackupRequestBody
@Produces(value={"application/xml;charset=UTF-8", "application/json;charset=UTF-8"})
@AuthIgnored
@Path(value="/networkedhelpdesk/tickets")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 <2\u00020\u0001:\u0001<B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0010\u001a\u00020\u00112\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001c\u0010\u0018\u001a\u00020\u00192\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0007J\u0018\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0019H\u0002J$\u0010\u001c\u001a\u00020\u00112\b\b\u0001\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u00192\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0007J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00172\u0006\u0010 \u001a\u00020\u001eH\u0002J,\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\n\b\u0002\u0010)\u001a\u0004\u0018\u00010*H\u0002J6\u0010+\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\u0010,\u001a\u0004\u0018\u00010-2\u001a\u0010.\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020*00\u0018\u00010/H\u0002J*\u00101\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020*000/2\u0006\u00102\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0019H\u0002J \u00103\u001a\u00020\"2\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00192\u0006\u0010#\u001a\u00020$H\u0002J\"\u00104\u001a\u0004\u0018\u00010-2\u0006\u00102\u001a\u00020\u00132\u000e\u0010.\u001a\n\u0012\u0004\u0012\u00020-\u0018\u00010/H\u0002J*\u00105\u001a\u0002H6\"\u0004\b\u0000\u001062\u0006\u00107\u001a\u00020(2\f\u00108\u001a\b\u0012\u0004\u0012\u0002H609H\u0082\b\u00a2\u0006\u0002\u0010:J$\u0010;\u001a\u00020\u00112\b\b\u0001\u00102\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00192\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u000b8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006="}, d2={"Ljetbrains/youtrack/zendesk/rest/integration/resources/TicketsSubResource;", "Ljetbrains/mps/webr/rpc/rest/runtime/Resource;", "()V", "attachmentClient", "Ljavax/ws/rs/client/Client;", "kotlin.jvm.PlatformType", "commandService", "Ljetbrains/youtrack/api/commands/CommandService;", "getCommandService", "()Ljetbrains/youtrack/api/commands/CommandService;", "notificationProvider", "Ljetbrains/youtrack/api/notifications/NotificationProvider;", "getNotificationProvider", "()Ljetbrains/youtrack/api/notifications/NotificationProvider;", "setNotificationProvider", "(Ljetbrains/youtrack/api/notifications/NotificationProvider;)V", "deleteTicket", "Ljavax/ws/rs/core/Response;", "ticket", "Ljetbrains/youtrack/zendesk/persistent/XdTicketSharingInfo;", "headers", "Ljavax/ws/rs/core/HttpHeaders;", "findAgreement", "Ljetbrains/youtrack/zendesk/persistent/XdAgreement;", "getTicket", "Ljetbrains/youtrack/zendesk/rest/integration/NHDTicket;", "newSharingInfo", "agreement", "newTicket", "ticketUid", "", "parseAgreementUuid", "sharingToken", "processAttachment", "", "issue", "Ljetbrains/youtrack/persistent/XdIssue;", "attachment", "Ljetbrains/youtrack/zendesk/rest/integration/NHDAttachment;", "author", "Ljetbrains/youtrack/persistent/XdUser;", "comment", "Ljetbrains/youtrack/persistent/XdIssueComment;", "processAttachments", "descriptionComment", "Ljetbrains/youtrack/zendesk/rest/integration/NHDComment;", "comments", "", "Lkotlin/Pair;", "processComments", "sharingInfo", "processCustomFields", "processDescription", "runWithFlushAs", "R", "user", "action", "Lkotlin/Function0;", "(Ljetbrains/youtrack/persistent/XdUser;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "updateTicket", "Companion", "youtrack-zendesk-integration"})
public final class TicketsSubResource
implements Resource {
    private final Client attachmentClient = ClientBuilder.newBuilder().build();
    @Autowired
    @Qualifier(value="notificationProvider")
    @NotNull
    public NotificationProvider notificationProvider;
    public static final Companion Companion = new Companion(null);

    private final CommandService getCommandService() {
        String name$iv = "commandService";
        boolean $i$f$getBean = false;
        Object object = ServiceLocator.getBean((String)name$iv);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.youtrack.api.commands.CommandService");
        }
        return (CommandService)object;
    }

    @NotNull
    public final NotificationProvider getNotificationProvider() {
        NotificationProvider notificationProvider = this.notificationProvider;
        if (notificationProvider == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"notificationProvider");
        }
        return notificationProvider;
    }

    public final void setNotificationProvider(@NotNull NotificationProvider notificationProvider) {
        Intrinsics.checkParameterIsNotNull((Object)notificationProvider, (String)"<set-?>");
        this.notificationProvider = notificationProvider;
    }

    @POST
    @AuthIgnored
    @Path(value="/{ticketUid}")
    @Consumes(value={"application/json;charset=UTF-8"})
    @NotNull
    public final Response newTicket(@PathParam(value="ticketUid") @NotNull String ticketUid, @NotNull NHDTicket ticket, @Context @NotNull HttpHeaders headers) {
        Intrinsics.checkParameterIsNotNull((Object)ticketUid, (String)"ticketUid");
        Intrinsics.checkParameterIsNotNull((Object)ticket, (String)"ticket");
        Intrinsics.checkParameterIsNotNull((Object)headers, (String)"headers");
        if (XdQueryKt.firstOrNull((XdQuery)XdFilteringQueryKt.filter((XdEntityType)((XdEntityType)XdTicketSharingInfo.Companion), (Function2)((Function2)new Function2<FilteringContext, XdTicketSharingInfo, XdSearchingNode>(ticketUid){
            final /* synthetic */ String $ticketUid;

            @NotNull
            public final XdSearchingNode invoke(@NotNull FilteringContext $receiver, @NotNull XdTicketSharingInfo it) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                return $receiver.eq((Comparable)((Object)it.getUuid()), (Comparable)((Object)this.$ticketUid));
            }
            {
                this.$ticketUid = string;
                super(2);
            }
        }))) != null) {
            Companion.getLogger().info((Function0)new Function0<String>(ticketUid){
                final /* synthetic */ String $ticketUid;

                @NotNull
                public final String invoke() {
                    return "ticket sharing info already found by '" + this.$ticketUid + '\'';
                }
                {
                    this.$ticketUid = string;
                    super(0);
                }
            });
            throw (Throwable)new UnprocessableEntityException();
        }
        if (Intrinsics.areEqual((Object)ticketUid, (Object)ticket.getUuid()) ^ true) {
            Companion.getLogger().info((Function0)new Function0<String>(ticketUid, ticket){
                final /* synthetic */ String $ticketUid;
                final /* synthetic */ NHDTicket $ticket;

                @NotNull
                public final String invoke() {
                    return "incoming ticket info mismatch: '" + this.$ticketUid + "' and '" + this.$ticket.getUuid() + '\'';
                }
                {
                    this.$ticketUid = string;
                    this.$ticket = nHDTicket;
                    super(0);
                }
            });
            throw (Throwable)new UnprocessableEntityException();
        }
        XdAgreement agreement = this.findAgreement(headers);
        try {
            XdTicketSharingInfo sharingInfo2 = this.newSharingInfo(agreement, ticket);
            XdIssue issue2 = sharingInfo2.getIssue();
            TicketSharingInfoService.syncWithZendesk$default(BeansKt.getTicketSharingInfoService(), issue2, issue2.getReporter(), false, 4, null);
            Response response = Response.status((Response.Status)Response.Status.CREATED).header("Location", (Object)UrlUtil.getRestPathUri((String[])new String[]{"networkedhelpdesk"}).addPathElementsEncoded(new String[]{"tickets"}).addPathElements(new String[]{sharingInfo2.getUuid()}).addQueryParameters(new QueryParameter[0])).build();
            Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.status(Response\u2026                 .build()");
            return response;
        }
        catch (Throwable e) {
            Throwable throwable = e;
            if (throwable instanceof WorkflowException || throwable instanceof WorkflowUILogicException) {
                Companion.getLogger().error(e, (Function0)new Function0<String>(ticket){
                    final /* synthetic */ NHDTicket $ticket;

                    @NotNull
                    public final String invoke() {
                        return "workflow prevents to create new issue from ticket " + this.$ticket.getOriginal_id();
                    }
                    {
                        this.$ticket = nHDTicket;
                        super(0);
                    }
                });
                XdProject xdProject = agreement.getProject();
                if (xdProject != null) {
                    XdProject xdProject2;
                    XdProject it = xdProject2 = xdProject;
                    boolean bl = false;
                    Map data = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"agreement", (Object)new ZendeskAgreementDTO(agreement)), TuplesKt.to((Object)"ticket", (Object)new ZendeskTicketDTO(ticket)), TuplesKt.to((Object)"exception", (Object)e)});
                    NotificationProvider notificationProvider = this.notificationProvider;
                    if (notificationProvider == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"notificationProvider");
                    }
                    notificationProvider.notify("zendeskWorkflow", it.getLeader().getEntity(), null, data);
                }
                Response response = Response.status((Response.StatusType)ResponseStatus.UNPROCESSABLE_ENTITY).build();
                Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.status(Response\u2026OCESSABLE_ENTITY).build()");
                return response;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @PUT
    @AuthIgnored
    @Path(value="/{sharingInfo}")
    @NotNull
    public final Response updateTicket(@Transformer(value="ticketByUuid") @PathParam(value="sharingInfo") @NotNull XdTicketSharingInfo sharingInfo2, @NotNull NHDTicket ticket, @Context @NotNull HttpHeaders headers) {
        void newComments;
        Intrinsics.checkParameterIsNotNull((Object)((Object)sharingInfo2), (String)"sharingInfo");
        Intrinsics.checkParameterIsNotNull((Object)ticket, (String)"ticket");
        Intrinsics.checkParameterIsNotNull((Object)headers, (String)"headers");
        if (Intrinsics.areEqual((Object)sharingInfo2.getUuid(), (Object)ticket.getUuid()) ^ true) {
            Companion.getLogger().info((Function0)new Function0<String>(sharingInfo2, ticket){
                final /* synthetic */ XdTicketSharingInfo $sharingInfo;
                final /* synthetic */ NHDTicket $ticket;

                @NotNull
                public final String invoke() {
                    return "ticket sharing info mismatch: '" + this.$sharingInfo.getUuid() + "' and '" + this.$ticket.getUuid() + '\'';
                }
                {
                    this.$sharingInfo = xdTicketSharingInfo;
                    this.$ticket = nHDTicket;
                    super(0);
                }
            });
            throw (Throwable)new UnprocessableEntityException();
        }
        XdAgreement agreement = this.findAgreement(headers);
        NHDUser nHDUser = ticket.getCurrent_actor();
        NHDUser nHDUser2 = ticket.getCurrent_actor();
        XdUser actor = agreement.resolveUser(nHDUser != null ? nHDUser.getUuid() : null, nHDUser2 != null ? nHDUser2.getName() : null);
        if (actor == null) {
            Companion.getLogger().info((Function0)new Function0<String>(ticket){
                final /* synthetic */ NHDTicket $ticket;

                @NotNull
                public final String invoke() {
                    NHDUser nHDUser = this.$ticket.getCurrent_actor();
                    NHDUser nHDUser2 = this.$ticket.getCurrent_actor();
                    return "can't resolve user by Zendesk uuid '" + (nHDUser != null ? nHDUser.getUuid() : null) + "' and name '" + (nHDUser2 != null ? nHDUser2.getName() : null) + '\'';
                }
                {
                    this.$ticket = nHDTicket;
                    super(0);
                }
            });
            throw (Throwable)new UnprocessableEntityException();
        }
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        TicketsSubResource this_$iv = this;
        boolean $i$f$runWithFlushAs = false;
        boolean $i$f$runAs = false;
        Entity user$iv$iv$iv = actor.getEntity();
        boolean $i$f$runAs2 = false;
        PrincipalManager _principalManager$iv$iv$iv = jetbrains.charisma.main.BeansKt.getPrincipalManager();
        try {
            _principalManager$iv$iv$iv.setTemporaryServerPrincipal((Object)user$iv$iv$iv);
            boolean bl = false;
            boolean bl2 = false;
            XdIssue issue2 = sharingInfo2.getIssue();
            try {
                if (ticket.getSubject() != null) {
                    issue2.setSummary(ticket.getSubject());
                }
                if (ticket.getStatus() != null) {
                    sharingInfo2.setStatus(ticket.getStatus());
                }
                this.processCustomFields(agreement, ticket, issue2);
                newComments.element = this.processComments(sharingInfo2, ticket);
                LegacySupportKt.flush();
                if (agreement.getSyncTags()) {
                    sharingInfo2.setTags(ticket.getTags());
                    sharingInfo2.setUpdatedByNhd(System.currentTimeMillis());
                }
                LegacySupportKt.flush();
                boolean ignoreStatus = Intrinsics.areEqual((Object)ticket.getStatus(), (Object)"open") && Intrinsics.areEqual((Object)sharingInfo2.getStatus(), (Object)"open");
                BeansKt.getTicketSharingInfoService().syncWithZendesk(issue2, actor, ignoreStatus);
            }
            catch (WorkflowException e) {
                Companion.getLogger().error((Throwable)e, (Function0)new Function0<String>(issue2){
                    final /* synthetic */ XdIssue $issue;

                    @NotNull
                    public final String invoke() {
                        return "workflow prevents to update issue '" + this.$issue.getIdReadable() + '\'';
                    }
                    {
                        this.$issue = xdIssue;
                        super(0);
                    }
                });
                XdProject xdProject = agreement.getProject();
                if (xdProject != null) {
                    XdProject xdProject2;
                    XdProject it = xdProject2 = xdProject;
                    boolean bl3 = false;
                    Map data = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"agreement", (Object)new ZendeskAgreementDTO(agreement)), TuplesKt.to((Object)"ticket", (Object)new ZendeskTicketDTO(ticket)), TuplesKt.to((Object)"exception", (Object)((Object)e))});
                    NotificationProvider notificationProvider = this.notificationProvider;
                    if (notificationProvider == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"notificationProvider");
                    }
                    notificationProvider.notify("zendeskWorkflow", it.getLeader().getEntity(), issue2.getEntity(), data);
                }
                Response response = Response.status((Response.StatusType)ResponseStatus.UNPROCESSABLE_ENTITY).build();
                Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.status(Response\u2026OCESSABLE_ENTITY).build()");
                Response response2 = response;
                _principalManager$iv$iv$iv.unsetTemporaryServerPrincipal();
                return response2;
            }
            Unit result$iv = Unit.INSTANCE;
            LegacySupportKt.flush();
            Unit unit = result$iv;
        }
        finally {
            _principalManager$iv$iv$iv.unsetTemporaryServerPrincipal();
        }
        boolean $i$f$transactional = false;
        TransientEntityStore.DefaultImpls.transactional$default((TransientEntityStore)DnqUtils.getTransientStore(), (boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, Unit>(this, sharingInfo2, (Ref.ObjectRef)newComments){
            final /* synthetic */ TicketsSubResource this$0;
            final /* synthetic */ XdTicketSharingInfo $sharingInfo$inlined;
            final /* synthetic */ Ref.ObjectRef $newComments$inlined;
            {
                this.this$0 = ticketsSubResource;
                this.$sharingInfo$inlined = xdTicketSharingInfo;
                this.$newComments$inlined = objectRef;
                super(1);
            }

            public final Unit invoke(@NotNull TransientStoreSession it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                boolean bl = false;
                TicketsSubResource.access$processAttachments(this.this$0, this.$sharingInfo$inlined.getIssue(), null, (List)this.$newComments$inlined.element);
                return Unit.INSTANCE;
            }
        }), (int)7, null);
        Response response = Response.ok().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok().build()");
        return response;
    }

    @GET
    @AuthIgnored
    @Path(value="/{ticket}")
    @NotNull
    public final NHDTicket getTicket(@Transformer(value="ticketByUuid") @PathParam(value="ticket") @NotNull XdTicketSharingInfo ticket, @Context @NotNull HttpHeaders headers) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)ticket), (String)"ticket");
        Intrinsics.checkParameterIsNotNull((Object)headers, (String)"headers");
        this.findAgreement(headers);
        return new NHDTicket(ticket, false);
    }

    @DELETE
    @AuthIgnored
    @Path(value="/{ticket}")
    @NotNull
    public final Response deleteTicket(@Transformer(value="ticketByUuid") @PathParam(value="ticket") @NotNull XdTicketSharingInfo ticket, @Context @NotNull HttpHeaders headers) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)ticket), (String)"ticket");
        Intrinsics.checkParameterIsNotNull((Object)headers, (String)"headers");
        this.findAgreement(headers);
        ticket.delete();
        LegacySupportKt.flush();
        Response response = Response.ok().build();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"Response.ok().build()");
        return response;
    }

    private final XdAgreement parseAgreementUuid(String sharingToken) {
        List splitResult = StringsKt.split$default((CharSequence)sharingToken, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
        if (splitResult.isEmpty()) {
            return null;
        }
        return (XdAgreement)XdQueryKt.firstOrNull((XdQuery)XdFilteringQueryKt.filter((XdEntityType)((XdEntityType)XdAgreement.Companion), (Function2)((Function2)new Function2<FilteringContext, XdAgreement, XdSearchingNode>(splitResult){
            final /* synthetic */ List $splitResult;

            @NotNull
            public final XdSearchingNode invoke(@NotNull FilteringContext $receiver, @NotNull XdAgreement it) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                return $receiver.eq((Comparable)((Object)it.getUuid()), (Comparable)this.$splitResult.get(0));
            }
            {
                this.$splitResult = list;
                super(2);
            }
        })));
    }

    private final XdAgreement findAgreement(HttpHeaders headers) {
        String sharedToken = (String)headers.getRequestHeaders().getFirst((Object)"X-Ticket-Sharing-Token");
        if (sharedToken == null) {
            Companion.getLogger().info((Function0)findAgreement.1.INSTANCE);
            throw (Throwable)new ForbiddenException();
        }
        XdAgreement agreementUuid = this.parseAgreementUuid(sharedToken);
        if (agreementUuid == null) {
            Companion.getLogger().info((Function0)findAgreement.2.INSTANCE);
        }
        XdAgreement xdAgreement = agreementUuid;
        if (xdAgreement == null) {
            throw (Throwable)new ForbiddenException();
        }
        return xdAgreement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final XdTicketSharingInfo newSharingInfo(XdAgreement agreement, NHDTicket ticket) {
        XdIssue $i$a$-runAs-TicketsSubResource$runWithFlushAs$22;
        CharSequence charSequence;
        void commandList;
        void newComments;
        void commentWithDescription;
        NHDUser nHDUser = ticket.getRequester();
        NHDUser nHDUser2 = ticket.getRequester();
        XdUser reporter = agreement.resolveUser(nHDUser != null ? nHDUser.getUuid() : null, nHDUser2 != null ? nHDUser2.getName() : null);
        if (reporter == null) {
            Companion.getLogger().info((Function0)new Function0<String>(ticket){
                final /* synthetic */ NHDTicket $ticket;

                @NotNull
                public final String invoke() {
                    NHDUser nHDUser = this.$ticket.getRequester();
                    NHDUser nHDUser2 = this.$ticket.getRequester();
                    return "can't resolve user by zendesk uuid '" + (nHDUser != null ? nHDUser.getUuid() : null) + "' and name '" + (nHDUser2 != null ? nHDUser2.getName() : null) + '\'';
                }
                {
                    this.$ticket = nHDTicket;
                    super(0);
                }
            });
            throw (Throwable)new UnprocessableEntityException();
        }
        XdTicketSharingInfo sharingInfo2 = XdTicketSharingInfo.Companion.new(agreement, (Function1<? super XdTicketSharingInfo, Unit>)((Function1)new Function1<XdTicketSharingInfo, Unit>(ticket){
            final /* synthetic */ NHDTicket $ticket;

            public final void invoke(@NotNull XdTicketSharingInfo $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)$receiver), (String)"receiver$0");
                $receiver.setUuid(this.$ticket.getUuid());
                Integer n = this.$ticket.getOriginal_id();
                $receiver.setOriginalId(n != null ? n : 0);
            }
            {
                this.$ticket = nHDTicket;
                super(1);
            }
        }));
        XdProject xdProject = agreement.getProject();
        if (xdProject == null) {
            Intrinsics.throwNpe();
        }
        XdProject project = xdProject;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        Ref.ObjectRef objectRef2 = new Ref.ObjectRef();
        objectRef2.element = null;
        Ref.ObjectRef objectRef3 = new Ref.ObjectRef();
        objectRef3.element = null;
        TicketsSubResource this_$iv = this;
        boolean $i$f$runWithFlushAs = false;
        boolean $i$f$runAs = false;
        Entity user$iv$iv$iv = reporter.getEntity();
        boolean $i$f$runAs2 = false;
        PrincipalManager _principalManager$iv$iv$iv = jetbrains.charisma.main.BeansKt.getPrincipalManager();
        try {
            String command;
            String string;
            _principalManager$iv$iv$iv.setTemporaryServerPrincipal((Object)user$iv$iv$iv);
            boolean $i$a$-runAs-TicketsSubResource$runWithFlushAs$22 = false;
            boolean bl = false;
            XdIssue issue2 = XdIssue.Companion.new(reporter, project, (Function1)new Function1<XdIssue, Unit>(this, reporter, project, ticket, sharingInfo2, agreement, (Ref.ObjectRef)commentWithDescription, (Ref.ObjectRef)newComments, (Ref.ObjectRef)commandList){
                final /* synthetic */ TicketsSubResource this$0;
                final /* synthetic */ XdUser $reporter$inlined;
                final /* synthetic */ XdProject $project$inlined;
                final /* synthetic */ NHDTicket $ticket$inlined;
                final /* synthetic */ XdTicketSharingInfo $sharingInfo$inlined;
                final /* synthetic */ XdAgreement $agreement$inlined;
                final /* synthetic */ Ref.ObjectRef $commentWithDescription$inlined;
                final /* synthetic */ Ref.ObjectRef $newComments$inlined;
                final /* synthetic */ Ref.ObjectRef $commandList$inlined;
                {
                    this.this$0 = ticketsSubResource;
                    this.$reporter$inlined = xdUser;
                    this.$project$inlined = xdProject;
                    this.$ticket$inlined = nHDTicket;
                    this.$sharingInfo$inlined = xdTicketSharingInfo;
                    this.$agreement$inlined = xdAgreement;
                    this.$commentWithDescription$inlined = objectRef;
                    this.$newComments$inlined = objectRef2;
                    this.$commandList$inlined = objectRef3;
                    super(1);
                }

                public final void invoke(@NotNull XdIssue $receiver) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                    $receiver.setSummary(this.$ticket$inlined.getSubject());
                    $receiver.setUsesMarkdown(true);
                }
            });
            sharingInfo2.setIssue(issue2);
            CharSequence charSequence2 = issue2.getSummary();
            if (charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) {
                issue2.setSummary(jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsgInServerLocale("tickets.Zendesk_issue", new Object[]{ticket.getUuid()}));
                Companion.getLogger().error((Function0)newSharingInfo.issue.1.1.INSTANCE);
            }
            XdUserGroup xdUserGroup = agreement.getPermittedGroup();
            if (xdUserGroup != null) {
                CharSequence it = charSequence2 = xdUserGroup;
                boolean bl2 = false;
                issue2.getPermittedGroup().clear();
                issue2.getPermittedGroup().add((XdEntity)it);
            }
            sharingInfo2.setStatus(ticket.getStatus());
            commentWithDescription.element = this.processDescription(sharingInfo2, ticket.getComments());
            this.processCustomFields(agreement, ticket, issue2);
            newComments.element = this.processComments(sharingInfo2, ticket);
            if (agreement.getSyncTags()) {
                sharingInfo2.setTags(ticket.getTags());
            }
            String string2 = agreement.getCommand();
            if (string2 != null) {
                charSequence = string2;
                String string3 = charSequence;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                string = ((Object)StringsKt.trim((CharSequence)string3)).toString();
            } else {
                string = command = null;
            }
            if (command != null && (charSequence = (CharSequence)command).length() > 0) {
                charSequence = this.getCommandService().parse(command, issue2.getEntity());
                void var22_34 = commandList;
                CharSequence it = charSequence;
                boolean bl3 = false;
                it.execute(false);
                CharSequence charSequence3 = charSequence;
                var22_34.element = charSequence3;
            }
            XdIssue result$iv = issue2;
            LegacySupportKt.flush();
            $i$a$-runAs-TicketsSubResource$runWithFlushAs$22 = result$iv;
        }
        finally {
            _principalManager$iv$iv$iv.unsetTemporaryServerPrincipal();
        }
        XdIssue issue3 = $i$a$-runAs-TicketsSubResource$runWithFlushAs$22;
        ICommandList iCommandList = (ICommandList)commandList.element;
        if (iCommandList != null) {
            TicketsSubResource it = this_$iv = iCommandList;
            boolean bl = false;
            XdUser user$iv = reporter;
            $i$f$runAs2 = false;
            Entity user$iv$iv = user$iv.getEntity();
            boolean $i$f$runAs3 = false;
            PrincipalManager _principalManager$iv$iv = jetbrains.charisma.main.BeansKt.getPrincipalManager();
            try {
                _principalManager$iv$iv.setTemporaryServerPrincipal((Object)user$iv$iv);
                boolean bl4 = false;
                if (it.hasErrors()) {
                    Map data = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"commandList", (Object)((ICommandList)commandList.element)), TuplesKt.to((Object)"agreement", (Object)new ZendeskAgreementDTO(agreement)), TuplesKt.to((Object)"ticket", (Object)new ZendeskTicketDTO(ticket))});
                    NotificationProvider notificationProvider = this.notificationProvider;
                    if (notificationProvider == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"notificationProvider");
                    }
                    notificationProvider.notify("zendeskBadCommand", project.getLeader().getEntity(), issue3.getEntity(), data);
                }
                charSequence = Unit.INSTANCE;
            }
            finally {
                _principalManager$iv$iv.unsetTemporaryServerPrincipal();
            }
        }
        this_$iv = this;
        $i$f$runWithFlushAs = false;
        $i$f$runAs = false;
        user$iv$iv$iv = reporter.getEntity();
        $i$f$runAs2 = false;
        _principalManager$iv$iv$iv = jetbrains.charisma.main.BeansKt.getPrincipalManager();
        try {
            _principalManager$iv$iv$iv.setTemporaryServerPrincipal((Object)user$iv$iv$iv);
            boolean bl = false;
            boolean bl5 = false;
            this.processAttachments(issue3, (NHDComment)commentWithDescription.element, (List)newComments.element);
            Unit result$iv = Unit.INSTANCE;
            LegacySupportKt.flush();
            Unit unit = result$iv;
        }
        finally {
            _principalManager$iv$iv$iv.unsetTemporaryServerPrincipal();
        }
        return sharingInfo2;
    }

    private final NHDComment processDescription(XdTicketSharingInfo sharingInfo2, List<NHDComment> comments2) {
        Collection collection;
        if (comments2 == null) {
            return null;
        }
        XdIssue issue2 = sharingInfo2.getIssue();
        NHDComment comment = null;
        if (sharingInfo2.getCommentMappedToDescriptionUuid() == null && !(collection = (Collection)comments2).isEmpty()) {
            comment = (NHDComment)CollectionsKt.first(comments2);
            sharingInfo2.setCommentMappedToDescriptionUuid(comment.getUuid());
        } else {
            Object v0;
            block6: {
                Iterable $receiver$iv = comments2;
                for (Object element$iv : $receiver$iv) {
                    NHDComment it = (NHDComment)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)sharingInfo2.getCommentMappedToDescriptionUuid(), null)) continue;
                    v0 = element$iv;
                    break block6;
                }
                v0 = null;
            }
            Object var11_10 = v0;
            comment = var11_10;
        }
        if (comment != null) {
            String string = comment.getBody();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            issue2.setDescription(string);
            return comment;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<NHDComment, XdIssueComment>> processComments(XdTicketSharingInfo sharingInfo2, NHDTicket ticket) {
        Collection<String> collection;
        void $receiver$iv$iv;
        String uuid;
        Iterable $receiver$iv;
        Collection<String> processedComments = sharingInfo2.getProcessedComments();
        ArrayList<Pair> newComments = new ArrayList<Pair>();
        List<NHDComment> list = ticket.getComments();
        if (list != null) {
            $receiver$iv = list;
            for (Object element$iv : $receiver$iv) {
                CharSequence charSequence;
                NHDComment it = (NHDComment)element$iv;
                boolean bl = false;
                String string = uuid = it.getUuid();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                XdIssueComment comment = sharingInfo2.findCommentByUuid(string);
                boolean alreadyProcessed = processedComments.contains(uuid);
                if (comment != null || alreadyProcessed) continue;
                XdAgreement xdAgreement = sharingInfo2.getAgreement();
                NHDUser nHDUser = it.getAuthor();
                if (nHDUser == null) {
                    Intrinsics.throwNpe();
                }
                String string2 = nHDUser.getUuid();
                NHDUser nHDUser2 = it.getAuthor();
                if (nHDUser2 == null) {
                    Intrinsics.throwNpe();
                }
                String string3 = nHDUser2.getName();
                if (string3 == null) {
                    Intrinsics.throwNpe();
                }
                XdUser commentAuthor = xdAgreement.resolveUser(string2, string3);
                Companion.getLogger().info((Function0)new Function0<String>(commentAuthor){
                    final /* synthetic */ XdUser $commentAuthor;

                    @NotNull
                    public final String invoke() {
                        XdUser xdUser = this.$commentAuthor;
                        return "resolved comment author is '" + (xdUser != null ? xdUser.getLogin() : null) + '\'';
                    }
                    {
                        this.$commentAuthor = xdUser;
                        super(0);
                    }
                });
                if (commentAuthor == null || (charSequence = (CharSequence)it.getBody()) == null || StringsKt.isBlank((CharSequence)charSequence)) continue;
                String string4 = it.getBody();
                if (string4 == null) {
                    Intrinsics.throwNpe();
                }
                comment = XdIssueComment.Companion.new(string4, sharingInfo2.getIssue(), commentAuthor, (Function1)processComments.1.2.INSTANCE);
                ExtensionsKt.setZendeskCommentUUID(comment, uuid);
                newComments.add(TuplesKt.to((Object)it, (Object)comment));
            }
        }
        $receiver$iv = newComments;
        XdTicketSharingInfo xdTicketSharingInfo = sharingInfo2;
        TicketSharingInfoService ticketSharingInfoService = BeansKt.getTicketSharingInfoService();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            uuid = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = ((NHDComment)it.getFirst()).getUuid();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        ticketSharingInfoService.addProcessedComments(xdTicketSharingInfo, CollectionsKt.filterNotNull((Iterable)CollectionsKt.toList((Iterable)collection)));
        return newComments;
    }

    private final void processCustomFields(XdAgreement agreement, NHDTicket ticket, XdIssue issue2) {
        if (!agreement.getSyncCustomFields()) {
            return;
        }
        NHDCustomFields customFields = ticket.getCustom_fields();
        if (customFields != null) {
            Map<String, String> map = customFields.getZd_custom_fields();
            if (map != null) {
                Map<String, String> $receiver$iv;
                Map<String, String> map2 = $receiver$iv = map;
                Iterator<Map.Entry<String, String>> iterator = map2.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, String> element$iv;
                    Map.Entry<String, String> it = element$iv = iterator.next();
                    boolean bl = false;
                    String value = it.getValue();
                    CharSequence charSequence = value;
                    if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) continue;
                    BeansKt.getTicketSharingInfoService().setCustomFieldIfPossible(issue2, it.getKey(), value);
                }
            }
        }
    }

    private final void processAttachments(XdIssue issue2, NHDComment descriptionComment, List<? extends Pair<NHDComment, ? extends XdIssueComment>> comments2) {
        jetbrains.charisma.persistence.customfields.BeansKt.getUserActionJobProcessor().queue(new Job(this, issue2, descriptionComment, comments2){
            final /* synthetic */ TicketsSubResource this$0;
            final /* synthetic */ XdIssue $issue;
            final /* synthetic */ NHDComment $descriptionComment;
            final /* synthetic */ List $comments;

            protected void execute() {
                block7: {
                    boolean $i$f$transactional = false;
                    String idReadable = (String)TransientEntityStore.DefaultImpls.transactional$default((TransientEntityStore)DnqUtils.getTransientStore(), (boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, String>(this){
                        final /* synthetic */ processAttachments.1 this$0;
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }

                        public final String invoke(@NotNull TransientStoreSession it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            boolean bl = false;
                            return this.this$0.$issue.getIdReadable();
                        }
                    }), (int)7, null);
                    try {
                        List list;
                        Iterable $receiver$iv;
                        boolean $i$f$transactional2 = false;
                        XdUser reporter = (XdUser)TransientEntityStore.DefaultImpls.transactional$default((TransientEntityStore)DnqUtils.getTransientStore(), (boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, XdUser>(this){
                            final /* synthetic */ processAttachments.1 this$0;
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }

                            public final XdUser invoke(@NotNull TransientStoreSession it) {
                                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                boolean bl = false;
                                return this.this$0.$issue.getReporter();
                            }
                        }), (int)7, null);
                        TicketsSubResource.Companion.getLogger().debug((Function0)new Function0<String>(idReadable){
                            final /* synthetic */ String $idReadable;

                            @NotNull
                            public final String invoke() {
                                return "Processing attachments to issue " + this.$idReadable;
                            }
                            {
                                this.$idReadable = string;
                                super(0);
                            }
                        });
                        NHDComment nHDComment = this.$descriptionComment;
                        if (nHDComment != null) {
                            NHDComment nHDComment2;
                            NHDComment comment = nHDComment2 = nHDComment;
                            boolean bl = false;
                            TicketsSubResource.Companion.getLogger().debug((Function0)new Function0<String>(this, idReadable, reporter){
                                final /* synthetic */ processAttachments.1 this$0;
                                final /* synthetic */ String $idReadable$inlined;
                                final /* synthetic */ XdUser $reporter$inlined;
                                {
                                    this.this$0 = var1_1;
                                    this.$idReadable$inlined = string;
                                    this.$reporter$inlined = xdUser;
                                    super(0);
                                }

                                @NotNull
                                public final String invoke() {
                                    return "Processing direct attachments to issue " + this.$idReadable$inlined;
                                }
                            });
                            List<NHDAttachment> list2 = comment.getAttachments();
                            if (list2 != null) {
                                $receiver$iv = list2;
                                for (T element$iv : $receiver$iv) {
                                    NHDAttachment it = (NHDAttachment)element$iv;
                                    boolean bl2 = false;
                                    boolean $i$f$transactional3 = false;
                                    TransientEntityStore.DefaultImpls.transactional$default((TransientEntityStore)DnqUtils.getTransientStore(), (boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, Unit>(it, this, idReadable, reporter){
                                        final /* synthetic */ NHDAttachment $it$inlined;
                                        final /* synthetic */ processAttachments.1 this$0;
                                        final /* synthetic */ String $idReadable$inlined;
                                        final /* synthetic */ XdUser $reporter$inlined;
                                        {
                                            this.$it$inlined = nHDAttachment;
                                            this.this$0 = var2_2;
                                            this.$idReadable$inlined = string;
                                            this.$reporter$inlined = xdUser;
                                            super(1);
                                        }

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        public final Unit invoke(@NotNull TransientStoreSession it) {
                                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                            boolean bl = false;
                                            TicketsSubResource ticketsSubResource = this.this$0.this$0;
                                            XdUser user$iv = this.$reporter$inlined;
                                            boolean $i$f$runWithFlushAs = false;
                                            boolean $i$f$runAs = false;
                                            Entity user$iv$iv$iv = user$iv.getEntity();
                                            boolean $i$f$runAs2 = false;
                                            PrincipalManager _principalManager$iv$iv$iv = jetbrains.charisma.main.BeansKt.getPrincipalManager();
                                            try {
                                                _principalManager$iv$iv$iv.setTemporaryServerPrincipal((Object)user$iv$iv$iv);
                                                boolean bl2 = false;
                                                boolean bl3 = false;
                                                TicketsSubResource.Companion.getLogger().debug((Function0)new Function0<String>(this){
                                                    final /* synthetic */ processAttachments$1$execute$$inlined$let$lambda$2 this$0;
                                                    {
                                                        this.this$0 = var1_1;
                                                        super(0);
                                                    }

                                                    @NotNull
                                                    public final String invoke() {
                                                        return "Adding attachment " + this.this$0.$it$inlined.getFilename() + " to issue " + this.this$0.$idReadable$inlined;
                                                    }
                                                });
                                                TicketsSubResource.processAttachment$default(this.this$0.this$0, this.this$0.$issue, this.$it$inlined, this.this$0.$issue.getReporter(), null, 8, null);
                                                Unit result$iv = Unit.INSTANCE;
                                                LegacySupportKt.flush();
                                                Unit unit = result$iv;
                                            }
                                            finally {
                                                _principalManager$iv$iv$iv.unsetTemporaryServerPrincipal();
                                            }
                                            return Unit.INSTANCE;
                                        }
                                    }), (int)7, null);
                                }
                            }
                        }
                        List list3 = this.$comments;
                        if (list3 == null) break block7;
                        List notNullComments = list = list3;
                        boolean bl = false;
                        TicketsSubResource.Companion.getLogger().debug((Function0)new Function0<String>(this, idReadable, reporter){
                            final /* synthetic */ processAttachments.1 this$0;
                            final /* synthetic */ String $idReadable$inlined;
                            final /* synthetic */ XdUser $reporter$inlined;
                            {
                                this.this$0 = var1_1;
                                this.$idReadable$inlined = string;
                                this.$reporter$inlined = xdUser;
                                super(0);
                            }

                            @NotNull
                            public final String invoke() {
                                return "Processing comment attachments to issue " + this.$idReadable$inlined;
                            }
                        });
                        $receiver$iv = notNullComments;
                        for (T element$iv : $receiver$iv) {
                            Pair $nhdComment_xdComment = (Pair)element$iv;
                            boolean bl3 = false;
                            NHDComment nhdComment = (NHDComment)$nhdComment_xdComment.component1();
                            XdIssueComment xdComment = (XdIssueComment)$nhdComment_xdComment.component2();
                            List<NHDAttachment> list4 = nhdComment.getAttachments();
                            if (list4 == null) continue;
                            Iterable $receiver$iv2 = list4;
                            for (T element$iv2 : $receiver$iv2) {
                                NHDAttachment it = (NHDAttachment)element$iv2;
                                boolean bl4 = false;
                                boolean $i$f$transactional4 = false;
                                TransientEntityStore.DefaultImpls.transactional$default((TransientEntityStore)DnqUtils.getTransientStore(), (boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, Unit>(it, xdComment, this, idReadable, reporter){
                                    final /* synthetic */ NHDAttachment $it$inlined;
                                    final /* synthetic */ XdIssueComment $xdComment$inlined;
                                    final /* synthetic */ processAttachments.1 this$0;
                                    final /* synthetic */ String $idReadable$inlined;
                                    final /* synthetic */ XdUser $reporter$inlined;
                                    {
                                        this.$it$inlined = nHDAttachment;
                                        this.$xdComment$inlined = xdIssueComment;
                                        this.this$0 = var3_3;
                                        this.$idReadable$inlined = string;
                                        this.$reporter$inlined = xdUser;
                                        super(1);
                                    }

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public final Unit invoke(@NotNull TransientStoreSession it) {
                                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                        boolean bl = false;
                                        TicketsSubResource ticketsSubResource = this.this$0.this$0;
                                        XdUser user$iv = this.$reporter$inlined;
                                        boolean $i$f$runWithFlushAs = false;
                                        boolean $i$f$runAs = false;
                                        Entity user$iv$iv$iv = user$iv.getEntity();
                                        boolean $i$f$runAs2 = false;
                                        PrincipalManager _principalManager$iv$iv$iv = jetbrains.charisma.main.BeansKt.getPrincipalManager();
                                        try {
                                            _principalManager$iv$iv$iv.setTemporaryServerPrincipal((Object)user$iv$iv$iv);
                                            boolean bl2 = false;
                                            boolean bl3 = false;
                                            TicketsSubResource.Companion.getLogger().debug((Function0)new Function0<String>(this){
                                                final /* synthetic */ processAttachments$1$execute$$inlined$let$lambda$4 this$0;
                                                {
                                                    this.this$0 = var1_1;
                                                    super(0);
                                                }

                                                @NotNull
                                                public final String invoke() {
                                                    return "Adding attachment " + this.this$0.$it$inlined.getFilename() + " to issue " + this.this$0.$idReadable$inlined + " to comment " + this.this$0.$xdComment$inlined.getXdId();
                                                }
                                            });
                                            TicketsSubResource.access$processAttachment(this.this$0.this$0, this.this$0.$issue, this.$it$inlined, this.$xdComment$inlined.getAuthor(), this.$xdComment$inlined);
                                            Unit result$iv = Unit.INSTANCE;
                                            LegacySupportKt.flush();
                                            Unit unit = result$iv;
                                        }
                                        finally {
                                            _principalManager$iv$iv$iv.unsetTemporaryServerPrincipal();
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }), (int)7, null);
                            }
                        }
                    }
                    catch (Throwable e) {
                        TicketsSubResource.Companion.getLogger().warn(e, (Function0)new Function0<String>(idReadable){
                            final /* synthetic */ String $idReadable;

                            @NotNull
                            public final String invoke() {
                                return "Failed to prcess attachments from issue " + this.$idReadable;
                            }
                            {
                                this.$idReadable = string;
                                super(0);
                            }
                        });
                    }
                }
            }
            {
                this.this$0 = $outer;
                this.$issue = $captured_local_variable$1;
                this.$descriptionComment = $captured_local_variable$2;
                this.$comments = $captured_local_variable$3;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processAttachment(XdIssue issue2, NHDAttachment attachment, XdUser author, XdIssueComment comment) {
        try {
            Response result;
            Invocation.Builder attachmentUrl = this.attachmentClient.target(attachment.getUrl()).request();
            Response response = result = attachmentUrl.get();
            Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"result");
            MediaType mediaType = response.getMediaType();
            String contentType = mediaType != null ? mediaType.toString() : null;
            DiskFileItem dfi = new DiskFileItem("file", contentType, false, attachment.getFilename(), 1000000, null);
            Closeable closeable = (Closeable)result.readEntity(InputStream.class);
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                InputStream inputStream = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"it");
                OutputStream outputStream = dfi.getOutputStream();
                Intrinsics.checkExpressionValueIsNotNull((Object)outputStream, (String)"dfi.outputStream");
                long l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)outputStream, (int)0, (int)2, null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            XdIssueAttachment.Companion.new(dfi, (Function1)new Function1<XdIssueAttachment, Unit>(author, issue2, comment){
                final /* synthetic */ XdUser $author;
                final /* synthetic */ XdIssue $issue;
                final /* synthetic */ XdIssueComment $comment;

                public final void invoke(@NotNull XdIssueAttachment $receiver) {
                    block0: {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                        $receiver.setAuthor(this.$author);
                        this.$issue.addAttachment($receiver);
                        XdIssueComment xdIssueComment = this.$comment;
                        if (xdIssueComment == null) break block0;
                        xdIssueComment.addAttachment($receiver);
                    }
                }
                {
                    this.$author = xdUser;
                    this.$issue = xdIssue;
                    this.$comment = xdIssueComment;
                    super(1);
                }
            });
        }
        catch (Exception e) {
            Companion.getLogger().warn((Throwable)e, (Function0)new Function0<String>(attachment){
                final /* synthetic */ NHDAttachment $attachment;

                @NotNull
                public final String invoke() {
                    return "Can't process attachment " + this.$attachment.getFilename();
                }
                {
                    this.$attachment = nHDAttachment;
                    super(0);
                }
            });
        }
    }

    static /* synthetic */ void processAttachment$default(TicketsSubResource ticketsSubResource, XdIssue xdIssue, NHDAttachment nHDAttachment, XdUser xdUser, XdIssueComment xdIssueComment, int n, Object object) {
        if ((n & 8) != 0) {
            xdIssueComment = null;
        }
        ticketsSubResource.processAttachment(xdIssue, nHDAttachment, xdUser, xdIssueComment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <R> R runWithFlushAs(XdUser user2, Function0<? extends R> action) {
        Object object;
        int $i$f$runWithFlushAs = 0;
        boolean $i$f$runAs = false;
        Entity user$iv$iv = user2.getEntity();
        boolean $i$f$runAs2 = false;
        PrincipalManager _principalManager$iv$iv = jetbrains.charisma.main.BeansKt.getPrincipalManager();
        try {
            _principalManager$iv$iv.setTemporaryServerPrincipal((Object)user$iv$iv);
            boolean bl = false;
            Object result = action.invoke();
            LegacySupportKt.flush();
            object = result;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            _principalManager$iv$iv.unsetTemporaryServerPrincipal();
            InlineMarker.finallyEnd((int)1);
        }
        return (R)object;
    }

    public static final /* synthetic */ void access$processAttachments(TicketsSubResource $this, XdIssue issue2, NHDComment descriptionComment, List comments2) {
        $this.processAttachments(issue2, descriptionComment, comments2);
    }

    public static final /* synthetic */ Object access$runWithFlushAs(TicketsSubResource $this, XdUser user2, Function0 action) {
        return $this.runWithFlushAs(user2, action);
    }

    public static final /* synthetic */ void access$processAttachment(TicketsSubResource $this, XdIssue issue2, NHDAttachment attachment, XdUser author, XdIssueComment comment) {
        $this.processAttachment(issue2, attachment, author, comment);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/zendesk/rest/integration/resources/TicketsSubResource$Companion;", "Lmu/KLogging;", "()V", "youtrack-zendesk-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

