/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.locale;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import jetbrains.jetpass.api.settings.Locale;
import jetbrains.jetpass.locale.CommunityLocale;
import jetbrains.jetpass.locale.LocaleContainer;
import jetbrains.jetpass.locale.PredefinedLocale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="localeManager")
@Scope(value="local")
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\u0005J\u0012\u0010\r\u001a\u0004\u0018\u00010\b2\b\u0010\f\u001a\u0004\u0018\u00010\u0005J\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0005J\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0005J\u0010\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0005R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u00060\u0006R\u00020\u00000\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001d"}, d2={"Ljetbrains/jetpass/locale/LocaleContainer;", "", "()V", "customLocales", "Ljava/util/TreeMap;", "", "Ljetbrains/jetpass/locale/LocaleContainer$LocaleEntry;", "default", "Ljetbrains/jetpass/api/settings/Locale;", "getDefault", "()Ljetbrains/jetpass/api/settings/Locale;", "fromTag", "name", "fromTagNullable", "getAvailableLocales", "Lkotlin/sequences/Sequence;", "withCommunity", "", "getCustomTranslation", "Ljava/io/InputStream;", "locale", "translationFileName", "getCustomTranslationFile", "Ljava/io/File;", "setCustomLocalesLocation", "", "customLocalesLocation", "Companion", "LocaleEntry", "jetbrains.jetpass.locale"})
public class LocaleContainer {
    private TreeMap<String, LocaleEntry> customLocales = new TreeMap();
    private static final Pattern LOCALE_PATTERN;
    public static final Companion Companion;

    @NotNull
    public final Locale getDefault() {
        return PredefinedLocale.ENGLISH;
    }

    @NotNull
    public final Sequence<Locale> getAvailableLocales(boolean withCommunity) {
        Sequence sequence;
        Sequence predefined = ArraysKt.asSequence((Object[])PredefinedLocale.values());
        Collection<LocaleEntry> collection = this.customLocales.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"customLocales.values");
        Sequence custom = CollectionsKt.asSequence((Iterable)collection);
        Sequence community = ArraysKt.asSequence((Object[])CommunityLocale.values());
        boolean bl = withCommunity;
        if (bl) {
            sequence = SequencesKt.plus((Sequence)SequencesKt.plus((Sequence)predefined, (Sequence)custom), (Sequence)community);
        } else if (!bl) {
            sequence = SequencesKt.plus((Sequence)predefined, (Sequence)custom);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return sequence;
    }

    @NotNull
    public final Locale fromTag(@Nullable String name) {
        Locale locale = this.fromTagNullable(name);
        if (locale == null) {
            locale = this.getDefault();
        }
        return locale;
    }

    @Nullable
    public final Locale fromTagNullable(@Nullable String name) {
        Locale locale;
        Object v5;
        block7: {
            Sequence locales;
            CharSequence charSequence;
            if (name == null || (charSequence = (CharSequence)name).length() == 0) {
                return null;
            }
            Object object = new String[]{"_", "-"};
            boolean bl = false;
            int n = 2;
            List list = StringsKt.split$default((CharSequence)name, (String[])object, (boolean)bl, (int)n, (int)2, null);
            object = list;
            String lang = (String)object.get(0);
            Sequence $receiver$iv = locales = SequencesKt.plus((Sequence)ArraysKt.asSequence((Object[])PredefinedLocale.values()), (Sequence)ArraysKt.asSequence((Object[])CommunityLocale.values()));
            for (Object element$iv : $receiver$iv) {
                String string;
                String string2;
                String string3;
                Locale it = (Locale)element$iv;
                String string4 = it.getName();
                if (string4 != null) {
                    String string5 = string3 = string4;
                    if (string5 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string6 = string5.toLowerCase();
                    string2 = string6;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).toLowerCase()");
                } else {
                    string2 = null;
                }
                string3 = lang;
                String string7 = string2;
                String string8 = string3;
                if (string8 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string8.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
                if (!Intrinsics.areEqual((Object)string7, (Object)string)) continue;
                v5 = element$iv;
                break block7;
            }
            v5 = null;
        }
        if ((locale = (Locale)v5) == null) {
            locale = this.customLocales.get(name);
        }
        return locale;
    }

    @Nullable
    public final InputStream getCustomTranslation(@NotNull Locale locale, @NotNull String translationFileName) {
        BufferedInputStream bufferedInputStream;
        Intrinsics.checkParameterIsNotNull((Object)locale, (String)"locale");
        Intrinsics.checkParameterIsNotNull((Object)translationFileName, (String)"translationFileName");
        File file = this.getCustomTranslationFile(locale, translationFileName);
        if (file == null) {
            return null;
        }
        File json = file;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(json));
        }
        catch (FileNotFoundException ex) {
            bufferedInputStream = null;
        }
        return bufferedInputStream;
    }

    @Nullable
    public final File getCustomTranslationFile(@NotNull Locale locale, @NotNull String translationFileName) {
        File file;
        Intrinsics.checkParameterIsNotNull((Object)locale, (String)"locale");
        Intrinsics.checkParameterIsNotNull((Object)translationFileName, (String)"translationFileName");
        String string = locale.getName();
        if (string != null) {
            LocaleEntry localeEntry;
            LocaleEntry custom;
            File json;
            String string2;
            String localeName = string2 = string;
            LocaleEntry localeEntry2 = this.customLocales.get(localeName);
            file = localeEntry2 != null ? ((json = new File((custom = (localeEntry = localeEntry2)).getDir(), FilenameUtils.getName((String)translationFileName))).exists() ? json : null) : null;
        } else {
            file = null;
        }
        return file;
    }

    public final void setCustomLocalesLocation(@Nullable String customLocalesLocation) {
        CharSequence charSequence;
        if (customLocalesLocation != null && (charSequence = (CharSequence)customLocalesLocation).length() > 0) {
            Companion.getLogger().info((Function0)new Function0<String>(customLocalesLocation){
                final /* synthetic */ String $customLocalesLocation;

                @NotNull
                public final String invoke() {
                    return "Loading languages from: " + this.$customLocalesLocation;
                }
                {
                    this.$customLocalesLocation = string;
                    super(0);
                }
            });
            File customLocalesDir = new File(customLocalesLocation);
            if (customLocalesDir.exists() && customLocalesDir.isDirectory()) {
                try {
                    Object[] objectArray = customLocalesDir.listFiles(setCustomLocalesLocation.2.INSTANCE);
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"customLocalesDir\n       \u2026                       })");
                    this.customLocales = (TreeMap)MapsKt.toMap((Sequence)SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])objectArray), (Function1)((Function1)new Function1<File, Pair<? extends String, ? extends LocaleEntry>>(this){
                        final /* synthetic */ LocaleContainer this$0;

                        @NotNull
                        public final Pair<String, LocaleEntry> invoke(File localeDir) {
                            File file = localeDir;
                            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"localeDir");
                            LocaleEntry entry = this.this$0.new LocaleEntry(file);
                            String customLocaleName = entry.getName();
                            LocaleContainer.Companion.getLogger().info((Function0)new Function0<String>(customLocaleName){
                                final /* synthetic */ String $customLocaleName;

                                @NotNull
                                public final String invoke() {
                                    return "Loaded custom locale: " + this.$customLocaleName;
                                }
                                {
                                    this.$customLocaleName = string;
                                    super(0);
                                }
                            });
                            return TuplesKt.to((Object)customLocaleName, (Object)entry);
                        }
                        {
                            this.this$0 = localeContainer;
                            super(1);
                        }
                    })), (Map)new TreeMap());
                }
                catch (Throwable e) {
                    Companion.getLogger().error(e, (Function0)setCustomLocalesLocation.4.INSTANCE);
                }
            } else {
                Companion.getLogger().info((Function0)setCustomLocalesLocation.5.INSTANCE);
            }
        }
    }

    static {
        Companion = new Companion(null);
        LOCALE_PATTERN = Pattern.compile("[a-z]+[_-][A-Z]+");
    }

    public static final /* synthetic */ Pattern access$getLOCALE_PATTERN$cp() {
        return LOCALE_PATTERN;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\bH\u0016J\b\u0010\f\u001a\u00020\bH\u0016J\b\u0010\r\u001a\u00020\bH\u0016J\b\u0010\u000e\u001a\u00020\bH\u0016J\r\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ljetbrains/jetpass/locale/LocaleContainer$LocaleEntry;", "Ljetbrains/jetpass/api/settings/Locale;", "dir", "Ljava/io/File;", "(Ljetbrains/jetpass/locale/LocaleContainer;Ljava/io/File;)V", "getDir", "()Ljava/io/File;", "lang", "", "name", "region", "getLabel", "getLanguage", "getName", "getRegion", "isCommunity", "", "()Ljava/lang/Boolean;", "jetbrains.jetpass.locale"})
    private final class LocaleEntry
    implements Locale {
        private final String name;
        private final String lang;
        private final String region;
        @NotNull
        private final File dir;

        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public String getLabel() {
            return this.name;
        }

        @NotNull
        public String getRegion() {
            return this.region;
        }

        @NotNull
        public String getLanguage() {
            return this.lang;
        }

        @NotNull
        public Boolean isCommunity() {
            return false;
        }

        @NotNull
        public final File getDir() {
            return this.dir;
        }

        public LocaleEntry(File dir) {
            String string;
            List list;
            String name;
            Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
            this.dir = dir;
            String string2 = name = this.dir.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name");
            List $receiver$iv = StringsKt.split$default((CharSequence)string2, (char[])new char[]{'_', '-'}, (boolean)false, (int)0, (int)6, null);
            if (!$receiver$iv.isEmpty()) {
                ListIterator iterator$iv = $receiver$iv.listIterator($receiver$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    CharSequence charSequence = it;
                    if (charSequence.length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$receiver$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            List langWithRegion = list;
            this.name = name;
            String string3 = (String)langWithRegion.get(0);
            LocaleEntry localeEntry = this;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
            localeEntry.lang = string = string5;
            this.region = (String)langWithRegion.get(1);
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ljetbrains/jetpass/locale/LocaleContainer$Companion;", "Lmu/KLogging;", "()V", "LOCALE_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "jetbrains.jetpass.locale"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

