/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore;

import java.lang.ref.WeakReference;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.core.dataStructures.ConcurrentObjectCache;
import jetbrains.exodus.core.dataStructures.ObjectCacheBase;
import jetbrains.exodus.core.dataStructures.Priority;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.core.execution.JobProcessor;
import jetbrains.exodus.core.execution.SharedTimer;
import jetbrains.exodus.entitystore.EntityIterableCacheAdapter;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityStoreSharedAsyncProcessor;
import jetbrains.exodus.entitystore.PersistentEntityStoreConfig;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.QueryCancellingPolicy;
import jetbrains.exodus.entitystore.StoreTransaction;
import jetbrains.exodus.entitystore.StoreTransactionalExecutable;
import jetbrains.exodus.entitystore.iterate.CachedInstanceIterable;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EntityIterableCache {
    private static final Logger logger = LoggerFactory.getLogger(EntityIterableCache.class);
    @NotNull
    private final PersistentEntityStoreImpl store;
    @NotNull
    private final PersistentEntityStoreConfig config;
    @NotNull
    private EntityIterableCacheAdapter cacheAdapter;
    @NotNull
    private ObjectCacheBase<Object, Long> deferredIterablesCache;
    @NotNull
    private ObjectCacheBase<Object, Long> iterableCountsCache;
    @NotNull
    final EntityStoreSharedAsyncProcessor processor;

    public EntityIterableCache(@NotNull PersistentEntityStoreImpl store) {
        this.store = store;
        this.config = store.getConfig();
        this.cacheAdapter = new EntityIterableCacheAdapter(this.config);
        this.clear();
        this.processor = new EntityStoreSharedAsyncProcessor(this.config.getEntityIterableCacheThreadCount());
        this.processor.start();
        SharedTimer.registerPeriodicTask((SharedTimer.ExpirablePeriodicTask)new CacheHitRateAdjuster(this));
    }

    public float hitRate() {
        return this.cacheAdapter.hitRate();
    }

    public int count() {
        return this.cacheAdapter.count();
    }

    public void clear() {
        this.cacheAdapter.clear();
        int cacheSize = this.config.getEntityIterableCacheSize();
        this.deferredIterablesCache = new ConcurrentObjectCache(cacheSize);
        this.iterableCountsCache = new ConcurrentObjectCache(cacheSize * 2);
    }

    public EntityIterableBase putIfNotCached(@NotNull EntityIterableBase it) {
        if (this.config.isCachingDisabled() || !it.canBeCached()) {
            return it;
        }
        EntityIterableHandle handle = it.getHandle();
        PersistentStoreTransaction txn = it.getTransaction();
        EntityIterableCacheAdapter localCache = txn.getLocalCache();
        txn.localCacheAttempt();
        CachedInstanceIterable cached = localCache.tryKey(handle);
        if (cached != null) {
            if (!cached.getHandle().isExpired()) {
                txn.localCacheHit();
                return cached;
            }
            localCache.remove(handle);
        }
        if (txn.isMutable() || !txn.isCurrent() || !txn.isCachingRelevant()) {
            return it;
        }
        if (!localCache.isSparse()) {
            long currentMillis = System.currentTimeMillis();
            Object handleIdentity = handle.getIdentity();
            Long whenCached = (Long)this.deferredIterablesCache.tryKey(handleIdentity);
            if (whenCached == null) {
                this.deferredIterablesCache.cacheObject(handleIdentity, (Object)currentMillis);
                return it;
            }
            if (whenCached + (long)this.config.getEntityIterableCacheDeferredDelay() > currentMillis) {
                return it;
            }
        }
        if (this.isDispatcherThread()) {
            return it.getOrCreateCachedInstance(txn);
        }
        if (!this.isCachingQueueFull()) {
            new EntityIterableAsyncInstantiation(handle, it, false).queue(Priority.below_normal);
        }
        return it;
    }

    @Nullable
    public Long getCachedCount(@NotNull EntityIterableHandle handle) {
        return (Long)this.iterableCountsCache.tryKey(handle.getIdentity());
    }

    public long getCachedCount(@NotNull EntityIterableBase it) {
        if (this.isDispatcherThread()) {
            return it.getOrCreateCachedInstance(it.getTransaction()).size();
        }
        EntityIterableHandle handle = it.getHandle();
        Long result = this.getCachedCount(handle);
        if (!it.hasCustomTxn() && !this.isCachingQueueFull()) {
            new EntityIterableAsyncInstantiation(handle, it, true).queue(Priority.normal);
        }
        return result == null ? -1L : result;
    }

    public void setCachedCount(@NotNull EntityIterableHandle handle, long count) {
        this.iterableCountsCache.cacheObject(handle.getIdentity(), (Object)count);
    }

    public boolean isDispatcherThread() {
        return this.processor.isDispatcherThread();
    }

    boolean isCachingQueueFull() {
        return this.processor.pendingJobs() > this.cacheAdapter.size();
    }

    @NotNull
    EntityIterableCacheAdapter getCacheAdapter() {
        return this.cacheAdapter;
    }

    boolean compareAndSetCacheAdapter(@NotNull EntityIterableCacheAdapter oldValue, @NotNull EntityIterableCacheAdapter newValue) {
        if (this.cacheAdapter == oldValue) {
            this.cacheAdapter = newValue;
            return true;
        }
        return false;
    }

    private String getStringPresentation(@NotNull EntityIterableHandle handle) {
        return this.config.getEntityIterableCacheUseHumanReadable() ? EntityIterableBase.getHumanReadablePresentation(handle) : handle.toString();
    }

    private static class CacheHitRateAdjuster
    implements SharedTimer.ExpirablePeriodicTask {
        @NotNull
        private final WeakReference<EntityIterableCache> cacheRef;

        private CacheHitRateAdjuster(@NotNull EntityIterableCache cache) {
            this.cacheRef = new WeakReference<EntityIterableCache>(cache);
        }

        public boolean isExpired() {
            return this.cacheRef.get() == null;
        }

        public void run() {
            EntityIterableCache cache = (EntityIterableCache)this.cacheRef.get();
            if (cache != null) {
                cache.cacheAdapter.adjustHitRate();
            }
        }
    }

    private static class TooLongEntityIterableInstantiationException
    extends ExodusException {
        private TooLongEntityIterableInstantiationException() {
        }
    }

    private final class CachingCancellingPolicy
    implements QueryCancellingPolicy {
        private final boolean cachingRoughCount;
        private final long startTime;
        private EntityIterableCacheAdapter localCache;

        private CachingCancellingPolicy(boolean cachingRoughCount) {
            this.cachingRoughCount = cachingRoughCount;
            this.startTime = System.currentTimeMillis();
        }

        private boolean isOverdue(long currentMillis) {
            return currentMillis - this.startTime > EntityIterableCache.this.config.getEntityIterableCacheCachingTimeout();
        }

        private void setLocalCache(@NotNull EntityIterableCacheAdapter localCache) {
            this.localCache = localCache;
        }

        public boolean needToCancel() {
            return !this.cachingRoughCount && EntityIterableCache.this.cacheAdapter != this.localCache || this.isOverdue(System.currentTimeMillis());
        }

        public void doCancel() {
            throw new TooLongEntityIterableInstantiationException();
        }
    }

    private final class EntityIterableAsyncInstantiation
    extends Job {
        @NotNull
        private final EntityIterableBase it;
        @NotNull
        private final EntityIterableHandle handle;
        @NotNull
        private final CachingCancellingPolicy cancellingPolicy;

        private EntityIterableAsyncInstantiation(@NotNull EntityIterableHandle handle, EntityIterableBase it, boolean cachingRoughCount) {
            this.it = it;
            this.handle = handle;
            this.cancellingPolicy = new CachingCancellingPolicy(cachingRoughCount);
            this.setProcessor((JobProcessor)EntityIterableCache.this.processor);
        }

        public String getName() {
            return "Caching job for handle " + this.it.getHandle();
        }

        public String getGroup() {
            return EntityIterableCache.this.store.getLocation();
        }

        public boolean isEqualTo(Job job) {
            return this.handle.equals(((EntityIterableAsyncInstantiation)job).handle);
        }

        public int hashCode() {
            return this.handle.hashCode();
        }

        protected void execute() throws Throwable {
            final long started = System.currentTimeMillis();
            if (this.cancellingPolicy.isOverdue(started) || EntityIterableCache.this.isCachingQueueFull()) {
                return;
            }
            Thread.yield();
            EntityIterableCache.this.store.executeInReadonlyTransaction(new StoreTransactionalExecutable(){

                public void execute(@NotNull StoreTransaction tx) {
                    block5: {
                        PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                        EntityIterableAsyncInstantiation.this.cancellingPolicy.setLocalCache(txn.getLocalCache());
                        txn.setQueryCancellingPolicy(EntityIterableAsyncInstantiation.this.cancellingPolicy);
                        try {
                            if (!logger.isInfoEnabled()) {
                                EntityIterableAsyncInstantiation.this.it.getOrCreateCachedInstance(txn);
                            } else {
                                EntityIterableAsyncInstantiation.this.it.getOrCreateCachedInstance(txn);
                                long cachedIn = System.currentTimeMillis() - started;
                                if (cachedIn > 1000L) {
                                    logger.info("Cached in " + cachedIn + " ms, handle=" + EntityIterableCache.this.getStringPresentation(EntityIterableAsyncInstantiation.this.handle));
                                }
                            }
                        }
                        catch (TooLongEntityIterableInstantiationException e) {
                            if (!logger.isInfoEnabled()) break block5;
                            logger.info("Caching forcedly stopped: " + EntityIterableCache.this.getStringPresentation(EntityIterableAsyncInstantiation.this.handle));
                        }
                    }
                }
            });
        }
    }
}

