/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore;

import java.lang.ref.SoftReference;
import jetbrains.exodus.core.dataStructures.hash.ObjectProcedure;
import jetbrains.exodus.core.dataStructures.persistent.PersistentObjectCache;
import jetbrains.exodus.core.execution.SharedTimer;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.PersistentEntityStoreConfig;
import jetbrains.exodus.entitystore.iterate.CachedInstanceIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class EntityIterableCacheAdapter {
    @NotNull
    private final PersistentEntityStoreConfig config;
    @NotNull
    private final NonAdjustablePersistentObjectCache<EntityIterableHandle, CacheItem> cache;

    EntityIterableCacheAdapter(@NotNull PersistentEntityStoreConfig config) {
        this.config = config;
        this.cache = new NonAdjustablePersistentObjectCache(config.getEntityIterableCacheSize());
    }

    private EntityIterableCacheAdapter(@NotNull EntityIterableCacheAdapter source) {
        this.config = source.config;
        this.cache = source.cache.getClone();
    }

    @NotNull
    public PersistentObjectCache<EntityIterableHandle, CacheItem> getCacheInstance() {
        return this.cache;
    }

    @Nullable
    CachedInstanceIterable tryKey(@NotNull EntityIterableHandle key) {
        return this.parseCachedObject(key, (CacheItem)this.cache.tryKey(key));
    }

    @Nullable
    CachedInstanceIterable getObject(@NotNull EntityIterableHandle key) {
        return this.parseCachedObject(key, (CacheItem)this.cache.getObject(key));
    }

    void cacheObject(@NotNull EntityIterableHandle key, @NotNull CachedInstanceIterable it) {
        this.cache.cacheObject(key, new CacheItem(it, this.config.getEntityIterableCacheMaxSizeOfDirectValue()));
    }

    void forEachKey(ObjectProcedure<EntityIterableHandle> procedure) {
        this.cache.forEachKey(procedure);
    }

    void remove(@NotNull EntityIterableHandle key) {
        this.cache.remove(key);
    }

    float hitRate() {
        return this.cache.hitRate();
    }

    int count() {
        return this.cache.count();
    }

    int size() {
        return this.cache.size();
    }

    void clear() {
        this.cache.clear();
    }

    boolean isSparse() {
        return this.cache.count() < this.cache.size() / 2;
    }

    EntityIterableCacheAdapter getClone() {
        return new EntityIterableCacheAdapter(this);
    }

    void adjustHitRate() {
        this.cache.adjustHitRate();
    }

    private CachedInstanceIterable parseCachedObject(@NotNull EntityIterableHandle key, @Nullable CacheItem item) {
        if (item == null) {
            return null;
        }
        CachedInstanceIterable cached = item.cached;
        if (cached == null && (cached = (CachedInstanceIterable)item.ref.get()) == null) {
            this.cache.remove(key);
        }
        return cached;
    }

    private static class NonAdjustablePersistentObjectCache<K, V>
    extends PersistentObjectCache<K, V> {
        private NonAdjustablePersistentObjectCache(int size) {
            super(size);
        }

        private NonAdjustablePersistentObjectCache(@NotNull NonAdjustablePersistentObjectCache<K, V> source) {
            super(source);
        }

        public NonAdjustablePersistentObjectCache<K, V> getClone() {
            return new NonAdjustablePersistentObjectCache<K, V>(this);
        }

        @Nullable
        protected SharedTimer.ExpirablePeriodicTask getCacheAdjuster() {
            return null;
        }
    }

    static final class CacheItem {
        private final CachedInstanceIterable cached;
        private final SoftReference<CachedInstanceIterable> ref;

        private CacheItem(@NotNull CachedInstanceIterable it, int maxSizeOfDirectValue) {
            if (it.isUpdatable() || it.size() <= (long)maxSizeOfDirectValue) {
                this.cached = it;
                this.ref = null;
            } else {
                this.cached = null;
                this.ref = new SoftReference<CachedInstanceIterable>(it);
            }
        }
    }
}

