/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicLong;
import jetbrains.exodus.backup.BackupStrategy;
import jetbrains.exodus.core.dataStructures.hash.LongHashMap;
import jetbrains.exodus.core.dataStructures.hash.LongHashSet;
import jetbrains.exodus.core.dataStructures.hash.LongIterator;
import jetbrains.exodus.core.dataStructures.hash.LongSet;
import jetbrains.exodus.core.dataStructures.hash.ObjectProcedureThrows;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.entitystore.BlobHandleGenerator;
import jetbrains.exodus.entitystore.BlobVault;
import jetbrains.exodus.entitystore.EntityStoreException;
import jetbrains.exodus.entitystore.UnexpectedBlobVaultVersionException;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.util.ByteArraySpinAllocator;
import jetbrains.exodus.util.DeferredIO;
import jetbrains.exodus.util.IOUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemBlobVaultOld
extends BlobVault {
    protected static final Logger logger = LoggerFactory.getLogger((String)"FileSystemBlobVault");
    @NonNls
    public static final String VERSION_FILE = "version";
    private static final int EXPECTED_VERSION = 0;
    private static final long UNKNOWN_SIZE = -1L;
    @NonNls
    private final String blobsDirectory;
    @NonNls
    private final String blobExtension;
    private final File location;
    private final BlobHandleGenerator blobHandleGenerator;
    private final int version;
    private final AtomicLong size;

    public FileSystemBlobVaultOld(@NotNull String parentDirectory, @NotNull String blobsDirectory, @NotNull String blobExtension, @NotNull BlobHandleGenerator blobHandleGenerator) throws IOException {
        this(parentDirectory, blobsDirectory, blobExtension, blobHandleGenerator, 0);
    }

    protected FileSystemBlobVaultOld(@NotNull String parentDirectory, @NotNull String blobsDirectory, @NotNull String blobExtension, @NotNull BlobHandleGenerator blobHandleGenerator, int expectedVersion) throws IOException {
        this.blobsDirectory = blobsDirectory;
        this.blobExtension = blobExtension;
        this.location = new File(parentDirectory, blobsDirectory);
        this.blobHandleGenerator = blobHandleGenerator;
        this.size = new AtomicLong(-1L);
        this.location.mkdirs();
        File versionFile = new File(this.location, VERSION_FILE);
        if (versionFile.exists()) {
            try (DataInputStream input = new DataInputStream(new FileInputStream(versionFile));){
                this.version = input.readInt();
            }
            if (expectedVersion != this.version) {
                throw new UnexpectedBlobVaultVersionException("Unexpected FileSystemBlobVault version: " + this.version);
            }
        } else {
            boolean hasFiles;
            File[] files = this.location.listFiles();
            boolean bl = hasFiles = files != null && files.length > 0;
            if (!hasFiles) {
                this.version = expectedVersion;
            } else {
                this.version = 0;
                if (expectedVersion != this.version) {
                    throw new UnexpectedBlobVaultVersionException("Unexpected FileSystemBlobVault version: " + this.version);
                }
            }
            try (DataOutputStream output = new DataOutputStream(new FileOutputStream(versionFile));){
                output.writeInt(expectedVersion);
            }
        }
    }

    public File getVaultLocation() {
        return this.location;
    }

    public int getVersion() {
        return this.version;
    }

    public long nextHandle(@NotNull Transaction txn) {
        return this.blobHandleGenerator.nextHandle(txn);
    }

    public void setContent(long blobHandle, @NotNull InputStream content) throws Exception {
        File location = this.getBlobLocation(blobHandle, false);
        this.setContentImpl(content, location);
        if (this.size.get() != -1L) {
            this.size.addAndGet(IOUtil.getAdjustedFileLength((File)location));
        }
    }

    public void setContent(long blobHandle, @NotNull File file) throws Exception {
        File location = this.getBlobLocation(blobHandle, false);
        if (!file.renameTo(location)) {
            try (FileInputStream content = new FileInputStream(file);){
                this.setContentImpl(content, location);
            }
        }
        if (this.size.get() != -1L) {
            this.size.addAndGet(IOUtil.getAdjustedFileLength((File)location));
        }
    }

    @Nullable
    public InputStream getContent(long blobHandle, @NotNull Transaction txn) {
        try {
            return new FileInputStream(this.getBlobLocation(blobHandle));
        }
        catch (FileNotFoundException e) {
            logger.error("File not found", (Throwable)e);
            return null;
        }
    }

    public long getSize(long blobHandle, @NotNull Transaction txn) {
        return this.getBlobLocation(blobHandle).length();
    }

    public boolean delete(long blobHandle) {
        File file = this.getBlobLocation(blobHandle);
        if (file.exists()) {
            if (this.size.get() != -1L) {
                this.size.addAndGet(-IOUtil.getAdjustedFileLength((File)file));
            }
            return this.deleteRecursively(file);
        }
        return true;
    }

    public boolean requiresTxn() {
        return false;
    }

    public void flushBlobs(@Nullable LongHashMap<InputStream> blobStreams, @Nullable LongHashMap<File> blobFiles, @Nullable LongSet deferredBlobsToDelete, @NotNull Transaction txn) throws Exception {
        if (blobStreams != null) {
            blobStreams.forEachEntry((ObjectProcedureThrows)new ObjectProcedureThrows<Map.Entry<Long, InputStream>, Exception>(){

                public boolean execute(Map.Entry<Long, InputStream> object) throws Exception {
                    InputStream stream = object.getValue();
                    stream.reset();
                    FileSystemBlobVaultOld.this.setContent((long)object.getKey(), stream);
                    return true;
                }
            });
        }
        if (blobFiles != null) {
            blobFiles.forEachEntry((ObjectProcedureThrows)new ObjectProcedureThrows<Map.Entry<Long, File>, Exception>(){

                public boolean execute(Map.Entry<Long, File> object) throws Exception {
                    FileSystemBlobVaultOld.this.setContent((long)object.getKey(), object.getValue());
                    return true;
                }
            });
        }
        if (deferredBlobsToDelete != null) {
            LongHashSet copy = new LongHashSet();
            LongIterator it = deferredBlobsToDelete.iterator();
            while (it.hasNext()) {
                copy.add(it.nextLong());
            }
            Environment environment = txn.getEnvironment();
            environment.executeTransactionSafeTask(new Runnable((LongSet)copy, environment){
                final /* synthetic */ LongSet val$copy;
                final /* synthetic */ Environment val$environment;
                {
                    this.val$copy = longSet;
                    this.val$environment = environment;
                }

                @Override
                public void run() {
                    DeferredIO.getJobProcessor().queueIn(new Job(){

                        protected void execute() throws Throwable {
                            LongIterator it = val$copy.iterator();
                            while (it.hasNext()) {
                                FileSystemBlobVaultOld.this.delete(it.nextLong());
                            }
                        }

                        public String getName() {
                            return "Delete obsolete blob files";
                        }

                        public String getGroup() {
                            return val$environment.getLocation();
                        }
                    }, (long)this.val$environment.getEnvironmentConfig().getGcFilesDeletionDelay());
                }
            });
        }
    }

    public long size() {
        long result = this.size.get();
        if (result == -1L) {
            result = this.calculateBlobSize();
            this.size.set(result);
        }
        return result;
    }

    public void clear() {
        IOUtil.deleteRecursively((File)this.location);
    }

    public void close() {
    }

    public BackupStrategy getBackupStrategy() {
        return new BackupStrategy(){

            public Iterable<BackupStrategy.FileDescriptor> listFiles() {
                return new Iterable<BackupStrategy.FileDescriptor>(){

                    @Override
                    public Iterator<BackupStrategy.FileDescriptor> iterator() {
                        final LinkedList<BackupStrategy.FileDescriptor> queue = new LinkedList<BackupStrategy.FileDescriptor>();
                        queue.add(new BackupStrategy.FileDescriptor(FileSystemBlobVaultOld.this.location, FileSystemBlobVaultOld.this.blobsDirectory + File.separator));
                        return new Iterator<BackupStrategy.FileDescriptor>(){
                            int i = 0;
                            int n = 0;
                            File[] files;
                            BackupStrategy.FileDescriptor next;
                            String currentPrefix;

                            @Override
                            public boolean hasNext() {
                                if (this.next != null) {
                                    return true;
                                }
                                while (this.i < this.n) {
                                    File file = this.files[this.i++];
                                    String name = file.getName();
                                    if (file.isDirectory()) {
                                        queue.push(new BackupStrategy.FileDescriptor(file, this.currentPrefix + file.getName() + File.separator));
                                        continue;
                                    }
                                    if (file.isFile()) {
                                        long fileSize = file.length();
                                        if (fileSize == 0L || !name.endsWith(FileSystemBlobVaultOld.this.blobExtension) && !name.equalsIgnoreCase(FileSystemBlobVaultOld.VERSION_FILE)) continue;
                                        this.next = new BackupStrategy.FileDescriptor(file, this.currentPrefix, fileSize);
                                        return true;
                                    }
                                    if (!file.exists()) continue;
                                    throw new EntityStoreException("File or directory expected: " + file.toString());
                                }
                                if (queue.isEmpty()) {
                                    return false;
                                }
                                BackupStrategy.FileDescriptor fd = (BackupStrategy.FileDescriptor)queue.pop();
                                this.files = IOUtil.listFiles((File)fd.getFile());
                                this.currentPrefix = fd.getPath();
                                this.i = 0;
                                this.n = this.files.length;
                                this.next = fd;
                                return true;
                            }

                            @Override
                            public BackupStrategy.FileDescriptor next() {
                                if (!this.hasNext()) {
                                    throw new NoSuchElementException();
                                }
                                BackupStrategy.FileDescriptor result = this.next;
                                this.next = null;
                                return result;
                            }

                            @Override
                            public void remove() {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }
                };
            }
        };
    }

    @NotNull
    public File getBlobLocation(long blobHandle) {
        return this.getBlobLocation(blobHandle, true);
    }

    @NotNull
    protected File getBlobLocation(long blobHandle, boolean readonly) {
        String file;
        File dir = this.location;
        while (true) {
            file = Integer.toHexString((int)(blobHandle & 0xFFL));
            if (blobHandle <= 255L) break;
            dir = new File(dir, file);
            blobHandle >>= 8;
        }
        if (!readonly) {
            dir.mkdirs();
        }
        File result = new File(dir, file + this.blobExtension);
        if (!readonly && result.exists()) {
            throw new EntityStoreException("Can't update existing blob file: " + result);
        }
        return result;
    }

    protected final String getBlobExtension() {
        return this.blobExtension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setContentImpl(@NotNull InputStream content, @NotNull File location) throws IOException {
        try (OutputStream blobOutput = null;){
            blobOutput = new BufferedOutputStream(new FileOutputStream(location));
            IOUtil.copyStreams((InputStream)content, (OutputStream)blobOutput, (ByteArraySpinAllocator)this.bufferAllocator);
        }
    }

    private long calculateBlobSize() {
        return IOUtil.getDirectorySize((File)this.location, (String)this.blobExtension, (boolean)true);
    }

    private boolean deleteRecursively(@NotNull File file) {
        if (!file.delete()) {
            file.deleteOnExit();
            return false;
        }
        File dir = file.getParentFile();
        if (dir != null && this.location.compareTo(dir) != 0 && dir.listFiles().length == 0) {
            this.deleteRecursively(dir);
        }
        return true;
    }
}

