/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore;

import java.util.regex.Pattern;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import org.jetbrains.annotations.NotNull;

public class PersistentEntityId
implements EntityId {
    @NotNull
    public static final PersistentEntityId EMPTY_ID = new PersistentEntityId(0, 0L);
    private static final Pattern ID_SPLIT_PATTERN = Pattern.compile("-");
    private final int entityTypeId;
    private final long entityLocalId;

    public PersistentEntityId(int entityTypeId, long entityLocalId, int version) {
        this.entityTypeId = entityTypeId;
        this.entityLocalId = entityLocalId;
    }

    public PersistentEntityId(int entityTypeId, long entityLocalId) {
        this.entityTypeId = entityTypeId;
        this.entityLocalId = entityLocalId;
    }

    public PersistentEntityId(@NotNull EntityId id) {
        this(id.getTypeId(), id.getLocalId());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PersistentEntityId)) {
            return false;
        }
        PersistentEntityId that = (PersistentEntityId)obj;
        return this.entityLocalId == that.entityLocalId && this.entityTypeId == that.entityTypeId;
    }

    public int hashCode() {
        return (int)((long)(this.entityTypeId << 20) ^ this.entityLocalId);
    }

    public int getTypeId() {
        return this.entityTypeId;
    }

    public long getLocalId() {
        return this.entityLocalId;
    }

    @NotNull
    public String toString() {
        StringBuilder builder = new StringBuilder(10);
        this.toString(builder);
        return builder.toString();
    }

    public void toString(@NotNull StringBuilder builder) {
        builder.append(this.entityTypeId);
        builder.append('-');
        builder.append(this.entityLocalId);
    }

    public void toHash(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
        hash.apply(this.entityTypeId);
        hash.applyDelimiter();
        hash.apply(this.entityLocalId);
    }

    public static EntityId toEntityId(@NotNull CharSequence representation) {
        String[] idParts = ID_SPLIT_PATTERN.split(representation);
        int partsCount = idParts.length;
        if (partsCount != 2) {
            throw new IllegalArgumentException("Invalid structure of entity id");
        }
        int entityTypeId = Integer.parseInt(idParts[0]);
        long entityLocalId = Long.parseLong(idParts[1]);
        return new PersistentEntityId(entityTypeId, entityLocalId);
    }

    public static EntityId toEntityId(@NotNull String representation, @NotNull PersistentEntityStoreImpl store) {
        EntityId result = store.getCachedEntityId(representation);
        if (result != null) {
            return result;
        }
        result = PersistentEntityId.toEntityId(representation);
        store.cacheEntityId(representation, result);
        return result;
    }

    public int compareTo(@NotNull EntityId o) {
        long rightLocalId = o.getLocalId();
        int rightType = o.getTypeId();
        if (this.entityTypeId < rightType) {
            return -3;
        }
        if (this.entityTypeId > rightType) {
            return 3;
        }
        if (this.entityLocalId < rightLocalId) {
            return -2;
        }
        if (this.entityLocalId > rightLocalId) {
            return 2;
        }
        return 0;
    }
}

