/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore;

import java.io.File;
import java.util.Iterator;
import jetbrains.exodus.backup.BackupStrategy;
import jetbrains.exodus.entitystore.BlobVault;
import jetbrains.exodus.entitystore.FileSystemBlobVault;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.log.LogUtil;
import org.jetbrains.annotations.NotNull;

public class PersistentEntityStoreBackupStrategy
extends BackupStrategy {
    private final PersistentStoreTransaction backupTxn;
    private final BackupStrategy environmentBackupStrategy;
    private final BackupStrategy blobVaultBackupStrategy;

    public PersistentEntityStoreBackupStrategy(@NotNull PersistentEntityStoreImpl store) {
        this.backupTxn = store.beginReadonlyTransaction();
        final long logHighAddress = this.backupTxn.getEnvironmentTransaction().getHighAddress();
        this.environmentBackupStrategy = new BackupStrategyDecorator(store.getEnvironment().getBackupStrategy()){

            @Override
            public long acceptFile(@NotNull File file) {
                return Math.min(super.acceptFile(file), logHighAddress - LogUtil.getAddress((String)file.getName()));
            }
        };
        BlobVault blobVault = store.getBlobVault();
        if (!(blobVault instanceof FileSystemBlobVault)) {
            this.blobVaultBackupStrategy = blobVault.getBackupStrategy();
        } else {
            final FileSystemBlobVault fsBlobVault = (FileSystemBlobVault)blobVault;
            final long lastUsedHandle = store.getSequence(this.backupTxn, "blob.handles.sequence").loadValue(this.backupTxn);
            this.blobVaultBackupStrategy = new BackupStrategyDecorator(blobVault.getBackupStrategy()){

                @Override
                public long acceptFile(@NotNull File file) {
                    block5: {
                        block4: {
                            if (!file.isFile()) break block4;
                            if (!file.getName().equals("version")) break block5;
                        }
                        return super.acceptFile(file);
                    }
                    if (fsBlobVault.getBlobHandleByFile(file) > lastUsedHandle) {
                        return -1L;
                    }
                    return super.acceptFile(file);
                }
            };
        }
    }

    public void beforeBackup() throws Exception {
        this.environmentBackupStrategy.beforeBackup();
        this.blobVaultBackupStrategy.beforeBackup();
    }

    public Iterable<BackupStrategy.FileDescriptor> listFiles() {
        return new Iterable<BackupStrategy.FileDescriptor>(){

            @Override
            public Iterator<BackupStrategy.FileDescriptor> iterator() {
                return new Iterator<BackupStrategy.FileDescriptor>(){
                    private Iterator<BackupStrategy.FileDescriptor> filesIterator;
                    private boolean environmentListed;
                    {
                        this.filesIterator = PersistentEntityStoreBackupStrategy.this.environmentBackupStrategy.listFiles().iterator();
                        this.environmentListed = false;
                    }

                    @Override
                    public boolean hasNext() {
                        while (!this.filesIterator.hasNext()) {
                            if (this.environmentListed) {
                                return false;
                            }
                            this.environmentListed = true;
                            this.filesIterator = PersistentEntityStoreBackupStrategy.this.blobVaultBackupStrategy.listFiles().iterator();
                        }
                        return true;
                    }

                    @Override
                    public BackupStrategy.FileDescriptor next() {
                        return this.filesIterator.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public void afterBackup() throws Exception {
        try {
            this.blobVaultBackupStrategy.afterBackup();
            this.environmentBackupStrategy.afterBackup();
        }
        finally {
            this.backupTxn.abort();
        }
    }

    public long acceptFile(@NotNull File file) {
        return LogUtil.isLogFile((File)file) ? this.environmentBackupStrategy.acceptFile(file) : this.blobVaultBackupStrategy.acceptFile(file);
    }

    private static class BackupStrategyDecorator
    extends BackupStrategy {
        @NotNull
        private final BackupStrategy decorated;

        public BackupStrategyDecorator(@NotNull BackupStrategy decorated) {
            this.decorated = decorated;
        }

        public void beforeBackup() throws Exception {
            this.decorated.beforeBackup();
        }

        public Iterable<BackupStrategy.FileDescriptor> listFiles() {
            return this.decorated.listFiles();
        }

        public void afterBackup() throws Exception {
            this.decorated.afterBackup();
        }

        public void onError(Throwable t) {
            this.decorated.onError(t);
        }

        public long acceptFile(@NotNull File file) {
            return this.decorated.acceptFile(file);
        }
    }
}

