/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterableBase;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.CompoundByteIterable;
import jetbrains.exodus.ConfigSettingChangeListener;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.FixedLengthByteIterable;
import jetbrains.exodus.backup.BackupStrategy;
import jetbrains.exodus.bindings.ComparableBinding;
import jetbrains.exodus.bindings.ComparableSet;
import jetbrains.exodus.bindings.ComparableSetBinding;
import jetbrains.exodus.bindings.ComparableValueType;
import jetbrains.exodus.bindings.IntegerBinding;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.core.dataStructures.ConcurrentObjectCache;
import jetbrains.exodus.core.dataStructures.Pair;
import jetbrains.exodus.core.dataStructures.hash.HashMap;
import jetbrains.exodus.core.dataStructures.hash.HashSet;
import jetbrains.exodus.core.dataStructures.hash.IntHashMap;
import jetbrains.exodus.entitystore.BlobHandleGenerator;
import jetbrains.exodus.entitystore.BlobVault;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.exodus.entitystore.EntityIterableCache;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.entitystore.EntityStoreException;
import jetbrains.exodus.entitystore.EntityStoreSharedAsyncProcessor;
import jetbrains.exodus.entitystore.Explainer;
import jetbrains.exodus.entitystore.FileSystemBlobVault;
import jetbrains.exodus.entitystore.FileSystemBlobVaultOld;
import jetbrains.exodus.entitystore.FlushLog;
import jetbrains.exodus.entitystore.OpenTablesCache;
import jetbrains.exodus.entitystore.PersistentEntity;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentEntityStore;
import jetbrains.exodus.entitystore.PersistentEntityStoreBackupStrategy;
import jetbrains.exodus.entitystore.PersistentEntityStoreConfig;
import jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings;
import jetbrains.exodus.entitystore.PersistentEntityStoreSettingsListener;
import jetbrains.exodus.entitystore.PersistentEntityStoreStatistics;
import jetbrains.exodus.entitystore.PersistentEntityStores;
import jetbrains.exodus.entitystore.PersistentSequence;
import jetbrains.exodus.entitystore.PersistentSequenceBlobHandleGenerator;
import jetbrains.exodus.entitystore.PersistentSequentialDictionary;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.ReadonlyPersistentStoreTransaction;
import jetbrains.exodus.entitystore.Settings;
import jetbrains.exodus.entitystore.StoreNamingRules;
import jetbrains.exodus.entitystore.StoreTransaction;
import jetbrains.exodus.entitystore.StoreTransactionalComputable;
import jetbrains.exodus.entitystore.StoreTransactionalExecutable;
import jetbrains.exodus.entitystore.TxnProvider;
import jetbrains.exodus.entitystore.UnexpectedBlobVaultVersionException;
import jetbrains.exodus.entitystore.VFSBlobVault;
import jetbrains.exodus.entitystore.iterate.EntityFromLinkSetIterable;
import jetbrains.exodus.entitystore.iterate.EntityFromLinksIterable;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.management.EntityStoreConfig;
import jetbrains.exodus.entitystore.management.EntityStoreStatistics;
import jetbrains.exodus.entitystore.tables.BlobsTable;
import jetbrains.exodus.entitystore.tables.LinkValue;
import jetbrains.exodus.entitystore.tables.PropertiesTable;
import jetbrains.exodus.entitystore.tables.PropertyKey;
import jetbrains.exodus.entitystore.tables.PropertyTypes;
import jetbrains.exodus.entitystore.tables.PropertyValue;
import jetbrains.exodus.entitystore.tables.SingleColumnTable;
import jetbrains.exodus.entitystore.tables.Table;
import jetbrains.exodus.entitystore.tables.TwoColumnTable;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.StoreImpl;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.log.CompressedUnsignedLongByteIterable;
import jetbrains.exodus.management.Statistics;
import jetbrains.exodus.util.ByteArraySizedInputStream;
import jetbrains.exodus.util.LightByteArrayOutputStream;
import jetbrains.exodus.util.UTFUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentEntityStoreImpl
implements PersistentEntityStore,
FlushLog.Member {
    private static final Logger logger = LoggerFactory.getLogger(PersistentEntityStoreImpl.class);
    @NonNls
    static final String BLOBS_DIR = "blobs";
    @NonNls
    static final String BLOBS_EXTENSION = ".blob";
    @NonNls
    static final String BLOB_HANDLES_SEQUENCE = "blob.handles.sequence";
    @NonNls
    private static final String SEQUENCES_STORE = "sequences";
    private static final long EMPTY_BLOB_HANDLE = Long.MAX_VALUE;
    private static final long IN_PLACE_BLOB_HANDLE = 0x7FFFFFFFFFFFFFFEL;
    private static final int ENTITY_ID_CACHE_SIZE = 2047;
    @NotNull
    private static final ByteArrayInputStream EMPTY_INPUT_STREAM = new ByteArrayInputStream(new byte[0]);
    @NotNull
    private static final String EMPTY_STRING = "";
    private final int hashCode;
    @NotNull
    private final PersistentEntityStoreConfig config;
    @NotNull
    private final String name;
    @NotNull
    private final Environment environment;
    @NotNull
    private final String location;
    @NotNull
    private final Map<Thread, Deque<PersistentStoreTransaction>> txns = new ConcurrentHashMap<Thread, Deque<PersistentStoreTransaction>>(4, 0.75f, 4);
    @NotNull
    private final StoreNamingRules namingRulez;
    @Nullable
    private BlobVault blobVault;
    @NotNull
    private final Map<String, PersistentSequence> allSequences;
    @NotNull
    private final IntHashMap<PersistentSequence> entitiesSequences;
    @NotNull
    private PersistentSequentialDictionary entityTypes;
    @NotNull
    private PersistentSequentialDictionary propertyIds;
    @NotNull
    private PersistentSequentialDictionary linkIds;
    @NotNull
    private final PropertyTypes propertyTypes;
    @NotNull
    private PersistentSequentialDictionary propertyCustomTypeIds;
    @NotNull
    private OpenTablesCache entitiesTables;
    @NotNull
    private OpenTablesCache propertiesTables;
    @NotNull
    private OpenTablesCache linksTables;
    @NotNull
    private OpenTablesCache blobsTables;
    @NotNull
    private Store internalSettings;
    @NotNull
    private Store sequences;
    @NotNull
    private final EntityIterableCache iterableCache;
    @NotNull
    private final ConcurrentObjectCache<String, EntityId> entityIdCache;
    private Explainer explainer;
    private final DataGetter propertyDataGetter;
    private final DataGetter linkDataGetter;
    private final DataGetter blobDataGetter;
    @NotNull
    private final PersistentEntityStoreStatistics statistics;
    @Nullable
    private final EntityStoreConfig configMBean;
    @Nullable
    private final EntityStoreStatistics statisticsMBean;
    @NotNull
    private final PersistentEntityStoreSettingsListener entityStoreSettingsListener;
    @NotNull
    private final Set<TableCreationOperation> tableCreationLog = new HashSet();

    public PersistentEntityStoreImpl(@NotNull Environment environment, @NotNull String name) throws Exception {
        this(environment, null, name);
    }

    public PersistentEntityStoreImpl(@NotNull Environment environment, @Nullable BlobVault blobVault, @NotNull String name) {
        this(new PersistentEntityStoreConfig(), environment, blobVault, name);
    }

    public PersistentEntityStoreImpl(@NotNull PersistentEntityStoreConfig config, @NotNull Environment environment, @Nullable BlobVault blobVault, @NotNull String name) {
        this.hashCode = System.identityHashCode(this);
        this.config = config;
        this.environment = environment;
        this.blobVault = blobVault;
        PersistentEntityStores.adjustEnvironmentConfigForEntityStore(environment.getEnvironmentConfig());
        this.name = name;
        this.location = environment.getLocation();
        this.namingRulez = new StoreNamingRules(name);
        this.iterableCache = new EntityIterableCache(this);
        this.entityIdCache = new ConcurrentObjectCache(2047);
        this.explainer = new Explainer(config.isExplainOn());
        this.propertyDataGetter = new PropertyDataGetter();
        this.linkDataGetter = config.isDebugLinkDataGetter() ? new DebugLinkDataGetter() : new LinkDataGetter();
        this.blobDataGetter = new BlobDataGetter();
        this.allSequences = new HashMap();
        this.entitiesSequences = new IntHashMap();
        this.propertyTypes = new PropertyTypes();
        this.init();
        this.statistics = new PersistentEntityStoreStatistics(this);
        if (config.isManagementEnabled()) {
            this.configMBean = new EntityStoreConfig(this);
            this.statisticsMBean = config.getGatherStatistics() ? new EntityStoreStatistics(this) : null;
        } else {
            this.configMBean = null;
            this.statisticsMBean = null;
        }
        this.entityStoreSettingsListener = new PersistentEntityStoreSettingsListener(this);
        config.addChangedSettingsListener((ConfigSettingChangeListener)this.entityStoreSettingsListener);
        if (logger.isDebugEnabled()) {
            logger.debug("Created successfully.");
        }
    }

    private void init() {
        boolean fromScratch = this.computeInTransaction(new StoreTransactionalComputable<Boolean>(){

            public Boolean compute(@NotNull StoreTransaction tx) {
                boolean result;
                PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                PersistentEntityStoreImpl.this.sequences = PersistentEntityStoreImpl.this.environment.openStore(PersistentEntityStoreImpl.SEQUENCES_STORE, StoreConfig.WITHOUT_DUPLICATES, txn.getEnvironmentTransaction());
                if (PersistentEntityStoreImpl.this.blobVault == null) {
                    PersistentEntityStoreImpl.this.setBlobVault(PersistentEntityStoreImpl.this.createDefaultFSBlobVault());
                }
                PersistentEntityStoreImpl.this.blobVault.setStringContentCacheSize(PersistentEntityStoreImpl.this.config.getBlobStringsCacheSize());
                TwoColumnTable entityTypesTable = new TwoColumnTable(txn, PersistentEntityStoreImpl.this.namingRulez.getEntityTypesTableName(), StoreConfig.WITHOUT_DUPLICATES);
                PersistentSequence entityTypesSequence = PersistentEntityStoreImpl.this.getSequence(txn, PersistentEntityStoreImpl.this.namingRulez.getEntityTypesSequenceName());
                PersistentEntityStoreImpl.this.entityTypes = new PersistentSequentialDictionary(entityTypesSequence, entityTypesTable){

                    @Override
                    protected void created(PersistentStoreTransaction txn, int id) {
                        PersistentEntityStoreImpl.this.preloadTables(txn, id);
                    }
                };
                PersistentEntityStoreImpl.this.propertyIds = new PersistentSequentialDictionary(PersistentEntityStoreImpl.this.getSequence(txn, PersistentEntityStoreImpl.this.namingRulez.getPropertyIdsSequenceName()), new TwoColumnTable(txn, PersistentEntityStoreImpl.this.namingRulez.getPropertyIdsTableName(), StoreConfig.WITHOUT_DUPLICATES));
                PersistentEntityStoreImpl.this.linkIds = new PersistentSequentialDictionary(PersistentEntityStoreImpl.this.getSequence(txn, PersistentEntityStoreImpl.this.namingRulez.getLinkIdsSequenceName()), new TwoColumnTable(txn, PersistentEntityStoreImpl.this.namingRulez.getLinkIdsTableName(), StoreConfig.WITHOUT_DUPLICATES));
                PersistentEntityStoreImpl.this.propertyCustomTypeIds = new PersistentSequentialDictionary(PersistentEntityStoreImpl.this.getSequence(txn, PersistentEntityStoreImpl.this.namingRulez.getPropertyCustomTypesSequence()), new TwoColumnTable(txn, PersistentEntityStoreImpl.this.namingRulez.getPropertyCustomTypesTable(), StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING));
                PersistentEntityStoreImpl.this.entitiesTables = new OpenTablesCache(new OpenTablesCache.TableCreator(){

                    @Override
                    @NotNull
                    public Table createTable(@NotNull PersistentStoreTransaction txn, int entityTypeId) {
                        return new SingleColumnTable(txn, PersistentEntityStoreImpl.this.namingRulez.getEntitiesTableName(entityTypeId), StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING);
                    }
                });
                PersistentEntityStoreImpl.this.propertiesTables = new OpenTablesCache(new OpenTablesCache.TableCreator(){

                    @Override
                    @NotNull
                    public Table createTable(@NotNull PersistentStoreTransaction txn, int entityTypeId) {
                        return new PropertiesTable(txn, PersistentEntityStoreImpl.this.namingRulez.getPropertiesTableName(entityTypeId), StoreConfig.WITHOUT_DUPLICATES);
                    }
                });
                PersistentEntityStoreImpl.this.linksTables = new OpenTablesCache(new OpenTablesCache.TableCreator(){

                    @Override
                    @NotNull
                    public Table createTable(@NotNull PersistentStoreTransaction txn, int entityTypeId) {
                        return new TwoColumnTable(txn, PersistentEntityStoreImpl.this.namingRulez.getLinksTableName(entityTypeId), StoreConfig.WITH_DUPLICATES_WITH_PREFIXING);
                    }
                });
                PersistentEntityStoreImpl.this.blobsTables = new OpenTablesCache(new OpenTablesCache.TableCreator(){

                    @Override
                    @NotNull
                    public Table createTable(@NotNull PersistentStoreTransaction txn, int entityTypeId) {
                        return new BlobsTable(PersistentEntityStoreImpl.this, txn, PersistentEntityStoreImpl.this.namingRulez.getBlobsTableName(entityTypeId), StoreConfig.WITHOUT_DUPLICATES);
                    }
                });
                String internalSettingsName = PersistentEntityStoreImpl.this.namingRulez.getInternalSettingsName();
                Store settings = PersistentEntityStoreImpl.this.environment.openStore(internalSettingsName, StoreConfig.WITHOUT_DUPLICATES, txn.getEnvironmentTransaction(), false);
                boolean bl = result = settings == null;
                if (result) {
                    PersistentEntityStoreImpl.this.internalSettings = PersistentEntityStoreImpl.this.environment.openStore(internalSettingsName, StoreConfig.WITHOUT_DUPLICATES, txn.getEnvironmentTransaction(), true);
                } else {
                    PersistentEntityStoreImpl.this.internalSettings = settings;
                }
                return result;
            }
        });
        if (!this.config.getRefactoringSkipAll()) {
            this.applyRefactorings(fromScratch);
        }
        this.executeInTransaction(new StoreTransactionalExecutable(){

            public void execute(@NotNull StoreTransaction txn) {
                PersistentEntityStoreImpl.this.preloadTables((PersistentStoreTransaction)txn);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyRefactorings(boolean fromScratch) {
        this.environment.suspendGC();
        try {
            PersistentEntityStoreRefactorings refactorings = new PersistentEntityStoreRefactorings(this);
            if (this.config.getRefactoringDeleteRedundantBlobs()) {
                refactorings.refactorDeleteRedundantBlobs();
            }
            if (fromScratch || Settings.get(this.internalSettings, "Entities' stores key-prefixed") == null) {
                if (!fromScratch) {
                    refactorings.refactorEntitiesTables();
                }
                Settings.set(this.internalSettings, "Entities' stores key-prefixed", "yes");
            }
            if (fromScratch || Settings.get(this.internalSettings, "Null-indices present 2") == null || this.config.getRefactoringNullIndices()) {
                if (!fromScratch) {
                    Settings.delete(this.internalSettings, "Null-indices present");
                    refactorings.refactorCreateNullPropertyIndices();
                }
                Settings.set(this.internalSettings, "Null-indices present 2", "yes");
            }
            if (fromScratch || Settings.get(this.internalSettings, "Blobs' null-indices present") == null || this.config.getRefactoringBlobNullIndices()) {
                if (!fromScratch) {
                    refactorings.refactorCreateNullBlobIndices();
                }
                Settings.set(this.internalSettings, "Blobs' null-indices present", "yes");
            }
            if (fromScratch || Settings.get(this.internalSettings, "refactorMakeLinkTablesConsistent() applied") == null || this.config.getRefactoringHeavyLinks()) {
                if (!fromScratch) {
                    refactorings.refactorMakeLinkTablesConsistent();
                }
                Settings.set(this.internalSettings, "refactorMakeLinkTablesConsistent() applied", "y");
            }
            if (fromScratch || Settings.get(this.internalSettings, "refactorMakePropTablesConsistent() applied") == null || this.config.getRefactoringHeavyProps()) {
                if (!fromScratch) {
                    refactorings.refactorMakePropTablesConsistent();
                }
                Settings.set(this.internalSettings, "refactorMakePropTablesConsistent() applied", "y");
            }
            if (fromScratch || Settings.get(this.internalSettings, "Entities history deleted") == null) {
                if (!fromScratch) {
                    refactorings.refactorRemoveHistoryStores();
                }
                Settings.set(this.internalSettings, "Entities history deleted", "y");
            }
            if (this.blobVault instanceof VFSBlobVault && new File(this.location, BLOBS_DIR).exists()) {
                try {
                    ((VFSBlobVault)this.blobVault).refactorFromFS(this);
                }
                catch (IOException e) {
                    throw ExodusException.toEntityStoreException((Throwable)e);
                }
            }
            if (this.blobVault instanceof FileSystemBlobVaultOld && !(this.blobVault instanceof FileSystemBlobVault) && this.config.getMaxInPlaceBlobSize() > 0) {
                refactorings.refactorInPlaceBlobs((FileSystemBlobVaultOld)this.blobVault, BLOB_HANDLES_SEQUENCE);
            }
        }
        finally {
            this.environment.resumeGC();
        }
    }

    private BlobVault createDefaultFSBlobVault() {
        try {
            FileSystemBlobVaultOld blobVault;
            PersistentSequenceBlobHandleGenerator.PersistentSequenceGetter persistentSequenceGetter = new PersistentSequenceBlobHandleGenerator.PersistentSequenceGetter(){

                @Override
                public PersistentSequence get() {
                    return PersistentEntityStoreImpl.this.getSequence(PersistentEntityStoreImpl.this.getAndCheckCurrentTransaction(), PersistentEntityStoreImpl.BLOB_HANDLES_SEQUENCE);
                }
            };
            try {
                blobVault = new FileSystemBlobVault(this.location, BLOBS_DIR, BLOBS_EXTENSION, new PersistentSequenceBlobHandleGenerator(persistentSequenceGetter));
            }
            catch (UnexpectedBlobVaultVersionException e) {
                blobVault = null;
            }
            if (blobVault == null) {
                blobVault = this.config.getMaxInPlaceBlobSize() > 0 ? new FileSystemBlobVaultOld(this.location, BLOBS_DIR, BLOBS_EXTENSION, BlobHandleGenerator.IMMUTABLE) : new FileSystemBlobVaultOld(this.location, BLOBS_DIR, BLOBS_EXTENSION, new PersistentSequenceBlobHandleGenerator(persistentSequenceGetter));
            }
            long current = persistentSequenceGetter.get().get();
            for (long blobHandle = current + 1L; blobHandle < current + 1000L; ++blobHandle) {
                File file = blobVault.getBlobLocation(blobHandle);
                if (!file.exists()) continue;
                logger.error("Redundant blob file: " + file);
            }
            return blobVault;
        }
        catch (IOException e) {
            throw ExodusException.toExodusException((Throwable)e);
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    @NotNull
    public PersistentStoreTransaction beginTransaction() {
        PersistentStoreTransaction txn = new PersistentStoreTransaction(this);
        this.registerTransaction(txn);
        return txn;
    }

    @NotNull
    public StoreTransaction beginExclusiveTransaction() {
        PersistentStoreTransaction txn = new PersistentStoreTransaction(this, PersistentStoreTransaction.TransactionType.Exclusive);
        this.registerTransaction(txn);
        return txn;
    }

    @NotNull
    public PersistentStoreTransaction beginReadonlyTransaction() {
        ReadonlyPersistentStoreTransaction txn = new ReadonlyPersistentStoreTransaction(this);
        this.registerTransaction(txn);
        return txn;
    }

    @Nullable
    public PersistentStoreTransaction getCurrentTransaction() {
        Thread thread = Thread.currentThread();
        Deque<PersistentStoreTransaction> stack = this.txns.get(thread);
        return stack == null ? null : stack.peek();
    }

    @NotNull
    public PersistentStoreTransaction getAndCheckCurrentTransaction() {
        PersistentStoreTransaction transaction = this.getCurrentTransaction();
        if (transaction == null) {
            throw new IllegalStateException("EntityStore: current transaction is not set.");
        }
        return transaction;
    }

    void registerTransaction(@NotNull PersistentStoreTransaction txn) {
        Thread thread = Thread.currentThread();
        Deque<PersistentStoreTransaction> stack = this.txns.get(thread);
        if (stack == null) {
            stack = new ArrayDeque<PersistentStoreTransaction>(4);
            this.txns.put(thread, stack);
        }
        stack.push(txn);
    }

    void unregisterTransaction(@NotNull PersistentStoreTransaction txn) {
        Thread thread = Thread.currentThread();
        Deque<PersistentStoreTransaction> stack = this.txns.get(thread);
        if (stack == null) {
            throw new EntityStoreException("Transaction was already finished");
        }
        if (txn != stack.peek()) {
            throw new EntityStoreException("Can't finish transaction: nested transaction is not finished");
        }
        stack.pop();
        if (stack.isEmpty()) {
            this.txns.remove(thread);
        }
        txn.closeCaches();
    }

    public void clear() {
        this.environment.clear();
        this.allSequences.clear();
        this.entitiesSequences.clear();
        this.propertyTypes.clear();
        this.iterableCache.clear();
        this.init();
        this.blobVault.clear();
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public PersistentEntityStoreConfig getConfig() {
        return this.config;
    }

    @NotNull
    public String getLocation() {
        return this.location;
    }

    @NotNull
    public Environment getEnvironment() {
        return this.environment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public PersistentSequence getSequence(@NotNull PersistentStoreTransaction txn, @NotNull String sequenceName) {
        Map<String, PersistentSequence> map = this.allSequences;
        synchronized (map) {
            PersistentSequence result = this.allSequences.get(sequenceName);
            if (result == null) {
                result = new PersistentSequence(txn, this.sequences, sequenceName);
                this.allSequences.put(sequenceName, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PersistentSequence> getAllSequences() {
        Map<String, PersistentSequence> map = this.allSequences;
        synchronized (map) {
            return new ArrayList<PersistentSequence>(this.allSequences.values());
        }
    }

    public long getUsableSpace() {
        return new File(this.location).getUsableSpace();
    }

    @NotNull
    public BlobVault getBlobVault() {
        return this.blobVault;
    }

    void setBlobVault(@NotNull BlobVault blobVault) {
        this.blobVault = blobVault;
    }

    public void registerCustomPropertyType(@NotNull StoreTransaction txn, @NotNull Class<? extends Comparable> clazz, @NotNull ComparableBinding binding) {
        this.propertyTypes.registerCustomPropertyType(this.propertyCustomTypeIds.getOrAllocateId((PersistentStoreTransaction)txn, clazz.getName()), clazz, binding);
    }

    public void executeInTransaction(@NotNull StoreTransactionalExecutable executable) {
        PersistentStoreTransaction txn = this.beginTransaction();
        try {
            do {
                executable.execute((StoreTransaction)txn);
                if (txn == this.getCurrentTransaction()) continue;
                txn = null;
                break;
            } while (!txn.flush());
        }
        finally {
            if (txn != null) {
                txn.abort();
            }
        }
    }

    public void executeInReadonlyTransaction(@NotNull StoreTransactionalExecutable executable) {
        PersistentStoreTransaction txn = this.beginReadonlyTransaction();
        try {
            executable.execute((StoreTransaction)txn);
        }
        finally {
            if (txn == this.getCurrentTransaction()) {
                txn.abort();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T computeInTransaction(@NotNull StoreTransactionalComputable<T> computable) {
        Object result;
        PersistentStoreTransaction txn = this.beginTransaction();
        try {
            do {
                result = computable.compute((StoreTransaction)txn);
                if (txn == this.getCurrentTransaction()) continue;
                txn = null;
                break;
            } while (!txn.flush());
        }
        finally {
            if (txn != null) {
                txn.abort();
            }
        }
        return (T)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T computeInReadonlyTransaction(@NotNull StoreTransactionalComputable<T> computable) {
        PersistentStoreTransaction txn = this.beginReadonlyTransaction();
        try {
            Object object = computable.compute((StoreTransaction)txn);
            return (T)object;
        }
        finally {
            if (txn == this.getCurrentTransaction()) {
                txn.abort();
            }
        }
    }

    public Explainer getExplainer() {
        return this.explainer;
    }

    @NotNull
    public EntityIterableCache getEntityIterableCache() {
        return this.iterableCache;
    }

    @Nullable
    public EntityId getCachedEntityId(@NotNull String representation) {
        return (EntityId)this.entityIdCache.tryKey((Object)representation);
    }

    public void cacheEntityId(@NotNull String representation, @NotNull EntityId id) {
        this.entityIdCache.cacheObject((Object)representation, (Object)id);
    }

    @Nullable
    public Comparable getProperty(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity entity, @NotNull String propertyName) {
        ByteIterable resultEntry;
        int propertyId = this.getPropertyId(txn, propertyName, false);
        if (propertyId < 0) {
            return null;
        }
        Comparable result = txn.getCachedProperty(entity, propertyId);
        if (result == null && (resultEntry = this.getRawProperty(txn, entity, propertyId)) != null) {
            PropertyValue propValue = this.propertyTypes.entryToPropertyValue(resultEntry);
            result = propValue.getData();
            if (propValue.getType().getTypeId() != 8) {
                txn.cacheProperty(entity.getId(), propertyId, result);
            }
        }
        return result;
    }

    @Nullable
    public ByteIterable getRawProperty(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity entity, int propertyId) {
        return this.getRawValue(txn, entity, propertyId, this.propertyDataGetter);
    }

    public boolean setProperty(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity entity, @NotNull String propertyName, @NotNull Comparable value) {
        Comparable oldValue;
        PropertyValue propValue = this.propertyTypes.dataToPropertyValue(value);
        ComparableValueType valueType = propValue.getType();
        if (valueType.getBinding() == ComparableSetBinding.BINDING && ((ComparableSet)value).isEmpty()) {
            return this.deleteProperty(txn, entity, propertyName);
        }
        int propertyId = this.getPropertyId(txn, propertyName, true);
        ByteIterable oldValueEntry = this.getRawProperty(txn, entity, propertyId);
        Comparable comparable = oldValue = oldValueEntry == null ? null : this.propertyTypes.entryToPropertyValue(oldValueEntry).getData();
        if (value.equals(oldValue)) {
            return false;
        }
        PersistentEntityId entityId = entity.getId();
        this.getPropertiesTable(txn, entityId.getTypeId()).put(txn, entityId.getLocalId(), (ByteIterable)PropertyTypes.propertyValueToEntry(propValue), oldValueEntry, propertyId, valueType);
        txn.propertyChanged(entityId, propertyId, oldValue, value);
        return true;
    }

    public boolean deleteProperty(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity entity, @NotNull String propertyName) {
        int propertyId = this.getPropertyId(txn, propertyName, false);
        if (propertyId < 0) {
            return false;
        }
        ByteIterable oldValue = this.getRawProperty(txn, entity, propertyId);
        if (oldValue == null) {
            return false;
        }
        PersistentEntityId id = entity.getId();
        PropertyValue propValue = this.propertyTypes.entryToPropertyValue(oldValue);
        this.getPropertiesTable(txn, id.getTypeId()).delete(txn, id.getLocalId(), oldValue, propertyId, propValue.getType());
        txn.propertyChanged(id, propertyId, propValue.getData(), null);
        return true;
    }

    @NotNull
    public List<String> getPropertyNames(@NotNull PersistentStoreTransaction txn, @NotNull Entity entity) {
        ArrayList<String> result = new ArrayList<String>();
        EntityId id = entity.getId();
        long entityLocalId = id.getLocalId();
        PropertyKey propertyKey = new PropertyKey(entityLocalId, 0);
        try (Cursor index = this.getPrimaryPropertyIndexCursor(txn, id.getTypeId());){
            boolean success;
            boolean bl = success = index.getSearchKeyRange((ByteIterable)PropertyKey.propertyKeyToEntry(propertyKey)) != null;
            while (success && (propertyKey = PropertyKey.entryToPropertyKey(index.getKey())).getEntityLocalId() == entityLocalId) {
                String propertyName = this.getPropertyName(txn, propertyKey.getPropertyId());
                if (propertyName != null) {
                    result.add(propertyName);
                }
                success = index.getNext();
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
    }

    @NotNull
    public List<Pair<String, Comparable>> getProperties(@NotNull PersistentStoreTransaction txn, @NotNull Entity entity) {
        ArrayList<Pair<String, Comparable>> result = new ArrayList<Pair<String, Comparable>>();
        EntityId fromId = entity.getId();
        int entityTypeId = fromId.getTypeId();
        long entityLocalId = fromId.getLocalId();
        PropertyKey propertyKey = new PropertyKey(entityLocalId, 0);
        try (Cursor cursor = this.getPrimaryPropertyIndexCursor(txn, entityTypeId);){
            boolean success;
            boolean bl = success = cursor.getSearchKeyRange((ByteIterable)PropertyKey.propertyKeyToEntry(propertyKey)) != null;
            while (success) {
                propertyKey = PropertyKey.entryToPropertyKey(cursor.getKey());
                if (propertyKey.getEntityLocalId() != entityLocalId) {
                    break;
                }
                String propertyName = this.getPropertyName(txn, propertyKey.getPropertyId());
                if (propertyName != null) {
                    result.add((Pair<String, Comparable>)new Pair((Object)propertyName, (Object)this.propertyTypes.entryToPropertyValue(cursor.getValue()).getData()));
                }
                success = cursor.getNext();
            }
        }
        return result;
    }

    @NotNull
    public Cursor getPrimaryPropertyIndexCursor(@NotNull PersistentStoreTransaction txn, int entityTypeId) {
        return this.getPrimaryPropertyIndexCursor(txn, this.getPropertiesTable(txn, entityTypeId));
    }

    @NotNull
    public Cursor getPrimaryPropertyIndexCursor(@NotNull PersistentStoreTransaction txn, @NotNull PropertiesTable properties) {
        return properties.getPrimaryIndex().openCursor(txn.getEnvironmentTransaction());
    }

    @Nullable
    public Cursor getPropertyValuesIndexCursor(@NotNull PersistentStoreTransaction txn, int entityTypeId, int propertyId) {
        Store valueIdx = this.getPropertiesTable(txn, entityTypeId).getValueIndex(txn, propertyId, false);
        if (valueIdx == null) {
            return null;
        }
        return valueIdx.openCursor(txn.getEnvironmentTransaction());
    }

    @NotNull
    public Cursor getEntityWithPropCursor(@NotNull PersistentStoreTransaction txn, int entityTypeId) {
        return this.getPropertiesTable(txn, entityTypeId).getAllPropsIndex().openCursor(txn.getEnvironmentTransaction());
    }

    @NotNull
    public Cursor getEntityWithBlobCursor(@NotNull PersistentStoreTransaction txn, int entityTypeId) {
        return this.getBlobsTable(txn, entityTypeId).getAllBlobsIndex().openCursor(txn.getEnvironmentTransaction());
    }

    @NotNull
    public Cursor getEntitiesIndexCursor(@NotNull PersistentStoreTransaction txn, int entityTypeId) {
        return this.getEntitiesTable(txn, entityTypeId).openCursor(txn.getEnvironmentTransaction());
    }

    @NotNull
    public Cursor getLinksFirstIndexCursor(@NotNull PersistentStoreTransaction txn, int entityTypeId) {
        return this.getLinksTable(txn, entityTypeId).getFirstIndexCursor(txn.getEnvironmentTransaction());
    }

    @NotNull
    public Cursor getLinksSecondIndexCursor(@NotNull PersistentStoreTransaction txn, int entityTypeId) {
        return this.getLinksTable(txn, entityTypeId).getSecondIndexCursor(txn.getEnvironmentTransaction());
    }

    public void clearProperties(@NotNull PersistentStoreTransaction txn, @NotNull Entity entity) {
        Transaction envTxn = txn.getEnvironmentTransaction();
        PersistentEntityId id = (PersistentEntityId)entity.getId();
        int entityTypeId = id.getTypeId();
        long entityLocalId = id.getLocalId();
        PropertiesTable properties = this.getPropertiesTable(txn, entityTypeId);
        PropertyKey propertyKey = new PropertyKey(entityLocalId, 0);
        try (Cursor cursor = this.getPrimaryPropertyIndexCursor(txn, properties);){
            boolean success;
            boolean bl = success = cursor.getSearchKeyRange((ByteIterable)PropertyKey.propertyKeyToEntry(propertyKey)) != null;
            while (success) {
                ByteIterable keyEntry = cursor.getKey();
                PropertyKey key = PropertyKey.entryToPropertyKey(keyEntry);
                if (key.getEntityLocalId() != entityLocalId) {
                    break;
                }
                int propertyId = key.getPropertyId();
                ByteIterable value = cursor.getValue();
                PropertyValue propValue = this.propertyTypes.entryToPropertyValue(value);
                txn.propertyChanged(id, propertyId, propValue.getData(), null);
                properties.deleteNoFail(txn, entityLocalId, value, propertyId, propValue.getType());
                success = cursor.getNext();
            }
        }
    }

    public long getBlobSize(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity entity, @NotNull String blobName) throws IOException {
        Pair<Long, ByteIterator> blobInfo = this.getBlobHandleAndValue(txn, entity, blobName);
        if (blobInfo == null) {
            return -1L;
        }
        long blobHandle = (Long)blobInfo.getFirst();
        if (blobHandle == Long.MAX_VALUE) {
            return 0L;
        }
        if (blobHandle == 0x7FFFFFFFFFFFFFFEL) {
            return CompressedUnsignedLongByteIterable.getLong((ByteIterator)((ByteIterator)blobInfo.getSecond()));
        }
        long result = txn.getBlobSize(blobHandle);
        if (result < 0L) {
            return this.blobVault.getSize(blobHandle, txn.getEnvironmentTransaction());
        }
        return result;
    }

    @Nullable
    public InputStream getBlob(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity entity, @NotNull String blobName) throws IOException {
        Pair<Long, InputStream> blobStream = this.getInPlaceBlobStream(txn, entity, blobName);
        if (blobStream == null) {
            return null;
        }
        long blobHandle = (Long)blobStream.getFirst();
        if (blobHandle == Long.MAX_VALUE) {
            return EMPTY_INPUT_STREAM;
        }
        InputStream result = (InputStream)blobStream.getSecond();
        return result != null ? result : this.blobVault.getContent(blobHandle, txn.getEnvironmentTransaction());
    }

    @Nullable
    public String getBlobString(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity entity, @NotNull String blobName) throws IOException {
        int blobId = this.getPropertyId(txn, blobName, false);
        if (blobId < 0) {
            return null;
        }
        String result = txn.getCachedBlobString(entity, blobId);
        if (result != null) {
            return result;
        }
        Pair<Long, InputStream> blobStream = this.getInPlaceBlobStream(txn, entity, blobName);
        if (blobStream == null) {
            return null;
        }
        long blobHandle = (Long)blobStream.getFirst();
        if (blobHandle == Long.MAX_VALUE) {
            result = EMPTY_STRING;
        } else {
            try {
                InputStream stream = (InputStream)blobStream.getSecond();
                if (stream == null) {
                    return this.blobVault.getStringContent(blobHandle, txn.getEnvironmentTransaction());
                }
                result = UTFUtil.readUTF((InputStream)stream);
            }
            catch (UTFDataFormatException e) {
                result = e.toString();
            }
        }
        if (result != null) {
            txn.cacheBlobString(entity, blobId, result);
        }
        return result;
    }

    @Nullable
    Pair<Long, ByteIterator> getBlobHandleAndValue(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity entity, @NotNull String blobName) {
        int blobId = this.getPropertyId(txn, blobName, false);
        if (blobId < 0) {
            return null;
        }
        ByteIterable valueEntry = this.getRawValue(txn, entity, blobId, this.blobDataGetter);
        if (valueEntry == null) {
            return null;
        }
        ByteIterator valueIterator = valueEntry instanceof FixedLengthByteIterable ? ((FixedLengthByteIterable)valueEntry).getSource().iterator() : valueEntry.iterator();
        return new Pair((Object)LongBinding.readCompressed((ByteIterator)valueIterator), (Object)valueIterator);
    }

    @Nullable
    private Pair<Long, InputStream> getInPlaceBlobStream(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity entity, @NotNull String blobName) throws IOException {
        Pair<Long, ByteIterator> blobInfo = this.getBlobHandleAndValue(txn, entity, blobName);
        if (blobInfo == null) {
            return null;
        }
        long blobHandle = (Long)blobInfo.getFirst();
        if (blobHandle == Long.MAX_VALUE) {
            return new Pair((Object)blobHandle, null);
        }
        if (blobHandle == 0x7FFFFFFFFFFFFFFEL) {
            ByteIterator valueIterator = (ByteIterator)blobInfo.getSecond();
            int size = (int)CompressedUnsignedLongByteIterable.getLong((ByteIterator)valueIterator);
            return new Pair((Object)blobHandle, (Object)new ByteArraySizedInputStream(ByteIterableBase.readIterator((ByteIterator)valueIterator, (int)size)));
        }
        return new Pair((Object)blobHandle, (Object)txn.getBlobStream(blobHandle));
    }

    public void setBlob(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity entity, @NotNull String blobName, @NotNull InputStream stream) throws IOException {
        ByteArraySizedInputStream copy = stream instanceof ByteArraySizedInputStream ? (ByteArraySizedInputStream)stream : this.blobVault.cloneStream(stream, true);
        long blobHandle = this.createBlobHandle(txn, entity, blobName, copy, copy.size());
        if (!PersistentEntityStoreImpl.isEmptyOrInPlaceBlobHandle(blobHandle)) {
            txn.addBlob(blobHandle, (InputStream)copy);
        }
    }

    public void setBlob(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity entity, @NotNull String blobName, @NotNull File file) throws IOException {
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            throw new EntityStoreException("Too large blob, size is greater than 2147483647");
        }
        int size = (int)length;
        long blobHandle = this.createBlobHandle(txn, entity, blobName, size > this.config.getMaxInPlaceBlobSize() ? null : this.blobVault.cloneStream((InputStream)new FileInputStream(file), true), size);
        if (!PersistentEntityStoreImpl.isEmptyOrInPlaceBlobHandle(blobHandle)) {
            txn.addBlob(blobHandle, file);
        }
    }

    public void setBlobString(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity entity, @NotNull String blobName, @NotNull String blobString) throws IOException {
        int length = blobString.length();
        if (length == 0) {
            this.createBlobHandle(txn, entity, blobName, null, 0);
        } else {
            LightByteArrayOutputStream memCopy = new LightByteArrayOutputStream();
            UTFUtil.writeUTF((OutputStream)memCopy, (String)blobString);
            int streamSize = memCopy.size();
            ByteArraySizedInputStream copy = new ByteArraySizedInputStream(memCopy.toByteArray(), 0, streamSize);
            long blobHandle = this.createBlobHandle(txn, entity, blobName, copy, streamSize);
            if (!PersistentEntityStoreImpl.isEmptyOrInPlaceBlobHandle(blobHandle)) {
                txn.addBlob(blobHandle, (InputStream)copy);
            }
        }
    }

    private long createBlobHandle(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity entity, @NotNull String blobName, @Nullable ByteArraySizedInputStream stream, int size) {
        long blobHandle;
        PersistentEntityId id = entity.getId();
        long entityLocalId = id.getLocalId();
        int blobId = this.getPropertyId(txn, blobName, true);
        txn.invalidateCachedBlobString(entity, blobId);
        BlobsTable blobs = this.getBlobsTable(txn, id.getTypeId());
        Transaction envTxn = txn.getEnvironmentTransaction();
        ByteIterable value = blobs.get(envTxn, entityLocalId, blobId);
        if (value != null) {
            this.deleteObsoleteBlobHandle(LongBinding.compressedEntryToLong((ByteIterable)value), txn);
        }
        if (size == 0) {
            blobHandle = Long.MAX_VALUE;
            blobs.put(envTxn, entityLocalId, blobId, (ByteIterable)LongBinding.longToCompressedEntry((long)blobHandle));
        } else if (size <= this.config.getMaxInPlaceBlobSize()) {
            if (stream == null) {
                throw new NullPointerException("In-memory blob content is expected");
            }
            blobHandle = 0x7FFFFFFFFFFFFFFEL;
            blobs.put(envTxn, entityLocalId, blobId, (ByteIterable)new CompoundByteIterable(new ByteIterable[]{LongBinding.longToCompressedEntry((long)blobHandle), CompressedUnsignedLongByteIterable.getIterable((long)size), new ArrayByteIterable(stream.toByteArray(), size)}));
        } else {
            blobHandle = this.blobVault.nextHandle(envTxn);
            blobs.put(envTxn, entityLocalId, blobId, (ByteIterable)LongBinding.longToCompressedEntry((long)blobHandle));
        }
        return blobHandle;
    }

    public boolean deleteBlob(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity entity, @NotNull String blobName) {
        Transaction envTxn = txn.getEnvironmentTransaction();
        int blobId = this.getPropertyId(txn, blobName, false);
        if (blobId < 0) {
            return false;
        }
        txn.invalidateCachedBlobString(entity, blobId);
        PersistentEntityId id = entity.getId();
        long entityLocalId = id.getLocalId();
        BlobsTable blobs = this.getBlobsTable(txn, id.getTypeId());
        ByteIterable value = blobs.get(envTxn, entityLocalId, blobId);
        if (value == null) {
            return false;
        }
        blobs.delete(envTxn, entityLocalId, blobId);
        this.deleteObsoleteBlobHandle(LongBinding.compressedEntryToLong((ByteIterable)value), txn);
        return true;
    }

    public void clearBlobs(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity entity) {
        PersistentEntityId id = entity.getId();
        int entityTypeId = id.getTypeId();
        long entityLocalId = id.getLocalId();
        Transaction envTxn = txn.getEnvironmentTransaction();
        BlobsTable blobs = this.getBlobsTable(txn, entityTypeId);
        PropertyKey propertyKey = new PropertyKey(entityLocalId, 0);
        ArrayByteIterable keyEntry = PropertyKey.propertyKeyToEntry(propertyKey);
        try (Cursor cursor = blobs.getPrimaryIndex().openCursor(envTxn);){
            boolean success;
            boolean bl = success = cursor.getSearchKeyRange((ByteIterable)keyEntry) != null;
            while (success) {
                keyEntry = cursor.getKey();
                PropertyKey key = PropertyKey.entryToPropertyKey((ByteIterable)keyEntry);
                if (key.getEntityLocalId() != entityLocalId) {
                    break;
                }
                ByteIterable value = cursor.getValue();
                int blobId = key.getPropertyId();
                blobs.delete(envTxn, entityLocalId, blobId);
                txn.invalidateCachedBlobString(entity, blobId);
                this.deleteObsoleteBlobHandle(LongBinding.compressedEntryToLong((ByteIterable)value), txn);
                success = cursor.getNext();
            }
        }
    }

    @NotNull
    public List<String> getBlobNames(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity entity) {
        ArrayList<String> result = new ArrayList<String>();
        PersistentEntityId id = entity.getId();
        long entityLocalId = id.getLocalId();
        PropertyKey propertyKey = new PropertyKey(entityLocalId, 0);
        try (Cursor index = this.getBlobsTable(txn, id.getTypeId()).getPrimaryIndex().openCursor(txn.getEnvironmentTransaction());){
            boolean success;
            boolean bl = success = index.getSearchKeyRange((ByteIterable)PropertyKey.propertyKeyToEntry(propertyKey)) != null;
            while (success && (propertyKey = PropertyKey.entryToPropertyKey(index.getKey())).getEntityLocalId() == entityLocalId) {
                String propertyName = this.getPropertyName(txn, propertyKey.getPropertyId());
                if (propertyName != null) {
                    result.add(propertyName);
                }
                success = index.getNext();
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
    }

    @NotNull
    public List<Pair<String, Long>> getBlobs(@NotNull PersistentStoreTransaction txn, @NotNull Entity entity) {
        ArrayList<Pair<String, Long>> result = new ArrayList<Pair<String, Long>>();
        EntityId fromId = entity.getId();
        int entityTypeId = fromId.getTypeId();
        long entityLocalId = fromId.getLocalId();
        PropertyKey blobKey = new PropertyKey(entityLocalId, 0);
        try (Cursor cursor = this.getBlobsTable(txn, entityTypeId).getPrimaryIndex().openCursor(txn.getEnvironmentTransaction());){
            boolean success;
            boolean bl = success = cursor.getSearchKeyRange((ByteIterable)PropertyKey.propertyKeyToEntry(blobKey)) != null;
            while (success) {
                blobKey = PropertyKey.entryToPropertyKey(cursor.getKey());
                if (blobKey.getEntityLocalId() != entityLocalId) {
                    break;
                }
                String blobName = this.getPropertyName(txn, blobKey.getPropertyId());
                if (blobName != null) {
                    result.add((Pair<String, Long>)new Pair((Object)blobName, (Object)LongBinding.compressedEntryToLong((ByteIterable)cursor.getValue())));
                }
                success = cursor.getNext();
            }
        }
        return result;
    }

    boolean addLink(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity from, @NotNull PersistentEntity to, int linkId) {
        PersistentEntityId fromId = from.getId();
        int entityTypeId = fromId.getTypeId();
        long entityLocalId = fromId.getLocalId();
        PropertyKey linkKey = new PropertyKey(entityLocalId, linkId);
        LinkValue linkValue = new LinkValue(to.getId(), linkId);
        if (!this.getLinksTable(txn, entityTypeId).put(txn.getEnvironmentTransaction(), (ByteIterable)PropertyKey.propertyKeyToEntry(linkKey), (ByteIterable)LinkValue.linkValueToEntry(linkValue))) {
            return false;
        }
        txn.linkAdded(from.getId(), to.getId(), linkId);
        return true;
    }

    boolean setLink(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity from, int linkId, @Nullable PersistentEntity to) {
        Transaction envTxn = txn.getEnvironmentTransaction();
        PersistentEntityId fromId = from.getId();
        int entityTypeId = fromId.getTypeId();
        long entityLocalId = fromId.getLocalId();
        ArrayByteIterable keyEntry = PropertyKey.propertyKeyToEntry(new PropertyKey(entityLocalId, linkId));
        TwoColumnTable links = this.getLinksTable(txn, entityTypeId);
        boolean oldTargetDeleted = false;
        ByteIterable valueEntry = this.getRawLink(txn, from, linkId);
        if (valueEntry != null) {
            PersistentEntity oldTarget = this.getEntity(LinkValue.entryToLinkValue(valueEntry).getEntityId());
            if (oldTarget.equals(to)) {
                return false;
            }
            links.delete(envTxn, (ByteIterable)keyEntry, valueEntry);
            txn.linkDeleted(fromId, oldTarget.getId(), linkId);
            oldTargetDeleted = true;
        }
        if (to == null) {
            return oldTargetDeleted;
        }
        LinkValue linkValue = new LinkValue(to.getId(), linkId);
        links.put(envTxn, (ByteIterable)keyEntry, (ByteIterable)LinkValue.linkValueToEntry(linkValue));
        txn.linkAdded(fromId, to.getId(), linkId);
        return true;
    }

    @Nullable
    PersistentEntity getLink(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity from, int linkId) {
        PersistentEntityId resultId = this.getLinkAsEntityId(txn, from, linkId);
        return resultId == null ? null : this.getEntity(resultId);
    }

    @Nullable
    public PersistentEntityId getLinkAsEntityId(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity from, int linkId) {
        ByteIterable resultEntry;
        PersistentEntityId resultId = txn.getCachedLink(from, linkId);
        if (resultId == null && (resultEntry = this.getRawLink(txn, from, linkId)) != null) {
            resultId = (PersistentEntityId)LinkValue.entryToLinkValue(resultEntry).getEntityId();
            txn.cacheLink(from, linkId, resultId);
        }
        return resultId;
    }

    @Nullable
    private ByteIterable getRawLink(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity from, int linkId) {
        return this.getRawValue(txn, from, linkId, this.linkDataGetter);
    }

    @Nullable
    private ByteIterable getRawValue(@NotNull PersistentStoreTransaction txn, @NotNull Entity entity, int propertyId, @NotNull DataGetter dataGetter) {
        EntityId fromId = entity.getId();
        return dataGetter.getUpToDateEntry(txn, fromId.getTypeId(), new PropertyKey(fromId.getLocalId(), propertyId));
    }

    @NotNull
    EntityIterableBase getLinks(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity from, int linkId) {
        return new EntityFromLinksIterable(txn, from.getId(), linkId);
    }

    @NotNull
    EntityIterable getLinks(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity from, IntHashMap<String> linkNames) {
        return new EntityFromLinkSetIterable(txn, from.getId(), linkNames);
    }

    boolean deleteLink(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity from, int linkId, @NotNull PersistentEntity to) {
        return this.deleteLink(txn, from, linkId, to.getId());
    }

    boolean deleteLink(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity from, int linkId, @NotNull PersistentEntityId toId) {
        PersistentEntityId fromId = from.getId();
        int entityTypeId = fromId.getTypeId();
        long entityLocalId = fromId.getLocalId();
        PropertyKey linkKey = new PropertyKey(entityLocalId, linkId);
        LinkValue linkValue = new LinkValue(toId, linkId);
        Transaction envTxn = txn.getEnvironmentTransaction();
        TwoColumnTable links = this.getLinksTable(txn, entityTypeId);
        if (links.delete(envTxn, (ByteIterable)PropertyKey.propertyKeyToEntry(linkKey), (ByteIterable)LinkValue.linkValueToEntry(linkValue))) {
            txn.linkDeleted(fromId, toId, linkId);
            return true;
        }
        return false;
    }

    @NotNull
    public List<String> getLinkNames(@NotNull PersistentStoreTransaction txn, @NotNull Entity entity) {
        ArrayList<String> result = new ArrayList<String>();
        EntityId id = entity.getId();
        long entityLocalId = id.getLocalId();
        PropertyKey linkKey = new PropertyKey(entityLocalId, 0);
        try (Cursor index = this.getLinksTable(txn, id.getTypeId()).getFirstIndexCursor(txn.getEnvironmentTransaction());){
            boolean success;
            boolean bl = success = index.getSearchKeyRange((ByteIterable)PropertyKey.propertyKeyToEntry(linkKey)) != null;
            while (success && (linkKey = PropertyKey.entryToPropertyKey(index.getKey())).getEntityLocalId() == entityLocalId) {
                String linkName = this.getLinkName(txn, linkKey.getPropertyId());
                if (linkName != null) {
                    result.add(linkName);
                }
                success = index.getNextNoDup();
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
    }

    @NotNull
    public List<Pair<String, EntityId>> getLinks(@NotNull PersistentStoreTransaction txn, @NotNull Entity entity) {
        ArrayList<Pair<String, EntityId>> result = new ArrayList<Pair<String, EntityId>>();
        EntityId fromId = entity.getId();
        int entityTypeId = fromId.getTypeId();
        long entityLocalId = fromId.getLocalId();
        PropertyKey linkKey = new PropertyKey(entityLocalId, 0);
        try (Cursor cursor = this.getLinksTable(txn, entityTypeId).getFirstIndexCursor(txn.getEnvironmentTransaction());){
            boolean success;
            boolean bl = success = cursor.getSearchKeyRange((ByteIterable)PropertyKey.propertyKeyToEntry(linkKey)) != null;
            while (success) {
                linkKey = PropertyKey.entryToPropertyKey(cursor.getKey());
                if (linkKey.getEntityLocalId() != entityLocalId) {
                    break;
                }
                String linkName = this.getLinkName(txn, linkKey.getPropertyId());
                if (linkName != null) {
                    result.add((Pair<String, EntityId>)new Pair((Object)linkName, (Object)LinkValue.entryToLinkValue(cursor.getValue()).getEntityId()));
                }
                success = cursor.getNext();
            }
        }
        return result;
    }

    @Deprecated
    public int getLastVersion(@NotNull EntityId id) {
        return this.getLastVersion(this.getAndCheckCurrentTransaction(), id);
    }

    public int getLastVersion(@NotNull PersistentStoreTransaction txn, @NotNull EntityId id) {
        Store entities = this.getEntitiesTable(txn, id.getTypeId());
        ByteIterable versionEntry = entities.get(txn.getEnvironmentTransaction(), (ByteIterable)LongBinding.longToCompressedEntry((long)id.getLocalId()));
        if (versionEntry == null) {
            return -1;
        }
        return IntegerBinding.compressedEntryToInt((ByteIterable)versionEntry);
    }

    public PersistentEntity getEntity(@NotNull EntityId id) {
        return new PersistentEntity(this, (PersistentEntityId)id);
    }

    boolean deleteEntity(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity entity) {
        this.clearProperties(txn, entity);
        this.clearBlobs(txn, entity);
        this.deleteLinks(txn, entity);
        PersistentEntityId id = entity.getId();
        int entityTypeId = id.getTypeId();
        long entityLocalId = id.getLocalId();
        ArrayByteIterable key = LongBinding.longToCompressedEntry((long)entityLocalId);
        if (this.config.isDebugSearchForIncomingLinksOnDelete()) {
            List<String> allLinkNames = this.getAllLinkNames(txn);
            for (String entityType : txn.getEntityTypes()) {
                for (String linkName : allLinkNames) {
                    EntityIterator entityIterator = txn.findLinks(entityType, entity, linkName).iterator();
                    if (!entityIterator.hasNext()) continue;
                    Entity referrer = (Entity)entityIterator.next();
                    throw new EntityStoreException(entity + " is about to be deleted, but it is referenced by " + referrer + ", link name: " + linkName);
                }
            }
        }
        if (this.getEntitiesTable(txn, entityTypeId).delete(txn.getEnvironmentTransaction(), (ByteIterable)key)) {
            txn.entityDeleted(id);
            return true;
        }
        return false;
    }

    private void deleteLinks(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntity entity) {
        PersistentEntityId id = entity.getId();
        int entityTypeId = id.getTypeId();
        long entityLocalId = id.getLocalId();
        Transaction envTxn = txn.getEnvironmentTransaction();
        TwoColumnTable links = this.getLinksTable(txn, entityTypeId);
        try (Cursor cursor = links.getFirstIndexCursor(envTxn);){
            boolean success;
            boolean bl = success = cursor.getSearchKeyRange((ByteIterable)PropertyKey.propertyKeyToEntry(new PropertyKey(entityLocalId, 0))) != null;
            while (success) {
                ByteIterable keyEntry = cursor.getKey();
                PropertyKey key = PropertyKey.entryToPropertyKey(keyEntry);
                if (key.getEntityLocalId() != entityLocalId) {
                    break;
                }
                ByteIterable valueEntry = cursor.getValue();
                if (links.delete(envTxn, keyEntry, valueEntry) && this.getLinkName(txn, key.getPropertyId()) != null) {
                    LinkValue linkValue = LinkValue.entryToLinkValue(valueEntry);
                    txn.linkDeleted(entity.getId(), (PersistentEntityId)linkValue.getEntityId(), linkValue.getLinkId());
                }
                success = cursor.getNext();
            }
        }
    }

    public int getEntityTypeId(@NotNull String entityType) {
        return this.getEntityTypeId(entityType, false);
    }

    @Deprecated
    public int getEntityTypeId(@NotNull String entityType, boolean allowCreate) {
        return this.getEntityTypeId(new TxnProvider(){

            @Override
            @NotNull
            public PersistentStoreTransaction getTransaction() {
                return PersistentEntityStoreImpl.this.getAndCheckCurrentTransaction();
            }
        }, entityType, allowCreate);
    }

    public int getEntityTypeId(@NotNull PersistentStoreTransaction txn, @NotNull String entityType, boolean allowCreate) {
        return allowCreate ? this.entityTypes.getOrAllocateId(txn, entityType) : this.entityTypes.getId(txn, entityType);
    }

    public int getEntityTypeId(@NotNull TxnProvider txnProvider, @NotNull String entityType, boolean allowCreate) {
        return allowCreate ? this.entityTypes.getOrAllocateId(txnProvider, entityType) : this.entityTypes.getId(txnProvider, entityType);
    }

    @NotNull
    public String getEntityType(int entityTypeId) {
        return this.getEntityType(new TxnProvider(){

            @Override
            @NotNull
            public PersistentStoreTransaction getTransaction() {
                return PersistentEntityStoreImpl.this.getAndCheckCurrentTransaction();
            }
        }, entityTypeId);
    }

    @NotNull
    public String getEntityType(@NotNull PersistentStoreTransaction txn, int entityTypeId) {
        String result = this.entityTypes.getName(txn, entityTypeId);
        if (result == null) {
            throw new EntityStoreException("Invalid type id: " + entityTypeId);
        }
        return result;
    }

    @NotNull
    public String getEntityType(@NotNull TxnProvider txnProvider, int entityTypeId) {
        String result = this.entityTypes.getName(txnProvider, entityTypeId);
        if (result == null) {
            throw new EntityStoreException("Invalid type id: " + entityTypeId);
        }
        return result;
    }

    @NotNull
    public List<String> getEntityTypes(@NotNull PersistentStoreTransaction txn) {
        ArrayList<String> result = new ArrayList<String>();
        try (Cursor entityTypesCursor = this.entityTypes.getTable().getSecondIndexCursor(txn.getEnvironmentTransaction());){
            while (entityTypesCursor.getNext()) {
                int entityTypeId = IntegerBinding.compressedEntryToInt((ByteIterable)entityTypesCursor.getKey());
                result.add(this.getEntityType(txn, entityTypeId));
            }
        }
        return result;
    }

    public void renameEntityType(@NotNull String oldEntityTypeName, @NotNull String newEntityTypeName) {
        this.entityTypes.rename(this.getAndCheckCurrentTransaction(), oldEntityTypeName, newEntityTypeName);
    }

    public void deleteEntityType(@NotNull String entityTypeName) {
        PersistentStoreTransaction txn = this.getAndCheckCurrentTransaction();
        int entityTypeId = this.entityTypes.delete(txn, entityTypeName);
        if (entityTypeId < 0) {
            return;
        }
        this.entitiesTables.remove(entityTypeId);
        this.propertiesTables.remove(entityTypeId);
        this.linksTables.remove(entityTypeId);
        this.blobsTables.remove(entityTypeId);
        String entityTableName = this.namingRulez.getEntitiesTableName(entityTypeId);
        final String propertiesTableName = this.namingRulez.getPropertiesTableName(entityTypeId);
        String linksTableName = this.namingRulez.getLinksTableName(entityTypeId);
        String secondLinksTableName = TwoColumnTable.secondColumnDatabaseName(linksTableName);
        String blobsTableName = this.namingRulez.getBlobsTableName(entityTypeId);
        this.truncateStores(txn, Arrays.asList(entityTableName, linksTableName, secondLinksTableName, propertiesTableName, blobsTableName), new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    private int propertyId = 0;

                    @Override
                    public boolean hasNext() {
                        return this.propertyId < 10000;
                    }

                    @Override
                    public String next() {
                        return propertiesTableName + "#value_idx" + this.propertyId++;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        });
    }

    private void truncateStores(@NotNull PersistentStoreTransaction txn, @NotNull Iterable<String> unsafe, @NotNull Iterable<String> safe) {
        Transaction envTxn = txn.getEnvironmentTransaction();
        for (String name : unsafe) {
            this.environment.truncateStore(name, envTxn);
        }
        for (String name : safe) {
            try {
                this.environment.truncateStore(name, envTxn);
            }
            catch (ExodusException e) {}
        }
    }

    @Deprecated
    public int getPropertyId(@NotNull String propertyName, boolean allowCreate) {
        return this.getPropertyId(new TxnProvider(){

            @Override
            @NotNull
            public PersistentStoreTransaction getTransaction() {
                return PersistentEntityStoreImpl.this.getAndCheckCurrentTransaction();
            }
        }, propertyName, allowCreate);
    }

    public int getPropertyId(@NotNull PersistentStoreTransaction txn, @NotNull String propertyName, boolean allowCreate) {
        return allowCreate ? this.propertyIds.getOrAllocateId(txn, propertyName) : this.propertyIds.getId(txn, propertyName);
    }

    public int getPropertyId(@NotNull TxnProvider txnProvider, @NotNull String propertyName, boolean allowCreate) {
        return allowCreate ? this.propertyIds.getOrAllocateId(txnProvider, propertyName) : this.propertyIds.getId(txnProvider, propertyName);
    }

    @Nullable
    public String getPropertyName(@NotNull PersistentStoreTransaction txn, int propertyId) {
        return this.propertyIds.getName(txn, propertyId);
    }

    @Deprecated
    public int getLinkId(@NotNull String linkName, boolean allowCreate) {
        return this.getLinkId(new TxnProvider(){

            @Override
            @NotNull
            public PersistentStoreTransaction getTransaction() {
                return PersistentEntityStoreImpl.this.getAndCheckCurrentTransaction();
            }
        }, linkName, allowCreate);
    }

    public int getLinkId(@NotNull PersistentStoreTransaction txn, @NotNull String linkName, boolean allowCreate) {
        return allowCreate ? this.linkIds.getOrAllocateId(txn, linkName) : this.linkIds.getId(txn, linkName);
    }

    public int getLinkId(@NotNull TxnProvider txnProvider, @NotNull String linkName, boolean allowCreate) {
        return allowCreate ? this.linkIds.getOrAllocateId(txnProvider, linkName) : this.linkIds.getId(txnProvider, linkName);
    }

    @Nullable
    String getLinkName(@NotNull PersistentStoreTransaction txn, int linkId) {
        return this.linkIds.getName(txn, linkId);
    }

    public List<String> getAllLinkNames(@NotNull PersistentStoreTransaction txn) {
        int lastLinkId = this.linkIds.getLastAllocatedId();
        ArrayList<String> result = new ArrayList<String>(lastLinkId + 1);
        for (int i = 0; i <= lastLinkId; ++i) {
            String linkName = this.getLinkName(txn, i);
            if (linkName == null) continue;
            result.add(linkName);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    PersistentSequence getEntitiesSequence(@NotNull PersistentStoreTransaction txn, int entityTypeId) {
        IntHashMap<PersistentSequence> intHashMap = this.entitiesSequences;
        synchronized (intHashMap) {
            PersistentSequence result = (PersistentSequence)this.entitiesSequences.get(entityTypeId);
            if (result == null) {
                result = this.getSequence(txn, this.namingRulez.getEntitiesSequenceName(entityTypeId));
                this.entitiesSequences.put(entityTypeId, (Object)result);
            }
            return result;
        }
    }

    private void preloadTables(PersistentStoreTransaction txn) {
        for (String entityType : this.getEntityTypes(txn)) {
            int id = this.getEntityTypeId(txn, entityType, false);
            if (id != -1) continue;
            throw new IllegalStateException("Entity types iterator returned non-existent id");
        }
    }

    private void preloadTables(@NotNull PersistentStoreTransaction txn, int entityTypeId) {
        this.getEntitiesTable(txn, entityTypeId);
        this.getPropertiesTable(txn, entityTypeId);
        this.getLinksTable(txn, entityTypeId);
        this.getBlobsTable(txn, entityTypeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trackTableCreation(@NotNull Store table, @NotNull PersistentStoreTransaction txn) {
        final StoreImpl tableImpl = (StoreImpl)table;
        if (tableImpl.isNew(txn.getEnvironmentTransaction())) {
            Set<TableCreationOperation> set = this.tableCreationLog;
            synchronized (set) {
                this.tableCreationLog.add(new TableCreationOperation(){

                    @Override
                    void persist(Transaction txn) {
                        tableImpl.persistCreation(txn);
                    }
                });
            }
        }
    }

    @Override
    public void logOperations(Transaction txn, FlushLog flushLog) {
        for (PersistentSequence sequence : this.getAllSequences()) {
            sequence.logOperations(txn, flushLog);
        }
        this.entityTypes.logOperations(txn, flushLog);
        this.propertyIds.logOperations(txn, flushLog);
        this.propertyCustomTypeIds.logOperations(txn, flushLog);
        this.linkIds.logOperations(txn, flushLog);
        for (TableCreationOperation op : this.tableCreationLog) {
            op.persist(txn);
            flushLog.add(op);
        }
    }

    @NotNull
    public TwoColumnTable getEntityTypesTable() {
        return this.entityTypes.getTable();
    }

    @NotNull
    public PropertyTypes getPropertyTypes() {
        return this.propertyTypes;
    }

    @NotNull
    public Store getEntitiesTable(@NotNull PersistentStoreTransaction txn, int entityTypeId) {
        return ((SingleColumnTable)this.entitiesTables.get(txn, entityTypeId)).getDatabase();
    }

    @NotNull
    public PropertiesTable getPropertiesTable(@NotNull PersistentStoreTransaction txn, int entityTypeId) {
        return (PropertiesTable)this.propertiesTables.get(txn, entityTypeId);
    }

    @NotNull
    public TwoColumnTable getLinksTable(@NotNull PersistentStoreTransaction txn, int entityTypeId) {
        return (TwoColumnTable)this.linksTables.get(txn, entityTypeId);
    }

    @NotNull
    public BlobsTable getBlobsTable(@NotNull PersistentStoreTransaction txn, int entityTypeId) {
        return (BlobsTable)this.blobsTables.get(txn, entityTypeId);
    }

    @NotNull
    public EntityStoreSharedAsyncProcessor getAsyncProcessor() {
        return this.iterableCache.processor;
    }

    @NotNull
    public Statistics getStatistics() {
        return this.statistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        logger.info("Closing...");
        this.config.removeChangedSettingsListener((ConfigSettingChangeListener)this.entityStoreSettingsListener);
        if (this.configMBean != null) {
            this.configMBean.unregister();
        }
        if (this.statisticsMBean != null) {
            this.statisticsMBean.unregister();
        }
        try {
            this.getAsyncProcessor().finish();
            PersistentEntityStoreImpl persistentEntityStoreImpl = this;
            synchronized (persistentEntityStoreImpl) {
                this.blobVault.close();
                this.environment.close();
            }
            logger.info("Closed successfully.");
        }
        catch (Exception e) {
            logger.error("close() failed", (Throwable)e);
            throw ExodusException.toExodusException((Throwable)e);
        }
    }

    public BackupStrategy getBackupStrategy() {
        return new PersistentEntityStoreBackupStrategy(this);
    }

    @NotNull
    StoreNamingRules getNamingRules() {
        return this.namingRulez;
    }

    static boolean isEmptyOrInPlaceBlobHandle(long blobHandle) {
        return Long.MAX_VALUE == blobHandle || 0x7FFFFFFFFFFFFFFEL == blobHandle;
    }

    private void safeTruncateStore(@NotNull PersistentStoreTransaction txn, @NotNull String dbName) {
        this.environment.truncateStore(dbName, txn.getEnvironmentTransaction());
    }

    private void deleteObsoleteBlobHandle(long blobHandle, PersistentStoreTransaction txn) {
        if (PersistentEntityStoreImpl.isEmptyOrInPlaceBlobHandle(blobHandle)) {
            return;
        }
        if (!txn.isBlobPreserved(blobHandle)) {
            txn.deleteBlob(blobHandle);
            txn.deferBlobDeletion(blobHandle);
        }
    }

    private abstract class TableCreationOperation
    implements FlushLog.Operation {
        private TableCreationOperation() {
        }

        abstract void persist(Transaction var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flushed() {
            Set set = PersistentEntityStoreImpl.this.tableCreationLog;
            synchronized (set) {
                PersistentEntityStoreImpl.this.tableCreationLog.remove(this);
            }
        }
    }

    private class BlobDataGetter
    implements DataGetter {
        private BlobDataGetter() {
        }

        @Override
        public ByteIterable getUpToDateEntry(@NotNull PersistentStoreTransaction txn, int typeId, PropertyKey key) {
            return PersistentEntityStoreImpl.this.getBlobsTable(txn, typeId).get(txn.getEnvironmentTransaction(), key);
        }
    }

    private class DebugLinkDataGetter
    implements DataGetter {
        private DebugLinkDataGetter() {
        }

        @Override
        public ByteIterable getUpToDateEntry(@NotNull PersistentStoreTransaction txn, int typeId, PropertyKey key) {
            ByteIterable valueEntry;
            ArrayByteIterable keyEntry = PropertyKey.propertyKeyToEntry(key);
            try (Cursor cursor = PersistentEntityStoreImpl.this.getLinksTable(txn, typeId).getFirstIndexCursor(txn.getEnvironmentTransaction());){
                valueEntry = cursor.getSearchKey((ByteIterable)keyEntry);
                if (valueEntry == null) {
                    ByteIterable byteIterable = null;
                    return byteIterable;
                }
                if (cursor.getNextDup()) {
                    throw new IllegalStateException("Only one link is allowed.");
                }
            }
            return valueEntry;
        }
    }

    private class LinkDataGetter
    implements DataGetter {
        private LinkDataGetter() {
        }

        @Override
        public ByteIterable getUpToDateEntry(@NotNull PersistentStoreTransaction txn, int typeId, PropertyKey key) {
            return PersistentEntityStoreImpl.this.getLinksTable(txn, typeId).get(txn.getEnvironmentTransaction(), (ByteIterable)PropertyKey.propertyKeyToEntry(key));
        }
    }

    private class PropertyDataGetter
    implements DataGetter {
        private PropertyDataGetter() {
        }

        @Override
        public ByteIterable getUpToDateEntry(@NotNull PersistentStoreTransaction txn, int typeId, PropertyKey key) {
            return PersistentEntityStoreImpl.this.getPropertiesTable(txn, typeId).get(txn, (ByteIterable)PropertyKey.propertyKeyToEntry(key));
        }
    }

    private static interface DataGetter {
        public ByteIterable getUpToDateEntry(@NotNull PersistentStoreTransaction var1, int var2, PropertyKey var3);
    }
}

