/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.bindings.ComparableBinding;
import jetbrains.exodus.bindings.ComparableSet;
import jetbrains.exodus.bindings.IntegerBinding;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.core.dataStructures.Pair;
import jetbrains.exodus.core.dataStructures.hash.IntHashMap;
import jetbrains.exodus.core.dataStructures.hash.LongHashMap;
import jetbrains.exodus.entitystore.BlobVault;
import jetbrains.exodus.entitystore.EntityStoreException;
import jetbrains.exodus.entitystore.FileSystemBlobVault;
import jetbrains.exodus.entitystore.FileSystemBlobVaultOld;
import jetbrains.exodus.entitystore.PersistentEntity;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentSequence;
import jetbrains.exodus.entitystore.PersistentSequenceBlobHandleGenerator;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.StoreTransaction;
import jetbrains.exodus.entitystore.StoreTransactionalComputable;
import jetbrains.exodus.entitystore.StoreTransactionalExecutable;
import jetbrains.exodus.entitystore.tables.BlobsTable;
import jetbrains.exodus.entitystore.tables.LinkValue;
import jetbrains.exodus.entitystore.tables.PropertiesTable;
import jetbrains.exodus.entitystore.tables.PropertyKey;
import jetbrains.exodus.entitystore.tables.PropertyTypes;
import jetbrains.exodus.entitystore.tables.PropertyValue;
import jetbrains.exodus.entitystore.tables.TwoColumnTable;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.ReadonlyTransactionException;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.env.TransactionalExecutable;
import jetbrains.exodus.util.IOUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PersistentEntityStoreRefactorings {
    private static final Logger logger = LoggerFactory.getLogger(PersistentEntityStoreRefactorings.class);
    @NonNls
    private static final String TEMP_BLOBS_DIR = "blobs-refactoring";
    @NotNull
    private final PersistentEntityStoreImpl store;

    PersistentEntityStoreRefactorings(@NotNull PersistentEntityStoreImpl store) {
        this.store = store;
    }

    void refactorDeleteRedundantBlobs() {
        BlobVault blobVault = this.store.getBlobVault();
        if (blobVault instanceof FileSystemBlobVaultOld) {
            PersistentEntityStoreRefactorings.logInfo("Deleting redundant blobs...");
            final FileSystemBlobVaultOld fsBlobVault = (FileSystemBlobVaultOld)blobVault;
            Long nextBlobHandle = this.store.computeInReadonlyTransaction(new StoreTransactionalComputable<Long>(){

                public Long compute(@NotNull StoreTransaction tx) {
                    PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                    return fsBlobVault.nextHandle(txn.getEnvironmentTransaction());
                }
            });
            for (int i = 0; i < 10000; ++i) {
                File blob = fsBlobVault.getBlobLocation(nextBlobHandle + (long)i);
                if (!blob.exists()) continue;
                if (blob.delete()) {
                    PersistentEntityStoreRefactorings.logInfo("Deleted " + blob);
                    continue;
                }
                logger.error("Failed to delete " + blob);
            }
        }
    }

    void refactorEntitiesTables() {
        this.store.executeInReadonlyTransaction(new StoreTransactionalExecutable(){

            public void execute(@NotNull StoreTransaction tx) {
                PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                for (String entityType : PersistentEntityStoreRefactorings.this.store.getEntityTypes(txn)) {
                    int entityTypeId = PersistentEntityStoreRefactorings.this.store.getEntityTypeId(txn, entityType, false);
                    String sourceName = PersistentEntityStoreRefactorings.this.store.getNamingRules().getEntitiesTableName(entityTypeId);
                    String targetName = sourceName + "_temp";
                    if (logger.isInfoEnabled()) {
                        logger.info("Refactoring " + sourceName + " to key-prefixed store.");
                    }
                    PersistentEntityStoreRefactorings.this.transactionalCopyAndRemoveEntitiesStore(sourceName, targetName);
                    PersistentEntityStoreRefactorings.this.transactionalCopyAndRemoveEntitiesStore(targetName, sourceName);
                }
            }
        });
    }

    void refactorCreateNullPropertyIndices() {
        this.store.executeInReadonlyTransaction(new StoreTransactionalExecutable(){

            public void execute(@NotNull StoreTransaction tx) {
                PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                for (final String entityType : PersistentEntityStoreRefactorings.this.store.getEntityTypes(txn)) {
                    if (logger.isInfoEnabled()) {
                        logger.info("Refactoring creating null-value property indices for [" + entityType + ']');
                    }
                    PersistentEntityStoreRefactorings.this.safeExecuteRefactoringForEntityType(entityType, new StoreTransactionalExecutable(){

                        public void execute(@NotNull StoreTransaction tx) {
                            PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                            int entityTypeId = PersistentEntityStoreRefactorings.this.store.getEntityTypeId(txn, entityType, false);
                            PropertiesTable props = PersistentEntityStoreRefactorings.this.store.getPropertiesTable(txn, entityTypeId);
                            Store allPropsIndex = props.getAllPropsIndex();
                            Cursor cursor = PersistentEntityStoreRefactorings.this.store.getPrimaryPropertyIndexCursor(txn, entityTypeId);
                            Transaction envTxn = txn.getEnvironmentTransaction();
                            while (cursor.getNext()) {
                                PropertyKey propertyKey = PropertyKey.entryToPropertyKey(cursor.getKey());
                                allPropsIndex.put(envTxn, (ByteIterable)IntegerBinding.intToCompressedEntry((int)propertyKey.getPropertyId()), (ByteIterable)LongBinding.longToCompressedEntry((long)propertyKey.getEntityLocalId()));
                            }
                            cursor.close();
                        }
                    });
                }
            }
        });
    }

    void refactorCreateNullBlobIndices() {
        this.store.executeInReadonlyTransaction(new StoreTransactionalExecutable(){

            public void execute(@NotNull StoreTransaction tx) {
                PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                for (final String entityType : PersistentEntityStoreRefactorings.this.store.getEntityTypes(txn)) {
                    if (logger.isInfoEnabled()) {
                        logger.info("Refactoring creating null-value blob indices for [" + entityType + ']');
                    }
                    PersistentEntityStoreRefactorings.this.safeExecuteRefactoringForEntityType(entityType, new StoreTransactionalExecutable(){

                        public void execute(@NotNull StoreTransaction tx) {
                            PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                            int entityTypeId = PersistentEntityStoreRefactorings.this.store.getEntityTypeId(txn, entityType, false);
                            BlobsTable blobs = PersistentEntityStoreRefactorings.this.store.getBlobsTable(txn, entityTypeId);
                            Store allBlobsIndex = blobs.getAllBlobsIndex();
                            Transaction envTxn = txn.getEnvironmentTransaction();
                            Cursor cursor = blobs.getPrimaryIndex().openCursor(envTxn);
                            while (cursor.getNext()) {
                                PropertyKey propertyKey = PropertyKey.entryToPropertyKey(cursor.getKey());
                                allBlobsIndex.put(envTxn, (ByteIterable)IntegerBinding.intToCompressedEntry((int)propertyKey.getPropertyId()), (ByteIterable)LongBinding.longToCompressedEntry((long)propertyKey.getEntityLocalId()));
                            }
                            cursor.close();
                        }
                    });
                }
            }
        });
    }

    void refactorMakeLinkTablesConsistent() {
        this.store.executeInReadonlyTransaction(new StoreTransactionalExecutable(){

            public void execute(@NotNull StoreTransaction tx) {
                final PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                for (final String entityType : PersistentEntityStoreRefactorings.this.store.getEntityTypes(txn)) {
                    if (logger.isInfoEnabled()) {
                        logger.info("Refactoring making links' tables consistent for [" + entityType + ']');
                    }
                    PersistentEntityStoreRefactorings.runReadonlyTransactionSafeForEntityType(entityType, new Runnable(){

                        @Override
                        public void run() {
                            final ArrayList<Pair> badLinks = new ArrayList<Pair>();
                            final ArrayList<Pair> deleteLinks = new ArrayList<Pair>();
                            int entityTypeId = PersistentEntityStoreRefactorings.this.store.getEntityTypeId(txn, entityType, false);
                            final TwoColumnTable linksTable = PersistentEntityStoreRefactorings.this.store.getLinksTable(txn, entityTypeId);
                            Transaction envTxn = txn.getEnvironmentTransaction();
                            Store entitiesTable = PersistentEntityStoreRefactorings.this.store.getEntitiesTable(txn, entityTypeId);
                            try (Cursor cursor = linksTable.getFirstIndexCursor(envTxn);){
                                while (cursor.getNext()) {
                                    ByteIterable first = cursor.getKey();
                                    ByteIterable second = cursor.getValue();
                                    long localId = LongBinding.compressedEntryToLong((ByteIterable)first);
                                    if (entitiesTable.get(envTxn, (ByteIterable)LongBinding.longToCompressedEntry((long)localId)) == null) {
                                        do {
                                            deleteLinks.add(new Pair((Object)first, (Object)second));
                                        } while (cursor.getNextDup());
                                        continue;
                                    }
                                    LinkValue linkValue = LinkValue.entryToLinkValue(second);
                                    if (PersistentEntityStoreRefactorings.this.store.getLastVersion(txn, linkValue.getEntityId()) < 0) {
                                        deleteLinks.add(new Pair((Object)first, (Object)second));
                                        continue;
                                    }
                                    if (linksTable.contains2(envTxn, first, second)) continue;
                                    badLinks.add(new Pair((Object)first, (Object)second));
                                }
                            }
                            if (!badLinks.isEmpty()) {
                                PersistentEntityStoreRefactorings.this.store.getEnvironment().executeInTransaction(new TransactionalExecutable(){

                                    public void execute(@NotNull Transaction txn) {
                                        for (Pair badLink : badLinks) {
                                            linksTable.put(txn, (ByteIterable)badLink.getFirst(), (ByteIterable)badLink.getSecond());
                                        }
                                    }
                                });
                                if (logger.isInfoEnabled()) {
                                    logger.info(badLinks.size() + " missing links found and fixed for [" + entityType + ']');
                                }
                                badLinks.clear();
                            }
                            cursor = linksTable.getSecondIndexCursor(envTxn);
                            var8_9 = null;
                            try {
                                while (cursor.getNext()) {
                                    ByteIterable second = cursor.getKey();
                                    ByteIterable first = cursor.getValue();
                                    if (linksTable.contains(envTxn, first, second)) continue;
                                    badLinks.add(new Pair((Object)first, (Object)second));
                                }
                            }
                            catch (Throwable throwable) {
                                var8_9 = throwable;
                                throw throwable;
                            }
                            finally {
                                if (cursor != null) {
                                    if (var8_9 != null) {
                                        try {
                                            cursor.close();
                                        }
                                        catch (Throwable throwable) {
                                            var8_9.addSuppressed(throwable);
                                        }
                                    } else {
                                        cursor.close();
                                    }
                                }
                            }
                            int badLinksSize = badLinks.size();
                            int deleteLinksSize = deleteLinks.size();
                            if (badLinksSize > 0 || deleteLinksSize > 0) {
                                PersistentEntityStoreRefactorings.this.store.getEnvironment().executeInTransaction(new TransactionalExecutable(){

                                    public void execute(@NotNull Transaction txn) {
                                        for (Pair badLink : badLinks) {
                                            PersistentEntityStoreRefactorings.deletePair(linksTable.getSecondIndexCursor(txn), (ByteIterable)badLink.getFirst(), (ByteIterable)badLink.getSecond());
                                        }
                                        for (Pair deleteLink : deleteLinks) {
                                            PersistentEntityStoreRefactorings.deletePair(linksTable.getFirstIndexCursor(txn), (ByteIterable)deleteLink.getFirst(), (ByteIterable)deleteLink.getSecond());
                                            PersistentEntityStoreRefactorings.deletePair(linksTable.getSecondIndexCursor(txn), (ByteIterable)deleteLink.getSecond(), (ByteIterable)deleteLink.getFirst());
                                        }
                                    }
                                });
                                if (logger.isInfoEnabled()) {
                                    if (badLinksSize > 0) {
                                        logger.info(badLinksSize + " redundant links found and fixed for [" + entityType + ']');
                                    }
                                    if (deleteLinksSize > 0) {
                                        logger.info(deleteLinksSize + " phantom links found and fixed for [" + entityType + ']');
                                    }
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    void refactorMakePropTablesConsistent() {
        this.store.executeInReadonlyTransaction(new StoreTransactionalExecutable(){

            public void execute(@NotNull StoreTransaction tx) {
                final PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                for (final String entityType : PersistentEntityStoreRefactorings.this.store.getEntityTypes(txn)) {
                    if (logger.isInfoEnabled()) {
                        logger.info("Refactoring making props' tables consistent for [" + entityType + ']');
                    }
                    PersistentEntityStoreRefactorings.runReadonlyTransactionSafeForEntityType(entityType, new Runnable(){

                        @Override
                        public void run() {
                            LongHashMap entitiesToValues;
                            int entityTypeId = PersistentEntityStoreRefactorings.this.store.getEntityTypeId(txn, entityType, false);
                            final PropertiesTable propTable = PersistentEntityStoreRefactorings.this.store.getPropertiesTable(txn, entityTypeId);
                            Transaction envTxn = txn.getEnvironmentTransaction();
                            IntHashMap props = new IntHashMap();
                            Cursor cursor = PersistentEntityStoreRefactorings.this.store.getPrimaryPropertyIndexCursor(txn, propTable);
                            PropertyTypes propertyTypes = PersistentEntityStoreRefactorings.this.store.getPropertyTypes();
                            while (cursor.getNext()) {
                                PropertyKey propKey = PropertyKey.entryToPropertyKey(cursor.getKey());
                                PropertyValue propValue = propertyTypes.entryToPropertyValue(cursor.getValue());
                                int propId = propKey.getPropertyId();
                                LongHashMap entitiesToValues2 = (LongHashMap)props.get(propId);
                                if (entitiesToValues2 == null) {
                                    entitiesToValues2 = new LongHashMap();
                                    props.put(propId, (Object)entitiesToValues2);
                                }
                                entitiesToValues2.put(propKey.getEntityLocalId(), (Object)propValue);
                            }
                            cursor.close();
                            final ArrayList<Pair> missingPairs = new ArrayList<Pair>();
                            final IntHashMap allPropsMap = new IntHashMap();
                            Iterator propId = props.keySet().iterator();
                            while (propId.hasNext()) {
                                Long[] localIds;
                                int propId2 = (Integer)propId.next();
                                Store valueIndex = propTable.getValueIndex(txn, propId2, false);
                                Cursor valueCursor = valueIndex == null ? null : valueIndex.openCursor(envTxn);
                                entitiesToValues = (LongHashMap)props.get(propId2);
                                Set localIdSet = entitiesToValues.keySet();
                                TreeSet sortedLocalIdSet = new TreeSet(localIdSet);
                                allPropsMap.put(propId2, sortedLocalIdSet);
                                Long[] longArray = localIds = sortedLocalIdSet.toArray(new Long[entitiesToValues.size()]);
                                int n = longArray.length;
                                for (int i = 0; i < n; ++i) {
                                    long localId = longArray[i];
                                    PropertyValue propValue = (PropertyValue)entitiesToValues.get(localId);
                                    for (ByteIterable secondaryKey : PropertiesTable.createSecondaryKeys(propertyTypes, (ByteIterable)PropertyTypes.propertyValueToEntry(propValue), propValue.getType())) {
                                        ArrayByteIterable secondaryValue = LongBinding.longToCompressedEntry((long)localId);
                                        if (valueCursor != null && valueCursor.getSearchBoth(secondaryKey, (ByteIterable)secondaryValue)) continue;
                                        missingPairs.add(new Pair((Object)propId2, (Object)new Pair((Object)secondaryKey, (Object)secondaryValue)));
                                    }
                                }
                                if (valueCursor == null) continue;
                                valueCursor.close();
                            }
                            if (!missingPairs.isEmpty()) {
                                PersistentEntityStoreRefactorings.this.store.executeInTransaction(new StoreTransactionalExecutable(){

                                    public void execute(@NotNull StoreTransaction tx) {
                                        PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                                        for (Pair pair : missingPairs) {
                                            Store valueIndex = propTable.getValueIndex(txn, (Integer)pair.getFirst(), true);
                                            Pair missing = (Pair)pair.getSecond();
                                            if (valueIndex == null) {
                                                throw new NullPointerException("Can't be");
                                            }
                                            valueIndex.put(txn.getEnvironmentTransaction(), (ByteIterable)missing.getFirst(), (ByteIterable)missing.getSecond());
                                        }
                                    }
                                });
                                if (logger.isInfoEnabled()) {
                                    logger.info(missingPairs.size() + " missing secondary keys found and fixed for [" + entityType + ']');
                                }
                            }
                            final ArrayList<Pair> phantomPairs = new ArrayList<Pair>();
                            for (Map.Entry<Integer, Store> entry : propTable.getValueIndices()) {
                                int propId3 = entry.getKey();
                                entitiesToValues = (LongHashMap)props.get(propId3);
                                Cursor c = entry.getValue().openCursor(envTxn);
                                while (c.getNext()) {
                                    ByteIterable keyEntry = c.getKey();
                                    ByteIterable valueEntry = c.getValue();
                                    PropertyValue propValue = (PropertyValue)entitiesToValues.get(LongBinding.compressedEntryToLong((ByteIterable)valueEntry));
                                    if (propValue != null) {
                                        ComparableBinding objectBinding;
                                        Class dataClass;
                                        Comparable data = propValue.getData();
                                        int typeId = propValue.getType().getTypeId();
                                        if (typeId == 8) {
                                            dataClass = ((ComparableSet)data).getItemClass();
                                            objectBinding = propertyTypes.getPropertyType(dataClass).getBinding();
                                        } else {
                                            dataClass = data.getClass();
                                            objectBinding = propValue.getBinding();
                                        }
                                        try {
                                            Comparable value = objectBinding.entryToObject(keyEntry);
                                            if (dataClass.equals(value.getClass()) && (typeId == 8 ? ((ComparableSet)data).containsItem(value) : PropertyTypes.toLowerCase(data).compareTo(value) == 0)) {
                                                continue;
                                            }
                                        }
                                        catch (Throwable t) {
                                            logger.error("Error reading property value index ", t);
                                            PersistentEntityStoreRefactorings.throwJVMError(t);
                                        }
                                    }
                                    phantomPairs.add(new Pair((Object)propId3, (Object)new Pair((Object)keyEntry, (Object)valueEntry)));
                                }
                                c.close();
                            }
                            if (!phantomPairs.isEmpty()) {
                                PersistentEntityStoreRefactorings.this.store.executeInTransaction(new StoreTransactionalExecutable(){

                                    public void execute(@NotNull StoreTransaction tx) {
                                        PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                                        Transaction envTxn = txn.getEnvironmentTransaction();
                                        for (Pair pair : phantomPairs) {
                                            Store valueIndex = propTable.getValueIndex(txn, (Integer)pair.getFirst(), true);
                                            Pair phantom = (Pair)pair.getSecond();
                                            if (valueIndex == null) {
                                                throw new NullPointerException("Can't be");
                                            }
                                            PersistentEntityStoreRefactorings.deletePair(valueIndex.openCursor(envTxn), (ByteIterable)phantom.getFirst(), (ByteIterable)phantom.getSecond());
                                        }
                                    }
                                });
                                if (logger.isInfoEnabled()) {
                                    logger.info(phantomPairs.size() + " phantom secondary keys found and fixed for [" + entityType + ']');
                                }
                            }
                            final ArrayList<Pair> phantomIds = new ArrayList<Pair>();
                            Cursor c = propTable.getAllPropsIndex().openCursor(envTxn);
                            while (c.getNext()) {
                                int propId4 = IntegerBinding.compressedEntryToInt((ByteIterable)c.getKey());
                                long localId = LongBinding.compressedEntryToLong((ByteIterable)c.getValue());
                                Set localIds = (Set)allPropsMap.get(propId4);
                                if (localIds == null || !localIds.remove(localId)) {
                                    phantomIds.add(new Pair((Object)propId4, (Object)localId));
                                    continue;
                                }
                                if (!localIds.isEmpty()) continue;
                                allPropsMap.remove(propId4);
                            }
                            c.close();
                            if (!allPropsMap.isEmpty()) {
                                final int[] added = new int[]{0};
                                PersistentEntityStoreRefactorings.this.store.executeInTransaction(new StoreTransactionalExecutable(){

                                    public void execute(@NotNull StoreTransaction txn) {
                                        int count = 0;
                                        Store allPropsIndex = propTable.getAllPropsIndex();
                                        Transaction envTxn = ((PersistentStoreTransaction)txn).getEnvironmentTransaction();
                                        for (Map.Entry entry : allPropsMap.entrySet()) {
                                            ArrayByteIterable keyEntry = IntegerBinding.intToCompressedEntry((int)((Integer)entry.getKey()));
                                            Iterator iterator = ((Set)entry.getValue()).iterator();
                                            while (iterator.hasNext()) {
                                                long localId = (Long)iterator.next();
                                                allPropsIndex.put(envTxn, (ByteIterable)keyEntry, (ByteIterable)LongBinding.longToCompressedEntry((long)localId));
                                                ++count;
                                            }
                                        }
                                        added[0] = count;
                                    }
                                });
                                if (logger.isInfoEnabled()) {
                                    logger.info(added[0] + " missing id pairs found and fixed for [" + entityType + ']');
                                }
                            }
                            if (!phantomIds.isEmpty()) {
                                PersistentEntityStoreRefactorings.this.store.executeInTransaction(new StoreTransactionalExecutable(){

                                    public void execute(@NotNull StoreTransaction txn) {
                                        Store allPropsIndex = propTable.getAllPropsIndex();
                                        Transaction envTxn = ((PersistentStoreTransaction)txn).getEnvironmentTransaction();
                                        Cursor c = allPropsIndex.openCursor(envTxn);
                                        for (Pair phantom : phantomIds) {
                                            if (!c.getSearchBoth((ByteIterable)IntegerBinding.intToCompressedEntry((int)((Integer)phantom.getFirst())), (ByteIterable)LongBinding.longToCompressedEntry((long)((Long)phantom.getSecond())))) {
                                                throw new EntityStoreException("Can't be");
                                            }
                                            c.deleteCurrent();
                                        }
                                        c.close();
                                    }
                                });
                                if (logger.isInfoEnabled()) {
                                    logger.info(phantomIds.size() + " phantom id pairs found and fixed for [" + entityType + ']');
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    void refactorInPlaceBlobs(final @NotNull FileSystemBlobVaultOld oldVault, final @NotNull String blobHandlesSequenceName) {
        this.store.executeInReadonlyTransaction(new StoreTransactionalExecutable(){

            public void execute(@NotNull StoreTransaction tx) {
                FileSystemBlobVault newVault;
                final PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                PersistentSequenceBlobHandleGenerator.PersistentSequenceGetter persistentSequenceGetter = new PersistentSequenceBlobHandleGenerator.PersistentSequenceGetter(){

                    @Override
                    public PersistentSequence get() {
                        return PersistentEntityStoreRefactorings.this.store.getSequence(txn, blobHandlesSequenceName);
                    }
                };
                final PersistentSequence sequence = persistentSequenceGetter.get();
                PersistentEntityStoreRefactorings.this.store.executeInTransaction(new StoreTransactionalExecutable(){

                    public void execute(@NotNull StoreTransaction txn) {
                        sequence.set(-1L);
                    }
                });
                try {
                    newVault = new FileSystemBlobVault(PersistentEntityStoreRefactorings.this.store.getLocation(), PersistentEntityStoreRefactorings.TEMP_BLOBS_DIR, ".blob", new PersistentSequenceBlobHandleGenerator(persistentSequenceGetter));
                    PersistentEntityStoreRefactorings.this.store.setBlobVault(newVault);
                }
                catch (IOException e) {
                    throw ExodusException.toEntityStoreException((Throwable)e);
                }
                for (final String entityType : PersistentEntityStoreRefactorings.this.store.getEntityTypes(txn)) {
                    PersistentEntityStoreRefactorings.runReadonlyTransactionSafeForEntityType(entityType, new Runnable(){

                        @Override
                        public void run() {
                            final ArrayList<Pair> blobHandles = new ArrayList<Pair>();
                            final int entityTypeId = PersistentEntityStoreRefactorings.this.store.getEntityTypeId(txn, entityType, false);
                            BlobsTable blobs = PersistentEntityStoreRefactorings.this.store.getBlobsTable(txn, entityTypeId);
                            Transaction envTxn = txn.getEnvironmentTransaction();
                            try (Cursor cursor = blobs.getPrimaryIndex().openCursor(envTxn);){
                                while (cursor.getNext()) {
                                    long blobHandle = LongBinding.compressedEntryToLong((ByteIterable)cursor.getValue());
                                    if (PersistentEntityStoreImpl.isEmptyOrInPlaceBlobHandle(blobHandle)) continue;
                                    PropertyKey key = PropertyKey.entryToPropertyKey(cursor.getKey());
                                    blobHandles.add(new Pair((Object)key, (Object)blobHandle));
                                }
                            }
                            if (!blobHandles.isEmpty()) {
                                PersistentEntityStoreRefactorings.this.safeExecuteRefactoringForEntityType(entityType, new StoreTransactionalExecutable(){

                                    public void execute(@NotNull StoreTransaction tx) {
                                        PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                                        int blobsCount = blobHandles.size();
                                        int i = 0;
                                        for (Pair entry : blobHandles) {
                                            if (i++ % 1000 == 0 && logger.isInfoEnabled()) {
                                                logger.info("Refactoring moving tiny blobs into database for [" + entityType + "]. Blobs processed: " + i + " of " + blobsCount);
                                            }
                                            PropertyKey key = (PropertyKey)entry.getFirst();
                                            PersistentEntity entity = new PersistentEntity(PersistentEntityStoreRefactorings.this.store, new PersistentEntityId(entityTypeId, key.getEntityLocalId()));
                                            String blobName = PersistentEntityStoreRefactorings.this.store.getPropertyName(txn, key.getPropertyId());
                                            if (blobName == null) {
                                                throw new NullPointerException("Blob name is expected");
                                            }
                                            try {
                                                long blobHandle = (Long)entry.getSecond();
                                                txn.preserveBlob(blobHandle);
                                                PersistentEntityStoreRefactorings.this.store.setBlob(txn, entity, blobName, oldVault.getBlobLocation(blobHandle));
                                            }
                                            catch (IOException e) {
                                                logger.error("Failed to set blob", (Throwable)e);
                                            }
                                        }
                                    }
                                });
                                if (logger.isInfoEnabled()) {
                                    logger.info("Refactoring moving tiny blobs into database for [" + entityType + "] completed.");
                                }
                            }
                        }
                    });
                }
                oldVault.close();
                newVault.close();
                PersistentEntityStoreRefactorings.logInfo("Moving finished, deleting old vault...");
                File oldVaultLocation = oldVault.getVaultLocation();
                IOUtil.deleteRecursively((File)oldVaultLocation);
                if (!oldVaultLocation.delete()) {
                    throw new EntityStoreException("Failed to delete old blob vault");
                }
                if (!newVault.getVaultLocation().renameTo(oldVaultLocation)) {
                    throw new EntityStoreException("Failed to rename temporary blob vault");
                }
                try {
                    PersistentEntityStoreRefactorings.this.store.setBlobVault(new FileSystemBlobVault(PersistentEntityStoreRefactorings.this.store.getLocation(), "blobs", ".blob", new PersistentSequenceBlobHandleGenerator(persistentSequenceGetter)));
                }
                catch (IOException e) {
                    throw ExodusException.toEntityStoreException((Throwable)e);
                }
                PersistentEntityStoreRefactorings.logInfo("Refactoring moving tiny blobs into database finished successfully.");
            }
        });
    }

    void refactorRemoveHistoryStores() {
        final Environment environment = this.store.getEnvironment();
        environment.executeInReadonlyTransaction(new TransactionalExecutable(){

            public void execute(@NotNull Transaction txn) {
                String persistentStoreName = PersistentEntityStoreRefactorings.this.store.getName();
                for (final String storeName : environment.getAllStoreNames(txn)) {
                    if (!storeName.startsWith(persistentStoreName) || !storeName.endsWith("#history")) continue;
                    environment.executeInTransaction(new TransactionalExecutable(){

                        public void execute(@NotNull Transaction txn) {
                            environment.removeStore(storeName, txn);
                        }
                    });
                }
            }
        });
    }

    private void safeExecuteRefactoringForEntityType(@NotNull String entityType, @NotNull StoreTransactionalExecutable executable) {
        try {
            this.store.executeInTransaction(executable);
        }
        catch (Throwable t) {
            logger.error("Failed to execute refactoring for entity type: " + entityType, t);
            PersistentEntityStoreRefactorings.throwJVMError(t);
        }
    }

    private void transactionalCopyAndRemoveEntitiesStore(final @NotNull String sourceName, final @NotNull String targetName) {
        final Environment env = this.store.getEnvironment();
        env.executeInTransaction(new TransactionalExecutable(){

            public void execute(@NotNull Transaction txn) {
                Store store = env.openStore(sourceName, StoreConfig.USE_EXISTING, txn);
                Store storeCopy = env.openStore(targetName, StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING, txn);
                Cursor cursor = store.openCursor(txn);
                ArrayByteIterable lastKey = null;
                while (cursor.getNext()) {
                    ArrayByteIterable key = new ArrayByteIterable(cursor.getKey());
                    if (lastKey != null && lastKey.compareTo((ByteIterable)key) >= 0) {
                        throw new IllegalStateException("Invalid key order");
                    }
                    storeCopy.putRight(txn, (ByteIterable)key, (ByteIterable)new ArrayByteIterable(cursor.getValue()));
                    lastKey = key;
                }
                cursor.close();
                env.removeStore(sourceName, txn);
            }
        });
    }

    private static void runReadonlyTransactionSafeForEntityType(@NotNull String entityType, @NotNull Runnable runnable) {
        try {
            runnable.run();
        }
        catch (ReadonlyTransactionException ignore) {
        }
        catch (Throwable t) {
            logger.error("Failed to execute refactoring for entity type: " + entityType, t);
            PersistentEntityStoreRefactorings.throwJVMError(t);
        }
    }

    private static void deletePair(@NotNull Cursor c, @NotNull ByteIterable key, @NotNull ByteIterable value) {
        if (c.getSearchBoth(key, value)) {
            c.deleteCurrent();
        }
        c.close();
    }

    private static void throwJVMError(@NotNull Throwable t) {
        if (t instanceof VirtualMachineError) {
            throw new EntityStoreException(t);
        }
    }

    private static void logInfo(@NotNull String message) {
        if (logger.isInfoEnabled()) {
            logger.info(message);
        }
    }
}

