/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore;

import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.management.Statistics;
import jetbrains.exodus.management.StatisticsItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentEntityStoreStatistics
extends Statistics {
    public static final String BLOBS_DISK_USAGE = "Blobs disk usage";
    public static final String CACHING_JOBS = "Caching jobs";
    @NotNull
    private final PersistentEntityStoreImpl store;

    PersistentEntityStoreStatistics(@NotNull PersistentEntityStoreImpl store) {
        this.store = store;
        this.getStatisticsItem(BLOBS_DISK_USAGE);
        this.getStatisticsItem(CACHING_JOBS);
    }

    @NotNull
    public StatisticsItem getStatisticsItem(@NotNull String statisticsName) {
        if (!this.store.getConfig().getGatherStatistics()) {
            return new StatisticsItem((Statistics)this);
        }
        return super.getStatisticsItem(statisticsName);
    }

    @NotNull
    protected StatisticsItem createNewItem(@NotNull String statisticsName) {
        if (BLOBS_DISK_USAGE.equals(statisticsName)) {
            return new BlobsDiskUsageStatisticsItem(this);
        }
        if (CACHING_JOBS.equals(statisticsName)) {
            return new CachingJobsStatisticsItem(this);
        }
        return super.createNewItem(statisticsName);
    }

    private static class CachingJobsStatisticsItem
    extends StatisticsItem {
        public CachingJobsStatisticsItem(@NotNull PersistentEntityStoreStatistics statistics) {
            super((Statistics)statistics);
        }

        @Nullable
        protected Long getAutoUpdatedTotal() {
            PersistentEntityStoreStatistics statistics = (PersistentEntityStoreStatistics)this.getStatistics();
            return statistics == null ? null : Long.valueOf(statistics.store.getAsyncProcessor().pendingJobs());
        }
    }

    private static class BlobsDiskUsageStatisticsItem
    extends StatisticsItem {
        public BlobsDiskUsageStatisticsItem(@NotNull PersistentEntityStoreStatistics statistics) {
            super((Statistics)statistics);
        }

        @Nullable
        protected Long getAutoUpdatedTotal() {
            PersistentEntityStoreStatistics statistics = (PersistentEntityStoreStatistics)this.getStatistics();
            return statistics == null ? null : Long.valueOf(statistics.store.getBlobVault().size());
        }
    }
}

