/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore;

import java.io.File;
import jetbrains.exodus.entitystore.BlobVault;
import jetbrains.exodus.entitystore.PersistentEntityStoreConfig;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.EnvironmentConfig;
import jetbrains.exodus.env.Environments;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PersistentEntityStores {
    @NonNls
    private static final String DEFAULT_NAME = "persistentEntityStore";
    private static final int STORE_GET_CACHE_SIZE = 65536;
    private static final int TREE_NODES_CACHE_SIZE = 0;

    private PersistentEntityStores() {
    }

    public static PersistentEntityStoreImpl newInstance(@NotNull PersistentEntityStoreConfig config, @NotNull Environment environment, @Nullable BlobVault blobVault, @NotNull String name) {
        return new PersistentEntityStoreImpl(config, environment, blobVault, name);
    }

    public static PersistentEntityStoreImpl newInstance(@NotNull Environment environment, @Nullable BlobVault blobVault, @NotNull String name) {
        return PersistentEntityStores.newInstance(new PersistentEntityStoreConfig(), environment, blobVault, name);
    }

    public static PersistentEntityStoreImpl newInstance(@NotNull PersistentEntityStoreConfig config, @NotNull Environment environment, @NotNull String name) {
        return new PersistentEntityStoreImpl(config, environment, null, name);
    }

    public static PersistentEntityStoreImpl newInstance(@NotNull Environment environment, @NotNull String name) {
        return PersistentEntityStores.newInstance(environment, null, name);
    }

    public static PersistentEntityStoreImpl newInstance(@NotNull Environment environment) {
        return PersistentEntityStores.newInstance(environment, DEFAULT_NAME);
    }

    public static PersistentEntityStoreImpl newInstance(@NotNull File dir) {
        return PersistentEntityStores.newInstance(Environments.newInstance((File)dir, (EnvironmentConfig)new EnvironmentConfig()));
    }

    public static PersistentEntityStoreImpl newInstance(@NotNull String dir) {
        return PersistentEntityStores.newInstance(new File(dir));
    }

    public static EnvironmentConfig adjustEnvironmentConfigForEntityStore(@NotNull EnvironmentConfig ec) {
        if (ec.getEnvStoreGetCacheSize() == EnvironmentConfig.DEFAULT.getEnvStoreGetCacheSize()) {
            ec.setEnvStoreGetCacheSize(65536);
        }
        if (ec.getTreeNodesCacheSize() == EnvironmentConfig.DEFAULT.getTreeNodesCacheSize()) {
            ec.setTreeNodesCacheSize(0);
        }
        return ec.setEnvReadonlyEmptyStores(true);
    }
}

