/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore;

import java.io.UnsupportedEncodingException;
import java.util.concurrent.atomic.AtomicLong;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.entitystore.EntityStoreException;
import jetbrains.exodus.entitystore.FlushLog;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.Sequence;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.Transaction;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PersistentSequence
implements Sequence,
FlushLog.Member {
    @NonNls
    private static final String UTF8 = "UTF-8";
    @NotNull
    private final Store store;
    @NotNull
    private final ArrayByteIterable idKeyEntry;
    private final String name;
    private final AtomicLong val;
    private final AtomicLong lastSavedValue = new AtomicLong(-1L);

    public PersistentSequence(@NotNull PersistentStoreTransaction txn, @NotNull Store store, @NotNull String name) {
        this.store = store;
        this.name = name;
        this.idKeyEntry = PersistentSequence.sequenceNameToEntry(name);
        this.val = new AtomicLong(this.loadValue(txn));
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "PersistentSequence '" + this.name + '\'' + ", value =" + this.val + ", last saved = " + this.lastSavedValue;
    }

    public long get() {
        return this.val.get();
    }

    public void set(long l) {
        this.val.set(l);
    }

    public long increment() {
        return this.val.incrementAndGet();
    }

    @Override
    public void logOperations(Transaction txn, FlushLog flushLog) {
        final long value = this.val.get();
        if (value > this.lastSavedValue.get()) {
            this.store.put(txn, (ByteIterable)this.idKeyEntry, (ByteIterable)LongBinding.longToCompressedEntry((long)value));
            flushLog.add(new FlushLog.Operation(){

                @Override
                public void flushed() {
                    long current;
                    while ((current = PersistentSequence.this.lastSavedValue.get()) < value && !PersistentSequence.this.lastSavedValue.compareAndSet(current, value)) {
                    }
                }
            });
        }
    }

    long loadValue(@NotNull PersistentStoreTransaction txn) {
        ByteIterable value = this.store.get(txn.getEnvironmentTransaction(), (ByteIterable)this.idKeyEntry);
        return value == null ? -1L : LongBinding.compressedEntryToLong((ByteIterable)value);
    }

    private static ArrayByteIterable sequenceNameToEntry(@NotNull String sequenceName) {
        try {
            return new ArrayByteIterable(sequenceName.getBytes(UTF8));
        }
        catch (UnsupportedEncodingException e) {
            throw new EntityStoreException((Throwable)e);
        }
    }
}

