/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.IntegerBinding;
import jetbrains.exodus.bindings.StringBinding;
import jetbrains.exodus.core.dataStructures.hash.HashSet;
import jetbrains.exodus.entitystore.FlushLog;
import jetbrains.exodus.entitystore.PersistentSequence;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.TxnProvider;
import jetbrains.exodus.entitystore.tables.TwoColumnTable;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.util.StringInterner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PersistentSequentialDictionary
implements FlushLog.Member {
    @NotNull
    private final PersistentSequence sequence;
    @NotNull
    private final TwoColumnTable table;
    @NotNull
    private final Map<String, Integer> cache = new ConcurrentHashMap<String, Integer>();
    @NotNull
    private final Map<Integer, String> reverseCache = new ConcurrentHashMap<Integer, String>();
    @NotNull
    private final Collection<DictionaryOperation> operationsLog = new HashSet();
    private final Object lock = new Object();

    public PersistentSequentialDictionary(@NotNull PersistentSequence sequence, @NotNull TwoColumnTable table) {
        this.sequence = sequence;
        this.table = table;
    }

    @NotNull
    public TwoColumnTable getTable() {
        return this.table;
    }

    public int getLastAllocatedId() {
        return (int)this.sequence.get();
    }

    public int getId(final @NotNull PersistentStoreTransaction txn, @NotNull String name) {
        return this.getId(new TxnProvider(){

            @Override
            @NotNull
            public PersistentStoreTransaction getTransaction() {
                return txn;
            }
        }, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getId(@NotNull TxnProvider txnProvider, @NotNull String name) {
        Integer result = this.cache.get(name);
        if (result != null) {
            return result;
        }
        Object object = this.lock;
        synchronized (object) {
            result = this.cache.get(name);
            if (result != null) {
                return result;
            }
            ByteIterable idEntry = this.table.get(txnProvider.getTransaction().getEnvironmentTransaction(), (ByteIterable)StringBinding.stringToEntry((String)name));
            if (idEntry != null) {
                int id = IntegerBinding.compressedEntryToInt((ByteIterable)idEntry);
                this.putIdUnsafe(name, id);
                return id;
            }
            this.putNoIdUnsafe(name);
        }
        return -1;
    }

    public int getOrAllocateId(final @NotNull PersistentStoreTransaction txn, @NotNull String name) {
        return this.getOrAllocateId(new TxnProvider(){

            @Override
            @NotNull
            public PersistentStoreTransaction getTransaction() {
                return txn;
            }
        }, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOrAllocateId(@NotNull TxnProvider txnProvider, @NotNull String name) {
        Integer result = this.cache.get(name);
        if (result != null && result >= 0) {
            return result;
        }
        Object object = this.lock;
        synchronized (object) {
            result = this.cache.get(name);
            if (result != null && result >= 0) {
                return result;
            }
            ArrayByteIterable nameEntry = StringBinding.stringToEntry((String)name);
            PersistentStoreTransaction txn = txnProvider.getTransaction();
            ByteIterable idEntry = this.table.get(txn.getEnvironmentTransaction(), (ByteIterable)nameEntry);
            int id = idEntry == null ? (int)this.sequence.increment() : IntegerBinding.compressedEntryToInt((ByteIterable)idEntry);
            this.putIdUnsafe(name, id);
            if (idEntry == null) {
                this.operationsLog.add(new DictionaryOperation((ByteIterable)nameEntry, id){
                    final /* synthetic */ ByteIterable val$nameEntry;
                    final /* synthetic */ int val$id;
                    {
                        this.val$nameEntry = byteIterable;
                        this.val$id = n;
                    }

                    @Override
                    public void persist(Transaction txn) {
                        PersistentSequentialDictionary.this.table.put(txn, this.val$nameEntry, (ByteIterable)IntegerBinding.intToCompressedEntry((int)this.val$id));
                    }
                });
                this.created(txn, id);
            }
            return id;
        }
    }

    @Nullable
    public String getName(final @NotNull PersistentStoreTransaction txn, int id) {
        return this.getName(new TxnProvider(){

            @Override
            @NotNull
            public PersistentStoreTransaction getTransaction() {
                return txn;
            }
        }, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getName(@NotNull TxnProvider txnProvider, int id) {
        String result = this.reverseCache.get(id);
        if (result == null) {
            Object object = this.lock;
            synchronized (object) {
                ArrayByteIterable idEntry = IntegerBinding.intToCompressedEntry((int)id);
                ByteIterable typeEntry = this.table.get2(txnProvider.getTransaction().getEnvironmentTransaction(), (ByteIterable)idEntry);
                if (typeEntry != null && (result = StringBinding.entryToString((ByteIterable)typeEntry)) != null) {
                    this.reverseCache.put(id, result);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(@NotNull PersistentStoreTransaction txn, final @NotNull String name) {
        final int id = this.getId(txn, name);
        if (id < 0) {
            return -1;
        }
        Object object = this.lock;
        synchronized (object) {
            this.operationsLog.add(new DictionaryOperation(){

                @Override
                void persist(Transaction txn) {
                    PersistentSequentialDictionary.this.table.delete(txn, (ByteIterable)StringBinding.stringToEntry((String)name), (ByteIterable)IntegerBinding.intToCompressedEntry((int)id));
                }
            });
            this.cache.remove(name);
            this.reverseCache.remove(id);
            return id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(@NotNull PersistentStoreTransaction txn, final @NotNull String oldName, @NotNull String newName) {
        if (oldName.equals(newName)) {
            return;
        }
        int id = this.getId(txn, oldName);
        if (id < 0) {
            throw new IllegalArgumentException("Old entity type doesn't exist: " + oldName);
        }
        int newId = this.getId(txn, newName);
        ArrayByteIterable idEntry = IntegerBinding.intToCompressedEntry((int)id);
        Object object = this.lock;
        synchronized (object) {
            this.operationsLog.add(new DictionaryOperation((ByteIterable)idEntry, newName){
                final /* synthetic */ ByteIterable val$idEntry;
                final /* synthetic */ String val$newName;
                {
                    this.val$idEntry = byteIterable;
                    this.val$newName = string2;
                }

                @Override
                void persist(Transaction txn) {
                    PersistentSequentialDictionary.this.table.delete(txn, (ByteIterable)StringBinding.stringToEntry((String)oldName), this.val$idEntry);
                    PersistentSequentialDictionary.this.table.put(txn, (ByteIterable)StringBinding.stringToEntry((String)this.val$newName), this.val$idEntry);
                }
            });
            this.cache.remove(oldName);
            this.cache.put(newName, id);
            this.reverseCache.remove(id);
            if (newId >= 0) {
                this.reverseCache.remove(newId);
            }
        }
    }

    protected void created(PersistentStoreTransaction txn, int id) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logOperations(Transaction txn, FlushLog flushLog) {
        Object object = this.lock;
        synchronized (object) {
            for (DictionaryOperation op : this.operationsLog) {
                op.persist(txn);
                flushLog.add(op);
            }
        }
    }

    private void putIdUnsafe(@NotNull String name, int id) {
        String nameInterned = StringInterner.intern((String)name);
        this.cache.put(nameInterned, id);
        this.reverseCache.put(id, nameInterned);
    }

    private void putNoIdUnsafe(@NotNull String name) {
        this.cache.put(StringInterner.intern((String)name), -1);
    }

    private abstract class DictionaryOperation
    implements FlushLog.Operation {
        private DictionaryOperation() {
        }

        abstract void persist(Transaction var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flushed() {
            Object object = PersistentSequentialDictionary.this.lock;
            synchronized (object) {
                PersistentSequentialDictionary.this.operationsLog.remove(this);
            }
        }
    }
}

