/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.OutOfDiskSpaceException;
import jetbrains.exodus.bindings.ComparableSet;
import jetbrains.exodus.bindings.IntegerBinding;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.core.dataStructures.ConcurrentObjectCache;
import jetbrains.exodus.core.dataStructures.FakeObjectCache;
import jetbrains.exodus.core.dataStructures.ObjectCacheBase;
import jetbrains.exodus.core.dataStructures.ObjectCacheDecorator;
import jetbrains.exodus.core.dataStructures.decorators.HashSetDecorator;
import jetbrains.exodus.core.dataStructures.hash.LongHashMap;
import jetbrains.exodus.core.dataStructures.hash.LongHashSet;
import jetbrains.exodus.core.dataStructures.hash.LongSet;
import jetbrains.exodus.core.execution.SharedTimer;
import jetbrains.exodus.entitystore.BlobVault;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.exodus.entitystore.EntityIterableCache;
import jetbrains.exodus.entitystore.EntityIterableCacheAdapter;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.entitystore.EntityRemovedInDatabaseException;
import jetbrains.exodus.entitystore.EntityStoreException;
import jetbrains.exodus.entitystore.FlushLog;
import jetbrains.exodus.entitystore.PersistentEntity;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentEntityStoreConfig;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransactionSnapshot;
import jetbrains.exodus.entitystore.QueryCancellingPolicy;
import jetbrains.exodus.entitystore.ReplayData;
import jetbrains.exodus.entitystore.Sequence;
import jetbrains.exodus.entitystore.StoreTransaction;
import jetbrains.exodus.entitystore.iterate.CachedInstanceIterable;
import jetbrains.exodus.entitystore.iterate.EntitiesOfTypeIterable;
import jetbrains.exodus.entitystore.iterate.EntitiesOfTypeRangeIterable;
import jetbrains.exodus.entitystore.iterate.EntitiesWithBlobIterable;
import jetbrains.exodus.entitystore.iterate.EntitiesWithLinkIterable;
import jetbrains.exodus.entitystore.iterate.EntitiesWithLinkSortedIterable;
import jetbrains.exodus.entitystore.iterate.EntitiesWithPropertyIterable;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityToLinksIterable;
import jetbrains.exodus.entitystore.iterate.MergeSortedIterable;
import jetbrains.exodus.entitystore.iterate.PropertiesIterable;
import jetbrains.exodus.entitystore.iterate.PropertyRangeIterable;
import jetbrains.exodus.entitystore.iterate.PropertyValueIterable;
import jetbrains.exodus.entitystore.iterate.SingleEntityIterable;
import jetbrains.exodus.entitystore.iterate.SortIndirectIterable;
import jetbrains.exodus.entitystore.iterate.SortIterable;
import jetbrains.exodus.entitystore.iterate.TxnGetterStategy;
import jetbrains.exodus.entitystore.iterate.UpdatableCachedInstanceIterable;
import jetbrains.exodus.entitystore.iterate.UpdatableEntityIdSortedSetCachedInstanceIterable;
import jetbrains.exodus.entitystore.iterate.UpdatablePropertiesCachedInstanceIterable;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.util.StringBuilderSpinAllocator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentStoreTransaction
implements StoreTransaction,
TxnGetterStategy {
    @NotNull
    private static final ByteIterable ZERO_VERSION_ENTRY = IntegerBinding.intToCompressedEntry((int)0);
    @NotNull
    protected final PersistentEntityStoreImpl store;
    @NotNull
    protected final Transaction txn;
    @NotNull
    private final Set<EntityIterator> createdIterators;
    private final ObjectCacheBase<PropertyId, Comparable> propsCache;
    @NotNull
    private final ObjectCacheBase<PropertyId, PersistentEntityId> linksCache;
    @NotNull
    private final ObjectCacheBase<PropertyId, String> blobStringsCache;
    private EntityIterableCacheAdapter localCache;
    private int localCacheAttempts;
    private int localCacheHits;
    @Nullable
    private EntityIterableCacheAdapter mutableCache;
    private List<UpdatableCachedInstanceIterable> mutatedInTxn;
    @Nullable
    private ReplayData replayData;
    @Nullable
    private LongHashMap<InputStream> blobStreams;
    @Nullable
    private LongHashMap<File> blobFiles;
    @Nullable
    private LongSet preservedBlobs;
    private LongSet deferredBlobsToDelete;
    private QueryCancellingPolicy queryCancellingPolicy;

    PersistentStoreTransaction(@NotNull PersistentEntityStoreImpl store) {
        this(store, TransactionType.Regular);
    }

    PersistentStoreTransaction(@NotNull PersistentStoreTransaction source, @NotNull TransactionType txnType) {
        this.store = source.store;
        this.createdIterators = new HashSetDecorator();
        PersistentEntityStoreConfig config = this.store.getConfig();
        this.propsCache = PersistentStoreTransaction.createObjectCache(config.getTransactionPropsCacheSize());
        this.linksCache = PersistentStoreTransaction.createObjectCache(config.getTransactionLinksCacheSize());
        this.blobStringsCache = PersistentStoreTransaction.createObjectCache(config.getTransactionBlobStringsCacheSize());
        this.localCache = source.localCache;
        this.localCacheHits = 0;
        this.localCacheAttempts = 0;
        switch (txnType) {
            case Regular: {
                this.txn = source.txn.getSnapshot(this.getRevertCachesBeginHook());
                break;
            }
            case Readonly: {
                this.txn = source.txn.getReadonlySnapshot();
                break;
            }
            default: {
                throw new EntityStoreException("Can't create exclusive snapshot transaction");
            }
        }
    }

    protected PersistentStoreTransaction(@NotNull PersistentEntityStoreImpl store, @NotNull TransactionType txnType) {
        this.store = store;
        this.createdIterators = new HashSetDecorator();
        PersistentEntityStoreConfig config = store.getConfig();
        this.propsCache = PersistentStoreTransaction.createObjectCache(config.getTransactionPropsCacheSize());
        this.linksCache = PersistentStoreTransaction.createObjectCache(config.getTransactionLinksCacheSize());
        this.blobStringsCache = PersistentStoreTransaction.createObjectCache(config.getTransactionBlobStringsCacheSize());
        this.localCacheHits = 0;
        this.localCacheAttempts = 0;
        Runnable beginHook = this.getRevertCachesBeginHook();
        Environment env = store.getEnvironment();
        switch (txnType) {
            case Regular: {
                this.txn = env.beginTransaction(beginHook);
                break;
            }
            case Exclusive: {
                this.txn = env.beginExclusiveTransaction(beginHook);
                break;
            }
            case Readonly: {
                this.txn = env.beginReadonlyTransaction(beginHook);
                break;
            }
            default: {
                throw new EntityStoreException("Can't create " + (Object)((Object)txnType) + " transaction");
            }
        }
    }

    @NotNull
    public PersistentEntityStoreImpl getStore() {
        return this.store;
    }

    public boolean isIdempotent() {
        return !(!this.getEnvironmentTransaction().isIdempotent() || this.blobStreams != null && !this.blobStreams.isEmpty() || this.blobFiles != null && !this.blobFiles.isEmpty());
    }

    public boolean isReadonly() {
        return this.txn.isReadonly();
    }

    public boolean commit() {
        if (!this.isReadonly()) {
            this.apply();
            return this.doCommit();
        }
        return true;
    }

    public boolean isCurrent() {
        return true;
    }

    private boolean doCommit() {
        if (this.txn.commit()) {
            this.store.unregisterTransaction(this);
            this.flushNonTransactionalBlobs();
            this.revertCaches();
            this.replayData = null;
            return true;
        }
        this.revert();
        return false;
    }

    public void abort() {
        try {
            this.disposeCreatedIterators();
            this.store.unregisterTransaction(this);
            this.revertCaches();
        }
        finally {
            this.txn.abort();
        }
    }

    public boolean flush() {
        if (!this.isReadonly()) {
            this.apply();
            return this.doFlush();
        }
        return true;
    }

    boolean doFlush() {
        if (this.txn.flush()) {
            this.flushNonTransactionalBlobs();
            this.revertCaches(false);
            this.replayData = null;
            return true;
        }
        this.revert();
        return false;
    }

    public void revert() {
        this.disposeCreatedIterators();
        this.txn.revert();
        if (this.replayData != null) {
            if (this.mutableCache == null) {
                this.mutableCache = this.localCache.getClone();
                this.mutatedInTxn = new ArrayList<UpdatableCachedInstanceIterable>();
            }
            this.replayData.init(this.mutableCache.getCacheInstance());
            this.replayData.apply(this.mutableCache);
        }
    }

    public PersistentStoreTransaction getSnapshot() {
        return new PersistentStoreTransactionSnapshot(this);
    }

    @NotNull
    public PersistentEntity newEntity(@NotNull String entityType) {
        try {
            int entityTypeId = this.store.getEntityTypeId(this, entityType, true);
            long entityLocalId = this.store.getEntitiesSequence(this, entityTypeId).increment();
            this.store.getEntitiesTable(this, entityTypeId).putRight(this.txn, (ByteIterable)LongBinding.longToCompressedEntry((long)entityLocalId), ZERO_VERSION_ENTRY);
            PersistentEntityId id = new PersistentEntityId(entityTypeId, entityLocalId);
            this.updateMutableCache(new EntityAddedHandleChecker(id));
            return new PersistentEntity(this.store, id);
        }
        catch (Exception e) {
            throw ExodusException.toEntityStoreException((Throwable)e);
        }
    }

    public void saveEntity(@NotNull Entity entity) {
        try {
            EntityId entityId = entity.getId();
            Store entitiesTable = this.store.getEntitiesTable(this, entityId.getTypeId());
            entitiesTable.put(this.txn, (ByteIterable)LongBinding.longToCompressedEntry((long)entityId.getLocalId()), ZERO_VERSION_ENTRY);
            this.updateMutableCache(new EntityAddedHandleChecker(entityId));
        }
        catch (Exception e) {
            throw ExodusException.toEntityStoreException((Throwable)e);
        }
    }

    @NotNull
    public PersistentEntity getEntity(@NotNull EntityId id) {
        int version = this.store.getLastVersion(this, id);
        if (version < 0) {
            throw new EntityRemovedInDatabaseException(this.store.getEntityType(this, id.getTypeId()));
        }
        return new PersistentEntity(this.store, (PersistentEntityId)id);
    }

    @NotNull
    public List<String> getEntityTypes() {
        return this.store.getEntityTypes(this);
    }

    @NotNull
    public EntityIterable getAll(@NotNull String entityType) {
        int entityTypeId = this.store.getEntityTypeId(this, entityType, false);
        if (entityTypeId < 0) {
            return EntityIterableBase.EMPTY;
        }
        return new EntitiesOfTypeIterable(this, entityTypeId);
    }

    @NotNull
    public EntityIterable getSingletonIterable(@NotNull Entity entity) {
        return new SingleEntityIterable(this, entity.getId());
    }

    @NotNull
    public EntityIterable find(@NotNull String entityType, @NotNull String propertyName, @NotNull Comparable value) {
        int entityTypeId = this.store.getEntityTypeId(this, entityType, false);
        if (entityTypeId < 0) {
            return EntityIterableBase.EMPTY;
        }
        int propertyId = this.store.getPropertyId(this, propertyName, false);
        if (propertyId < 0) {
            return EntityIterableBase.EMPTY;
        }
        return new PropertyValueIterable(this, entityTypeId, propertyId, value);
    }

    @NotNull
    public EntityIterable find(@NotNull String entityType, @NotNull String propertyName, @NotNull Comparable minValue, @NotNull Comparable maxValue) {
        int entityTypeId = this.store.getEntityTypeId(this, entityType, false);
        if (entityTypeId < 0) {
            return EntityIterableBase.EMPTY;
        }
        int propertyId = this.store.getPropertyId(this, propertyName, false);
        if (propertyId < 0) {
            return EntityIterableBase.EMPTY;
        }
        return new PropertyRangeIterable(this, entityTypeId, propertyId, minValue, maxValue);
    }

    @NotNull
    public EntityIterable findIds(@NotNull String entityType, long minValue, long maxValue) {
        int entityTypeId = this.store.getEntityTypeId(this, entityType, false);
        if (entityTypeId < 0) {
            return EntityIterableBase.EMPTY;
        }
        return new EntitiesOfTypeRangeIterable(this, entityTypeId, minValue, maxValue);
    }

    @NotNull
    public EntityIterableBase findWithProp(@NotNull String entityType, @NotNull String propertyName) {
        int entityTypeId = this.store.getEntityTypeId(this, entityType, false);
        if (entityTypeId < 0) {
            return EntityIterableBase.EMPTY;
        }
        int propertyId = this.store.getPropertyId(this, propertyName, false);
        if (propertyId < 0) {
            return EntityIterableBase.EMPTY;
        }
        return new EntitiesWithPropertyIterable(this, entityTypeId, propertyId);
    }

    public EntityIterableBase findWithPropSortedByValue(@NotNull String entityType, @NotNull String propertyName) {
        int entityTypeId = this.store.getEntityTypeId(this, entityType, false);
        if (entityTypeId < 0) {
            return EntityIterableBase.EMPTY;
        }
        int propertyId = this.store.getPropertyId(this, propertyName, false);
        if (propertyId < 0) {
            return EntityIterableBase.EMPTY;
        }
        return new PropertiesIterable(this, entityTypeId, propertyId);
    }

    @NotNull
    public EntityIterable findStartingWith(@NotNull String entityType, @NotNull String propertyName, @NotNull String value) {
        int len = value.length();
        if (len == 0) {
            return this.getAll(entityType);
        }
        return this.find(entityType, propertyName, (Comparable)((Object)value), (Comparable)((Object)(value + '\uffff')));
    }

    @NotNull
    public EntityIterable findWithBlob(@NotNull String entityType, @NotNull String blobName) {
        int entityTypeId = this.store.getEntityTypeId(this, entityType, false);
        if (entityTypeId < 0) {
            return EntityIterableBase.EMPTY;
        }
        int blobId = this.store.getPropertyId(this, blobName, false);
        if (blobId < 0) {
            return EntityIterableBase.EMPTY;
        }
        return new EntitiesWithBlobIterable(this, entityTypeId, blobId);
    }

    @NotNull
    public EntityIterable findLinks(@NotNull String entityType, @NotNull Entity entity, @NotNull String linkName) {
        int entityTypeId = this.store.getEntityTypeId(this, entityType, false);
        if (entityTypeId < 0) {
            return EntityIterableBase.EMPTY;
        }
        int linkId = this.store.getLinkId(this, linkName, false);
        if (linkId < 0) {
            return EntityIterableBase.EMPTY;
        }
        if (entity instanceof PersistentEntity) {
            return new EntityToLinksIterable(this, ((PersistentEntity)entity).getId(), entityTypeId, linkId);
        }
        EntityId id = entity.getId();
        if (id instanceof PersistentEntityId) {
            return new EntityToLinksIterable(this, id, entityTypeId, linkId);
        }
        return EntityIterableBase.EMPTY;
    }

    @NotNull
    public EntityIterable findLinks(@NotNull String entityType, @NotNull EntityIterable entities, @NotNull String linkName) {
        ArrayList<EntityIterable> links = null;
        for (Entity entity : entities) {
            if (links == null) {
                links = new ArrayList<EntityIterable>();
            }
            links.add(this.findLinks(entityType, entity, linkName));
        }
        if (links == null) {
            return EntityIterableBase.EMPTY;
        }
        if (links.size() > 1) {
            for (int i = 0; i < links.size() - 1; i += 2) {
                links.add(((EntityIterable)links.get(i)).union((EntityIterable)links.get(i + 1)));
            }
        }
        return (EntityIterable)links.get(links.size() - 1);
    }

    @NotNull
    public EntityIterable findWithLinks(@NotNull String entityType, @NotNull String linkName) {
        int entityTypeId = this.store.getEntityTypeId(this, entityType, false);
        if (entityTypeId < 0) {
            return EntityIterableBase.EMPTY;
        }
        int linkId = this.store.getLinkId(this, linkName, false);
        if (linkId < 0) {
            return EntityIterableBase.EMPTY;
        }
        return new EntitiesWithLinkIterable(this, entityTypeId, linkId);
    }

    @NotNull
    public EntityIterable findWithLinks(@NotNull String entityType, @NotNull String linkName, @NotNull String oppositeEntityType, @NotNull String oppositeLinkName) {
        int entityTypeId = this.store.getEntityTypeId(this, entityType, false);
        if (entityTypeId < 0) {
            return EntityIterableBase.EMPTY;
        }
        int linkId = this.store.getLinkId(this, linkName, false);
        if (linkId < 0) {
            return EntityIterableBase.EMPTY;
        }
        int oppositeEntityId = this.store.getEntityTypeId(this, oppositeEntityType, false);
        if (oppositeEntityId < 0) {
            return EntityIterableBase.EMPTY;
        }
        int oppositeLinkId = this.store.getLinkId(this, oppositeLinkName, false);
        if (oppositeLinkId < 0) {
            return EntityIterableBase.EMPTY;
        }
        return new EntitiesWithLinkSortedIterable(this, entityTypeId, linkId, oppositeEntityId, oppositeLinkId);
    }

    @NotNull
    public EntityIterable sort(@NotNull String entityType, @NotNull String propertyName, boolean ascending) {
        return this.sort(entityType, propertyName, this.getAll(entityType), ascending);
    }

    @NotNull
    public EntityIterable sort(@NotNull String entityType, @NotNull String propertyName, @NotNull EntityIterable rightOrder, boolean ascending) {
        int entityTypeId = this.store.getEntityTypeId(this, entityType, false);
        if (entityTypeId < 0) {
            return EntityIterableBase.EMPTY;
        }
        int propertyId = this.store.getPropertyId(this, propertyName, false);
        if (propertyId < 0 || rightOrder == EntityIterableBase.EMPTY) {
            return rightOrder;
        }
        return new SortIterable(this, this.findWithPropSortedByValue(entityType, propertyName), (EntityIterableBase)rightOrder, entityTypeId, propertyId, ascending);
    }

    @NotNull
    public EntityIterable sortLinks(@NotNull String entityType, @NotNull EntityIterable sortedLinks, boolean isMultiple, @NotNull String linkName, @NotNull EntityIterable rightOrder) {
        SortIndirectIterable result = new SortIndirectIterable(this, this.store, entityType, ((EntityIterableBase)sortedLinks).getSource(), linkName, (EntityIterableBase)rightOrder, null, null);
        return isMultiple ? result.distinct() : result;
    }

    @NotNull
    public EntityIterable sortLinks(@NotNull String entityType, @NotNull EntityIterable sortedLinks, boolean isMultiple, @NotNull String linkName, @NotNull EntityIterable rightOrder, @NotNull String oppositeEntityType, @NotNull String oppositeLinkName) {
        SortIndirectIterable result = new SortIndirectIterable(this, this.store, entityType, ((EntityIterableBase)sortedLinks).getSource(), linkName, (EntityIterableBase)rightOrder, oppositeEntityType, oppositeLinkName);
        return isMultiple ? result.distinct() : result;
    }

    @NotNull
    public EntityIterable mergeSorted(@NotNull List<EntityIterable> sorted, @NotNull Comparator<Entity> comparator) {
        ArrayList<EntityIterable> filtered = null;
        for (EntityIterable it : sorted) {
            if (it == EntityIterableBase.EMPTY) continue;
            if (filtered == null) {
                filtered = new ArrayList<EntityIterable>();
            }
            filtered.add(it);
        }
        return filtered == null ? EntityIterableBase.EMPTY : new MergeSortedIterable(this, filtered, comparator);
    }

    @NotNull
    public EntityId toEntityId(@NotNull String representation) {
        return PersistentEntityId.toEntityId(representation, this.store);
    }

    @NotNull
    public Sequence getSequence(@NotNull String sequenceName) {
        try {
            return this.store.getSequence(this, sequenceName);
        }
        catch (Exception e) {
            throw ExodusException.wrap((Exception)e);
        }
    }

    public void setQueryCancellingPolicy(QueryCancellingPolicy policy) {
        this.queryCancellingPolicy = policy;
    }

    @Nullable
    public QueryCancellingPolicy getQueryCancellingPolicy() {
        return this.queryCancellingPolicy;
    }

    public String toString() {
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        try {
            builder.append(this.store.getLocation());
            builder.append(", thread = ");
            builder.append(Thread.currentThread().toString());
            String string = builder.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        }
    }

    public void registerEntityIterator(@NotNull EntityIterator iterator) {
        if (!this.txn.isIdempotent()) {
            this.createdIterators.add(iterator);
        }
    }

    public void deregisterEntityIterator(@NotNull EntityIterator iterator) {
        if (!this.createdIterators.isEmpty()) {
            this.createdIterators.remove(iterator);
        }
    }

    @NotNull
    public Transaction getEnvironmentTransaction() {
        return this.txn;
    }

    @Override
    public PersistentStoreTransaction getTxn(@NotNull EntityIterableBase iterable) {
        return this;
    }

    @Nullable
    public CachedInstanceIterable getCachedInstance(@NotNull EntityIterableBase sample) {
        EntityIterableHandle handle = sample.getHandle();
        EntityIterableCacheAdapter localCache = this.getLocalCache();
        return localCache.tryKey(handle);
    }

    @Nullable
    public CachedInstanceIterable getCachedInstanceFast(@NotNull EntityIterableBase sample) {
        EntityIterableHandle handle = sample.getHandle();
        EntityIterableCacheAdapter localCache = this.getLocalCache();
        return localCache.getObject(handle);
    }

    public void addCachedInstance(@NotNull CachedInstanceIterable cached) {
        EntityIterableHandle handle;
        EntityIterableCacheAdapter localCache;
        if (!(this.replayData != null && this.replayData.hasCacheSnapshot() || (localCache = this.getLocalCache()).getObject(handle = cached.getHandle()) != null)) {
            localCache.cacheObject(handle, cached);
            this.store.getEntityIterableCache().setCachedCount(handle, cached.size());
        }
    }

    @NotNull
    EntityIterableCacheAdapter getLocalCache() {
        return this.mutableCache != null ? this.mutableCache : this.localCache;
    }

    void localCacheAttempt() {
        ++this.localCacheAttempts;
    }

    void localCacheHit() {
        ++this.localCacheHits;
    }

    boolean isCachingRelevant() {
        return this.localCacheAttempts <= this.localCache.size() >> 2 || this.localCacheHits >= this.localCacheAttempts >> 2;
    }

    void disposeCreatedIterators() {
        EntityIterator[] copy = this.createdIterators.toArray(new EntityIterator[this.createdIterators.size()]);
        this.createdIterators.clear();
        for (EntityIterator iterator : copy) {
            iterator.dispose();
        }
    }

    void cacheProperty(@NotNull PersistentEntityId fromId, int propId, @NotNull Comparable value) {
        PropertyId fromEnd = new PropertyId(fromId, propId);
        if (this.propsCache.getObject((Object)fromEnd) == null) {
            this.propsCache.cacheObject((Object)fromEnd, (Object)value);
        }
    }

    Comparable getCachedProperty(@NotNull PersistentEntity from, int propId) {
        return (Comparable)this.propsCache.tryKey((Object)new PropertyId(from.getId(), propId));
    }

    void cacheLink(@NotNull PersistentEntity from, int linkId, @NotNull PersistentEntityId to) {
        PropertyId fromEnd = new PropertyId(from.getId(), linkId);
        if (this.linksCache.getObject((Object)fromEnd) != null) {
            throw new IllegalStateException("Link is already cached, at first it should be invalidated");
        }
        this.linksCache.cacheObject((Object)fromEnd, (Object)to);
    }

    PersistentEntityId getCachedLink(@NotNull PersistentEntity from, int linkId) {
        return (PersistentEntityId)this.linksCache.tryKey((Object)new PropertyId(from.getId(), linkId));
    }

    void cacheBlobString(@NotNull PersistentEntity from, int blobId, @NotNull String value) {
        PropertyId fromEnd = new PropertyId(from.getId(), blobId);
        if (this.blobStringsCache.getObject((Object)fromEnd) != null) {
            throw new IllegalStateException("Blob string is already cached, at first it should be invalidated");
        }
        this.blobStringsCache.cacheObject((Object)fromEnd, (Object)value);
    }

    String getCachedBlobString(@NotNull PersistentEntity from, int blobId) {
        return (String)this.blobStringsCache.tryKey((Object)new PropertyId(from.getId(), blobId));
    }

    void invalidateCachedBlobString(@NotNull PersistentEntity from, int blobId) {
        this.blobStringsCache.remove((Object)new PropertyId(from.getId(), blobId));
    }

    boolean isMutable() {
        return this.mutableCache != null;
    }

    void entityDeleted(@NotNull PersistentEntityId id) {
        this.updateMutableCache(new EntityDeletedHandleChecker(id));
    }

    void propertyChanged(@NotNull PersistentEntityId id, int propertyId, @Nullable Comparable oldValue, @Nullable Comparable newValue) {
        PropertyId propId = new PropertyId(id, propertyId);
        this.propsCache.remove((Object)propId);
        this.updateMutableCache(new PropertyChangedHandleChecker(id.getTypeId(), id.getLocalId(), propertyId, oldValue, newValue));
    }

    void linkAdded(@NotNull PersistentEntityId sourceId, @NotNull PersistentEntityId targetId, int linkId) {
        PropertyId propId = new PropertyId(sourceId, linkId);
        this.linksCache.remove((Object)propId);
        this.updateMutableCache(new LinkAddedHandleChecker(sourceId, targetId, linkId));
    }

    void linkDeleted(@NotNull PersistentEntityId sourceId, @NotNull PersistentEntityId targetId, int linkId) {
        PropertyId propId = new PropertyId(sourceId, linkId);
        this.linksCache.remove((Object)propId);
        this.updateMutableCache(new LinkDeletedHandleChecker(sourceId, targetId, linkId));
    }

    void addBlob(long blobHandle, @NotNull InputStream stream) throws IOException {
        LongHashMap blobStreams = this.blobStreams;
        if (blobStreams == null) {
            this.blobStreams = blobStreams = new LongHashMap();
        }
        if (!stream.markSupported()) {
            throw new EntityStoreException("Blob input stream should support the mark and reset methods");
        }
        stream.mark(Integer.MAX_VALUE);
        blobStreams.put(blobHandle, (Object)stream);
    }

    void addBlob(long blobHandle, @NotNull File file) {
        LongHashMap blobFiles = this.blobFiles;
        if (blobFiles == null) {
            this.blobFiles = blobFiles = new LongHashMap();
        }
        blobFiles.put(blobHandle, (Object)file);
    }

    void deleteBlob(long blobHandle) {
        if (this.blobStreams != null) {
            this.blobStreams.remove(blobHandle);
        }
        if (this.blobFiles != null) {
            this.blobFiles.remove(blobHandle);
        }
    }

    long getBlobSize(long blobHandle) throws IOException {
        File file;
        InputStream stream;
        LongHashMap<InputStream> blobStreams = this.blobStreams;
        if (blobStreams != null && (stream = (InputStream)blobStreams.get(blobHandle)) != null) {
            stream.reset();
            return stream.skip(Long.MAX_VALUE);
        }
        LongHashMap<File> blobFiles = this.blobFiles;
        if (blobFiles != null && (file = (File)blobFiles.get(blobHandle)) != null) {
            return file.length();
        }
        return -1L;
    }

    @Nullable
    InputStream getBlobStream(long blobHandle) throws IOException {
        File file;
        InputStream stream;
        LongHashMap<InputStream> blobStreams = this.blobStreams;
        if (blobStreams != null && (stream = (InputStream)blobStreams.get(blobHandle)) != null) {
            stream.reset();
            return stream;
        }
        LongHashMap<File> blobFiles = this.blobFiles;
        if (blobFiles != null && (file = (File)blobFiles.get(blobHandle)) != null) {
            return this.store.getBlobVault().cloneStream((InputStream)new FileInputStream(file), true);
        }
        return null;
    }

    void preserveBlob(long blobHandle) {
        if (this.preservedBlobs == null) {
            this.preservedBlobs = new LongHashSet();
        }
        this.preservedBlobs.add(blobHandle);
    }

    boolean isBlobPreserved(long blobHandle) {
        return this.preservedBlobs != null && this.preservedBlobs.contains(blobHandle);
    }

    void deferBlobDeletion(long blobHandle) {
        if (this.deferredBlobsToDelete == null) {
            this.deferredBlobsToDelete = new LongHashSet();
        }
        this.deferredBlobsToDelete.add(blobHandle);
    }

    void closeCaches() {
        this.propsCache.close();
        this.linksCache.close();
        this.blobStringsCache.close();
    }

    void revertCaches() {
        this.revertCaches(true);
    }

    private void revertCaches(boolean clearPropsAndLinksCache) {
        if (clearPropsAndLinksCache) {
            this.propsCache.clear();
            this.linksCache.clear();
            this.blobStringsCache.clear();
        }
        this.localCache = this.store.getEntityIterableCache().getCacheAdapter();
        this.mutableCache = null;
        this.mutatedInTxn = null;
        this.blobStreams = null;
        this.blobFiles = null;
        this.preservedBlobs = null;
        this.deferredBlobsToDelete = null;
    }

    void apply() {
        this.disposeCreatedIterators();
        final FlushLog log = new FlushLog();
        this.store.logOperations(this.txn, log);
        BlobVault blobVault = this.store.getBlobVault();
        if (blobVault.requiresTxn()) {
            try {
                blobVault.flushBlobs(this.blobStreams, this.blobFiles, this.deferredBlobsToDelete, this.txn);
            }
            catch (Exception e) {
                throw ExodusException.toEntityStoreException((Throwable)e);
            }
        }
        this.txn.setCommitHook(new Runnable(){

            @Override
            public void run() {
                log.flushed();
                if (PersistentStoreTransaction.this.mutableCache != null) {
                    EntityIterableCache entityIterableCache = PersistentStoreTransaction.this.store.getEntityIterableCache();
                    for (UpdatableCachedInstanceIterable it : PersistentStoreTransaction.this.mutatedInTxn) {
                        it.endUpdate();
                        entityIterableCache.setCachedCount(it.getHandle(), it.size());
                    }
                    if (!entityIterableCache.compareAndSetCacheAdapter(PersistentStoreTransaction.this.localCache, PersistentStoreTransaction.this.mutableCache)) {
                        throw new EntityStoreException("This exception should never be thrown");
                    }
                }
            }
        });
    }

    private Runnable getRevertCachesBeginHook() {
        return new Runnable(){

            @Override
            public void run() {
                PersistentStoreTransaction.this.revertCaches();
            }
        };
    }

    private void flushNonTransactionalBlobs() {
        BlobVault blobVault = this.store.getBlobVault();
        if (!(blobVault.requiresTxn() || this.blobStreams == null && this.blobFiles == null && this.deferredBlobsToDelete == null)) {
            ((EnvironmentImpl)this.txn.getEnvironment()).flushAndSync();
            try {
                blobVault.flushBlobs(this.blobStreams, this.blobFiles, this.deferredBlobsToDelete, this.txn);
            }
            catch (Exception e) {
                this.handleOutOfDiskSpace(e);
                throw ExodusException.toEntityStoreException((Throwable)e);
            }
        }
    }

    private void updateMutableCache(@NotNull HandleChecker checker) {
        if (this.replayData == null) {
            this.replayData = new ReplayData();
        }
        if (this.mutableCache == null) {
            this.mutableCache = this.localCache.getClone();
            this.mutatedInTxn = new ArrayList<UpdatableCachedInstanceIterable>();
            this.replayData.setCacheSnapshot(this.mutableCache.getClone());
        }
        this.replayData.updateMutableCache(this.mutableCache, this.mutatedInTxn, checker);
    }

    private void handleOutOfDiskSpace(Exception e) {
        if (e instanceof IOException && this.store.getUsableSpace() < 4096L) {
            throw new OutOfDiskSpaceException((Throwable)e);
        }
    }

    private static <V> ObjectCacheBase<PropertyId, V> createObjectCache(int size) {
        return size == 0 ? new FakeObjectCache() : new TransactionObjectCache(size);
    }

    private static final class TransactionObjectCache<V>
    extends ObjectCacheDecorator<PropertyId, V> {
        private TransactionObjectCache(int size) {
            super(size);
        }

        protected ObjectCacheBase<PropertyId, V> createdDecorated() {
            return new ConcurrentObjectCache<PropertyId, V>(this.size()){

                @Nullable
                protected SharedTimer.ExpirablePeriodicTask getCacheAdjuster() {
                    return null;
                }
            };
        }
    }

    private static final class PropertyChangedHandleChecker
    extends HandleChecker {
        private final int typeId;
        private final long localId;
        private final int propertyId;
        @Nullable
        private final Comparable oldValue;
        @Nullable
        private final Comparable newValue;

        private PropertyChangedHandleChecker(int typeId, long localId, int propertyId, @Nullable Comparable oldValue, @Nullable Comparable newValue) {
            if (oldValue == null && newValue == null) {
                throw new IllegalArgumentException("Either oldValue or newValue should be not null");
            }
            this.typeId = typeId;
            this.localId = localId;
            this.propertyId = propertyId;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @Override
        public HandleCheckResult checkHandle(@NotNull EntityIterableHandle handle, @NotNull EntityIterableCacheAdapter mutableCache) {
            if (handle.isMatchedPropertyChanged(this.typeId, this.propertyId, this.oldValue, this.newValue)) {
                EntityIterableType handleType = handle.getType();
                if (handleType == EntityIterableType.ENTITIES_WITH_PROPERTY_SORTED_BY_VALUE) {
                    return HandleCheckResult.UPDATE;
                }
                if (handleType == EntityIterableType.ENTITIES_WITH_PROPERTY) {
                    return this.oldValue == null || this.newValue == null ? HandleCheckResult.UPDATE : HandleCheckResult.KEEP;
                }
                return HandleCheckResult.REMOVE;
            }
            return HandleCheckResult.KEEP;
        }

        @Override
        void update(@NotNull EntityIterableHandle handle, @NotNull UpdatableCachedInstanceIterable iterable) {
            if (handle.getType() == EntityIterableType.ENTITIES_WITH_PROPERTY_SORTED_BY_VALUE) {
                UpdatablePropertiesCachedInstanceIterable propertyIndex = (UpdatablePropertiesCachedInstanceIterable)iterable;
                if (this.oldValue instanceof ComparableSet || this.newValue instanceof ComparableSet) {
                    ComparableSet oldSet = (ComparableSet)this.oldValue;
                    ComparableSet newSet = (ComparableSet)this.newValue;
                    if (oldSet != null) {
                        for (Comparable item : oldSet.minus(newSet)) {
                            propertyIndex.update(this.typeId, this.localId, item, null);
                        }
                    }
                    if (newSet != null) {
                        for (Comparable item : newSet.minus(oldSet)) {
                            propertyIndex.update(this.typeId, this.localId, null, item);
                        }
                    }
                } else {
                    propertyIndex.update(this.typeId, this.localId, this.oldValue, this.newValue);
                }
            } else {
                UpdatableEntityIdSortedSetCachedInstanceIterable cachedInstance = (UpdatableEntityIdSortedSetCachedInstanceIterable)iterable;
                if (this.oldValue == null) {
                    cachedInstance.addEntity(new PersistentEntityId(this.typeId, this.localId));
                } else {
                    cachedInstance.removeEntity(new PersistentEntityId(this.typeId, this.localId));
                }
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PropertyChangedHandleChecker that = (PropertyChangedHandleChecker)obj;
            if (this.propertyId != that.propertyId) {
                return false;
            }
            if (this.typeId != that.typeId) {
                return false;
            }
            if (this.newValue != null ? !this.newValue.equals(that.newValue) : that.newValue != null) {
                return false;
            }
            return !(this.oldValue == null ? that.oldValue != null : !this.oldValue.equals(that.oldValue));
        }

        public int hashCode() {
            int result = this.typeId;
            result = 31 * result + this.propertyId;
            result = 31 * result + (this.oldValue != null ? this.oldValue.hashCode() : 0);
            result = 31 * result + (this.newValue != null ? this.newValue.hashCode() : 0);
            return result;
        }
    }

    private static final class LinkDeletedHandleChecker
    extends LinkChangedHandleChecker {
        private LinkDeletedHandleChecker(@NotNull PersistentEntityId sourceId, @NotNull PersistentEntityId targetId, int linkId) {
            super(sourceId, targetId, linkId);
        }

        @Override
        public HandleCheckResult checkHandle(@NotNull EntityIterableHandle handle, @NotNull EntityIterableCacheAdapter mutableCache) {
            return handle.hasLinkId(this.linkId) && handle.isMatchedLinkDeleted(this.sourceId, this.targetId, this.linkId) ? HandleCheckResult.REMOVE : HandleCheckResult.KEEP;
        }
    }

    private static final class LinkAddedHandleChecker
    extends LinkChangedHandleChecker {
        private LinkAddedHandleChecker(@NotNull PersistentEntityId sourceId, @NotNull PersistentEntityId targetId, int linkId) {
            super(sourceId, targetId, linkId);
        }

        @Override
        public HandleCheckResult checkHandle(@NotNull EntityIterableHandle handle, @NotNull EntityIterableCacheAdapter mutableCache) {
            return handle.hasLinkId(this.linkId) && handle.isMatchedLinkAdded(this.sourceId, this.targetId, this.linkId) ? HandleCheckResult.REMOVE : HandleCheckResult.KEEP;
        }
    }

    private static abstract class LinkChangedHandleChecker
    extends HandleChecker {
        @NotNull
        final PersistentEntityId sourceId;
        @NotNull
        final PersistentEntityId targetId;
        protected final int linkId;

        private LinkChangedHandleChecker(@NotNull PersistentEntityId sourceId, @NotNull PersistentEntityId targetId, int linkId) {
            this.sourceId = sourceId;
            this.targetId = targetId;
            this.linkId = linkId;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            LinkChangedHandleChecker that = (LinkChangedHandleChecker)obj;
            if (this.linkId != that.linkId) {
                return false;
            }
            if (!this.sourceId.equals(that.sourceId)) {
                return false;
            }
            return this.targetId.equals(that.targetId);
        }

        public int hashCode() {
            int result = this.sourceId.hashCode();
            result = 31 * result + this.targetId.hashCode();
            result = 31 * result + this.linkId;
            return result;
        }
    }

    private static class EntityAddedHandleChecker
    extends EntityAddedOrRemovedHandleChecker {
        private EntityAddedHandleChecker(@NotNull EntityId id) {
            super(id);
        }

        @Override
        public HandleCheckResult checkHandle(@NotNull EntityIterableHandle handle, @NotNull EntityIterableCacheAdapter mutableCache) {
            boolean result = handle.isMatchedEntityAdded(this.id);
            if (result && handle.getType() == EntityIterableType.ALL_ENTITIES) {
                return HandleCheckResult.UPDATE;
            }
            return result ? HandleCheckResult.REMOVE : HandleCheckResult.KEEP;
        }

        @Override
        void update(@NotNull EntityIterableHandle handle, @NotNull UpdatableCachedInstanceIterable iterable) {
            ((UpdatableEntityIdSortedSetCachedInstanceIterable)iterable).addEntity(this.id);
        }
    }

    private static class EntityDeletedHandleChecker
    extends EntityAddedOrRemovedHandleChecker {
        private EntityDeletedHandleChecker(@NotNull EntityId id) {
            super(id);
        }

        @Override
        public HandleCheckResult checkHandle(@NotNull EntityIterableHandle handle, @NotNull EntityIterableCacheAdapter mutableCache) {
            boolean result = handle.isMatchedEntityDeleted(this.id);
            if (result && handle.getType() == EntityIterableType.ALL_ENTITIES) {
                return HandleCheckResult.UPDATE;
            }
            return result ? HandleCheckResult.REMOVE : HandleCheckResult.KEEP;
        }

        @Override
        void update(@NotNull EntityIterableHandle handle, @NotNull UpdatableCachedInstanceIterable iterable) {
            ((UpdatableEntityIdSortedSetCachedInstanceIterable)iterable).removeEntity(this.id);
        }
    }

    private static abstract class EntityAddedOrRemovedHandleChecker
    extends HandleChecker {
        protected final EntityId id;

        EntityAddedOrRemovedHandleChecker(@NotNull EntityId id) {
            this.id = id;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            EntityAddedOrRemovedHandleChecker that = (EntityAddedOrRemovedHandleChecker)obj;
            return this.id.equals(that.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }
    }

    private static class PropertyId {
        @NotNull
        private final PersistentEntityId entityId;
        private final int propId;

        private PropertyId(@NotNull PersistentEntityId entityId, int propId) {
            this.entityId = entityId;
            this.propId = propId;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PropertyId propertyId = (PropertyId)obj;
            return this.propId == propertyId.propId && this.entityId.equals(propertyId.entityId);
        }

        public int hashCode() {
            return 31 * this.entityId.hashCode() + this.propId;
        }
    }

    static abstract class HandleChecker {
        HandleChecker() {
        }

        abstract HandleCheckResult checkHandle(@NotNull EntityIterableHandle var1, @NotNull EntityIterableCacheAdapter var2);

        void update(@NotNull EntityIterableHandle handle, @NotNull UpdatableCachedInstanceIterable iterable) {
        }
    }

    static enum HandleCheckResult {
        KEEP,
        REMOVE,
        UPDATE;

    }

    static enum TransactionType {
        Regular,
        Exclusive,
        Readonly;

    }
}

