/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.exodus.core.dataStructures.hash.HashMap;
import jetbrains.exodus.core.dataStructures.hash.HashSet;
import jetbrains.exodus.core.dataStructures.hash.ObjectProcedure;
import jetbrains.exodus.core.dataStructures.persistent.PersistentObjectCache;
import jetbrains.exodus.entitystore.EntityIterableCacheAdapter;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.UpdatableCachedInstanceIterable;
import org.jetbrains.annotations.NotNull;

public class ReplayData {
    private static final List<EntityIterableHandle> NO_UPDATES = Collections.emptyList();
    private EntityIterableCacheAdapter cacheSnapshot;
    private final Map<PersistentStoreTransaction.HandleChecker, List<EntityIterableHandle>> changes = new HashMap();
    private Set<EntityIterableHandle> delete = new HashSet();
    private Set<EntityIterableHandle> suspicious;

    public void updateMutableCache(final @NotNull EntityIterableCacheAdapter mutableCache, final @NotNull List<UpdatableCachedInstanceIterable> mutatedInTxn, final @NotNull PersistentStoreTransaction.HandleChecker checker) {
        boolean alreadySeen = this.changes.containsKey(checker);
        if (this.suspicious != null && alreadySeen) {
            List<EntityIterableHandle> l;
            if (!this.suspicious.isEmpty()) {
                for (EntityIterableHandle handle : this.suspicious) {
                    this.check(handle, checker, mutableCache, mutatedInTxn);
                }
            }
            if ((l = this.changes.get(checker)) != null) {
                for (EntityIterableHandle handle : l) {
                    UpdatableCachedInstanceIterable it = (UpdatableCachedInstanceIterable)mutableCache.getObject(handle);
                    if (it == null) continue;
                    if (!it.isMutated()) {
                        it = it.beginUpdate();
                        mutableCache.cacheObject(handle, it);
                        mutatedInTxn.add(it);
                    }
                    checker.update(handle, it);
                }
            }
            return;
        }
        if (!alreadySeen) {
            this.changes.put(checker, NO_UPDATES);
        }
        mutableCache.forEachKey(new ObjectProcedure<EntityIterableHandle>(){

            public boolean execute(EntityIterableHandle object) {
                ReplayData.this.check(object, checker, mutableCache, mutatedInTxn);
                return true;
            }
        });
    }

    private void check(@NotNull EntityIterableHandle handle, @NotNull PersistentStoreTransaction.HandleChecker checker, @NotNull EntityIterableCacheAdapter mutableCache, @NotNull List<UpdatableCachedInstanceIterable> mutatedInTxn) {
        switch (checker.checkHandle(handle, mutableCache)) {
            case KEEP: {
                break;
            }
            case REMOVE: {
                this.delete.add(handle);
                mutableCache.remove(handle);
                break;
            }
            case UPDATE: {
                UpdatableCachedInstanceIterable it = (UpdatableCachedInstanceIterable)mutableCache.getObject(handle);
                if (it == null) break;
                if (!it.isMutated()) {
                    it = it.beginUpdate();
                    mutableCache.cacheObject(handle, it);
                    mutatedInTxn.add(it);
                }
                checker.update(handle, it);
                List<EntityIterableHandle> l = this.changes.get(checker);
                if (l == NO_UPDATES) {
                    l = new ArrayList<EntityIterableHandle>(8);
                    this.changes.put(checker, l);
                }
                l.add(handle);
            }
        }
    }

    public void setCacheSnapshot(@NotNull EntityIterableCacheAdapter cache) {
        this.cacheSnapshot = cache;
    }

    public boolean hasCacheSnapshot() {
        return this.cacheSnapshot != null;
    }

    public void init(final @NotNull PersistentObjectCache<EntityIterableHandle, EntityIterableCacheAdapter.CacheItem> localCache) {
        this.suspicious = new HashSet();
        if (this.hasCacheSnapshot()) {
            final PersistentObjectCache<EntityIterableHandle, EntityIterableCacheAdapter.CacheItem> oldCache = this.cacheSnapshot.getCacheInstance();
            localCache.forEachKey((ObjectProcedure)new ObjectProcedure<EntityIterableHandle>(){

                public boolean execute(EntityIterableHandle object) {
                    EntityIterableCacheAdapter.CacheItem oldItem = (EntityIterableCacheAdapter.CacheItem)oldCache.getObject((Object)object);
                    if (oldItem == null || oldItem != localCache.getObject((Object)object)) {
                        ReplayData.this.suspicious.add(object);
                    }
                    return true;
                }
            });
        }
    }

    public void apply(@NotNull EntityIterableCacheAdapter localCache) {
        for (EntityIterableHandle handle : this.delete) {
            localCache.remove(handle);
        }
    }
}

