/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.CachedInstanceIterable;
import jetbrains.exodus.entitystore.iterate.ConstantEntityIterableHandle;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableInstantiator;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.UpdatableEntityIdSortedSetCachedInstanceIterable;
import jetbrains.exodus.env.Cursor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntitiesOfTypeIterable
extends EntityIterableBase {
    private final int entityTypeId;

    public EntitiesOfTypeIterable(@NotNull PersistentStoreTransaction txn, int entityTypeId) {
        super(txn);
        this.entityTypeId = entityTypeId;
    }

    public static EntityIterableType getType() {
        return EntityIterableType.ALL_ENTITIES;
    }

    @Override
    public int getEntityTypeId() {
        return this.entityTypeId;
    }

    @Override
    @NotNull
    public EntityIteratorBase getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        return new EntitiesOfTypeIterator(this, this.getStore().getEntitiesIndexCursor(txn, this.entityTypeId));
    }

    @Override
    public boolean nonCachedHasFastCountAndIsEmpty() {
        return true;
    }

    @Override
    @NotNull
    protected EntityIterableHandle getHandleImpl() {
        return new EntitiesOfTypeIterableHandle();
    }

    @Override
    protected long countImpl(@NotNull PersistentStoreTransaction txn) {
        return this.getStore().getEntitiesTable(txn, this.entityTypeId).count(txn.getEnvironmentTransaction());
    }

    @Override
    public boolean isEmptyImpl(@NotNull PersistentStoreTransaction txn) {
        return this.countImpl(txn) == 0L;
    }

    @Override
    protected CachedInstanceIterable createCachedInstance(@NotNull PersistentStoreTransaction txn) {
        return new UpdatableEntityIdSortedSetCachedInstanceIterable(txn, this);
    }

    static {
        EntitiesOfTypeIterable.registerType(EntitiesOfTypeIterable.getType(), new EntityIterableInstantiator(){

            @Override
            public EntityIterableBase instantiate(PersistentStoreTransaction txn, PersistentEntityStoreImpl store, Object[] parameters) {
                return new EntitiesOfTypeIterable(txn, Integer.valueOf((String)parameters[0]));
            }
        });
    }

    private final class EntitiesOfTypeIterableHandle
    extends ConstantEntityIterableHandle {
        public EntitiesOfTypeIterableHandle() {
            super(EntitiesOfTypeIterable.this.getStore(), EntitiesOfTypeIterable.getType());
        }

        @Override
        public void toString(@NotNull StringBuilder builder) {
            super.toString(builder);
            builder.append(EntitiesOfTypeIterable.this.entityTypeId);
        }

        @Override
        public void hashCode(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
            hash.apply(EntitiesOfTypeIterable.this.entityTypeId);
        }

        @Override
        public boolean isMatchedEntityAdded(@NotNull EntityId added) {
            return added.getTypeId() == EntitiesOfTypeIterable.this.entityTypeId;
        }

        @Override
        public boolean isMatchedEntityDeleted(@NotNull EntityId deleted) {
            return deleted.getTypeId() == EntitiesOfTypeIterable.this.entityTypeId;
        }
    }

    private final class EntitiesOfTypeIterator
    extends EntityIteratorBase {
        private boolean hasNext;
        private boolean hasNextValid;

        private EntitiesOfTypeIterator(@NotNull EntitiesOfTypeIterable iterable, Cursor index) {
            super(iterable);
            this.setCursor(index);
        }

        @Override
        public boolean hasNextImpl() {
            if (!this.hasNextValid) {
                this.hasNext = this.getCursor().getNext();
                this.hasNextValid = true;
            }
            return this.hasNext;
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            if (this.hasNextImpl()) {
                EntitiesOfTypeIterable.this.explain(EntitiesOfTypeIterable.getType());
                EntityId result = this.getEntityId();
                this.hasNextValid = false;
                return result;
            }
            return null;
        }

        @Override
        @Nullable
        public EntityId getLast() {
            if (!this.getCursor().getPrev()) {
                return null;
            }
            return this.getEntityId();
        }

        private EntityId getEntityId() {
            return new PersistentEntityId(EntitiesOfTypeIterable.this.entityTypeId, LongBinding.compressedEntryToLong((ByteIterable)this.getCursor().getKey()));
        }
    }
}

