/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.ConstantEntityIterableHandle;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableInstantiator;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.env.Cursor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntitiesOfTypeRangeIterable
extends EntityIterableBase {
    private final int entityTypeId;
    private final long min;
    private final long max;

    public EntitiesOfTypeRangeIterable(@NotNull PersistentStoreTransaction txn, int entityTypeId, long min, long max) {
        super(txn);
        this.entityTypeId = entityTypeId;
        this.min = min;
        this.max = max;
    }

    public static EntityIterableType getType() {
        return EntityIterableType.ALL_ENTITIES_RANGE;
    }

    @Override
    public int getEntityTypeId() {
        return this.entityTypeId;
    }

    @Override
    @NotNull
    public EntityIteratorBase getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        return new EntitiesOfTypeIterator(this, this.openCursor(txn));
    }

    private Cursor openCursor(@NotNull PersistentStoreTransaction txn) {
        return this.getStore().getEntitiesIndexCursor(txn, this.entityTypeId);
    }

    @Override
    @NotNull
    protected EntityIterableHandle getHandleImpl() {
        return new ConstantEntityIterableHandle(this.getStore(), EntitiesOfTypeRangeIterable.getType()){

            @Override
            public void toString(@NotNull StringBuilder builder) {
                super.toString(builder);
                builder.append(EntitiesOfTypeRangeIterable.this.entityTypeId);
                builder.append('-');
                builder.append(EntitiesOfTypeRangeIterable.this.min);
                builder.append('-');
                builder.append(EntitiesOfTypeRangeIterable.this.max);
            }

            @Override
            public void hashCode(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
                hash.apply(EntitiesOfTypeRangeIterable.this.entityTypeId);
                hash.applyDelimiter();
                hash.apply(EntitiesOfTypeRangeIterable.this.min);
                hash.applyDelimiter();
                hash.apply(EntitiesOfTypeRangeIterable.this.max);
            }

            @Override
            public boolean isMatchedEntityAdded(@NotNull EntityId added) {
                return added.getTypeId() == EntitiesOfTypeRangeIterable.this.entityTypeId && this.isRangeAffected(added.getLocalId());
            }

            @Override
            public boolean isMatchedEntityDeleted(@NotNull EntityId deleted) {
                return deleted.getTypeId() == EntitiesOfTypeRangeIterable.this.entityTypeId && this.isRangeAffected(deleted.getLocalId());
            }

            private boolean isRangeAffected(long id) {
                return EntitiesOfTypeRangeIterable.this.min <= id && id <= EntitiesOfTypeRangeIterable.this.max;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long countImpl(@NotNull PersistentStoreTransaction txn) {
        Cursor cursor = this.openCursor(txn);
        if (cursor == null) {
            return 0L;
        }
        try {
            boolean success;
            ArrayByteIterable key = LongBinding.longToCompressedEntry((long)this.min);
            long result = 0L;
            boolean bl = success = cursor.getSearchKeyRange((ByteIterable)key) != null;
            while (success && this.max <= LongBinding.compressedEntryToLong((ByteIterable)cursor.getKey())) {
                ++result;
                success = cursor.getNextNoDup();
            }
            long l = result;
            return l;
        }
        finally {
            cursor.close();
        }
    }

    static {
        EntitiesOfTypeRangeIterable.registerType(EntitiesOfTypeRangeIterable.getType(), new EntityIterableInstantiator(){

            @Override
            public EntityIterableBase instantiate(PersistentStoreTransaction txn, PersistentEntityStoreImpl store, Object[] parameters) {
                long min = Long.parseLong((String)parameters[1]);
                long max = Long.parseLong((String)parameters[2]);
                return new EntitiesOfTypeRangeIterable(txn, Integer.valueOf((String)parameters[0]), min, max);
            }
        });
    }

    private final class EntitiesOfTypeIterator
    extends EntityIteratorBase {
        private boolean hasNext;

        private EntitiesOfTypeIterator(@NotNull EntitiesOfTypeRangeIterable iterable, Cursor index) {
            super(iterable);
            this.setCursor(index);
            ArrayByteIterable key = LongBinding.longToCompressedEntry((long)EntitiesOfTypeRangeIterable.this.min);
            this.checkHasNext(this.getCursor().getSearchKeyRange((ByteIterable)key) != null);
        }

        @Override
        public boolean hasNextImpl() {
            return this.hasNext;
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            if (this.hasNextImpl()) {
                EntitiesOfTypeRangeIterable.this.explain(EntitiesOfTypeRangeIterable.getType());
                Cursor cursor = this.getCursor();
                long localId = LongBinding.compressedEntryToLong((ByteIterable)cursor.getKey());
                PersistentEntityId result = new PersistentEntityId(EntitiesOfTypeRangeIterable.this.entityTypeId, localId);
                this.checkHasNext(cursor.getNext());
                return result;
            }
            return null;
        }

        private void checkHasNext(boolean success) {
            this.hasNext = success && EntitiesOfTypeRangeIterable.this.max >= LongBinding.compressedEntryToLong((ByteIterable)this.getCursor().getKey());
        }
    }
}

