/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntitiesWithLinkIterable;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.tables.LinkValue;
import jetbrains.exodus.env.Cursor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EntitiesWithLinkSortedIterable
extends EntitiesWithLinkIterable {
    private final int oppositeEntityTypeId;
    private final int oppositeLinkId;

    public EntitiesWithLinkSortedIterable(@NotNull PersistentStoreTransaction txn, int entityTypeId, int linkId, int oppositeEntityTypeId, int oppositeLinkId) {
        super(txn, entityTypeId, linkId);
        this.oppositeEntityTypeId = oppositeEntityTypeId;
        this.oppositeLinkId = oppositeLinkId;
    }

    @Override
    public boolean isSortedById() {
        return true;
    }

    @Override
    @NotNull
    public EntityIteratorBase getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        return new LinksIterator(this.openCursor(txn));
    }

    @Override
    @NotNull
    protected EntityIterableHandle getHandleImpl() {
        return new EntitiesWithLinkIterable.EntitiesWithLinkIterableHandle(){

            @Override
            public void hashCode(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
                super.hashCode(hash);
                hash.applyDelimiter();
                hash.apply(EntitiesWithLinkSortedIterable.this.oppositeEntityTypeId);
            }
        };
    }

    private Cursor openCursor(@NotNull PersistentStoreTransaction txn) {
        return this.getStore().getLinksSecondIndexCursor(txn, this.oppositeEntityTypeId);
    }

    private final class LinksIterator
    extends EntityIteratorBase {
        private boolean hasNext;
        private LinkValue linkValue;

        private LinksIterator(Cursor index) {
            super(EntitiesWithLinkSortedIterable.this);
            this.setCursor(index);
            ArrayByteIterable key = LinkValue.linkValueToEntry(new LinkValue(new PersistentEntityId(EntitiesWithLinkSortedIterable.this.getEntityTypeId(), 0L), EntitiesWithLinkSortedIterable.this.oppositeLinkId));
            this.hasNext = index.getSearchKeyRange((ByteIterable)key) != null;
            this.checkCursorKey();
        }

        @Override
        public boolean hasNextImpl() {
            return this.hasNext;
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            if (this.hasNextImpl()) {
                EntitiesWithLinkSortedIterable.this.explain(EntitiesWithLinkIterable.getType());
                EntityId result = this.linkValue.getEntityId();
                this.hasNext = this.getCursor().getNext();
                this.checkCursorKey();
                return result;
            }
            return null;
        }

        private void checkCursorKey() {
            if (this.hasNext) {
                this.linkValue = LinkValue.entryToLinkValue(this.getCursor().getKey());
                this.hasNext = this.linkValue.getLinkId() == EntitiesWithLinkSortedIterable.this.oppositeLinkId && this.linkValue.getEntityId().getTypeId() == EntitiesWithLinkSortedIterable.this.getEntityTypeId();
            }
        }
    }
}

