/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.IntegerBinding;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.CachedInstanceIterable;
import jetbrains.exodus.entitystore.iterate.ConstantEntityIterableHandle;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableInstantiator;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.UpdatableEntityIdSortedSetCachedInstanceIterable;
import jetbrains.exodus.env.Cursor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntitiesWithPropertyIterable
extends EntityIterableBase {
    private final int entityTypeId;
    private final int propertyId;

    public EntitiesWithPropertyIterable(@NotNull PersistentStoreTransaction txn, int entityTypeId, int propertyId) {
        super(txn);
        this.entityTypeId = entityTypeId;
        this.propertyId = propertyId;
    }

    public static EntityIterableType getType() {
        return EntityIterableType.ENTITIES_WITH_PROPERTY;
    }

    @Override
    public int getEntityTypeId() {
        return this.entityTypeId;
    }

    @Override
    @NotNull
    public EntityIterator getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        return new PropertiesIterator(this.getStore().getEntityWithPropCursor(txn, this.entityTypeId));
    }

    @Override
    @NotNull
    protected EntityIterableHandle getHandleImpl() {
        return new EntitiesWithPropertyIterableHandle();
    }

    @Override
    protected CachedInstanceIterable createCachedInstance(@NotNull PersistentStoreTransaction txn) {
        return new UpdatableEntityIdSortedSetCachedInstanceIterable(txn, this);
    }

    static {
        EntitiesWithPropertyIterable.registerType(EntitiesWithPropertyIterable.getType(), new EntityIterableInstantiator(){

            @Override
            public EntityIterableBase instantiate(PersistentStoreTransaction txn, PersistentEntityStoreImpl store, Object[] parameters) {
                return new EntitiesWithPropertyIterable(txn, Integer.valueOf((String)parameters[0]), Integer.valueOf((String)parameters[1]));
            }
        });
    }

    public final class PropertiesIterator
    extends EntityIteratorBase {
        private boolean hasNext;

        public PropertiesIterator(Cursor cursor) {
            super(EntitiesWithPropertyIterable.this);
            this.setCursor(cursor);
            this.hasNext = cursor.getSearchKey((ByteIterable)IntegerBinding.intToCompressedEntry((int)EntitiesWithPropertyIterable.this.propertyId)) != null;
        }

        @Override
        protected boolean hasNextImpl() {
            return this.hasNext;
        }

        @Override
        protected EntityId nextIdImpl() {
            if (this.hasNext) {
                EntitiesWithPropertyIterable.this.explain(EntitiesWithPropertyIterable.getType());
                Cursor cursor = this.getCursor();
                long localId = LongBinding.compressedEntryToLong((ByteIterable)cursor.getValue());
                PersistentEntityId result = new PersistentEntityId(EntitiesWithPropertyIterable.this.entityTypeId, localId);
                this.hasNext = cursor.getNextDup();
                return result;
            }
            return null;
        }
    }

    private final class EntitiesWithPropertyIterableHandle
    extends ConstantEntityIterableHandle {
        private EntitiesWithPropertyIterableHandle() {
            super(EntitiesWithPropertyIterable.this.getStore(), EntitiesWithPropertyIterable.getType());
        }

        @Override
        public void toString(@NotNull StringBuilder builder) {
            super.toString(builder);
            builder.append(EntitiesWithPropertyIterable.this.entityTypeId);
            builder.append('-');
            builder.append(EntitiesWithPropertyIterable.this.propertyId);
        }

        @Override
        public void hashCode(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
            hash.apply(EntitiesWithPropertyIterable.this.entityTypeId);
            hash.applyDelimiter();
            hash.apply(EntitiesWithPropertyIterable.this.propertyId);
        }

        @Override
        public boolean isMatchedPropertyChanged(int typeId, int propertyId, @Nullable Comparable oldValue, @Nullable Comparable newValue) {
            return EntitiesWithPropertyIterable.this.propertyId == propertyId && EntitiesWithPropertyIterable.this.entityTypeId == typeId;
        }
    }
}

