/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.core.dataStructures.IntArrayList;
import jetbrains.exodus.core.dataStructures.hash.IntHashMap;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.entitystore.PersistentEntity;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.CachedInstanceIterable;
import jetbrains.exodus.entitystore.iterate.ConstantEntityIterableHandle;
import jetbrains.exodus.entitystore.iterate.EntityFromLinkSetIteratorBase;
import jetbrains.exodus.entitystore.iterate.EntityIdArrayCachedInstanceIterable;
import jetbrains.exodus.entitystore.iterate.EntityIdArrayWithSetIteratorWrapper;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableInstantiator;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.EntityLinksIterableBase;
import jetbrains.exodus.entitystore.tables.LinkValue;
import jetbrains.exodus.entitystore.tables.PropertyKey;
import jetbrains.exodus.env.Cursor;
import org.jetbrains.annotations.NotNull;

public class EntityFromLinkSetIterable
extends EntityLinksIterableBase {
    private final IntHashMap<String> linkNames;

    public EntityFromLinkSetIterable(@NotNull PersistentStoreTransaction txn, @NotNull EntityId entityId, @NotNull IntHashMap<String> linkNames) {
        super(txn, entityId);
        this.linkNames = linkNames;
    }

    public static EntityIterableType getType() {
        return EntityIterableType.ENTITY_FROM_LINKS_SET;
    }

    @Override
    public boolean isSortedById() {
        return false;
    }

    @Override
    @NotNull
    public EntityIteratorBase getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        return new LinksIterator(this.openCursor(txn), this.getFirstKey());
    }

    @Override
    @NotNull
    protected EntityIterableHandle getHandleImpl() {
        return new ConstantEntityIterableHandle(this.getStore(), EntityFromLinkSetIterable.getType()){

            @Override
            @NotNull
            public int[] getLinkIds() {
                int linksCount = EntityFromLinkSetIterable.this.linkNames.size();
                if (linksCount == 0) {
                    return EntityIterableHandleBase.LinksFilter.EMPTY_LINKS_ARRAY;
                }
                int[] result = new int[linksCount];
                int i = 0;
                Iterator iterator = EntityFromLinkSetIterable.this.linkNames.keySet().iterator();
                while (iterator.hasNext()) {
                    int id = (Integer)iterator.next();
                    result[i++] = id;
                }
                Arrays.sort(result);
                return result;
            }

            @Override
            public void toString(@NotNull StringBuilder builder) {
                super.toString(builder);
                ((PersistentEntityId)EntityFromLinkSetIterable.this.entityId).toString(builder);
                builder.append('-');
                builder.append(EntityFromLinkSetIterable.this.linkNames.size());
                Iterator iterator = EntityFromLinkSetIterable.this.linkNames.keySet().iterator();
                while (iterator.hasNext()) {
                    int id = (Integer)iterator.next();
                    builder.append('-');
                    builder.append(id);
                }
            }

            @Override
            public void hashCode(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
                ((PersistentEntityId)EntityFromLinkSetIterable.this.entityId).toHash(hash);
                hash.applyDelimiter();
                hash.apply(EntityFromLinkSetIterable.this.linkNames.size());
                Iterator iterator = EntityFromLinkSetIterable.this.linkNames.keySet().iterator();
                while (iterator.hasNext()) {
                    int id = (Integer)iterator.next();
                    hash.applyDelimiter();
                    hash.apply(id);
                }
            }

            @Override
            public boolean isMatchedLinkAdded(@NotNull EntityId source, @NotNull EntityId target, int linkId) {
                return EntityFromLinkSetIterable.this.entityId.equals(source);
            }

            @Override
            public boolean isMatchedLinkDeleted(@NotNull EntityId source, @NotNull EntityId target, int linkId) {
                return EntityFromLinkSetIterable.this.entityId.equals(source);
            }
        };
    }

    @Override
    protected CachedInstanceIterable createCachedInstance(@NotNull PersistentStoreTransaction txn) {
        final IntArrayList propIds = new IntArrayList();
        return new EntityIdArrayCachedInstanceIterable(txn, this){

            @Override
            protected EntityId extractNextId(EntityIterator it) {
                EntityId result = super.extractNextId(it);
                propIds.add(((EntityFromLinkSetIteratorBase)it).currentPropId());
                return result;
            }

            @Override
            @NotNull
            public EntityIteratorBase getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
                return new EntityIdArrayWithSetIteratorWrapper(this, super.getIteratorImpl(txn), propIds, (IntHashMap<String>)EntityFromLinkSetIterable.this.linkNames);
            }
        };
    }

    private Cursor openCursor(@NotNull PersistentStoreTransaction txn) {
        return this.getStore().getLinksFirstIndexCursor(txn, this.entityId.getTypeId());
    }

    private ByteIterable getFirstKey() {
        return PropertyKey.propertyKeyToEntry(new PropertyKey(this.entityId.getLocalId(), 0));
    }

    static {
        EntityFromLinkSetIterable.registerType(EntityFromLinkSetIterable.getType(), new EntityIterableInstantiator(){

            @Override
            public EntityIterableBase instantiate(PersistentStoreTransaction txn, PersistentEntityStoreImpl store, Object[] parameters) {
                Integer linkCount = Integer.valueOf((String)parameters[2]);
                IntHashMap linkNames = new IntHashMap(linkCount.intValue());
                for (int i = 0; i < linkCount; ++i) {
                    linkNames.put(Integer.valueOf((String)parameters[4 + i]), null);
                }
                PersistentEntityId entityId = new PersistentEntityId(Integer.valueOf((String)parameters[0]), Long.valueOf((String)parameters[1]));
                List<String> entityLinkNames = store.getLinkNames(txn, new PersistentEntity(store, entityId));
                for (String linkName : entityLinkNames) {
                    int linkId = store.getLinkId(txn, linkName, false);
                    if (!linkNames.containsKey(linkId)) continue;
                    linkNames.put(linkId, (Object)linkName);
                }
                return new EntityFromLinkSetIterable(txn, entityId, (IntHashMap<String>)linkNames);
            }
        });
    }

    private class LinksIterator
    extends EntityFromLinkSetIteratorBase {
        private boolean hasNext;
        private boolean hasNextValid;
        private int currentPropId;

        private LinksIterator(@NotNull Cursor index, ByteIterable key) {
            super(EntityFromLinkSetIterable.this);
            this.setCursor(index);
            this.hasNextValid = index.getSearchKeyRange(key) == null;
        }

        @Override
        public int currentPropId() {
            return this.currentPropId;
        }

        @Override
        protected String getLinkName(int linkId) {
            return (String)EntityFromLinkSetIterable.this.linkNames.get(linkId);
        }

        @Override
        protected boolean hasNextImpl() {
            if (!this.hasNextValid) {
                this.hasNext = this.hasNextProp();
                this.hasNextValid = true;
            }
            return this.hasNext;
        }

        @Override
        protected EntityId nextIdImpl() {
            if (this.hasNextImpl()) {
                EntityFromLinkSetIterable.this.explain(EntityFromLinkSetIterable.getType());
                LinkValue value = LinkValue.entryToLinkValue(this.getCursor().getValue());
                EntityId result = value.getEntityId();
                if (this.getCursor().getNext()) {
                    this.hasNextValid = false;
                } else {
                    this.hasNext = false;
                }
                return result;
            }
            return null;
        }

        private boolean hasNextProp() {
            Cursor index = this.getCursor();
            do {
                PropertyKey prop;
                if ((prop = PropertyKey.entryToPropertyKey(index.getKey())).getEntityLocalId() != EntityFromLinkSetIterable.this.entityId.getLocalId()) {
                    return false;
                }
                int propId = prop.getPropertyId();
                if (!EntityFromLinkSetIterable.this.linkNames.containsKey(propId)) continue;
                this.currentPropId = propId;
                return true;
            } while (index.getNext());
            return false;
        }
    }
}

