/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.ConstantEntityIterableHandle;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableInstantiator;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.EntityLinksIterableBase;
import jetbrains.exodus.entitystore.iterate.SingleKeyCursorCounter;
import jetbrains.exodus.entitystore.iterate.SingleKeyCursorIsEmptyChecker;
import jetbrains.exodus.entitystore.tables.LinkValue;
import jetbrains.exodus.entitystore.tables.PropertyKey;
import jetbrains.exodus.env.Cursor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityFromLinksIterable
extends EntityLinksIterableBase {
    private final int linkId;

    public EntityFromLinksIterable(@NotNull PersistentStoreTransaction txn, @NotNull EntityId entityId, int linkId) {
        super(txn, entityId);
        this.linkId = linkId;
    }

    public static EntityIterableType getType() {
        return EntityIterableType.ENTITY_FROM_LINKS;
    }

    @Override
    @NotNull
    public EntityIteratorBase getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        return new LinksIterator(this.openCursor(txn), this.getFirstKey());
    }

    @Override
    public boolean nonCachedHasFastCountAndIsEmpty() {
        return true;
    }

    @Override
    @NotNull
    protected EntityIterableHandle getHandleImpl() {
        return new ConstantEntityIterableHandle(this.getStore(), EntityFromLinksIterable.getType()){

            @Override
            @NotNull
            public int[] getLinkIds() {
                return new int[]{EntityFromLinksIterable.this.linkId};
            }

            @Override
            public void toString(@NotNull StringBuilder builder) {
                super.toString(builder);
                ((PersistentEntityId)EntityFromLinksIterable.this.entityId).toString(builder);
                builder.append('-');
                builder.append(EntityFromLinksIterable.this.linkId);
            }

            @Override
            public void hashCode(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
                ((PersistentEntityId)EntityFromLinksIterable.this.entityId).toHash(hash);
                hash.applyDelimiter();
                hash.apply(EntityFromLinksIterable.this.linkId);
            }

            @Override
            public boolean isMatchedLinkAdded(@NotNull EntityId source, @NotNull EntityId target, int linkId) {
                return EntityFromLinksIterable.this.entityId.equals(source);
            }

            @Override
            public boolean isMatchedLinkDeleted(@NotNull EntityId source, @NotNull EntityId target, int linkId) {
                return EntityFromLinksIterable.this.entityId.equals(source);
            }
        };
    }

    @Override
    protected long countImpl(@NotNull PersistentStoreTransaction txn) {
        return new SingleKeyCursorCounter(this.openCursor(txn), this.getFirstKey()).getCount();
    }

    @Override
    public boolean isEmptyImpl(@NotNull PersistentStoreTransaction txn) {
        return new SingleKeyCursorIsEmptyChecker(this.openCursor(txn), this.getFirstKey()).isEmpty();
    }

    private Cursor openCursor(@NotNull PersistentStoreTransaction txn) {
        return this.getStore().getLinksFirstIndexCursor(txn, this.entityId.getTypeId());
    }

    private ByteIterable getFirstKey() {
        return PropertyKey.propertyKeyToEntry(new PropertyKey(this.entityId.getLocalId(), this.linkId));
    }

    static {
        EntityFromLinksIterable.registerType(EntityFromLinksIterable.getType(), new EntityIterableInstantiator(){

            @Override
            public EntityIterableBase instantiate(PersistentStoreTransaction txn, PersistentEntityStoreImpl store, Object[] parameters) {
                return new EntityFromLinksIterable(txn, new PersistentEntityId(Integer.valueOf((String)parameters[0]), Integer.valueOf((String)parameters[1]).intValue()), Integer.valueOf((String)parameters[2]));
            }
        });
    }

    private final class LinksIterator
    extends EntityIteratorBase {
        private boolean hasNext;

        private LinksIterator(@NotNull Cursor index, ByteIterable key) {
            super(EntityFromLinksIterable.this);
            this.setCursor(index);
            this.hasNext = index.getSearchKey(key) != null;
        }

        @Override
        public boolean hasNextImpl() {
            return this.hasNext;
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            if (this.hasNextImpl()) {
                EntityFromLinksIterable.this.explain(EntityFromLinksIterable.getType());
                LinkValue value = LinkValue.entryToLinkValue(this.getCursor().getValue());
                EntityId result = value.getEntityId();
                this.hasNext = this.getCursor().getNextDup();
                return result;
            }
            return null;
        }
    }
}

