/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import java.util.Arrays;
import jetbrains.exodus.core.dataStructures.IntArrayList;
import jetbrains.exodus.core.dataStructures.LongArrayList;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.CachedInstanceIterable;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.NonDisposableEntityIterator;
import jetbrains.exodus.entitystore.util.EntityIdSet;
import jetbrains.exodus.entitystore.util.IntArrayListSpinAllocator;
import jetbrains.exodus.entitystore.util.LongArrayListSpinAllocator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityIdArrayCachedInstanceIterable
extends CachedInstanceIterable {
    private static final int[] EMPTY_TYPE_IDS = new int[0];
    private static final long[] EMPTY_LOCAL_IDS = new long[0];
    private final boolean singleTypeId;
    @NotNull
    private final int[] typeIds;
    @NotNull
    private final long[] localIds;
    private boolean isSortedById;
    @Nullable
    private EntityIdSet idSet;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityIdArrayCachedInstanceIterable(@NotNull PersistentStoreTransaction txn, @NotNull EntityIterableBase source) {
        block35: {
            super(txn, source);
            EntityIteratorBase it = (EntityIteratorBase)source.getIteratorImpl(txn);
            try {
                if (!it.hasNext()) {
                    this.singleTypeId = true;
                    this.isSortedById = true;
                    this.typeIds = EMPTY_TYPE_IDS;
                    this.localIds = EMPTY_LOCAL_IDS;
                    this.idSet = EntityIdSet.EMPTY_SET;
                    break block35;
                }
                IntArrayList typeIds = IntArrayListSpinAllocator.alloc();
                LongArrayList localIds = LongArrayListSpinAllocator.alloc();
                try {
                    if (source.isSortedById()) {
                        int lastTypeId = -1;
                        boolean first = true;
                        EntityId id = this.extractNextId(it);
                        while (true) {
                            int nextTypeId;
                            if (id == null) {
                                nextTypeId = Integer.MIN_VALUE;
                                localIds.add(0L);
                            } else {
                                nextTypeId = id.getTypeId();
                                localIds.add(id.getLocalId());
                            }
                            if (nextTypeId != lastTypeId) {
                                if (lastTypeId != -1) {
                                    first = false;
                                    typeIds.add(localIds.size() - 1);
                                }
                                typeIds.add(nextTypeId);
                                lastTypeId = nextTypeId;
                            }
                            if (!it.hasNext()) {
                                if (first) break;
                                typeIds.add(localIds.size());
                                break;
                            }
                            id = this.extractNextId(it);
                        }
                        this.singleTypeId = first;
                        this.isSortedById = true;
                        this.typeIds = typeIds.toArray();
                        this.localIds = localIds.toArray();
                    } else {
                        int lastTypeId = -1;
                        long lastLocalId = -1L;
                        boolean first = true;
                        boolean localSorted = true;
                        boolean compact = true;
                        EntityId id = this.extractNextId(it);
                        while (true) {
                            int length;
                            long nextLocalId;
                            int nextTypeId;
                            if (id == null) {
                                nextTypeId = Integer.MIN_VALUE;
                                nextLocalId = 0L;
                            } else {
                                nextTypeId = id.getTypeId();
                                nextLocalId = id.getLocalId();
                            }
                            if (localSorted) {
                                if (lastTypeId > nextTypeId || lastTypeId == nextTypeId && lastLocalId > nextLocalId) {
                                    if (nextTypeId == Integer.MIN_VALUE && (length = localIds.size()) <= 1) {
                                        if (length == 1) {
                                            first = false;
                                            localSorted = false;
                                            compact = false;
                                        } else {
                                            typeIds.add(Integer.MIN_VALUE);
                                        }
                                        lastLocalId = nextLocalId;
                                    } else {
                                        localSorted = false;
                                    }
                                } else {
                                    lastLocalId = nextLocalId;
                                }
                            }
                            localIds.add(nextLocalId);
                            if (compact) {
                                if (localSorted) {
                                    if (nextTypeId > lastTypeId) {
                                        if (lastTypeId != -1) {
                                            first = false;
                                            typeIds.add(localIds.size() - 1);
                                        }
                                        typeIds.add(nextTypeId);
                                    }
                                    lastTypeId = nextTypeId;
                                } else {
                                    length = typeIds.size();
                                    if (length > 1 || nextTypeId != lastTypeId) {
                                        first = false;
                                        compact = false;
                                        int[] typeIdsCopy = typeIds.toArray();
                                        int maxBound = localIds.size() - 1;
                                        typeIds.ensureCapacity(maxBound);
                                        typeIds.clear();
                                        int i = 0;
                                        int j = 0;
                                        int currentBound = 0;
                                        int typeId = 0;
                                        while (j < maxBound) {
                                            if (++j > currentBound) {
                                                typeId = typeIdsCopy[i];
                                                currentBound = ++i < length ? typeIdsCopy[i] : maxBound;
                                                ++i;
                                            }
                                            typeIds.add(typeId);
                                        }
                                        typeIds.add(nextTypeId);
                                    }
                                }
                            } else {
                                typeIds.add(nextTypeId);
                            }
                            if (!it.hasNext()) {
                                if (!compact || first) break;
                                typeIds.add(localIds.size());
                                break;
                            }
                            id = this.extractNextId(it);
                        }
                        this.singleTypeId = first;
                        this.isSortedById = localSorted;
                        this.typeIds = typeIds.toArray();
                        this.localIds = localIds.toArray();
                    }
                }
                finally {
                    LongArrayListSpinAllocator.dispose(localIds);
                    IntArrayListSpinAllocator.dispose(typeIds);
                }
                this.idSet = it.toSet();
            }
            finally {
                it.disposeIfShouldBe();
            }
        }
    }

    @Override
    public int getEntityTypeId() {
        if (this.singleTypeId && this.typeIds.length > 0) {
            return this.typeIds[0];
        }
        return super.getEntityTypeId();
    }

    protected EntityId extractNextId(EntityIterator it) {
        return it.nextId();
    }

    @Override
    public boolean isSortedById() {
        return this.isSortedById;
    }

    @Override
    protected int indexOfImpl(@NotNull EntityId entityId) {
        long localId = entityId.getLocalId();
        if (this.isSortedById) {
            if (this.singleTypeId) {
                int result = Arrays.binarySearch(this.localIds, localId);
                if (result >= 0 && this.typeIds[0] == entityId.getTypeId()) {
                    return result;
                }
            } else {
                int typeId = entityId.getTypeId();
                int prevBound = 0;
                int length = this.typeIds.length;
                for (int i = 0; i < length; ++i) {
                    if (this.typeIds[i] == typeId) {
                        int result;
                        if ((result = Arrays.binarySearch(this.localIds, prevBound, this.typeIds[++i], localId)) >= 0) {
                            return result;
                        }
                        break;
                    }
                    prevBound = this.typeIds[++i];
                }
            }
        } else if (this.singleTypeId) {
            if (entityId.getTypeId() == this.typeIds[0]) {
                return LongArrayList.indexOf((long[])this.localIds, (long)localId);
            }
        } else {
            int result = 0;
            do {
                if (this.localIds[result] != localId || this.typeIds[result] != entityId.getTypeId()) continue;
                return result;
            } while (++result < this.localIds.length);
        }
        return -1;
    }

    @Override
    @NotNull
    public EntityIteratorBase getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        if (this.localIds.length == 0) {
            return EntityIteratorBase.EMPTY;
        }
        if (this.singleTypeId) {
            int typeId = this.typeIds[0];
            if (typeId == Integer.MIN_VALUE) {
                return new EntityIdArrayIteratorNullTypeId();
            }
            return new EntityIdArrayIteratorSingleTypeId(typeId);
        }
        if (this.isSortedById) {
            return new EntityIdArrayIteratorPacked();
        }
        return new EntityIdArrayIteratorUnpacked();
    }

    @Override
    @NotNull
    public EntityIteratorBase getReverseIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        if (this.localIds.length == 0) {
            return EntityIteratorBase.EMPTY;
        }
        if (this.singleTypeId) {
            int typeId = this.typeIds[0];
            if (typeId == Integer.MIN_VALUE) {
                return new ReverseEntityIdArrayIteratorNullTypeId();
            }
            return new ReverseEntityIdArrayIteratorSingleTypeId(typeId);
        }
        if (this.isSortedById) {
            return new ReverseEntityIdArrayIteratorPacked();
        }
        return new ReverseEntityIdArrayIteratorUnpacked();
    }

    @Override
    protected void orderById() {
        if (!this.isSortedById && this.singleTypeId && this.localIds.length > 1) {
            Arrays.sort(this.localIds);
            this.isSortedById = true;
        }
    }

    @Override
    protected long countImpl(@NotNull PersistentStoreTransaction txn) {
        return this.localIds.length;
    }

    @Override
    public EntityIdSet toSet(@NotNull PersistentStoreTransaction txn) {
        if (this.idSet == null) {
            EntityIdSet result;
            int count = this.typeIds.length;
            if (count == 0) {
                return EntityIdSet.EMPTY_SET;
            }
            if (count == 1) {
                result = new EntityIdSet();
                int typeId = this.typeIds[0];
                if (typeId == Integer.MIN_VALUE) {
                    result.add(null);
                } else {
                    for (long localId : this.localIds) {
                        result.add(typeId, localId);
                    }
                }
            } else {
                result = new EntityIdSet();
                if (this.isSortedById) {
                    int j = 0;
                    for (int i = 0; i < count; ++i) {
                        int typeId = this.typeIds[i];
                        int upperBound = this.typeIds[++i];
                        if (typeId == Integer.MIN_VALUE) {
                            while (j < upperBound) {
                                result.add(null);
                                ++j;
                            }
                            continue;
                        }
                        while (j < upperBound) {
                            result.add(typeId, this.localIds[j++]);
                        }
                    }
                } else {
                    for (int i = 0; i < count; ++i) {
                        int typeId = this.typeIds[i];
                        if (typeId == Integer.MIN_VALUE) {
                            result.add(null);
                            continue;
                        }
                        result.add(typeId, this.localIds[i]);
                    }
                }
            }
            this.idSet = result;
        }
        return this.idSet;
    }

    private class ReverseEntityIdArrayIteratorUnpacked
    extends NonDisposableEntityIterator {
        private int index;

        private ReverseEntityIdArrayIteratorUnpacked() {
            super(EntityIdArrayCachedInstanceIterable.this);
            this.index = EntityIdArrayCachedInstanceIterable.this.localIds.length;
        }

        @Override
        public boolean skip(int number) {
            this.index -= number;
            return this.hasNextImpl();
        }

        @Override
        @Nullable
        public EntityId nextId() {
            int index = --this.index;
            int typeId = EntityIdArrayCachedInstanceIterable.this.typeIds[index];
            return typeId == Integer.MIN_VALUE ? null : new PersistentEntityId(typeId, EntityIdArrayCachedInstanceIterable.this.localIds[index]);
        }

        @Override
        @Nullable
        public EntityId getLast() {
            int typeId;
            if (EntityIdArrayCachedInstanceIterable.this.localIds.length == 0 || (typeId = EntityIdArrayCachedInstanceIterable.this.typeIds[0]) == Integer.MIN_VALUE) {
                return null;
            }
            return new PersistentEntityId(typeId, EntityIdArrayCachedInstanceIterable.this.localIds[0]);
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            int index = --this.index;
            int typeId = EntityIdArrayCachedInstanceIterable.this.typeIds[index];
            return typeId == Integer.MIN_VALUE ? null : new PersistentEntityId(typeId, EntityIdArrayCachedInstanceIterable.this.localIds[index]);
        }

        @Override
        protected boolean hasNextImpl() {
            return this.index > 0;
        }

        @Override
        protected int getIndex() {
            return this.index;
        }
    }

    private class ReverseEntityIdArrayIteratorPacked
    extends NonDisposableEntityIterator {
        private int index;
        private int typeId;
        private int typeIndex;
        private int currentBound;

        private ReverseEntityIdArrayIteratorPacked() {
            super(EntityIdArrayCachedInstanceIterable.this);
            this.index = EntityIdArrayCachedInstanceIterable.this.localIds.length;
            this.typeIndex = EntityIdArrayCachedInstanceIterable.this.typeIds.length - 1;
            this.currentBound = EntityIdArrayCachedInstanceIterable.this.localIds.length;
        }

        @Override
        public boolean skip(int number) {
            int index;
            this.index = index = this.index - number;
            if (this.hasNextImpl()) {
                while (index <= this.currentBound) {
                    --this.typeIndex;
                    this.typeId = EntityIdArrayCachedInstanceIterable.this.typeIds[this.typeIndex];
                    if (this.typeIndex > 0) {
                        --this.typeIndex;
                        this.currentBound = EntityIdArrayCachedInstanceIterable.this.typeIds[this.typeIndex];
                        continue;
                    }
                    this.currentBound = 0;
                }
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public EntityId nextId() {
            int index;
            if ((index = --this.index) < this.currentBound) {
                --this.typeIndex;
                this.typeId = EntityIdArrayCachedInstanceIterable.this.typeIds[this.typeIndex];
                if (this.typeIndex > 0) {
                    --this.typeIndex;
                    this.currentBound = EntityIdArrayCachedInstanceIterable.this.typeIds[this.typeIndex];
                } else {
                    this.currentBound = 0;
                }
            }
            return this.typeId == Integer.MIN_VALUE ? null : new PersistentEntityId(this.typeId, EntityIdArrayCachedInstanceIterable.this.localIds[index]);
        }

        @Override
        @Nullable
        public EntityId getLast() {
            int typeId;
            if (EntityIdArrayCachedInstanceIterable.this.localIds.length == 0 || (typeId = EntityIdArrayCachedInstanceIterable.this.typeIds[0]) == Integer.MIN_VALUE) {
                return null;
            }
            return new PersistentEntityId(typeId, EntityIdArrayCachedInstanceIterable.this.localIds[0]);
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            int index;
            if ((index = --this.index) < this.currentBound) {
                --this.typeIndex;
                this.typeId = EntityIdArrayCachedInstanceIterable.this.typeIds[this.typeIndex];
                if (this.typeIndex > 0) {
                    --this.typeIndex;
                    this.currentBound = EntityIdArrayCachedInstanceIterable.this.typeIds[this.typeIndex];
                } else {
                    this.currentBound = 0;
                }
            }
            return this.typeId == Integer.MIN_VALUE ? null : new PersistentEntityId(this.typeId, EntityIdArrayCachedInstanceIterable.this.localIds[index]);
        }

        @Override
        protected boolean hasNextImpl() {
            return this.index > 0;
        }

        @Override
        protected int getIndex() {
            return this.index;
        }
    }

    private class ReverseEntityIdArrayIteratorSingleTypeId
    extends NonDisposableEntityIterator {
        private int index;
        private final int typeId;

        private ReverseEntityIdArrayIteratorSingleTypeId(int typeId) {
            super(EntityIdArrayCachedInstanceIterable.this);
            this.index = EntityIdArrayCachedInstanceIterable.this.localIds.length;
            this.typeId = typeId;
        }

        @Override
        public boolean skip(int number) {
            this.index -= number;
            return this.hasNextImpl();
        }

        @Override
        @Nullable
        public EntityId nextId() {
            int index = --this.index;
            return new PersistentEntityId(this.typeId, EntityIdArrayCachedInstanceIterable.this.localIds[index]);
        }

        @Override
        @Nullable
        public EntityId getLast() {
            return new PersistentEntityId(this.typeId, EntityIdArrayCachedInstanceIterable.this.localIds[0]);
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            int index = --this.index;
            return new PersistentEntityId(this.typeId, EntityIdArrayCachedInstanceIterable.this.localIds[index]);
        }

        @Override
        protected boolean hasNextImpl() {
            return this.index > 0;
        }

        @Override
        protected int getIndex() {
            return this.index;
        }
    }

    private class ReverseEntityIdArrayIteratorNullTypeId
    extends NonDisposableEntityIterator {
        private int index;

        private ReverseEntityIdArrayIteratorNullTypeId() {
            super(EntityIdArrayCachedInstanceIterable.this);
            this.index = EntityIdArrayCachedInstanceIterable.this.localIds.length;
        }

        @Override
        public boolean skip(int number) {
            this.index -= number;
            return this.hasNextImpl();
        }

        @Override
        @Nullable
        public EntityId nextId() {
            --this.index;
            return null;
        }

        @Override
        @Nullable
        public EntityId getLast() {
            return null;
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            --this.index;
            return null;
        }

        @Override
        protected boolean hasNextImpl() {
            return this.index > 0;
        }

        @Override
        protected int getIndex() {
            return this.index;
        }
    }

    private class EntityIdArrayIteratorPacked
    extends NonDisposableEntityIterator {
        private int index;
        private int typeId;
        private int typeIndex;
        private int currentBound;

        private EntityIdArrayIteratorPacked() {
            super(EntityIdArrayCachedInstanceIterable.this);
            this.index = 0;
            this.typeIndex = 0;
            this.currentBound = 0;
        }

        @Override
        public boolean skip(int number) {
            int index;
            this.index = index = this.index + number;
            if (this.hasNextImpl()) {
                while (index > this.currentBound) {
                    this.typeId = EntityIdArrayCachedInstanceIterable.this.typeIds[this.typeIndex];
                    ++this.typeIndex;
                    this.currentBound = EntityIdArrayCachedInstanceIterable.this.typeIds[this.typeIndex];
                    ++this.typeIndex;
                }
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public EntityId nextId() {
            int index;
            if ((index = this.index++) >= this.currentBound) {
                this.typeId = EntityIdArrayCachedInstanceIterable.this.typeIds[this.typeIndex];
                ++this.typeIndex;
                this.currentBound = EntityIdArrayCachedInstanceIterable.this.typeIds[this.typeIndex];
                ++this.typeIndex;
            }
            return this.typeId == Integer.MIN_VALUE ? null : new PersistentEntityId(this.typeId, EntityIdArrayCachedInstanceIterable.this.localIds[index]);
        }

        @Override
        @Nullable
        public EntityId getLast() {
            int typeId;
            int count = EntityIdArrayCachedInstanceIterable.this.localIds.length;
            if (count == 0 || (typeId = EntityIdArrayCachedInstanceIterable.this.typeIds[EntityIdArrayCachedInstanceIterable.this.typeIds.length - 2]) == Integer.MIN_VALUE) {
                return null;
            }
            return new PersistentEntityId(typeId, EntityIdArrayCachedInstanceIterable.this.localIds[count - 1]);
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            int index;
            if ((index = this.index++) >= this.currentBound) {
                this.typeId = EntityIdArrayCachedInstanceIterable.this.typeIds[this.typeIndex];
                ++this.typeIndex;
                this.currentBound = EntityIdArrayCachedInstanceIterable.this.typeIds[this.typeIndex];
                ++this.typeIndex;
            }
            return this.typeId == Integer.MIN_VALUE ? null : new PersistentEntityId(this.typeId, EntityIdArrayCachedInstanceIterable.this.localIds[index]);
        }

        @Override
        protected boolean hasNextImpl() {
            return this.index < EntityIdArrayCachedInstanceIterable.this.localIds.length;
        }

        @Override
        protected int getIndex() {
            return this.index;
        }
    }

    private class EntityIdArrayIteratorUnpacked
    extends NonDisposableEntityIterator {
        private int index;

        private EntityIdArrayIteratorUnpacked() {
            super(EntityIdArrayCachedInstanceIterable.this);
            this.index = 0;
        }

        @Override
        public boolean skip(int number) {
            this.index += number;
            return this.hasNextImpl();
        }

        @Override
        @Nullable
        public EntityId nextId() {
            int index = this.index++;
            int typeId = EntityIdArrayCachedInstanceIterable.this.typeIds[index];
            return typeId == Integer.MIN_VALUE ? null : new PersistentEntityId(typeId, EntityIdArrayCachedInstanceIterable.this.localIds[index]);
        }

        @Override
        @Nullable
        public EntityId getLast() {
            int typeId;
            int count = EntityIdArrayCachedInstanceIterable.this.localIds.length;
            if (count == 0 || (typeId = EntityIdArrayCachedInstanceIterable.this.typeIds[EntityIdArrayCachedInstanceIterable.this.typeIds.length - 1]) == Integer.MIN_VALUE) {
                return null;
            }
            return new PersistentEntityId(typeId, EntityIdArrayCachedInstanceIterable.this.localIds[count - 1]);
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            int index = this.index++;
            int typeId = EntityIdArrayCachedInstanceIterable.this.typeIds[index];
            return typeId == Integer.MIN_VALUE ? null : new PersistentEntityId(typeId, EntityIdArrayCachedInstanceIterable.this.localIds[index]);
        }

        @Override
        protected boolean hasNextImpl() {
            return this.index < EntityIdArrayCachedInstanceIterable.this.localIds.length;
        }

        @Override
        protected int getIndex() {
            return this.index;
        }
    }

    private class EntityIdArrayIteratorSingleTypeId
    extends NonDisposableEntityIterator {
        private int index;
        private final int typeId;

        private EntityIdArrayIteratorSingleTypeId(int typeId) {
            super(EntityIdArrayCachedInstanceIterable.this);
            this.index = 0;
            this.typeId = typeId;
        }

        @Override
        public boolean skip(int number) {
            this.index += number;
            return this.hasNextImpl();
        }

        @Override
        @Nullable
        public EntityId nextId() {
            int index = this.index++;
            return new PersistentEntityId(this.typeId, EntityIdArrayCachedInstanceIterable.this.localIds[index]);
        }

        @Override
        @Nullable
        public EntityId getLast() {
            return new PersistentEntityId(this.typeId, EntityIdArrayCachedInstanceIterable.this.localIds[EntityIdArrayCachedInstanceIterable.this.localIds.length - 1]);
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            int index = this.index++;
            return new PersistentEntityId(this.typeId, EntityIdArrayCachedInstanceIterable.this.localIds[index]);
        }

        @Override
        protected boolean hasNextImpl() {
            return this.index < EntityIdArrayCachedInstanceIterable.this.localIds.length;
        }

        @Override
        protected int getIndex() {
            return this.index;
        }
    }

    private class EntityIdArrayIteratorNullTypeId
    extends NonDisposableEntityIterator {
        private int index;

        private EntityIdArrayIteratorNullTypeId() {
            super(EntityIdArrayCachedInstanceIterable.this);
            this.index = 0;
        }

        @Override
        public boolean skip(int number) {
            this.index += number;
            return this.hasNextImpl();
        }

        @Override
        @Nullable
        public EntityId nextId() {
            ++this.index;
            return null;
        }

        @Override
        @Nullable
        public EntityId getLast() {
            return null;
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            ++this.index;
            return null;
        }

        @Override
        protected boolean hasNextImpl() {
            return this.index < EntityIdArrayCachedInstanceIterable.this.localIds.length;
        }

        @Override
        protected int getIndex() {
            return this.index;
        }
    }
}

