/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import java.io.UnsupportedEncodingException;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.PersistentEntityStore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EntityIterableHandleBase
implements EntityIterableHandle {
    private static final int HASH_LONGS_COUNT = 4;
    @Nullable
    private final PersistentEntityStore store;
    @NotNull
    private final EntityIterableType type;
    @Nullable
    private EntityIterableHandleHash hash;
    @NotNull
    private LinksFilter linksFilter;

    protected EntityIterableHandleBase(@Nullable PersistentEntityStore store, @NotNull EntityIterableType type) {
        this.store = store;
        this.type = type;
        this.hash = null;
        this.linksFilter = new InitialLinksFilter();
    }

    @Override
    @NotNull
    public EntityIterableType getType() {
        return this.type;
    }

    @Override
    public final boolean hasLinkId(int id) {
        return this.linksFilter.hasLinkId(id);
    }

    @Nullable
    public PersistentEntityStore getStore() {
        return this.store;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EntityIterableHandle)) {
            return false;
        }
        EntityIterableHandle that = (EntityIterableHandle)obj;
        return this.getIdentity().equals(that.getIdentity());
    }

    public final int hashCode() {
        return this.getIdentity().hashCode();
    }

    @Override
    @NotNull
    public final Object getIdentity() {
        if (this.hash == null) {
            this.hash = new EntityIterableHandleHash(this.store);
            this.hash.apply(this.type.getType());
            if (this.type != EntityIterableType.EMPTY) {
                this.hash.applyDelimiter();
            }
            this.hashCode(this.hash);
            this.hash.computeHashCode();
        }
        return this.hash;
    }

    @Override
    public boolean isMatchedEntityAdded(@NotNull EntityId added) {
        return true;
    }

    @Override
    public boolean isMatchedEntityDeleted(@NotNull EntityId deleted) {
        return true;
    }

    @Override
    public boolean isMatchedPropertyChanged(int typeId, int propertyId, @Nullable Comparable oldValue, @Nullable Comparable newValue) {
        return true;
    }

    @Override
    @NotNull
    public int[] getLinkIds() {
        return LinksFilter.EMPTY_LINKS_ARRAY;
    }

    @Override
    public boolean isExpired() {
        return false;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        this.toString(builder);
        return builder.toString();
    }

    public void toString(@NotNull StringBuilder builder) {
        builder.append(this.type.getType());
        if (this.type != EntityIterableType.EMPTY) {
            builder.append('-');
        }
    }

    public abstract void hashCode(@NotNull EntityIterableHandleHash var1);

    @NotNull
    public static int[] mergeLinkIds(@NotNull int[] left, @NotNull int[] right) {
        int l = left.length;
        if (l == 0) {
            return right;
        }
        int r = right.length;
        if (r == 0) {
            return left;
        }
        int mergedLength = EntityIterableHandleBase.getMergedLength(left, right, l, r);
        if (mergedLength == l) {
            return left;
        }
        if (mergedLength == r) {
            return right;
        }
        return EntityIterableHandleBase.merge(left, right, l, r, new int[mergedLength]);
    }

    private static int getMergedLength(int[] left, int[] right, int l, int r) {
        int k;
        block5: {
            int i = 0;
            int j = 0;
            k = 0;
            while (true) {
                int b;
                int a;
                if ((a = left[i]) <= (b = right[j])) {
                    ++k;
                    if (++i >= l) {
                        if (a == b) {
                            ++j;
                        }
                        k += r - j;
                        break block5;
                    }
                    if (a != b) continue;
                    ++j;
                } else {
                    ++j;
                    ++k;
                }
                if (j >= r) break;
            }
            k += l - i;
        }
        return k;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int[] merge(int[] left, int[] right, int l, int r, int[] result) {
        int i = 0;
        int j = 0;
        int k = 0;
        int a = left[0];
        int b = right[0];
        while (true) {
            block7: {
                block6: {
                    if (a > b) break block6;
                    result[k++] = a;
                    if (++i < l) {
                        boolean neq = a != b;
                        a = left[i];
                        if (neq) continue;
                        ++j;
                        break block7;
                    } else {
                        if (a == b) {
                            ++j;
                        }
                        while (j < r) {
                            result[k++] = right[j++];
                        }
                        return result;
                    }
                }
                ++j;
                result[k++] = b;
            }
            if (j >= r) break;
            b = right[j];
        }
        while (i < l) {
            result[k++] = left[i++];
        }
        return result;
    }

    private static class BinarySearchLinksFilter
    extends BloomLinksFilter {
        private BinarySearchLinksFilter(@NotNull int[] ids) {
            super(ids);
        }

        @Override
        public boolean hasLinkId(int linkId) {
            if (super.hasLinkId(linkId)) {
                int high = this.ids.length - 1;
                int low = 0;
                while (low <= high) {
                    int mid = low + high >>> 1;
                    int midVal = this.ids[mid];
                    if (midVal < linkId) {
                        low = mid + 1;
                        continue;
                    }
                    if (midVal > linkId) {
                        high = mid - 1;
                        continue;
                    }
                    return true;
                }
            }
            return false;
        }
    }

    private static class LinearSearchLinksFilter
    extends BloomLinksFilter {
        private LinearSearchLinksFilter(@NotNull int[] ids) {
            super(ids);
        }

        @Override
        public boolean hasLinkId(int linkId) {
            if (super.hasLinkId(linkId)) {
                for (int id : this.ids) {
                    if (id == linkId) {
                        return true;
                    }
                    if (id > linkId) break;
                }
            }
            return false;
        }
    }

    private static abstract class BloomLinksFilter
    implements LinksFilter {
        protected final int[] ids;
        private final int bloomFilter;

        private BloomLinksFilter(@NotNull int[] ids) {
            this.ids = ids;
            int bloomFilter = 0;
            for (int id : ids) {
                bloomFilter |= 1 << (id & 0x1F);
            }
            this.bloomFilter = bloomFilter;
        }

        @Override
        public boolean hasLinkId(int linkId) {
            return (this.bloomFilter & 1 << (linkId & 0x1F)) != 0;
        }
    }

    private static class SingleLinkFilter
    implements LinksFilter {
        private final int linkId;

        private SingleLinkFilter(int linkId) {
            this.linkId = linkId;
        }

        @Override
        public boolean hasLinkId(int linkId) {
            return linkId == this.linkId;
        }
    }

    private class InitialLinksFilter
    implements LinksFilter {
        private InitialLinksFilter() {
        }

        @Override
        public boolean hasLinkId(int linkId) {
            int[] linkIds = EntityIterableHandleBase.this.getLinkIds();
            int linksCount = linkIds.length;
            if (linksCount == 0) {
                EntityIterableHandleBase.this.linksFilter = TrivialLinksFilter.INSTANCE;
                return false;
            }
            if (linksCount == 1) {
                int singleId = linkIds[0];
                EntityIterableHandleBase.this.linksFilter = new SingleLinkFilter(singleId);
                return singleId == linkId;
            }
            EntityIterableHandleBase.this.linksFilter = linksCount < 4 ? new LinearSearchLinksFilter(linkIds) : new BinarySearchLinksFilter(linkIds);
            return EntityIterableHandleBase.this.linksFilter.hasLinkId(linkId);
        }
    }

    private static class TrivialLinksFilter
    implements LinksFilter {
        public static final LinksFilter INSTANCE = new TrivialLinksFilter();

        private TrivialLinksFilter() {
        }

        @Override
        public boolean hasLinkId(int linkId) {
            return false;
        }
    }

    static interface LinksFilter {
        public static final int[] EMPTY_LINKS_ARRAY = new int[0];

        public boolean hasLinkId(int var1);
    }

    public static final class EntityIterableHandleHash {
        private static final String UTF_8 = "UTF-8";
        private static final byte[][] INTS = new byte[1024][];
        @NotNull
        private final long[] hashLongs = new long[4];
        private int bytesProcessed;
        private int hashCode;

        public EntityIterableHandleHash(@Nullable PersistentEntityStore store) {
            this.hashCode = store == null ? 0 : System.identityHashCode(store);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EntityIterableHandleHash)) {
                return false;
            }
            EntityIterableHandleHash rightHash = (EntityIterableHandleHash)obj;
            if (this.hashCode != rightHash.hashCode) {
                return false;
            }
            long[] rightHashLongs = rightHash.hashLongs;
            for (int i = 0; i < this.hashLongs.length; ++i) {
                if (this.hashLongs[i] == rightHashLongs[i]) continue;
                return false;
            }
            return true;
        }

        public void apply(byte b) {
            int bytesProcessed = this.bytesProcessed;
            if (bytesProcessed < 32) {
                int n = bytesProcessed >> 3 & 3;
                this.hashLongs[n] = this.hashLongs[n] + ((long)(b & 0xFF) << ((bytesProcessed & 7) << 3));
            } else {
                int index = bytesProcessed & 3;
                long hashValue = this.hashLongs[index];
                this.hashLongs[index] = (hashValue << 5) - hashValue + (long)(b & 0xFF);
            }
            this.bytesProcessed = bytesProcessed + 1;
        }

        public void apply(byte[] bytes) {
            for (byte b : bytes) {
                this.apply(b);
            }
        }

        public void apply(int i) {
            if (i >= 0 && i < INTS.length) {
                this.apply(INTS[i]);
            } else {
                this.apply(Integer.toString(i));
            }
        }

        public void apply(long l) {
            if (l >= 0L && l < (long)INTS.length) {
                this.apply(INTS[(int)l]);
            } else {
                this.apply(Long.toString(l));
            }
        }

        public void apply(@NotNull String s) {
            try {
                for (byte b : s.getBytes(UTF_8)) {
                    this.apply(b);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw ExodusException.toExodusException((Throwable)e);
            }
        }

        public void apply(@NotNull EntityIterableHandle source) {
            ((EntityIterableHandleHash)source.getIdentity()).forEachByte(new ByteConsumer(){

                @Override
                public void accept(byte b) {
                    EntityIterableHandleHash.this.apply(b);
                }
            });
        }

        public void applyDelimiter() {
            this.apply((byte)45);
        }

        public String toString() {
            int hashBytes = Math.min(this.bytesProcessed, 32);
            final StringBuilder builder = new StringBuilder(hashBytes);
            this.forEachByte(new ByteConsumer(){

                @Override
                public void accept(byte b) {
                    builder.append((char)b);
                }
            });
            return builder.toString();
        }

        public void computeHashCode() {
            long result = 314159265358L;
            for (long hl : this.hashLongs) {
                result += hl;
            }
            this.hashCode += (int)result;
            this.hashCode += (int)(result >>> 32);
        }

        private void forEachByte(@NotNull ByteConsumer consumer) {
            int hashBytes = Math.min(this.bytesProcessed, 32);
            long hashLong = 0L;
            for (int i = 0; i < hashBytes; ++i) {
                if ((i & 7) == 0) {
                    hashLong = this.hashLongs[i >> 3];
                }
                consumer.accept((byte)(hashLong & 0xFFL));
                hashLong >>= 8;
            }
        }

        static {
            try {
                for (int i = 0; i < INTS.length; ++i) {
                    EntityIterableHandleHash.INTS[i] = Integer.toString(i).getBytes(UTF_8);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw ExodusException.toExodusException((Throwable)e);
            }
        }

        private static interface ByteConsumer {
            public void accept(byte var1);
        }
    }
}

