/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import java.util.NoSuchElementException;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.entitystore.EntityStoreException;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.QueryCancellingPolicy;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.NonDisposableEntityIterator;
import jetbrains.exodus.entitystore.util.EntityIdSet;
import jetbrains.exodus.env.Cursor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EntityIteratorBase
implements EntityIterator {
    public static final EntityIteratorBase EMPTY = new NonDisposableEntityIterator(EntityIterableBase.EMPTY){

        @Override
        public boolean skip(int number) {
            return false;
        }

        @Override
        protected boolean hasNextImpl() {
            return false;
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            return null;
        }
    };
    private static int nextIdCounter = 0;
    @NotNull
    private final EntityIterableBase iterable;
    private boolean finished;
    private boolean disposed;
    private Cursor cursor;

    protected EntityIteratorBase(@NotNull EntityIterableBase iterable) {
        this.iterable = iterable;
        this.cursor = null;
        this.finished = iterable == EntityIterableBase.EMPTY;
        this.disposed = false;
    }

    @NotNull
    public EntityIterableBase getIterable() {
        return this.iterable;
    }

    public final boolean hasNext() {
        try {
            if (this.finished) {
                return false;
            }
            this.checkDisposed();
            boolean result = this.hasNextImpl();
            if (!result) {
                this.finished = true;
                this.disposeIfShouldBe();
            }
            return result;
        }
        catch (ExodusException e) {
            this.disposeIfShouldBe();
            throw e;
        }
    }

    @Nullable
    public Entity next() {
        this.throwNoSuchElementExceptionIfNecessary();
        this.checkDisposed();
        EntityId nextEntityId = this.nextId();
        return nextEntityId == null ? null : this.iterable.getEntity(nextEntityId);
    }

    public void remove() {
        throw new UnsupportedOperationException("EntityIterator.remove() is not supported.");
    }

    public boolean skip(int number) {
        if (this.finished) {
            return false;
        }
        this.checkDisposed();
        try {
            while (number-- > 0 && this.hasNextImpl()) {
                this.nextIdImpl();
            }
            return this.hasNextImpl();
        }
        catch (ExodusException e) {
            this.disposeIfShouldBe();
            throw e;
        }
    }

    @Nullable
    public EntityId nextId() {
        this.throwNoSuchElementExceptionIfNecessary();
        try {
            QueryCancellingPolicy cancellingPolicy;
            if ((++nextIdCounter & 0x1FF) == 0 && (cancellingPolicy = this.iterable.getTransaction().getQueryCancellingPolicy()) != null && cancellingPolicy.needToCancel()) {
                cancellingPolicy.doCancel();
            }
            return this.nextIdImpl();
        }
        catch (ExodusException e) {
            this.disposeIfShouldBe();
            throw e;
        }
    }

    @Nullable
    public EntityId getLast() {
        EntityId result = null;
        while (this.hasNext()) {
            result = this.nextId();
        }
        return result;
    }

    public boolean shouldBeDisposed() {
        return true;
    }

    public boolean dispose() {
        if (!this.disposed) {
            Cursor cursor;
            this.disposed = true;
            PersistentStoreTransaction txn = this.iterable.getStore().getCurrentTransaction();
            if (txn != null) {
                txn.deregisterEntityIterator(this);
            }
            if ((cursor = this.cursor) != null) {
                cursor.close();
                this.cursor = null;
            }
            return true;
        }
        return false;
    }

    public void disposeIfShouldBe() {
        if (this.shouldBeDisposed()) {
            this.dispose();
        }
    }

    protected PersistentEntityStoreImpl getStore() {
        return this.iterable.getStore();
    }

    protected Cursor getCursor() {
        return this.cursor;
    }

    protected void setCursor(@NotNull Cursor cursor) {
        if (this.cursor != null) {
            throw new RuntimeException("EntityIterator: Cursor is already set.");
        }
        this.cursor = cursor;
    }

    protected int getIndex() {
        throw new UnsupportedOperationException();
    }

    @Nullable
    protected EntityIdSet toSet() {
        return null;
    }

    private void throwNoSuchElementExceptionIfNecessary() {
        if (this.finished) {
            throw new NoSuchElementException();
        }
    }

    private void checkDisposed() {
        if (this.disposed) {
            throw new EntityStoreException("Can't access disposed EntityIterator.");
        }
    }

    protected abstract boolean hasNextImpl();

    @Nullable
    protected abstract EntityId nextIdImpl();
}

