/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableDecoratorBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleDecorator;
import jetbrains.exodus.entitystore.iterate.EntityIterableInstantiator;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorFixingDecorator;
import jetbrains.exodus.entitystore.iterate.NonDisposableEntityIterator;
import jetbrains.exodus.entitystore.util.EntityIdSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilterLinksIterable
extends EntityIterableDecoratorBase {
    private final int linkId;
    @NotNull
    private final EntityIterableBase entities;

    public FilterLinksIterable(@NotNull PersistentStoreTransaction txn, int linkId, @NotNull EntityIterableBase source, @NotNull EntityIterable entities) {
        super(txn, source);
        this.linkId = linkId;
        this.entities = ((EntityIterableBase)entities).getSource();
    }

    public static EntityIterableType getType() {
        return EntityIterableType.FILTER_LINKS;
    }

    @Override
    @NotNull
    public EntityIterator getIteratorImpl(final @NotNull PersistentStoreTransaction txn) {
        return new EntityIteratorFixingDecorator(this, new NonDisposableEntityIterator(this){
            @NotNull
            private final EntityIteratorBase sourceIt;
            @Nullable
            private EntityId nextId;
            @Nullable
            private EntityIdSet idSet;
            @NotNull
            private final PersistentEntityStoreImpl store;
            {
                super(iterable);
                this.sourceIt = (EntityIteratorBase)FilterLinksIterable.this.source.iterator();
                this.nextId = PersistentEntityId.EMPTY_ID;
                this.idSet = null;
                this.store = FilterLinksIterable.this.getStore();
            }

            @Override
            protected boolean hasNextImpl() {
                if (this.nextId != PersistentEntityId.EMPTY_ID) {
                    return true;
                }
                while (this.sourceIt.hasNext()) {
                    PersistentEntityId targetId;
                    this.nextId = this.sourceIt.nextId();
                    if (this.nextId == null || (targetId = this.store.getLinkAsEntityId(txn, this.store.getEntity(this.nextId), FilterLinksIterable.this.linkId)) == null || !this.getIdSet().contains(targetId)) continue;
                    return true;
                }
                return false;
            }

            @Override
            protected EntityId nextIdImpl() {
                EntityId result = this.nextId;
                this.nextId = PersistentEntityId.EMPTY_ID;
                return result;
            }

            @NotNull
            private EntityIdSet getIdSet() {
                if (this.idSet == null) {
                    this.idSet = FilterLinksIterable.this.entities.toSet(txn);
                }
                return this.idSet;
            }
        });
    }

    @Override
    @NotNull
    protected EntityIterableHandle getHandleImpl() {
        return new EntityIterableHandleDecorator(this.getStore(), FilterLinksIterable.getType(), this.source.getHandle()){

            @Override
            public void toString(@NotNull StringBuilder builder) {
                super.toString(builder);
                builder.append(FilterLinksIterable.this.linkId);
                builder.append('-');
                this.applyDecoratedToBuilder(builder);
                builder.append('-');
                ((EntityIterableHandleBase)FilterLinksIterable.this.entities.getHandle()).toString(builder);
            }

            @Override
            public void hashCode(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
                hash.apply(FilterLinksIterable.this.linkId);
                hash.applyDelimiter();
                super.hashCode(hash);
                hash.applyDelimiter();
                hash.apply(FilterLinksIterable.this.entities.getHandle());
            }
        };
    }

    @Override
    public boolean isSortedById() {
        return this.source.isSortedById();
    }

    @Override
    public boolean canBeCached() {
        return false;
    }

    static {
        FilterLinksIterable.registerType(FilterLinksIterable.getType(), new EntityIterableInstantiator(){

            @Override
            public EntityIterableBase instantiate(PersistentStoreTransaction txn, PersistentEntityStoreImpl store, Object[] parameters) {
                return new FilterLinksIterable(txn, Integer.valueOf((String)parameters[0]), (EntityIterableBase)parameters[1], (EntityIterable)parameters[2]);
            }
        });
    }
}

