/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.ComparableBinding;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.ConstantEntityIterableHandle;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableInstantiator;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.PropertyRangeOrValueIterableBase;
import jetbrains.exodus.entitystore.iterate.SingleKeyCursorCounter;
import jetbrains.exodus.entitystore.iterate.SingleKeyCursorIsEmptyChecker;
import jetbrains.exodus.entitystore.iterate.UpdatablePropertiesCachedInstanceIterable;
import jetbrains.exodus.entitystore.tables.PropertyTypes;
import jetbrains.exodus.env.Cursor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PropertyValueIterable
extends PropertyRangeOrValueIterableBase {
    @NotNull
    private final Comparable value;

    public PropertyValueIterable(@NotNull PersistentStoreTransaction txn, int entityTypeId, int propertyId, @NotNull Comparable value) {
        super(txn, entityTypeId, propertyId);
        this.value = PropertyTypes.toLowerCase(value);
    }

    @Override
    @NotNull
    public EntityIteratorBase getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        EntityIterableBase it = this.getPropertyValueIndex();
        if (it.isCachedInstance()) {
            UpdatablePropertiesCachedInstanceIterable cached = (UpdatablePropertiesCachedInstanceIterable)it;
            if (this.value.getClass() != cached.getPropertyValueClass()) {
                return EntityIteratorBase.EMPTY;
            }
            return cached.getPropertyValueIterator(this.value);
        }
        Cursor valueIdx = this.openCursor(txn);
        if (valueIdx == null) {
            return EntityIteratorBase.EMPTY;
        }
        return new PropertyValueIterator(valueIdx);
    }

    @Override
    public boolean nonCachedHasFastCountAndIsEmpty() {
        return true;
    }

    @Override
    @NotNull
    protected EntityIterableHandle getHandleImpl() {
        final int entityTypeId = this.getEntityTypeId();
        final int propertyId = this.getPropertyId();
        return new ConstantEntityIterableHandle(this.getStore(), PropertyValueIterable.getType()){

            @Override
            public void toString(@NotNull StringBuilder builder) {
                super.toString(builder);
                builder.append(entityTypeId);
                builder.append('-');
                builder.append(propertyId);
                builder.append('-');
                builder.append(PropertyValueIterable.this.value.toString());
            }

            @Override
            public void hashCode(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
                hash.apply(entityTypeId);
                hash.applyDelimiter();
                hash.apply(propertyId);
                hash.applyDelimiter();
                hash.apply(PropertyValueIterable.this.value.toString());
            }

            @Override
            public boolean isMatchedPropertyChanged(int typeId, int propId, @Nullable Comparable oldValue, @Nullable Comparable newValue) {
                return propertyId == propId && entityTypeId == typeId && (this.isValueMatched(oldValue) || this.isValueMatched(newValue));
            }

            private boolean isValueMatched(Comparable value) {
                if (value == null) {
                    return false;
                }
                return (value = PropertyTypes.toLowerCase(value)).compareTo(PropertyValueIterable.this.value) == 0;
            }
        };
    }

    @Override
    protected long countImpl(@NotNull PersistentStoreTransaction txn) {
        ArrayByteIterable key = this.getStore().getPropertyTypes().dataToPropertyValue(this.value).dataToEntry();
        Cursor valueIdx = this.openCursor(txn);
        return valueIdx == null ? 0L : new SingleKeyCursorCounter(valueIdx, (ByteIterable)key).getCount();
    }

    @Override
    public boolean isEmptyImpl(@NotNull PersistentStoreTransaction txn) {
        ArrayByteIterable key = this.getStore().getPropertyTypes().dataToPropertyValue(this.value).dataToEntry();
        Cursor valueIdx = this.openCursor(txn);
        return valueIdx == null || new SingleKeyCursorIsEmptyChecker(valueIdx, (ByteIterable)key).isEmpty();
    }

    private static EntityIterableType getType() {
        return EntityIterableType.ENTITIES_BY_PROP_VALUE;
    }

    static {
        PropertyValueIterable.registerType(PropertyValueIterable.getType(), new EntityIterableInstantiator(){

            @Override
            public EntityIterableBase instantiate(PersistentStoreTransaction txn, PersistentEntityStoreImpl store, Object[] parameters) {
                try {
                    return new PropertyValueIterable(txn, Integer.valueOf((String)parameters[0]), Integer.valueOf((String)parameters[1]), Long.valueOf(Long.parseLong((String)parameters[2])));
                }
                catch (NumberFormatException e) {
                    return new PropertyValueIterable(txn, Integer.valueOf((String)parameters[0]), Integer.valueOf((String)parameters[1]), (Comparable)parameters[2]);
                }
            }
        });
    }

    private final class PropertyValueIterator
    extends EntityIteratorBase {
        private boolean hasNext;
        @NotNull
        private final ComparableBinding binding;

        private PropertyValueIterator(Cursor cursor) {
            super(PropertyValueIterable.this);
            this.setCursor(cursor);
            this.binding = this.getStore().getPropertyTypes().dataToPropertyValue(PropertyValueIterable.this.value).getBinding();
            ArrayByteIterable key = this.binding.objectToEntry(PropertyValueIterable.this.value);
            this.checkHasNext(this.getCursor().getSearchKey((ByteIterable)key) != null);
        }

        @Override
        public boolean hasNextImpl() {
            return this.hasNext;
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            if (this.hasNextImpl()) {
                PropertyValueIterable.this.explain(PropertyValueIterable.getType());
                Cursor cursor = this.getCursor();
                PersistentEntityId result = new PersistentEntityId(PropertyValueIterable.this.getEntityTypeId(), LongBinding.compressedEntryToLong((ByteIterable)cursor.getValue()));
                this.checkHasNext(cursor.getNextDup());
                return result;
            }
            return null;
        }

        private void checkHasNext(boolean success) {
            this.hasNext = success && PropertyValueIterable.this.value.compareTo(this.binding.entryToObject(this.getCursor().getKey())) == 0;
        }
    }
}

