/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.core.dataStructures.hash.IntHashMap;
import jetbrains.exodus.core.dataStructures.hash.ObjectProcedure;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableDecoratorBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleDecorator;
import jetbrains.exodus.entitystore.iterate.EntityIterableInstantiator;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorFixingDecorator;
import jetbrains.exodus.entitystore.tables.LinkValue;
import jetbrains.exodus.entitystore.tables.PropertyKey;
import jetbrains.exodus.entitystore.util.EntityIdSet;
import jetbrains.exodus.env.Cursor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SelectDistinctIterable
extends EntityIterableDecoratorBase {
    private final int linkId;

    public SelectDistinctIterable(@NotNull PersistentStoreTransaction txn, @NotNull EntityIterableBase source, int linkId) {
        super(txn, source);
        this.linkId = linkId;
    }

    public static EntityIterableType getType() {
        return EntityIterableType.SELECT_DISTINCT;
    }

    @Override
    public boolean isEmpty() {
        return this.source.isEmpty();
    }

    @Override
    @NotNull
    public EntityIteratorBase getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        return new EntityIteratorFixingDecorator(this, new SelectDistinctIterator(txn));
    }

    @Override
    @NotNull
    protected EntityIterableHandle getHandleImpl() {
        return new EntityIterableHandleDecorator(this.getStore(), SelectDistinctIterable.getType(), this.source.getHandle()){
            @NotNull
            private final int[] linkIds;
            {
                this.linkIds = 2.mergeLinkIds(new int[]{SelectDistinctIterable.this.linkId}, this.decorated.getLinkIds());
            }

            @Override
            @NotNull
            public int[] getLinkIds() {
                return this.linkIds;
            }

            @Override
            public void toString(@NotNull StringBuilder builder) {
                super.toString(builder);
                this.applyDecoratedToBuilder(builder);
                builder.append('-');
                builder.append(SelectDistinctIterable.this.linkId);
            }

            @Override
            public void hashCode(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
                super.hashCode(hash);
                hash.applyDelimiter();
                hash.apply(SelectDistinctIterable.this.linkId);
            }

            @Override
            public boolean isMatchedEntityAdded(@NotNull EntityId added) {
                return this.decorated.isMatchedEntityAdded(added);
            }

            @Override
            public boolean isMatchedEntityDeleted(@NotNull EntityId deleted) {
                return this.decorated.isMatchedEntityDeleted(deleted);
            }

            @Override
            public boolean isMatchedLinkAdded(@NotNull EntityId source, @NotNull EntityId target, int linkId) {
                return linkId == SelectDistinctIterable.this.linkId || this.decorated.isMatchedLinkAdded(source, target, linkId);
            }

            @Override
            public boolean isMatchedLinkDeleted(@NotNull EntityId source, @NotNull EntityId target, int linkId) {
                return linkId == SelectDistinctIterable.this.linkId || this.decorated.isMatchedLinkDeleted(source, target, linkId);
            }

            @Override
            public boolean isMatchedPropertyChanged(int typeId, int propertyId, @Nullable Comparable oldValue, @Nullable Comparable newValue) {
                return this.decorated.isMatchedPropertyChanged(typeId, propertyId, oldValue, newValue);
            }
        };
    }

    static {
        SelectDistinctIterable.registerType(SelectDistinctIterable.getType(), new EntityIterableInstantiator(){

            @Override
            public EntityIterableBase instantiate(PersistentStoreTransaction txn, PersistentEntityStoreImpl store, Object[] parameters) {
                return new SelectDistinctIterable(txn, (EntityIterableBase)parameters[1], Integer.valueOf((String)parameters[0]));
            }
        });
    }

    private class SelectDistinctIterator
    extends EntityIteratorBase {
        @NotNull
        private final EntityIteratorBase sourceIt;
        @NotNull
        private final IntHashMap<Cursor> usedCursors;
        private final EntityIdSet iterated;
        private EntityId nextId;
        @NotNull
        private final PersistentStoreTransaction txn;

        private SelectDistinctIterator(PersistentStoreTransaction txn) {
            super(SelectDistinctIterable.this);
            this.sourceIt = (EntityIteratorBase)SelectDistinctIterable.this.source.iterator();
            this.usedCursors = new IntHashMap();
            this.iterated = new EntityIdSet();
            this.nextId = null;
            this.txn = txn;
        }

        @Override
        protected boolean hasNextImpl() {
            if (SelectDistinctIterable.this.linkId < 0) {
                return !this.iterated.contains(null) && this.sourceIt.hasNext();
            }
            while (this.sourceIt.hasNext()) {
                ArrayByteIterable keyEntry;
                ByteIterable value;
                EntityId nextSourceId = this.sourceIt.nextId();
                if (nextSourceId == null) continue;
                int typeId = nextSourceId.getTypeId();
                Cursor cursor = (Cursor)this.usedCursors.get(typeId);
                if (cursor == null) {
                    cursor = this.getStore().getLinksFirstIndexCursor(this.txn, typeId);
                    this.usedCursors.put(typeId, (Object)cursor);
                }
                if ((value = cursor.getSearchKey((ByteIterable)(keyEntry = PropertyKey.propertyKeyToEntry(new PropertyKey(nextSourceId.getLocalId(), SelectDistinctIterable.this.linkId))))) == null) {
                    if (this.iterated.contains(null)) continue;
                    this.nextId = null;
                    return true;
                }
                LinkValue linkValue = LinkValue.entryToLinkValue(value);
                EntityId nextId = linkValue.getEntityId();
                if (this.iterated.contains(nextId)) continue;
                this.nextId = nextId;
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            EntityId nextId = this.nextId;
            this.iterated.add(nextId);
            return nextId;
        }

        @Override
        public boolean dispose() {
            this.sourceIt.disposeIfShouldBe();
            return super.dispose() && this.usedCursors.forEachValue((ObjectProcedure)new ObjectProcedure<Cursor>(){

                public boolean execute(Cursor object) {
                    object.close();
                    return true;
                }
            });
        }

        @Override
        @Nullable
        protected EntityIdSet toSet() {
            return this.iterated;
        }
    }
}

