/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import java.util.Iterator;
import java.util.Set;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.core.dataStructures.hash.IntHashMap;
import jetbrains.exodus.core.dataStructures.hash.LinkedHashSet;
import jetbrains.exodus.core.dataStructures.hash.ObjectProcedure;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableDecoratorBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleDecorator;
import jetbrains.exodus.entitystore.iterate.EntityIterableInstantiator;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorFixingDecorator;
import jetbrains.exodus.entitystore.tables.LinkValue;
import jetbrains.exodus.entitystore.tables.PropertyKey;
import jetbrains.exodus.env.Cursor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectManyDistinctIterable
extends EntityIterableDecoratorBase {
    private final int linkId;

    public SelectManyDistinctIterable(@NotNull PersistentStoreTransaction txn, @NotNull EntityIterableBase source, int linkId) {
        super(txn, source);
        this.linkId = linkId;
    }

    public static EntityIterableType getType() {
        return EntityIterableType.SELECTMANY_DISTINCT;
    }

    @Override
    @NotNull
    public EntityIteratorBase getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        return new EntityIteratorFixingDecorator(this, new SelectManyDistinctIterator(txn));
    }

    @Override
    @NotNull
    protected EntityIterableHandle getHandleImpl() {
        return new EntityIterableHandleDecorator(this.getStore(), SelectManyDistinctIterable.getType(), this.source.getHandle()){
            @NotNull
            private final int[] linkIds;
            {
                this.linkIds = 2.mergeLinkIds(new int[]{SelectManyDistinctIterable.this.linkId}, this.decorated.getLinkIds());
            }

            @Override
            @NotNull
            public int[] getLinkIds() {
                return this.linkIds;
            }

            @Override
            public void toString(@NotNull StringBuilder builder) {
                super.toString(builder);
                this.applyDecoratedToBuilder(builder);
                builder.append('-');
                builder.append(SelectManyDistinctIterable.this.linkId);
            }

            @Override
            public void hashCode(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
                super.hashCode(hash);
                hash.applyDelimiter();
                hash.apply(SelectManyDistinctIterable.this.linkId);
            }

            @Override
            public boolean isMatchedEntityAdded(@NotNull EntityId added) {
                return this.decorated.isMatchedEntityAdded(added);
            }

            @Override
            public boolean isMatchedEntityDeleted(@NotNull EntityId deleted) {
                return this.decorated.isMatchedEntityDeleted(deleted);
            }

            @Override
            public boolean isMatchedLinkAdded(@NotNull EntityId source, @NotNull EntityId target, int linkId) {
                return linkId == SelectManyDistinctIterable.this.linkId || this.decorated.isMatchedLinkAdded(source, target, linkId);
            }

            @Override
            public boolean isMatchedLinkDeleted(@NotNull EntityId source, @NotNull EntityId target, int linkId) {
                return linkId == SelectManyDistinctIterable.this.linkId || this.decorated.isMatchedLinkDeleted(source, target, linkId);
            }

            @Override
            public boolean isMatchedPropertyChanged(int typeId, int propertyId, @Nullable Comparable oldValue, @Nullable Comparable newValue) {
                return this.decorated.isMatchedPropertyChanged(typeId, propertyId, oldValue, newValue);
            }
        };
    }

    static {
        SelectManyDistinctIterable.registerType(SelectManyDistinctIterable.getType(), new EntityIterableInstantiator(){

            @Override
            public EntityIterableBase instantiate(PersistentStoreTransaction txn, PersistentEntityStoreImpl store, Object[] parameters) {
                return new SelectManyDistinctIterable(txn, (EntityIterableBase)parameters[1], Integer.valueOf((String)parameters[0]));
            }
        });
    }

    private class SelectManyDistinctIterator
    extends EntityIteratorBase {
        @NotNull
        private final EntityIteratorBase sourceIt;
        @NotNull
        private final IntHashMap<Cursor> usedCursors;
        private Set<EntityId> usedIds;
        @NotNull
        private final PersistentStoreTransaction txn;

        private SelectManyDistinctIterator(PersistentStoreTransaction txn) {
            super(SelectManyDistinctIterable.this);
            this.sourceIt = (EntityIteratorBase)SelectManyDistinctIterable.this.source.iterator();
            this.usedCursors = new IntHashMap();
            this.usedIds = null;
            this.txn = txn;
        }

        @Override
        protected boolean hasNextImpl() {
            if (this.usedIds == null) {
                this.collectIds();
            }
            return !this.usedIds.isEmpty();
        }

        private void collectIds() {
            LinkedHashSet usedIds;
            this.usedIds = usedIds = new LinkedHashSet();
            EntityIteratorBase sourceIt = this.sourceIt;
            int linkId = SelectManyDistinctIterable.this.linkId;
            if (linkId >= 0) {
                block0: while (sourceIt.hasNext()) {
                    long sourceLocalId;
                    ByteIterable value;
                    EntityId nextId = sourceIt.nextId();
                    if (nextId == null) continue;
                    int typeId = nextId.getTypeId();
                    Cursor cursor = (Cursor)this.usedCursors.get(typeId);
                    if (cursor == null) {
                        cursor = this.getStore().getLinksFirstIndexCursor(this.txn, typeId);
                        this.usedCursors.put(typeId, (Object)cursor);
                    }
                    if ((value = cursor.getSearchKey((ByteIterable)PropertyKey.propertyKeyToEntry(new PropertyKey(sourceLocalId = nextId.getLocalId(), linkId)))) == null) {
                        usedIds.add(null);
                        continue;
                    }
                    while (true) {
                        PropertyKey key;
                        LinkValue linkValue = LinkValue.entryToLinkValue(value);
                        nextId = linkValue.getEntityId();
                        usedIds.add(nextId);
                        if (!cursor.getNext() || (key = PropertyKey.entryToPropertyKey(cursor.getKey())).getPropertyId() != linkId || key.getEntityLocalId() != sourceLocalId) continue block0;
                        value = cursor.getValue();
                    }
                }
            }
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            Iterator<EntityId> it = this.usedIds.iterator();
            if (it.hasNext()) {
                EntityId id = it.next();
                this.usedIds.remove(id);
                return id;
            }
            return null;
        }

        @Override
        public boolean dispose() {
            this.sourceIt.disposeIfShouldBe();
            return super.dispose() && this.usedCursors.forEachValue((ObjectProcedure)new ObjectProcedure<Cursor>(){

                public boolean execute(Cursor object) {
                    object.close();
                    return true;
                }
            });
        }
    }
}

