/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.PriorityQueue;
import jetbrains.exodus.core.dataStructures.hash.HashMap;
import jetbrains.exodus.core.dataStructures.hash.LongHashSet;
import jetbrains.exodus.core.dataStructures.hash.LongIterator;
import jetbrains.exodus.core.dataStructures.hash.LongSet;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableDecoratorBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleDecorator;
import jetbrains.exodus.entitystore.iterate.EntityIterableInstantiator;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorFixingDecorator;
import jetbrains.exodus.entitystore.iterate.EntityTypeFilteredIterator;
import jetbrains.exodus.entitystore.iterate.NonDisposableEntityIterator;
import jetbrains.exodus.entitystore.iterate.PropertyValueIterator;
import jetbrains.exodus.entitystore.util.EntityIdSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SortIterable
extends EntityIterableDecoratorBase {
    @NotNull
    private final EntityIterableBase propIndex;
    private final int sourceTypeId;
    private final int propertyId;
    private final boolean ascending;

    public SortIterable(@NotNull PersistentStoreTransaction txn, @NotNull EntityIterableBase propIndex, @NotNull EntityIterableBase source, int sourceTypeId, boolean ascending) {
        this(txn, propIndex, source, sourceTypeId, -1, ascending);
    }

    public SortIterable(@NotNull PersistentStoreTransaction txn, @NotNull EntityIterableBase propIndex, @NotNull EntityIterableBase source, int sourceTypeId, int propertyId, boolean ascending) {
        super(txn, source);
        this.propIndex = propIndex;
        this.sourceTypeId = sourceTypeId;
        this.propertyId = propertyId;
        this.ascending = ascending;
    }

    @Override
    public boolean setOrigin(Object origin) {
        if (super.setOrigin(origin)) {
            this.propIndex.setOrigin(origin);
            return true;
        }
        return false;
    }

    public static EntityIterableType getType() {
        return EntityIterableType.SORTING;
    }

    @Override
    public boolean isEmpty() {
        return this.source.isEmpty();
    }

    @Override
    public long size() {
        return this.source.size();
    }

    @Override
    public long count() {
        return this.source.count();
    }

    @Override
    protected long countImpl(@NotNull PersistentStoreTransaction txn) {
        int count = 0;
        EntityTypeFilteredIterator sorted = new EntityTypeFilteredIterator(this.source, this.sourceTypeId);
        while (sorted.hasNext()) {
            sorted.nextId();
            ++count;
        }
        return count;
    }

    @Override
    @NotNull
    public EntityIterator getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        EntityIterator propIterator;
        if (this.propIndex == EntityIterableBase.EMPTY) {
            return new EntityTypeFilteredIterator(this.source, this.sourceTypeId);
        }
        PersistentEntityStoreImpl store = this.getStore();
        EntityIterableBase cached = store.getEntityIterableCache().putIfNotCached(this.propIndex);
        EntityIterator entityIterator = propIterator = this.ascending ? cached.getIteratorImpl(txn) : cached.getReverseIteratorImpl(txn);
        if (propIterator.shouldBeDisposed()) {
            store.getAndCheckCurrentTransaction().registerEntityIterator(propIterator);
        }
        if (propIterator == EntityIteratorBase.EMPTY) {
            return new EntityTypeFilteredIterator(this.source, this.sourceTypeId);
        }
        if (this.source.isSortResult()) {
            StableSortIterator itr = new StableSortIterator((PropertyValueIterator)propIterator);
            return new PropertyValueIteratorFixingDecorator(this, itr, itr);
        }
        return new EntityIteratorFixingDecorator(this, new NonStableSortIterator(txn, propIterator));
    }

    @Override
    @NotNull
    protected EntityIterableHandle getHandleImpl() {
        return new EntityIterableHandleDecorator(this.getStore(), SortIterable.getType(), this.source.getHandle()){

            @Override
            public void toString(@NotNull StringBuilder builder) {
                super.toString(builder);
                builder.append(SortIterable.this.sourceTypeId);
                builder.append('-');
                builder.append(SortIterable.this.propertyId);
                builder.append('-');
                this.applyDecoratedToBuilder(builder);
                builder.append('-');
                builder.append(SortIterable.this.ascending ? 0 : 1);
            }

            @Override
            public void hashCode(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
                hash.apply(SortIterable.this.sourceTypeId);
                hash.applyDelimiter();
                hash.apply(SortIterable.this.propertyId);
                hash.applyDelimiter();
                super.hashCode(hash);
                hash.applyDelimiter();
                hash.apply(SortIterable.this.ascending ? 0 : 1);
            }

            @Override
            public boolean isMatchedPropertyChanged(int typeId, int propertyId, @Nullable Comparable oldValue, @Nullable Comparable newValue) {
                return SortIterable.this.sourceTypeId == typeId && (this.decorated.isMatchedPropertyChanged(typeId, propertyId, oldValue, newValue) || SortIterable.this.propIndex.getHandle().isMatchedPropertyChanged(typeId, propertyId, oldValue, newValue));
            }
        };
    }

    @Override
    public boolean canBeCached() {
        return true;
    }

    @NotNull
    private Map<EntityId, Integer> getRightOrder() {
        HashMap result = new HashMap();
        int position = 0;
        EntityIterator sorted = this.source.iterator();
        while (sorted.hasNext()) {
            EntityId entityId = sorted.nextId();
            if (entityId != null && this.sourceTypeId != entityId.getTypeId()) continue;
            result.put(entityId, ++position);
        }
        return result;
    }

    static {
        SortIterable.registerType(SortIterable.getType(), new EntityIterableInstantiator(){

            @Override
            public EntityIterableBase instantiate(PersistentStoreTransaction txn, PersistentEntityStoreImpl store, Object[] parameters) {
                return new SortIterable(txn, (EntityIterableBase)parameters[3], (EntityIterableBase)parameters[3], Integer.valueOf((String)parameters[0]), Integer.valueOf((String)parameters[1]), "0".equals(parameters[2]));
            }
        });
    }

    private static final class PropertyValueIteratorFixingDecorator
    extends NonDisposableEntityIterator
    implements PropertyValueIterator {
        private final PropertyValueIterator index;
        private final EntityIteratorBase iterator;
        private boolean hasNext;
        private boolean hasNextValid;

        public PropertyValueIteratorFixingDecorator(@NotNull EntityIterableBase iterable, @NotNull PropertyValueIterator index, @NotNull EntityIteratorBase iterator) {
            super(iterable);
            this.index = index;
            this.iterator = iterator;
        }

        @Override
        protected boolean hasNextImpl() {
            if (!this.hasNextValid) {
                this.hasNext = this.iterator.hasNextImpl();
                this.hasNextValid = true;
            }
            return this.hasNext;
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            EntityId result = this.hasNextImpl() ? this.iterator.nextIdImpl() : null;
            this.hasNextValid = false;
            return result;
        }

        @Override
        public Comparable currentValue() {
            return this.index.currentValue();
        }
    }

    private final class NonStableSortIterator
    extends NonDisposableEntityIterator {
        @NotNull
        private final EntityIterator propIterator;
        private EntityId nextId;
        private final LongSet rightOrder;
        private LongIterator rightOrderIt;
        private boolean hasNull;

        private NonStableSortIterator(@NotNull PersistentStoreTransaction txn, EntityIterator propIterator) {
            super(SortIterable.this.propIndex);
            this.propIterator = propIterator;
            EntityIdSet sourceSet = SortIterable.this.source.toSet(txn);
            this.hasNull = sourceSet.contains(null);
            LongSet rightOrder = sourceSet.getTypeSet(SortIterable.this.sourceTypeId);
            if (rightOrder == null) {
                this.rightOrder = LongSet.EMPTY;
            } else {
                this.rightOrder = new LongHashSet(rightOrder.size());
                LongIterator longIterator = rightOrder.iterator();
                while (longIterator.hasNext()) {
                    long localId = (Long)longIterator.next();
                    this.rightOrder.add(localId);
                }
            }
            this.nextId = null;
        }

        @Override
        protected boolean hasNextImpl() {
            LongIterator it;
            LongSet rightOrder = this.rightOrder;
            while (!rightOrder.isEmpty() && this.propIterator.hasNext()) {
                EntityId nextId = this.propIterator.nextId();
                if (nextId == null || !rightOrder.remove(nextId.getLocalId())) continue;
                this.nextId = nextId;
                return true;
            }
            if (this.rightOrderIt == null) {
                this.rightOrderIt = rightOrder.iterator();
            }
            if ((it = this.rightOrderIt).hasNext()) {
                long localId = it.nextLong();
                this.nextId = new PersistentEntityId(SortIterable.this.sourceTypeId, localId);
                return true;
            }
            if (this.hasNull) {
                this.nextId = null;
                this.hasNull = false;
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            return this.nextId;
        }
    }

    private final class StableSortIterator
    extends NonDisposableEntityIterator
    implements PropertyValueIterator {
        @NotNull
        private final PropertyValueIterator propertyValueIterator;
        private final PriorityQueue<EntityId> sameValueQueue;
        private final Map<EntityId, Integer> rightOrder;
        private EntityId nextId;
        private Comparable currentValue;
        private Comparable lastValue;
        private EntityId lastEntityId;

        private StableSortIterator(PropertyValueIterator propertyValueIterator) {
            super(SortIterable.this.propIndex);
            this.propertyValueIterator = propertyValueIterator;
            this.sameValueQueue = new PriorityQueue<EntityId>(4, new Comparator<EntityId>(){

                @Override
                public int compare(EntityId o1, EntityId o2) {
                    return (Integer)StableSortIterator.this.rightOrder.get(o1) - (Integer)StableSortIterator.this.rightOrder.get(o2);
                }
            });
            this.rightOrder = SortIterable.this.getRightOrder();
            this.nextId = null;
            this.currentValue = null;
            this.lastValue = null;
            this.lastEntityId = null;
        }

        @Override
        protected boolean hasNextImpl() {
            PriorityQueue<EntityId> sameValueQueue = this.sameValueQueue;
            Map<EntityId, Integer> rightOrder = this.rightOrder;
            if (sameValueQueue.isEmpty()) {
                Comparable lastValue = this.lastValue;
                if (lastValue != null) {
                    this.currentValue = lastValue;
                    sameValueQueue.offer(this.lastEntityId);
                    this.lastValue = null;
                    this.lastEntityId = null;
                }
                while (this.propertyValueIterator.hasNext()) {
                    EntityId nextId = this.propertyValueIterator.nextId();
                    if (!rightOrder.containsKey(nextId)) continue;
                    Comparable currentValue = this.propertyValueIterator.currentValue();
                    if (currentValue != null && lastValue != null && lastValue.compareTo(currentValue) != 0) {
                        this.lastValue = currentValue;
                        this.lastEntityId = nextId;
                        break;
                    }
                    lastValue = currentValue;
                    this.currentValue = currentValue;
                    sameValueQueue.offer(nextId);
                }
            }
            block1: while (true) {
                if (!sameValueQueue.isEmpty()) {
                    EntityId id;
                    this.nextId = id = sameValueQueue.poll();
                    rightOrder.remove(id);
                    return true;
                }
                this.currentValue = null;
                if (rightOrder.isEmpty()) break;
                Iterator<EntityId> iterator = rightOrder.keySet().iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block1;
                    EntityId entityId = iterator.next();
                    sameValueQueue.offer(entityId);
                }
                break;
            }
            if (rightOrder.containsKey(null)) {
                rightOrder.remove(null);
                this.nextId = null;
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            return this.nextId;
        }

        @Override
        public Comparable currentValue() {
            return this.currentValue;
        }
    }
}

