/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import java.util.Iterator;
import jetbrains.exodus.core.dataStructures.persistent.PersistentLong23TreeMap;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.NonDisposableEntityIterator;
import jetbrains.exodus.entitystore.iterate.UpdatableCachedInstanceIterable;
import jetbrains.exodus.entitystore.util.EntityIdSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdatableEntityIdSortedSetCachedInstanceIterable
extends UpdatableCachedInstanceIterable {
    private static final PersistentLong23TreeMap EMPTY_IDS = new PersistentLong23TreeMap();
    private final int entityTypeId;
    @NotNull
    private final PersistentLong23TreeMap localIds;
    @Nullable
    private PersistentLong23TreeMap.MutableMap mutableLocalIds;
    @Nullable
    private EntityIdSet idSet;
    @Nullable
    private long[] idArray;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdatableEntityIdSortedSetCachedInstanceIterable(@NotNull PersistentStoreTransaction txn, @NotNull EntityIterableBase source) {
        super(txn, source);
        this.entityTypeId = source.getEntityTypeId();
        EntityIteratorBase it = (EntityIteratorBase)source.getIteratorImpl(txn);
        try {
            if (!it.hasNext()) {
                this.localIds = EMPTY_IDS;
            } else {
                this.localIds = new PersistentLong23TreeMap();
                PersistentLong23TreeMap.MutableMap mutableLocalIds = this.localIds.beginWrite();
                do {
                    EntityId entityId;
                    if ((entityId = it.nextId()) == null) {
                        throw new NullPointerException("EntityIteratorBase.nextId() returned null!");
                    }
                    mutableLocalIds.put(entityId.getLocalId(), (Object)EMPTY_IDS);
                } while (it.hasNext());
                mutableLocalIds.endWrite();
            }
        }
        finally {
            it.disposeIfShouldBe();
        }
        this.mutableLocalIds = null;
        this.idSet = null;
        this.idArray = null;
    }

    private UpdatableEntityIdSortedSetCachedInstanceIterable(@NotNull UpdatableEntityIdSortedSetCachedInstanceIterable source) {
        super(source.getTransaction(), source);
        this.entityTypeId = source.entityTypeId;
        this.localIds = source.localIds.getClone();
        this.mutableLocalIds = this.localIds.beginWrite();
        this.idSet = null;
        this.idArray = null;
    }

    @Override
    public int getEntityTypeId() {
        return this.entityTypeId;
    }

    @Override
    @NotNull
    public EntityIterator getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        if (this.localIds == EMPTY_IDS && this.mutableLocalIds == null) {
            return EntityIteratorBase.EMPTY;
        }
        final PersistentLong23TreeMap.MutableMap currentMap = this.getCurrentMap();
        if (this.mutableLocalIds == null) {
            if (this.idArray == null) {
                long[] result = new long[currentMap.size()];
                Iterator it = currentMap.iterator();
                int i = 0;
                while (it.hasNext()) {
                    result[i++] = ((PersistentLong23TreeMap.Entry)it.next()).getKey();
                }
                this.idArray = result;
            }
            return new NonDisposableEntityIterator(this){
                private int i;
                {
                    this.i = 0;
                }

                @Override
                protected boolean hasNextImpl() {
                    return this.i < UpdatableEntityIdSortedSetCachedInstanceIterable.this.idArray.length;
                }

                @Override
                @Nullable
                protected EntityId nextIdImpl() {
                    return new PersistentEntityId(UpdatableEntityIdSortedSetCachedInstanceIterable.this.entityTypeId, UpdatableEntityIdSortedSetCachedInstanceIterable.this.idArray[this.i++]);
                }
            };
        }
        return new NonDisposableEntityIterator(this){
            private final Iterator<PersistentLong23TreeMap.Entry> it;
            {
                super(iterable);
                this.it = currentMap.iterator();
            }

            @Override
            protected boolean hasNextImpl() {
                return this.it.hasNext();
            }

            @Override
            @Nullable
            protected EntityId nextIdImpl() {
                return new PersistentEntityId(UpdatableEntityIdSortedSetCachedInstanceIterable.this.entityTypeId, this.it.next().getKey());
            }
        };
    }

    @Override
    public long size() {
        return this.getCurrentMap().size();
    }

    @Override
    public EntityIdSet toSet(@NotNull PersistentStoreTransaction txn) {
        if (this.idSet == null) {
            EntityIdSet result = new EntityIdSet();
            EntityIterator it = this.getIteratorImpl(txn);
            while (it.hasNext()) {
                result.add(it.nextId());
            }
            if (this.mutableLocalIds != null) {
                return result;
            }
            this.idSet = result;
        }
        return this.idSet;
    }

    @Override
    protected long countImpl(@NotNull PersistentStoreTransaction txn) {
        return this.size();
    }

    @Override
    public UpdatableEntityIdSortedSetCachedInstanceIterable beginUpdate() {
        return new UpdatableEntityIdSortedSetCachedInstanceIterable(this);
    }

    @Override
    public boolean isMutated() {
        return this.mutableLocalIds != null;
    }

    @Override
    public void endUpdate() {
        this.checkMutableIds().endWrite();
        this.mutableLocalIds = null;
    }

    public final void addEntity(EntityId id) {
        this.checkEntityType(id);
        this.checkMutableIds().put(id.getLocalId(), (Object)EMPTY_IDS);
    }

    public final void removeEntity(EntityId id) {
        this.checkEntityType(id);
        this.checkMutableIds().remove(id.getLocalId());
    }

    private PersistentLong23TreeMap.MutableMap getCurrentMap() {
        return this.mutableLocalIds == null ? this.localIds.beginWrite() : this.mutableLocalIds;
    }

    private PersistentLong23TreeMap.MutableMap checkMutableIds() {
        PersistentLong23TreeMap.MutableMap mutableLocalIds = this.mutableLocalIds;
        if (mutableLocalIds == null) {
            throw new IllegalStateException("UpdatableEntityIdSortedSetCachedInstanceIterable was not mutated");
        }
        return mutableLocalIds;
    }

    private void checkEntityType(EntityId id) {
        if (id.getTypeId() != this.entityTypeId) {
            throw new IllegalStateException("Unexpected entity type id: " + id.getTypeId());
        }
    }
}

