/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import java.util.ArrayList;
import java.util.Iterator;
import jetbrains.exodus.core.dataStructures.persistent.AbstractPersistent23Tree;
import jetbrains.exodus.core.dataStructures.persistent.Persistent23Tree;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityStoreException;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.NonDisposableEntityIterator;
import jetbrains.exodus.entitystore.iterate.PropertyValueIterator;
import jetbrains.exodus.entitystore.iterate.UpdatableCachedInstanceIterable;
import jetbrains.exodus.entitystore.tables.PropertyTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdatablePropertiesCachedInstanceIterable
extends UpdatableCachedInstanceIterable {
    private static final Logger logger = LoggerFactory.getLogger(UpdatablePropertiesCachedInstanceIterable.class);
    private int entityTypeId;
    @NotNull
    private final Persistent23Tree<IndexEntry> index;
    @Nullable
    private Persistent23Tree.MutableTree<IndexEntry> mutableIndex;
    @Nullable
    private Class<? extends Comparable> valueClass;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdatablePropertiesCachedInstanceIterable(@Nullable PersistentStoreTransaction txn, @Nullable PropertyValueIterator it, @NotNull EntityIterableBase source) {
        block6: {
            super(txn, source);
            this.index = new Persistent23Tree();
            this.mutableIndex = null;
            if (it == null) {
                this.entityTypeId = -1;
                return;
            }
            try {
                ArrayList<IndexEntry> tempList;
                block7: {
                    if (!it.hasNext()) {
                        this.entityTypeId = -1;
                        this.valueClass = null;
                        break block6;
                    }
                    tempList = new ArrayList<IndexEntry>();
                    EntityId id = it.nextId();
                    this.entityTypeId = id.getTypeId();
                    Comparable propValue = it.currentValue();
                    this.valueClass = propValue.getClass();
                    do {
                        tempList.add(new IndexEntry(propValue, id.getLocalId()));
                        if (!it.hasNext()) break block7;
                        id = it.nextId();
                    } while (this.valueClass.equals((propValue = it.currentValue()).getClass()));
                    throw new EntityStoreException("Unexpected property value class");
                }
                Persistent23Tree.MutableTree mutableTree = this.index.beginWrite();
                mutableTree.addAll(tempList, tempList.size());
                mutableTree.endWrite();
            }
            finally {
                ((EntityIteratorBase)((Object)it)).disposeIfShouldBe();
            }
        }
    }

    private UpdatablePropertiesCachedInstanceIterable(@NotNull UpdatablePropertiesCachedInstanceIterable source) {
        super(source.getTransaction(), source);
        this.entityTypeId = source.entityTypeId;
        this.index = source.index.getClone();
        this.mutableIndex = this.index.beginWrite();
        this.valueClass = source.valueClass;
    }

    @Override
    public int getEntityTypeId() {
        return this.entityTypeId;
    }

    @Nullable
    public Class<? extends Comparable> getPropertyValueClass() {
        return this.valueClass;
    }

    @Override
    public boolean isSortedById() {
        return false;
    }

    @Override
    public UpdatablePropertiesCachedInstanceIterable beginUpdate() {
        return new UpdatablePropertiesCachedInstanceIterable(this);
    }

    @Override
    public boolean isMutated() {
        return this.mutableIndex != null;
    }

    @Override
    public void endUpdate() {
        Persistent23Tree.MutableTree<IndexEntry> index = this.mutableIndex;
        if (index == null) {
            throw new IllegalStateException("UpdatablePropertiesCachedInstanceIterable was not mutated");
        }
        index.endWrite();
        this.mutableIndex = null;
    }

    public void update(int typeId, long localId, @Nullable Comparable oldValue, @Nullable Comparable newValue) {
        IndexEntry newEntry;
        if (this.entityTypeId == -1) {
            this.entityTypeId = typeId;
        }
        IndexEntry oldEntry = oldValue == null ? null : new IndexEntry(PropertyTypes.toLowerCase(oldValue), localId);
        IndexEntry indexEntry = newEntry = newValue == null ? null : new IndexEntry(PropertyTypes.toLowerCase(newValue), localId);
        if (oldEntry == null && newEntry == null) {
            throw new IllegalStateException("Can't update in-memory index: both oldValue and newValue are null");
        }
        Persistent23Tree.MutableTree<IndexEntry> index = this.mutableIndex;
        if (index == null) {
            throw new IllegalStateException("Mutate index before updating it");
        }
        if (oldEntry != null) {
            if (index.contains((Comparable)oldEntry)) {
                index.exclude((Comparable)oldEntry);
            } else if (newEntry != null && !index.contains((Comparable)newEntry)) {
                logger.warn("In-memory index doesn't contain the value [" + oldValue + "]. New value [" + newValue + "]. Handle [" + this.getHandle() + ']');
            }
        }
        if (newEntry != null) {
            index.add((Comparable)newEntry);
            if (this.valueClass == null) {
                this.valueClass = newValue.getClass();
            }
        }
    }

    EntityIteratorBase getPropertyValueIterator(@NotNull Comparable value) {
        return new PropertyValueCachedInstanceIterator(value);
    }

    EntityIteratorBase getPropertyRangeIterator(@NotNull Comparable min, @NotNull Comparable max) {
        return new PropertyRangeCachedInstanceIterator(min, max);
    }

    @Override
    @NotNull
    public EntityIteratorBase getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        return this.getCurrentTree().isEmpty() ? EntityIteratorBase.EMPTY : new PropertiesCachedInstanceIterator();
    }

    @Override
    @NotNull
    public EntityIteratorBase getReverseIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        return this.getCurrentTree().isEmpty() ? EntityIteratorBase.EMPTY : new ReversePropertiesCachedInstanceIterator();
    }

    @Override
    public long size() {
        return this.getCurrentTree().size();
    }

    @Override
    protected long countImpl(@NotNull PersistentStoreTransaction txn) {
        return this.size();
    }

    private AbstractPersistent23Tree<IndexEntry> getCurrentTree() {
        return this.mutableIndex == null ? this.index.beginRead() : this.mutableIndex;
    }

    private class PropertyRangeCachedInstanceIterator
    extends PropertiesCachedInstanceIteratorBase {
        @NotNull
        private final Comparable max;

        private PropertyRangeCachedInstanceIterator(@NotNull Comparable min, Comparable max) {
            super(UpdatablePropertiesCachedInstanceIterable.this.getCurrentTree().tailIterator((Comparable)new IndexEntry(min, 0L)));
            this.max = max;
        }

        @Override
        protected boolean checkIndexEntry(IndexEntry entry) {
            return entry != null && entry.propValue.compareTo(this.max) <= 0;
        }
    }

    private class PropertyValueCachedInstanceIterator
    extends PropertiesCachedInstanceIteratorBase {
        @NotNull
        private final Comparable value;

        private PropertyValueCachedInstanceIterator(Comparable value) {
            super(UpdatablePropertiesCachedInstanceIterable.this.getCurrentTree().tailIterator((Comparable)new IndexEntry(value, 0L)));
            this.value = value;
        }

        @Override
        protected boolean checkIndexEntry(IndexEntry entry) {
            return entry != null && entry.propValue.compareTo(this.value) == 0;
        }
    }

    private class ReversePropertiesCachedInstanceIterator
    extends PropertiesCachedInstanceIteratorBase {
        private ReversePropertiesCachedInstanceIterator() {
            super(UpdatablePropertiesCachedInstanceIterable.this.getCurrentTree().reverseIterator());
        }
    }

    private class PropertiesCachedInstanceIterator
    extends PropertiesCachedInstanceIteratorBase {
        private PropertiesCachedInstanceIterator() {
            super(UpdatablePropertiesCachedInstanceIterable.this.getCurrentTree().iterator());
        }
    }

    private abstract class PropertiesCachedInstanceIteratorBase
    extends NonDisposableEntityIterator
    implements PropertyValueIterator {
        @NotNull
        private final Iterator<IndexEntry> it;
        @Nullable
        protected IndexEntry next;
        protected boolean hasNextValid;

        protected PropertiesCachedInstanceIteratorBase(Iterator<IndexEntry> it) {
            super(UpdatablePropertiesCachedInstanceIterable.this);
            this.it = it;
        }

        @Override
        protected boolean hasNextImpl() {
            if (this.hasNextValid) {
                return true;
            }
            if (!this.it.hasNext()) {
                return false;
            }
            IndexEntry next = this.it.next();
            if (!this.checkIndexEntry(next)) {
                return false;
            }
            this.next = next;
            this.hasNextValid = true;
            return true;
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            if (!this.hasNextImpl()) {
                return null;
            }
            PersistentEntityId result = new PersistentEntityId(UpdatablePropertiesCachedInstanceIterable.this.entityTypeId, this.next.localId);
            this.hasNextValid = false;
            return result;
        }

        @Override
        @Nullable
        public Comparable currentValue() {
            IndexEntry entry = this.next;
            return entry == null ? null : entry.propValue;
        }

        protected boolean checkIndexEntry(IndexEntry entry) {
            return entry != null;
        }
    }

    private static class IndexEntry
    implements Comparable<IndexEntry> {
        @NotNull
        private final Comparable propValue;
        private final long localId;

        private IndexEntry(@NotNull Comparable propValue, long localId) {
            this.propValue = propValue;
            this.localId = localId;
        }

        @Override
        public int compareTo(IndexEntry o) {
            int result = this.propValue.compareTo(o.propValue);
            if (result == 0) {
                if (this.localId < o.localId) {
                    result = -1;
                } else if (this.localId > o.localId) {
                    result = 1;
                }
            }
            return result;
        }
    }
}

