/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate.binop;

import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableInstantiator;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorFixingDecorator;
import jetbrains.exodus.entitystore.iterate.NonDisposableEntityIterator;
import jetbrains.exodus.entitystore.iterate.binop.BinaryOperatorEntityIterable;
import jetbrains.exodus.entitystore.util.EntityIdSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IntersectionIterable
extends BinaryOperatorEntityIterable {
    public IntersectionIterable(@Nullable PersistentStoreTransaction txn, @NotNull EntityIterableBase iterable1, @NotNull EntityIterableBase iterable2) {
        this(txn, iterable1, iterable2, false);
    }

    public IntersectionIterable(@Nullable PersistentStoreTransaction txn, @NotNull EntityIterableBase iterable1, @NotNull EntityIterableBase iterable2, boolean preserveRightOrder) {
        super(txn, iterable1, iterable2, !preserveRightOrder);
        if (preserveRightOrder) {
            if (this.iterable2.isSortedById()) {
                this.depth += 0x20000000;
            }
        } else if (iterable1.isSortedById() || iterable2.isSortedById()) {
            this.depth += 0x20000000;
        }
    }

    @Override
    protected EntityIterableType getIterableType() {
        return EntityIterableType.INTERSECT;
    }

    @Override
    @NotNull
    public EntityIteratorBase getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        EntityIterableBase iterable1 = this.iterable1;
        EntityIterableBase iterable2 = this.iterable2;
        NonDisposableEntityIterator iterator = this.isSortedById() ? (iterable1.isSortedById() ? (iterable2.isSortedById() ? new SortedIterator(this, iterable1, iterable2) : new UnsortedIterator(this, txn, iterable2, iterable1)) : new UnsortedIterator(this, txn, iterable1, iterable2)) : new UnsortedIterator(this, txn, iterable1, iterable2);
        return new EntityIteratorFixingDecorator(this, iterator);
    }

    @Override
    protected long countImpl(@NotNull PersistentStoreTransaction txn) {
        return this.isEmptyFast(txn) ? 0L : super.countImpl(txn);
    }

    @Override
    public boolean isEmptyImpl(@NotNull PersistentStoreTransaction txn) {
        return this.isEmptyFast(txn) || super.isEmptyImpl(txn);
    }

    @Override
    protected boolean isEmptyFast(@NotNull PersistentStoreTransaction txn) {
        return super.isEmptyFast(txn) || (this.iterable1.isCached() || this.iterable1.nonCachedHasFastCountAndIsEmpty()) && this.iterable1.isEmptyImpl(txn) || (this.iterable2.isCached() || this.iterable2.nonCachedHasFastCountAndIsEmpty()) && this.iterable2.isEmptyImpl(txn);
    }

    static {
        IntersectionIterable.registerType(EntityIterableType.INTERSECT, new EntityIterableInstantiator(){

            @Override
            public EntityIterableBase instantiate(PersistentStoreTransaction txn, PersistentEntityStoreImpl store, Object[] parameters) {
                return new IntersectionIterable(txn, (EntityIterableBase)parameters[0], (EntityIterableBase)parameters[1]);
            }
        });
    }

    private static final class UnsortedIterator
    extends NonDisposableEntityIterator {
        @NotNull
        private final PersistentStoreTransaction txn;
        private EntityIterableBase iterable1;
        @NotNull
        private final EntityIteratorBase iterator2;
        private EntityIdSet entityIdSet;
        private EntityId nextId;

        private UnsortedIterator(@NotNull EntityIterableBase iterable, @NotNull PersistentStoreTransaction txn, @NotNull EntityIterableBase iterable1, @NotNull EntityIterableBase iterable2) {
            super(iterable);
            this.txn = txn;
            this.iterable1 = iterable1;
            this.iterator2 = (EntityIteratorBase)iterable2.iterator();
            this.nextId = null;
        }

        @Override
        protected boolean hasNextImpl() {
            while (this.iterator2.hasNext()) {
                EntityId nextId = this.iterator2.nextId();
                if (!this.getEntityIdSet().contains(nextId)) continue;
                this.nextId = nextId;
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            return this.nextId;
        }

        private EntityIdSet getEntityIdSet() {
            if (this.entityIdSet == null) {
                this.entityIdSet = this.iterable1.toSet(this.txn);
                this.iterable1 = null;
            }
            return this.entityIdSet;
        }
    }

    private static final class SortedIterator
    extends NonDisposableEntityIterator {
        @NotNull
        private final EntityIteratorBase iterator1;
        @NotNull
        private final EntityIteratorBase iterator2;
        private EntityId nextId;

        private SortedIterator(@NotNull EntityIterableBase iterable, @NotNull EntityIterableBase iterable1, @NotNull EntityIterableBase iterable2) {
            super(iterable);
            this.iterator1 = (EntityIteratorBase)iterable1.iterator();
            this.iterator2 = (EntityIteratorBase)iterable2.iterator();
            this.nextId = null;
        }

        @Override
        protected boolean hasNextImpl() {
            EntityId next = this.nextId;
            if (next != PersistentEntityId.EMPTY_ID) {
                block5: {
                    next = PersistentEntityId.EMPTY_ID;
                    EntityId e1 = null;
                    EntityId e2 = null;
                    EntityIteratorBase iterator1 = this.iterator1;
                    EntityIteratorBase iterator2 = this.iterator2;
                    while (true) {
                        int cmp;
                        if (e1 == null) {
                            if (!iterator1.hasNext()) break block5;
                            e1 = iterator1.nextId();
                        }
                        if (e2 == null) {
                            if (!iterator2.hasNext()) break block5;
                            e2 = iterator2.nextId();
                        }
                        if (e1 != e2 && (e1 == null || e2 == null)) continue;
                        int n = cmp = e1 == e2 ? 0 : e1.compareTo((Object)e2);
                        if (cmp < 0) {
                            e1 = null;
                            continue;
                        }
                        if (cmp <= 0) break;
                        e2 = null;
                    }
                    next = e1;
                }
                this.nextId = next;
                return this.nextId != PersistentEntityId.EMPTY_ID;
            }
            return false;
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            return this.nextId;
        }
    }
}

