/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate.binop;

import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableInstantiator;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorFixingDecorator;
import jetbrains.exodus.entitystore.iterate.NonDisposableEntityIterator;
import jetbrains.exodus.entitystore.iterate.binop.BinaryOperatorEntityIterable;
import jetbrains.exodus.entitystore.util.EntityIdSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MinusIterable
extends BinaryOperatorEntityIterable {
    public MinusIterable(@Nullable PersistentStoreTransaction txn, @NotNull EntityIterableBase minuend, @NotNull EntityIterableBase subtrahend) {
        super(txn, minuend, subtrahend, false);
        if (minuend.isSortedById()) {
            this.depth += 0x20000000;
        }
    }

    @Override
    protected EntityIterableType getIterableType() {
        return EntityIterableType.MINUS;
    }

    @Override
    @NotNull
    public EntityIteratorBase getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        EntityIterableBase iterable1 = this.iterable1;
        EntityIterableBase iterable2 = this.iterable2;
        return new EntityIteratorFixingDecorator(this, this.isSortedById() && iterable2.isSortedById() ? new SortedIterator(this, iterable1, iterable2) : new UnsortedIterator(this, txn, iterable1, iterable2));
    }

    static {
        EntityIterableBase.registerType(EntityIterableType.MINUS, new EntityIterableInstantiator(){

            @Override
            public EntityIterableBase instantiate(PersistentStoreTransaction txn, PersistentEntityStoreImpl store, Object[] parameters) {
                return new MinusIterable(txn, (EntityIterableBase)parameters[0], (EntityIterableBase)parameters[1]);
            }
        });
    }

    private static final class UnsortedIterator
    extends NonDisposableEntityIterator {
        @NotNull
        private final PersistentStoreTransaction txn;
        @NotNull
        private final EntityIteratorBase minuend;
        private EntityIterableBase subtrahend;
        private EntityIdSet exceptSet;
        private EntityId nextId;

        private UnsortedIterator(@NotNull EntityIterableBase iterable, @NotNull PersistentStoreTransaction txn, @NotNull EntityIterableBase minuend, @NotNull EntityIterableBase subtrahend) {
            super(iterable);
            this.txn = txn;
            this.minuend = (EntityIteratorBase)minuend.iterator();
            this.subtrahend = subtrahend;
        }

        @Override
        protected boolean hasNextImpl() {
            while (this.minuend.hasNext()) {
                EntityId nextId = this.minuend.nextId();
                if (this.getExceptSet().contains(nextId)) continue;
                this.nextId = nextId;
                return true;
            }
            this.nextId = null;
            return false;
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            return this.nextId;
        }

        private EntityIdSet getExceptSet() {
            if (this.exceptSet == null) {
                this.exceptSet = this.subtrahend.toSet(this.txn);
                this.subtrahend = null;
            }
            return this.exceptSet;
        }
    }

    private static final class SortedIterator
    extends NonDisposableEntityIterator {
        @NotNull
        private final EntityIteratorBase minuend;
        private final EntityIteratorBase subtrahend;
        private EntityId nextId;
        private EntityId currentMinuend;
        private EntityId currentSubtrahend;

        private SortedIterator(@NotNull EntityIterableBase iterable, @NotNull EntityIterableBase minuend, @NotNull EntityIterableBase subtrahend) {
            super(iterable);
            this.minuend = (EntityIteratorBase)minuend.iterator();
            this.subtrahend = (EntityIteratorBase)subtrahend.iterator();
            this.nextId = null;
            this.currentMinuend = null;
            this.currentSubtrahend = null;
        }

        @Override
        protected boolean hasNextImpl() {
            EntityId currentMinuend = this.currentMinuend;
            EntityId currentSubtrahend = this.currentSubtrahend;
            while (currentMinuend != PersistentEntityId.EMPTY_ID) {
                if (currentMinuend == null) {
                    this.currentMinuend = currentMinuend = SortedIterator.nextId(this.minuend);
                }
                if (currentSubtrahend == null) {
                    this.currentSubtrahend = currentSubtrahend = SortedIterator.nextId(this.subtrahend);
                }
                if ((this.nextId = currentMinuend) == PersistentEntityId.EMPTY_ID) break;
                if (currentSubtrahend == PersistentEntityId.EMPTY_ID) {
                    currentMinuend = null;
                    break;
                }
                if (currentMinuend != currentSubtrahend && (currentMinuend == null || currentSubtrahend == null)) break;
                if (currentMinuend == currentSubtrahend) {
                    currentSubtrahend = null;
                    currentMinuend = null;
                    continue;
                }
                int cmp = currentMinuend.compareTo((Object)currentSubtrahend);
                if (cmp < 0) {
                    currentMinuend = null;
                    break;
                }
                currentSubtrahend = null;
                if (cmp != 0) continue;
                currentMinuend = null;
            }
            this.currentMinuend = currentMinuend;
            this.currentSubtrahend = currentSubtrahend;
            return this.currentMinuend != PersistentEntityId.EMPTY_ID;
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            return this.nextId;
        }

        @Nullable
        private static EntityId nextId(EntityIterator it) {
            return it.hasNext() ? it.nextId() : PersistentEntityId.EMPTY_ID;
        }
    }
}

