/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.management;

import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.management.EntityStoreStatisticsMBean;
import jetbrains.exodus.management.MBeanBase;
import org.jetbrains.annotations.NotNull;

public class EntityStoreStatistics
extends MBeanBase
implements EntityStoreStatisticsMBean {
    @NotNull
    private final PersistentEntityStoreImpl store;

    public EntityStoreStatistics(@NotNull PersistentEntityStoreImpl store) {
        super(EntityStoreStatistics.getObjectName(store));
        this.store = store;
    }

    @Override
    public long getBlobsDiskUsage() {
        return this.store.getStatistics().getStatisticsItem("Blobs disk usage").getTotal();
    }

    @Override
    public long getNumberOfCachingJobs() {
        return this.store.getStatistics().getStatisticsItem("Caching jobs").getTotal();
    }

    @Override
    public float getEntityIterableCacheHitRate() {
        return this.store.getEntityIterableCache().hitRate();
    }

    @Override
    public float getBlobStringsCacheHitRate() {
        return this.store.getBlobVault().getStringContentCacheHitRate();
    }

    public static String getObjectName(@NotNull PersistentEntityStoreImpl store) {
        return "jetbrains.exodus.entitystore: type=EntityStoreStatistics, location=" + EntityStoreStatistics.escapeLocation((String)store.getLocation());
    }
}

