/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.tables;

import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.IntegerBinding;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.tables.PropertyKey;
import jetbrains.exodus.entitystore.tables.Table;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BlobsTable
extends Table {
    @NonNls
    private static final String ALL_PROPS_IDX = "#all_idx";
    private final Store primaryStore;
    private final Store allBlobsIndex;

    public BlobsTable(@NotNull PersistentEntityStoreImpl store, @NotNull PersistentStoreTransaction txn, @NotNull String name, @NotNull StoreConfig primaryConfig) {
        Transaction envTxn = txn.getEnvironmentTransaction();
        Environment env = store.getEnvironment();
        this.primaryStore = env.openStore(name, primaryConfig, envTxn);
        this.allBlobsIndex = env.openStore(name + ALL_PROPS_IDX, StoreConfig.WITH_DUPLICATES_WITH_PREFIXING, envTxn);
        store.trackTableCreation(this.primaryStore, txn);
        store.trackTableCreation(this.allBlobsIndex, txn);
    }

    @Nullable
    public ByteIterable get(@NotNull Transaction txn, @NotNull PropertyKey propertyKey) {
        return this.primaryStore.get(txn, (ByteIterable)PropertyKey.propertyKeyToEntry(propertyKey));
    }

    @Nullable
    public ByteIterable get(@NotNull Transaction txn, long localId, int blobId) {
        return this.get(txn, new PropertyKey(localId, blobId));
    }

    public void put(@NotNull Transaction txn, long localId, int blobId, @NotNull ByteIterable value) {
        this.primaryStore.put(txn, (ByteIterable)PropertyKey.propertyKeyToEntry(new PropertyKey(localId, blobId)), value);
        this.allBlobsIndex.put(txn, (ByteIterable)IntegerBinding.intToCompressedEntry((int)blobId), (ByteIterable)LongBinding.longToCompressedEntry((long)localId));
    }

    public void delete(@NotNull Transaction txn, long localId, int blobId) {
        ArrayByteIterable key = PropertyKey.propertyKeyToEntry(new PropertyKey(localId, blobId));
        boolean success = this.primaryStore.delete(txn, (ByteIterable)key);
        if (success) {
            try (Cursor cursor = this.allBlobsIndex.openCursor(txn);){
                success = cursor.getSearchBoth((ByteIterable)IntegerBinding.intToCompressedEntry((int)blobId), (ByteIterable)LongBinding.longToCompressedEntry((long)localId));
                if (success) {
                    success = cursor.deleteCurrent();
                }
            }
        }
        BlobsTable.checkStatus(success, "Failed to delete");
    }

    public Store getPrimaryIndex() {
        return this.primaryStore;
    }

    public Store getAllBlobsIndex() {
        return this.allBlobsIndex;
    }

    @Override
    public boolean canBeCached() {
        return !this.primaryStore.getConfig().temporaryEmpty && !this.allBlobsIndex.getConfig().temporaryEmpty;
    }
}

