/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.tables;

import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.bindings.IntegerBinding;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.util.LightOutputStream;
import org.jetbrains.annotations.NotNull;

public class EntityIdBinding {
    @NotNull
    private final EntityId entityId;

    public EntityIdBinding(@NotNull EntityId entityId) {
        this.entityId = entityId;
    }

    @NotNull
    public EntityId getEntityId() {
        return this.entityId;
    }

    public static EntityId entryToEntityId(@NotNull ByteIterable entry) {
        ByteIterator it = entry.iterator();
        return EntityIdBinding.iteratorToEntityId(it);
    }

    public static ArrayByteIterable objectToEntry(@NotNull EntityId object) {
        LightOutputStream output = new LightOutputStream(7);
        EntityIdBinding.writeEntityId(output, object);
        return output.asArrayByteIterable();
    }

    public static EntityId iteratorToEntityId(@NotNull ByteIterator it) {
        int entityTypeId = IntegerBinding.readCompressed((ByteIterator)it);
        long entityLocalId = LongBinding.readCompressed((ByteIterator)it);
        return new PersistentEntityId(entityTypeId, entityLocalId);
    }

    public static void writeEntityId(@NotNull LightOutputStream output, @NotNull EntityId object) {
        IntegerBinding.writeCompressed((LightOutputStream)output, (int)object.getTypeId());
        LongBinding.writeCompressed((LightOutputStream)output, (long)object.getLocalId());
    }
}

