/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.tables;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.ComparableBinding;
import jetbrains.exodus.bindings.ComparableSet;
import jetbrains.exodus.bindings.ComparableValueType;
import jetbrains.exodus.bindings.IntegerBinding;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.core.dataStructures.hash.IntHashMap;
import jetbrains.exodus.entitystore.EntityStoreException;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.tables.PropertyKey;
import jetbrains.exodus.entitystore.tables.PropertyTypes;
import jetbrains.exodus.entitystore.tables.PropertyValue;
import jetbrains.exodus.entitystore.tables.Table;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PropertiesTable
extends Table {
    @NonNls
    private static final String PROP_VALUE_IDX = "#value_idx";
    @NonNls
    private static final String ALL_PROPS_IDX = "#all_idx";
    @NotNull
    private final PersistentEntityStoreImpl store;
    private final String name;
    private final Store primaryStore;
    private final IntHashMap<Store> valueIndexes;
    private final Store allPropsIndex;

    public PropertiesTable(@NotNull PersistentStoreTransaction txn, @NotNull String name, @NotNull StoreConfig primaryConfig) {
        this.store = txn.getStore();
        this.name = name;
        Transaction envTxn = txn.getEnvironmentTransaction();
        Environment env = this.store.getEnvironment();
        this.primaryStore = env.openStore(name, primaryConfig, envTxn);
        this.allPropsIndex = env.openStore(name + ALL_PROPS_IDX, StoreConfig.WITH_DUPLICATES_WITH_PREFIXING, envTxn);
        this.store.trackTableCreation(this.primaryStore, txn);
        this.store.trackTableCreation(this.allPropsIndex, txn);
        this.valueIndexes = new IntHashMap();
    }

    @Nullable
    public ByteIterable get(@NotNull PersistentStoreTransaction txn, @NotNull ByteIterable key) {
        return this.primaryStore.get(txn.getEnvironmentTransaction(), key);
    }

    public void put(@NotNull PersistentStoreTransaction txn, long localId, @NotNull ByteIterable value, @Nullable ByteIterable oldValue, int propertyId, @NotNull ComparableValueType type) {
        Store valueIdx = this.getOrCreateValueIndex(txn, propertyId);
        ArrayByteIterable key = PropertyKey.propertyKeyToEntry(new PropertyKey(localId, propertyId));
        Transaction envTxn = txn.getEnvironmentTransaction();
        this.primaryStore.put(envTxn, (ByteIterable)key, value);
        ArrayByteIterable secondaryValue = LongBinding.longToCompressedEntry((long)localId);
        boolean success = oldValue == null ? this.allPropsIndex.put(envTxn, (ByteIterable)IntegerBinding.intToCompressedEntry((int)propertyId), (ByteIterable)secondaryValue) : PropertiesTable.deleteFromStore(envTxn, valueIdx, (ByteIterable)secondaryValue, PropertiesTable.createSecondaryKeys(this.store.getPropertyTypes(), oldValue, type));
        if (success) {
            for (ByteIterable secondaryKey : PropertiesTable.createSecondaryKeys(this.store.getPropertyTypes(), value, type)) {
                valueIdx.put(envTxn, secondaryKey, (ByteIterable)secondaryValue);
            }
        }
        PropertiesTable.checkStatus(success, "Failed to put");
    }

    public void delete(@NotNull PersistentStoreTransaction txn, long localId, @NotNull ByteIterable value, int propertyId, @NotNull ComparableValueType type) {
        PropertiesTable.checkStatus(this.deleteNoFail(txn, localId, value, propertyId, type), "Failed to delete");
    }

    public boolean deleteNoFail(@NotNull PersistentStoreTransaction txn, long localId, @NotNull ByteIterable value, int propertyId, @NotNull ComparableValueType type) {
        ArrayByteIterable key = PropertyKey.propertyKeyToEntry(new PropertyKey(localId, propertyId));
        Transaction envTxn = txn.getEnvironmentTransaction();
        ArrayByteIterable secondaryValue = LongBinding.longToCompressedEntry((long)localId);
        return this.primaryStore.delete(envTxn, (ByteIterable)key) && PropertiesTable.deleteFromStore(envTxn, this.getOrCreateValueIndex(txn, propertyId), (ByteIterable)secondaryValue, PropertiesTable.createSecondaryKeys(this.store.getPropertyTypes(), value, type)) && PropertiesTable.deleteFromStore(envTxn, this.allPropsIndex, (ByteIterable)secondaryValue, new ByteIterable[]{IntegerBinding.intToCompressedEntry((int)propertyId)});
    }

    public Store getPrimaryIndex() {
        return this.primaryStore;
    }

    public Store getAllPropsIndex() {
        return this.allPropsIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Store getValueIndex(@NotNull PersistentStoreTransaction txn, int propertyId, boolean creationRequired) {
        Store valueIndex;
        IntHashMap<Store> intHashMap = this.valueIndexes;
        synchronized (intHashMap) {
            Transaction envTxn;
            valueIndex = (Store)this.valueIndexes.get(propertyId);
            if (valueIndex == null && (valueIndex = (envTxn = txn.getEnvironmentTransaction()).getEnvironment().openStore(this.valueIndexName(propertyId), StoreConfig.WITH_DUPLICATES, envTxn, creationRequired)) != null && !valueIndex.getConfig().temporaryEmpty) {
                this.store.trackTableCreation(valueIndex, txn);
                this.valueIndexes.put(propertyId, (Object)valueIndex);
            }
        }
        return valueIndex;
    }

    @NotNull
    public Store getOrCreateValueIndex(@NotNull PersistentStoreTransaction txn, int propertyId) {
        Store result = this.getValueIndex(txn, propertyId, true);
        if (result == null) {
            throw new EntityStoreException("Failed to create value index " + this.valueIndexName(propertyId));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Collection<Map.Entry<Integer, Store>> getValueIndices() {
        IntHashMap<Store> intHashMap = this.valueIndexes;
        synchronized (intHashMap) {
            return new ArrayList<Map.Entry<Integer, Store>>(this.valueIndexes.entrySet());
        }
    }

    public static ByteIterable[] createSecondaryKeys(@NotNull PropertyTypes propertyTypes, @NotNull ByteIterable value, @NotNull ComparableValueType type) {
        int valueTypeId = type.getTypeId();
        if (valueTypeId == 2) {
            PropertyValue propValue = propertyTypes.entryToPropertyValue(value);
            return new ByteIterable[]{new PropertyValue(type, (Comparable)((Object)((String)((Object)propValue.getData())).toLowerCase())).dataToEntry()};
        }
        if (valueTypeId == 8) {
            PropertyValue propValue = propertyTypes.entryToPropertyValue(value);
            ComparableSet data = (ComparableSet)propValue.getData();
            Class itemClass = data.getItemClass();
            final ComparableBinding itemBinding = propertyTypes.getPropertyType(itemClass).getBinding();
            final ByteIterable[] result = new ByteIterable[data.size()];
            data.forEach(new ComparableSet.Consumer(){

                public void accept(@NotNull Comparable item, int index) {
                    result[index] = itemBinding.objectToEntry(PropertyTypes.toLowerCase(item));
                }
            });
            return result;
        }
        return new ByteIterable[]{value.subIterable(1, value.getLength() - 1)};
    }

    private String valueIndexName(int propertyId) {
        return this.name + PROP_VALUE_IDX + propertyId;
    }

    private static boolean deleteFromStore(@NotNull Transaction txn, @NotNull Store store, @NotNull ByteIterable value, ByteIterable ... keys) {
        try (Cursor cursor = store.openCursor(txn);){
            for (ByteIterable key : keys) {
                if (!cursor.getSearchBoth(key, value)) {
                    cursor.getSearchBoth(key, value);
                    boolean bl = false;
                    return bl;
                }
                if (cursor.deleteCurrent()) continue;
                cursor.deleteCurrent();
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public boolean canBeCached() {
        return !this.primaryStore.getConfig().temporaryEmpty && !this.allPropsIndex.getConfig().temporaryEmpty;
    }
}

