/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.tables;

import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.bindings.IntegerBinding;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.util.LightOutputStream;
import org.jetbrains.annotations.NotNull;

public final class PropertyKey {
    private final long entityLocalId;
    private final int propertyId;

    public PropertyKey(long entityLocalId, int propertyId) {
        this.entityLocalId = entityLocalId;
        this.propertyId = propertyId;
    }

    public long getEntityLocalId() {
        return this.entityLocalId;
    }

    public int getPropertyId() {
        return this.propertyId;
    }

    public static PropertyKey entryToPropertyKey(@NotNull ByteIterable entry) {
        ByteIterator it = entry.iterator();
        long entityLocalId = LongBinding.readCompressed((ByteIterator)it);
        int propertyId = IntegerBinding.readCompressed((ByteIterator)it);
        return new PropertyKey(entityLocalId, propertyId);
    }

    public static ArrayByteIterable propertyKeyToEntry(@NotNull PropertyKey object) {
        LightOutputStream output = new LightOutputStream(7);
        PropertyKey.writePropertyKey(output, object);
        return output.asArrayByteIterable();
    }

    public static void writePropertyKey(@NotNull LightOutputStream output, @NotNull PropertyKey object) {
        LongBinding.writeCompressed((LightOutputStream)output, (long)object.entityLocalId);
        IntegerBinding.writeCompressed((LightOutputStream)output, (int)object.propertyId);
    }
}

